/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package org.apache.plc4x.java.eip.readwrite;

import static org.apache.plc4x.java.spi.codegen.fields.FieldReaderFactory.*;
import static org.apache.plc4x.java.spi.codegen.fields.FieldWriterFactory.*;
import static org.apache.plc4x.java.spi.codegen.io.DataReaderFactory.*;
import static org.apache.plc4x.java.spi.codegen.io.DataWriterFactory.*;
import static org.apache.plc4x.java.spi.generation.StaticHelper.*;

import java.time.*;
import java.util.*;
import org.apache.plc4x.java.api.exceptions.*;
import org.apache.plc4x.java.api.value.*;
import org.apache.plc4x.java.spi.codegen.*;
import org.apache.plc4x.java.spi.codegen.fields.*;
import org.apache.plc4x.java.spi.codegen.io.*;
import org.apache.plc4x.java.spi.generation.*;

// Code generated by code-generation. DO NOT EDIT.

public class CipConnectionManagerCloseRequest extends CipService implements Message {

  // Accessors for discriminator values.
  public Byte getService() {
    return (byte) 0x4E;
  }

  public Boolean getResponse() {
    return (boolean) false;
  }

  public Boolean getConnected() {
    return false;
  }

  // Properties.
  protected final short requestPathSize;
  protected final PathSegment classSegment;
  protected final PathSegment instanceSegment;
  protected final byte priority;
  protected final byte tickTime;
  protected final short timeoutTicks;
  protected final int connectionSerialNumber;
  protected final int originatorVendorId;
  protected final long originatorSerialNumber;
  protected final short connectionPathSize;
  protected final List<PathSegment> connectionPaths;

  public CipConnectionManagerCloseRequest(
      short requestPathSize,
      PathSegment classSegment,
      PathSegment instanceSegment,
      byte priority,
      byte tickTime,
      short timeoutTicks,
      int connectionSerialNumber,
      int originatorVendorId,
      long originatorSerialNumber,
      short connectionPathSize,
      List<PathSegment> connectionPaths) {
    super();
    this.requestPathSize = requestPathSize;
    this.classSegment = classSegment;
    this.instanceSegment = instanceSegment;
    this.priority = priority;
    this.tickTime = tickTime;
    this.timeoutTicks = timeoutTicks;
    this.connectionSerialNumber = connectionSerialNumber;
    this.originatorVendorId = originatorVendorId;
    this.originatorSerialNumber = originatorSerialNumber;
    this.connectionPathSize = connectionPathSize;
    this.connectionPaths = connectionPaths;
  }

  public short getRequestPathSize() {
    return requestPathSize;
  }

  public PathSegment getClassSegment() {
    return classSegment;
  }

  public PathSegment getInstanceSegment() {
    return instanceSegment;
  }

  public byte getPriority() {
    return priority;
  }

  public byte getTickTime() {
    return tickTime;
  }

  public short getTimeoutTicks() {
    return timeoutTicks;
  }

  public int getConnectionSerialNumber() {
    return connectionSerialNumber;
  }

  public int getOriginatorVendorId() {
    return originatorVendorId;
  }

  public long getOriginatorSerialNumber() {
    return originatorSerialNumber;
  }

  public short getConnectionPathSize() {
    return connectionPathSize;
  }

  public List<PathSegment> getConnectionPaths() {
    return connectionPaths;
  }

  @Override
  protected void serializeCipServiceChild(WriteBuffer writeBuffer) throws SerializationException {
    PositionAware positionAware = writeBuffer;
    boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();
    writeBuffer.pushContext("CipConnectionManagerCloseRequest");

    // Simple Field (requestPathSize)
    writeSimpleField("requestPathSize", requestPathSize, writeUnsignedShort(writeBuffer, 8));

    // Simple Field (classSegment)
    writeSimpleField("classSegment", classSegment, writeComplex(writeBuffer));

    // Simple Field (instanceSegment)
    writeSimpleField("instanceSegment", instanceSegment, writeComplex(writeBuffer));

    // Simple Field (priority)
    writeSimpleField("priority", priority, writeUnsignedByte(writeBuffer, 4));

    // Simple Field (tickTime)
    writeSimpleField("tickTime", tickTime, writeUnsignedByte(writeBuffer, 4));

    // Simple Field (timeoutTicks)
    writeSimpleField("timeoutTicks", timeoutTicks, writeUnsignedShort(writeBuffer, 8));

    // Simple Field (connectionSerialNumber)
    writeSimpleField(
        "connectionSerialNumber", connectionSerialNumber, writeUnsignedInt(writeBuffer, 16));

    // Simple Field (originatorVendorId)
    writeSimpleField("originatorVendorId", originatorVendorId, writeUnsignedInt(writeBuffer, 16));

    // Simple Field (originatorSerialNumber)
    writeSimpleField(
        "originatorSerialNumber", originatorSerialNumber, writeUnsignedLong(writeBuffer, 32));

    // Simple Field (connectionPathSize)
    writeSimpleField("connectionPathSize", connectionPathSize, writeUnsignedShort(writeBuffer, 8));

    // Reserved Field (reserved)
    writeReservedField("reserved", (byte) 0x00, writeByte(writeBuffer, 8));

    // Array Field (connectionPaths)
    writeComplexTypeArrayField("connectionPaths", connectionPaths, writeBuffer);

    writeBuffer.popContext("CipConnectionManagerCloseRequest");
  }

  @Override
  public int getLengthInBytes() {
    return (int) Math.ceil((float) getLengthInBits() / 8.0);
  }

  @Override
  public int getLengthInBits() {
    int lengthInBits = super.getLengthInBits();
    CipConnectionManagerCloseRequest _value = this;
    boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();

    // Simple field (requestPathSize)
    lengthInBits += 8;

    // Simple field (classSegment)
    lengthInBits += classSegment.getLengthInBits();

    // Simple field (instanceSegment)
    lengthInBits += instanceSegment.getLengthInBits();

    // Simple field (priority)
    lengthInBits += 4;

    // Simple field (tickTime)
    lengthInBits += 4;

    // Simple field (timeoutTicks)
    lengthInBits += 8;

    // Simple field (connectionSerialNumber)
    lengthInBits += 16;

    // Simple field (originatorVendorId)
    lengthInBits += 16;

    // Simple field (originatorSerialNumber)
    lengthInBits += 32;

    // Simple field (connectionPathSize)
    lengthInBits += 8;

    // Reserved Field (reserved)
    lengthInBits += 8;

    // Array field
    if (connectionPaths != null) {
      for (Message element : connectionPaths) {
        lengthInBits += element.getLengthInBits();
      }
    }

    return lengthInBits;
  }

  public static CipServiceBuilder staticParseCipServiceBuilder(
      ReadBuffer readBuffer, Boolean connected, Integer serviceLen) throws ParseException {
    readBuffer.pullContext("CipConnectionManagerCloseRequest");
    PositionAware positionAware = readBuffer;
    boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();

    short requestPathSize = readSimpleField("requestPathSize", readUnsignedShort(readBuffer, 8));

    PathSegment classSegment =
        readSimpleField(
            "classSegment", readComplex(() -> PathSegment.staticParse(readBuffer), readBuffer));

    PathSegment instanceSegment =
        readSimpleField(
            "instanceSegment", readComplex(() -> PathSegment.staticParse(readBuffer), readBuffer));

    byte priority = readSimpleField("priority", readUnsignedByte(readBuffer, 4));

    byte tickTime = readSimpleField("tickTime", readUnsignedByte(readBuffer, 4));

    short timeoutTicks = readSimpleField("timeoutTicks", readUnsignedShort(readBuffer, 8));

    int connectionSerialNumber =
        readSimpleField("connectionSerialNumber", readUnsignedInt(readBuffer, 16));

    int originatorVendorId = readSimpleField("originatorVendorId", readUnsignedInt(readBuffer, 16));

    long originatorSerialNumber =
        readSimpleField("originatorSerialNumber", readUnsignedLong(readBuffer, 32));

    short connectionPathSize =
        readSimpleField("connectionPathSize", readUnsignedShort(readBuffer, 8));

    Byte reservedField0 = readReservedField("reserved", readByte(readBuffer, 8), (byte) 0x00);

    List<PathSegment> connectionPaths =
        readTerminatedArrayField(
            "connectionPaths",
            readComplex(() -> PathSegment.staticParse(readBuffer), readBuffer),
            () ->
                ((boolean)
                    (org.apache.plc4x.java.eip.readwrite.utils.StaticHelper.noMorePathSegments(
                        readBuffer))));

    readBuffer.closeContext("CipConnectionManagerCloseRequest");
    // Create the instance
    return new CipConnectionManagerCloseRequestBuilderImpl(
        requestPathSize,
        classSegment,
        instanceSegment,
        priority,
        tickTime,
        timeoutTicks,
        connectionSerialNumber,
        originatorVendorId,
        originatorSerialNumber,
        connectionPathSize,
        connectionPaths);
  }

  public static class CipConnectionManagerCloseRequestBuilderImpl
      implements CipService.CipServiceBuilder {
    private final short requestPathSize;
    private final PathSegment classSegment;
    private final PathSegment instanceSegment;
    private final byte priority;
    private final byte tickTime;
    private final short timeoutTicks;
    private final int connectionSerialNumber;
    private final int originatorVendorId;
    private final long originatorSerialNumber;
    private final short connectionPathSize;
    private final List<PathSegment> connectionPaths;

    public CipConnectionManagerCloseRequestBuilderImpl(
        short requestPathSize,
        PathSegment classSegment,
        PathSegment instanceSegment,
        byte priority,
        byte tickTime,
        short timeoutTicks,
        int connectionSerialNumber,
        int originatorVendorId,
        long originatorSerialNumber,
        short connectionPathSize,
        List<PathSegment> connectionPaths) {
      this.requestPathSize = requestPathSize;
      this.classSegment = classSegment;
      this.instanceSegment = instanceSegment;
      this.priority = priority;
      this.tickTime = tickTime;
      this.timeoutTicks = timeoutTicks;
      this.connectionSerialNumber = connectionSerialNumber;
      this.originatorVendorId = originatorVendorId;
      this.originatorSerialNumber = originatorSerialNumber;
      this.connectionPathSize = connectionPathSize;
      this.connectionPaths = connectionPaths;
    }

    public CipConnectionManagerCloseRequest build() {
      CipConnectionManagerCloseRequest cipConnectionManagerCloseRequest =
          new CipConnectionManagerCloseRequest(
              requestPathSize,
              classSegment,
              instanceSegment,
              priority,
              tickTime,
              timeoutTicks,
              connectionSerialNumber,
              originatorVendorId,
              originatorSerialNumber,
              connectionPathSize,
              connectionPaths);
      return cipConnectionManagerCloseRequest;
    }
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (!(o instanceof CipConnectionManagerCloseRequest)) {
      return false;
    }
    CipConnectionManagerCloseRequest that = (CipConnectionManagerCloseRequest) o;
    return (getRequestPathSize() == that.getRequestPathSize())
        && (getClassSegment() == that.getClassSegment())
        && (getInstanceSegment() == that.getInstanceSegment())
        && (getPriority() == that.getPriority())
        && (getTickTime() == that.getTickTime())
        && (getTimeoutTicks() == that.getTimeoutTicks())
        && (getConnectionSerialNumber() == that.getConnectionSerialNumber())
        && (getOriginatorVendorId() == that.getOriginatorVendorId())
        && (getOriginatorSerialNumber() == that.getOriginatorSerialNumber())
        && (getConnectionPathSize() == that.getConnectionPathSize())
        && (getConnectionPaths() == that.getConnectionPaths())
        && super.equals(that)
        && true;
  }

  @Override
  public int hashCode() {
    return Objects.hash(
        super.hashCode(),
        getRequestPathSize(),
        getClassSegment(),
        getInstanceSegment(),
        getPriority(),
        getTickTime(),
        getTimeoutTicks(),
        getConnectionSerialNumber(),
        getOriginatorVendorId(),
        getOriginatorSerialNumber(),
        getConnectionPathSize(),
        getConnectionPaths());
  }

  @Override
  public String toString() {
    WriteBufferBoxBased writeBufferBoxBased = new WriteBufferBoxBased(true, true);
    try {
      writeBufferBoxBased.writeSerializable(this);
    } catch (SerializationException e) {
      throw new RuntimeException(e);
    }
    return "\n" + writeBufferBoxBased.getBox().toString() + "\n";
  }
}
