/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package org.apache.plc4x.java.eip.readwrite;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

// Code generated by code-generation. DO NOT EDIT.

public enum CIPDataTypeCode {
  BOOL((int) 0X00C1, (short) 1),
  SINT((int) 0X00C2, (short) 1),
  INT((int) 0X00C3, (short) 2),
  DINT((int) 0X00C4, (short) 4),
  LINT((int) 0X00C5, (short) 8),
  USINT((int) 0X00C6, (short) 1),
  UINT((int) 0X00C7, (short) 2),
  UDINT((int) 0X00C8, (short) 4),
  ULINT((int) 0X00C9, (short) 8),
  REAL((int) 0X00CA, (short) 4),
  LREAL((int) 0X00CB, (short) 8),
  STIME((int) 0X00CC, (short) 4),
  DATE((int) 0X00CD, (short) 2),
  TIME_OF_DAY((int) 0X00CE, (short) 4),
  DATE_AND_TIME((int) 0X00CF, (short) 6),
  STRING((int) 0X00D0, (short) 0),
  BYTE((int) 0X00D1, (short) 1),
  WORD((int) 0X00D2, (short) 2),
  DWORD((int) 0X00D3, (short) 4),
  LWORD((int) 0X00D3, (short) 8),
  STRING2((int) 0X00D5, (short) 0),
  FTIME((int) 0X00D6, (short) 4),
  LTIME((int) 0X00D7, (short) 8),
  ITIME((int) 0X00D8, (short) 2),
  STRINGN((int) 0X00D9, (short) 0),
  SHORT_STRING((int) 0X00DA, (short) 0),
  TIME((int) 0X00DB, (short) 4),
  EPATH((int) 0X00DC, (short) 0),
  ENGUNIT((int) 0X00DD, (short) 0),
  STRINGI((int) 0X00DD, (short) 0),
  STRUCTURED((int) 0X02A0, (short) 88);
  private static final Map<Integer, CIPDataTypeCode> map;

  static {
    map = new HashMap<>();
    for (CIPDataTypeCode value : CIPDataTypeCode.values()) {
      map.put((int) value.getValue(), value);
    }
  }

  private final int value;
  private final short size;

  CIPDataTypeCode(int value, short size) {
    this.value = value;
    this.size = size;
  }

  public int getValue() {
    return value;
  }

  public short getSize() {
    return size;
  }

  public static CIPDataTypeCode firstEnumForFieldSize(short fieldValue) {
    for (CIPDataTypeCode _val : CIPDataTypeCode.values()) {
      if (_val.getSize() == fieldValue) {
        return _val;
      }
    }
    return null;
  }

  public static List<CIPDataTypeCode> enumsForFieldSize(short fieldValue) {
    List<CIPDataTypeCode> _values = new ArrayList<>();
    for (CIPDataTypeCode _val : CIPDataTypeCode.values()) {
      if (_val.getSize() == fieldValue) {
        _values.add(_val);
      }
    }
    return _values;
  }

  public static CIPDataTypeCode enumForValue(int value) {
    return map.get(value);
  }

  public static Boolean isDefined(int value) {
    return map.containsKey(value);
  }
}
