/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package org.apache.plc4x.java.bacnetip.readwrite;

import static org.apache.plc4x.java.spi.codegen.fields.FieldReaderFactory.*;
import static org.apache.plc4x.java.spi.codegen.fields.FieldWriterFactory.*;
import static org.apache.plc4x.java.spi.codegen.io.DataReaderFactory.*;
import static org.apache.plc4x.java.spi.codegen.io.DataWriterFactory.*;
import static org.apache.plc4x.java.spi.generation.StaticHelper.*;

import java.time.*;
import java.util.*;
import org.apache.plc4x.java.api.exceptions.*;
import org.apache.plc4x.java.api.value.*;
import org.apache.plc4x.java.spi.codegen.*;
import org.apache.plc4x.java.spi.codegen.fields.*;
import org.apache.plc4x.java.spi.codegen.io.*;
import org.apache.plc4x.java.spi.generation.*;

// Code generated by code-generation. DO NOT EDIT.

public class NLMRequestMasterKey extends NLM implements Message {

  // Accessors for discriminator values.
  public Short getMessageType() {
    return (short) 0x10;
  }

  // Properties.
  protected final short numberOfSupportedKeyAlgorithms;
  protected final byte[] encryptionAndSignatureAlgorithms;

  // Arguments.
  protected final Integer apduLength;

  public NLMRequestMasterKey(
      short numberOfSupportedKeyAlgorithms,
      byte[] encryptionAndSignatureAlgorithms,
      Integer apduLength) {
    super(apduLength);
    this.numberOfSupportedKeyAlgorithms = numberOfSupportedKeyAlgorithms;
    this.encryptionAndSignatureAlgorithms = encryptionAndSignatureAlgorithms;
    this.apduLength = apduLength;
  }

  public short getNumberOfSupportedKeyAlgorithms() {
    return numberOfSupportedKeyAlgorithms;
  }

  public byte[] getEncryptionAndSignatureAlgorithms() {
    return encryptionAndSignatureAlgorithms;
  }

  @Override
  protected void serializeNLMChild(WriteBuffer writeBuffer) throws SerializationException {
    PositionAware positionAware = writeBuffer;
    boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();
    writeBuffer.pushContext("NLMRequestMasterKey");

    // Simple Field (numberOfSupportedKeyAlgorithms)
    writeSimpleField(
        "numberOfSupportedKeyAlgorithms",
        numberOfSupportedKeyAlgorithms,
        writeUnsignedShort(writeBuffer, 8));

    // Array Field (encryptionAndSignatureAlgorithms)
    writeByteArrayField(
        "encryptionAndSignatureAlgorithms",
        encryptionAndSignatureAlgorithms,
        writeByteArray(writeBuffer, 8));

    writeBuffer.popContext("NLMRequestMasterKey");
  }

  @Override
  public int getLengthInBytes() {
    return (int) Math.ceil((float) getLengthInBits() / 8.0);
  }

  @Override
  public int getLengthInBits() {
    int lengthInBits = super.getLengthInBits();
    NLMRequestMasterKey _value = this;
    boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();

    // Simple field (numberOfSupportedKeyAlgorithms)
    lengthInBits += 8;

    // Array field
    if (encryptionAndSignatureAlgorithms != null) {
      lengthInBits += 8 * encryptionAndSignatureAlgorithms.length;
    }

    return lengthInBits;
  }

  public static NLMBuilder staticParseNLMBuilder(ReadBuffer readBuffer, Integer apduLength)
      throws ParseException {
    readBuffer.pullContext("NLMRequestMasterKey");
    PositionAware positionAware = readBuffer;
    boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();

    short numberOfSupportedKeyAlgorithms =
        readSimpleField("numberOfSupportedKeyAlgorithms", readUnsignedShort(readBuffer, 8));

    byte[] encryptionAndSignatureAlgorithms =
        readBuffer.readByteArray(
            "encryptionAndSignatureAlgorithms", Math.toIntExact((apduLength) - (2)));

    readBuffer.closeContext("NLMRequestMasterKey");
    // Create the instance
    return new NLMRequestMasterKeyBuilderImpl(
        numberOfSupportedKeyAlgorithms, encryptionAndSignatureAlgorithms, apduLength);
  }

  public static class NLMRequestMasterKeyBuilderImpl implements NLM.NLMBuilder {
    private final short numberOfSupportedKeyAlgorithms;
    private final byte[] encryptionAndSignatureAlgorithms;
    private final Integer apduLength;

    public NLMRequestMasterKeyBuilderImpl(
        short numberOfSupportedKeyAlgorithms,
        byte[] encryptionAndSignatureAlgorithms,
        Integer apduLength) {
      this.numberOfSupportedKeyAlgorithms = numberOfSupportedKeyAlgorithms;
      this.encryptionAndSignatureAlgorithms = encryptionAndSignatureAlgorithms;
      this.apduLength = apduLength;
    }

    public NLMRequestMasterKey build(Integer apduLength) {

      NLMRequestMasterKey nLMRequestMasterKey =
          new NLMRequestMasterKey(
              numberOfSupportedKeyAlgorithms, encryptionAndSignatureAlgorithms, apduLength);
      return nLMRequestMasterKey;
    }
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (!(o instanceof NLMRequestMasterKey)) {
      return false;
    }
    NLMRequestMasterKey that = (NLMRequestMasterKey) o;
    return (getNumberOfSupportedKeyAlgorithms() == that.getNumberOfSupportedKeyAlgorithms())
        && (getEncryptionAndSignatureAlgorithms() == that.getEncryptionAndSignatureAlgorithms())
        && super.equals(that)
        && true;
  }

  @Override
  public int hashCode() {
    return Objects.hash(
        super.hashCode(),
        getNumberOfSupportedKeyAlgorithms(),
        getEncryptionAndSignatureAlgorithms());
  }

  @Override
  public String toString() {
    WriteBufferBoxBased writeBufferBoxBased = new WriteBufferBoxBased(true, true);
    try {
      writeBufferBoxBased.writeSerializable(this);
    } catch (SerializationException e) {
      throw new RuntimeException(e);
    }
    return "\n" + writeBufferBoxBased.getBox().toString() + "\n";
  }
}
