/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package org.apache.plc4x.java.bacnetip.readwrite;

import static org.apache.plc4x.java.spi.codegen.fields.FieldReaderFactory.*;
import static org.apache.plc4x.java.spi.codegen.fields.FieldWriterFactory.*;
import static org.apache.plc4x.java.spi.codegen.io.DataReaderFactory.*;
import static org.apache.plc4x.java.spi.codegen.io.DataWriterFactory.*;
import static org.apache.plc4x.java.spi.generation.StaticHelper.*;

import java.time.*;
import java.util.*;
import org.apache.plc4x.java.api.exceptions.*;
import org.apache.plc4x.java.api.value.*;
import org.apache.plc4x.java.spi.codegen.*;
import org.apache.plc4x.java.spi.codegen.fields.*;
import org.apache.plc4x.java.spi.codegen.io.*;
import org.apache.plc4x.java.spi.generation.*;

// Code generated by code-generation. DO NOT EDIT.

public class NLMInitializeRoutingTablePortMapping implements Message {

  // Properties.
  protected final int destinationNetworkAddress;
  protected final short portId;
  protected final short portInfoLength;
  protected final byte[] portInfo;

  public NLMInitializeRoutingTablePortMapping(
      int destinationNetworkAddress, short portId, short portInfoLength, byte[] portInfo) {
    super();
    this.destinationNetworkAddress = destinationNetworkAddress;
    this.portId = portId;
    this.portInfoLength = portInfoLength;
    this.portInfo = portInfo;
  }

  public int getDestinationNetworkAddress() {
    return destinationNetworkAddress;
  }

  public short getPortId() {
    return portId;
  }

  public short getPortInfoLength() {
    return portInfoLength;
  }

  public byte[] getPortInfo() {
    return portInfo;
  }

  public void serialize(WriteBuffer writeBuffer) throws SerializationException {
    PositionAware positionAware = writeBuffer;
    boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();
    writeBuffer.pushContext("NLMInitializeRoutingTablePortMapping");

    // Simple Field (destinationNetworkAddress)
    writeSimpleField(
        "destinationNetworkAddress", destinationNetworkAddress, writeUnsignedInt(writeBuffer, 16));

    // Simple Field (portId)
    writeSimpleField("portId", portId, writeUnsignedShort(writeBuffer, 8));

    // Simple Field (portInfoLength)
    writeSimpleField("portInfoLength", portInfoLength, writeUnsignedShort(writeBuffer, 8));

    // Array Field (portInfo)
    writeByteArrayField("portInfo", portInfo, writeByteArray(writeBuffer, 8));

    writeBuffer.popContext("NLMInitializeRoutingTablePortMapping");
  }

  @Override
  public int getLengthInBytes() {
    return (int) Math.ceil((float) getLengthInBits() / 8.0);
  }

  @Override
  public int getLengthInBits() {
    int lengthInBits = 0;
    NLMInitializeRoutingTablePortMapping _value = this;
    boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();

    // Simple field (destinationNetworkAddress)
    lengthInBits += 16;

    // Simple field (portId)
    lengthInBits += 8;

    // Simple field (portInfoLength)
    lengthInBits += 8;

    // Array field
    if (portInfo != null) {
      lengthInBits += 8 * portInfo.length;
    }

    return lengthInBits;
  }

  public static NLMInitializeRoutingTablePortMapping staticParse(ReadBuffer readBuffer)
      throws ParseException {
    readBuffer.pullContext("NLMInitializeRoutingTablePortMapping");
    PositionAware positionAware = readBuffer;
    boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();

    int destinationNetworkAddress =
        readSimpleField("destinationNetworkAddress", readUnsignedInt(readBuffer, 16));

    short portId = readSimpleField("portId", readUnsignedShort(readBuffer, 8));

    short portInfoLength = readSimpleField("portInfoLength", readUnsignedShort(readBuffer, 8));

    byte[] portInfo = readBuffer.readByteArray("portInfo", Math.toIntExact(portInfoLength));

    readBuffer.closeContext("NLMInitializeRoutingTablePortMapping");
    // Create the instance
    NLMInitializeRoutingTablePortMapping _nLMInitializeRoutingTablePortMapping;
    _nLMInitializeRoutingTablePortMapping =
        new NLMInitializeRoutingTablePortMapping(
            destinationNetworkAddress, portId, portInfoLength, portInfo);
    return _nLMInitializeRoutingTablePortMapping;
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (!(o instanceof NLMInitializeRoutingTablePortMapping)) {
      return false;
    }
    NLMInitializeRoutingTablePortMapping that = (NLMInitializeRoutingTablePortMapping) o;
    return (getDestinationNetworkAddress() == that.getDestinationNetworkAddress())
        && (getPortId() == that.getPortId())
        && (getPortInfoLength() == that.getPortInfoLength())
        && (getPortInfo() == that.getPortInfo())
        && true;
  }

  @Override
  public int hashCode() {
    return Objects.hash(
        getDestinationNetworkAddress(), getPortId(), getPortInfoLength(), getPortInfo());
  }

  @Override
  public String toString() {
    WriteBufferBoxBased writeBufferBoxBased = new WriteBufferBoxBased(true, true);
    try {
      writeBufferBoxBased.writeSerializable(this);
    } catch (SerializationException e) {
      throw new RuntimeException(e);
    }
    return "\n" + writeBufferBoxBased.getBox().toString() + "\n";
  }
}
