/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package org.apache.plc4x.java.bacnetip.readwrite;

import java.util.HashMap;
import java.util.Map;

// Code generated by code-generation. DO NOT EDIT.

public enum BACnetPropertyIdentifier {
  ABSENTEE_LIMIT((long) 244L),
  ACCEPTED_MODES((long) 175L),
  ACCESS_ALARM_EVENTS((long) 245L),
  ACCESS_DOORS((long) 246L),
  ACCESS_EVENT((long) 247L),
  ACCESS_EVENT_AUTHENTICATION_FACTOR((long) 248L),
  ACCESS_EVENT_CREDENTIAL((long) 249L),
  ACCESS_EVENT_TAG((long) 322L),
  ACCESS_EVENT_TIME((long) 250L),
  ACCESS_TRANSACTION_EVENTS((long) 251L),
  ACCOMPANIMENT((long) 252L),
  ACCOMPANIMENT_TIME((long) 253L),
  ACK_REQUIRED((long) 1L),
  ACKED_TRANSITIONS((long) 0L),
  ACTION((long) 2L),
  ACTION_TEXT((long) 3L),
  ACTIVATION_TIME((long) 254L),
  ACTIVE_AUTHENTICATION_POLICY((long) 255L),
  ACTIVE_COV_MULTIPLE_SUBSCRIPTIONS((long) 481L),
  ACTIVE_COV_SUBSCRIPTIONS((long) 152L),
  ACTIVE_TEXT((long) 4L),
  ACTIVE_VT_SESSIONS((long) 5L),
  ACTUAL_SHED_LEVEL((long) 212L),
  ADJUST_VALUE((long) 176L),
  ALARM_VALUE((long) 6L),
  ALARM_VALUES((long) 7L),
  ALIGN_INTERVALS((long) 193L),
  ALL((long) 8L),
  ALL_WRITES_SUCCESSFUL((long) 9L),
  ALLOW_GROUP_DELAY_INHIBIT((long) 365L),
  APDU_LENGTH((long) 399L),
  APDU_SEGMENT_TIMEOUT((long) 10L),
  APDU_TIMEOUT((long) 11L),
  APPLICATION_SOFTWARE_VERSION((long) 12L),
  ARCHIVE((long) 13L),
  ASSIGNED_ACCESS_RIGHTS((long) 256L),
  ASSIGNED_LANDING_CALLS((long) 447L),
  ATTEMPTED_SAMPLES((long) 124L),
  AUTHENTICATION_FACTORS((long) 257L),
  AUTHENTICATION_POLICY_LIST((long) 258L),
  AUTHENTICATION_POLICY_NAMES((long) 259L),
  AUTHENTICATION_STATUS((long) 260L),
  AUTHORIZATION_EXEMPTIONS((long) 364L),
  AUTHORIZATION_MODE((long) 261L),
  AUTO_SLAVE_DISCOVERY((long) 169L),
  AVERAGE_VALUE((long) 125L),
  BACKUP_AND_RESTORE_STATE((long) 338L),
  BACKUP_FAILURE_TIMEOUT((long) 153L),
  BACKUP_PREPARATION_TIME((long) 339L),
  BACNET_IP_GLOBAL_ADDRESS((long) 407L),
  BACNET_IP_MODE((long) 408L),
  BACNET_IP_MULTICAST_ADDRESS((long) 409L),
  BACNET_IP_NAT_TRAVERSAL((long) 410L),
  BACNET_IP_UDP_PORT((long) 412L),
  BACNET_IPV6_MODE((long) 435L),
  BACNET_IPV6_UDP_PORT((long) 438L),
  BACNET_IPV6_MULTICAST_ADDRESS((long) 440L),
  BASE_DEVICE_SECURITY_POLICY((long) 327L),
  BBMD_ACCEPT_FD_REGISTRATIONS((long) 413L),
  BBMD_BROADCAST_DISTRIBUTION_TABLE((long) 414L),
  BBMD_FOREIGN_DEVICE_TABLE((long) 415L),
  BELONGS_TO((long) 262L),
  BIAS((long) 14L),
  BIT_MASK((long) 342L),
  BIT_TEXT((long) 343L),
  BLINK_WARN_ENABLE((long) 373L),
  BUFFER_SIZE((long) 126L),
  CAR_ASSIGNED_DIRECTION((long) 448L),
  CAR_DOOR_COMMAND((long) 449L),
  CAR_DOOR_STATUS((long) 450L),
  CAR_DOOR_TEXT((long) 451L),
  CAR_DOOR_ZONE((long) 452L),
  CAR_DRIVE_STATUS((long) 453L),
  CAR_LOAD((long) 454L),
  CAR_LOAD_UNITS((long) 455L),
  CAR_MODE((long) 456L),
  CAR_MOVING_DIRECTION((long) 457L),
  CAR_POSITION((long) 458L),
  CHANGE_OF_STATE_COUNT((long) 15L),
  CHANGE_OF_STATE_TIME((long) 16L),
  CHANGES_PENDING((long) 416L),
  CHANNEL_NUMBER((long) 366L),
  CLIENT_COV_INCREMENT((long) 127L),
  COMMAND((long) 417L),
  COMMAND_TIME_ARRAY((long) 430L),
  CONFIGURATION_FILES((long) 154L),
  CONTROL_GROUPS((long) 367L),
  CONTROLLED_VARIABLE_REFERENCE((long) 19L),
  CONTROLLED_VARIABLE_UNITS((long) 20L),
  CONTROLLED_VARIABLE_VALUE((long) 21L),
  COUNT((long) 177L),
  COUNT_BEFORE_CHANGE((long) 178L),
  COUNT_CHANGE_TIME((long) 179L),
  COV_INCREMENT((long) 22L),
  COV_PERIOD((long) 180L),
  COV_RESUBSCRIPTION_INTERVAL((long) 128L),
  COVU_PERIOD((long) 349L),
  COVU_RECIPIENTS((long) 350L),
  CREDENTIAL_DISABLE((long) 263L),
  CREDENTIAL_STATUS((long) 264L),
  CREDENTIALS((long) 265L),
  CREDENTIALS_IN_ZONE((long) 266L),
  CURRENT_COMMAND_PRIORITY((long) 431L),
  DATABASE_REVISION((long) 155L),
  DATE_LIST((long) 23L),
  DAYLIGHT_SAVINGS_STATUS((long) 24L),
  DAYS_REMAINING((long) 267L),
  DEADBAND((long) 25L),
  DEFAULT_FADE_TIME((long) 374L),
  DEFAULT_RAMP_RATE((long) 375L),
  DEFAULT_STEP_INCREMENT((long) 376L),
  DEFAULT_SUBORDINATE_RELATIONSHIP((long) 490L),
  DEFAULT_TIMEOUT((long) 393L),
  DEPLOYED_PROFILE_LOCATION((long) 484L),
  DERIVATIVE_CONSTANT((long) 26L),
  DERIVATIVE_CONSTANT_UNITS((long) 27L),
  DESCRIPTION((long) 28L),
  DESCRIPTION_OF_HALT((long) 29L),
  DEVICE_ADDRESS_BINDING((long) 30L),
  DEVICE_TYPE((long) 31L),
  DIRECT_READING((long) 156L),
  DISTRIBUTION_KEY_REVISION((long) 328L),
  DO_NOT_HIDE((long) 329L),
  DOOR_ALARM_STATE((long) 226L),
  DOOR_EXTENDED_PULSE_TIME((long) 227L),
  DOOR_MEMBERS((long) 228L),
  DOOR_OPEN_TOO_LONG_TIME((long) 229L),
  DOOR_PULSE_TIME((long) 230L),
  DOOR_STATUS((long) 231L),
  DOOR_UNLOCK_DELAY_TIME((long) 232L),
  DUTY_WINDOW((long) 213L),
  EFFECTIVE_PERIOD((long) 32L),
  EGRESS_ACTIVE((long) 386L),
  EGRESS_TIME((long) 377L),
  ELAPSED_ACTIVE_TIME((long) 33L),
  ELEVATOR_GROUP((long) 459L),
  ENABLE((long) 133L),
  ENERGY_METER((long) 460L),
  ENERGY_METER_REF((long) 461L),
  ENTRY_POINTS((long) 268L),
  ERROR_LIMIT((long) 34L),
  ESCALATOR_MODE((long) 462L),
  EVENT_ALGORITHM_INHIBIT((long) 354L),
  EVENT_ALGORITHM_INHIBIT_REF((long) 355L),
  EVENT_DETECTION_ENABLE((long) 353L),
  EVENT_ENABLE((long) 35L),
  EVENT_MESSAGE_TEXTS((long) 351L),
  EVENT_MESSAGE_TEXTS_CONFIG((long) 352L),
  EVENT_PARAMETERS((long) 83L),
  EVENT_STATE((long) 36L),
  EVENT_TIME_STAMPS((long) 130L),
  EVENT_TYPE((long) 37L),
  EXCEPTION_SCHEDULE((long) 38L),
  EXECUTION_DELAY((long) 368L),
  EXIT_POINTS((long) 269L),
  EXPECTED_SHED_LEVEL((long) 214L),
  EXPIRATION_TIME((long) 270L),
  EXTENDED_TIME_ENABLE((long) 271L),
  FAILED_ATTEMPT_EVENTS((long) 272L),
  FAILED_ATTEMPTS((long) 273L),
  FAILED_ATTEMPTS_TIME((long) 274L),
  FAULT_HIGH_LIMIT((long) 388L),
  FAULT_LOW_LIMIT((long) 389L),
  FAULT_PARAMETERS((long) 358L),
  FAULT_SIGNALS((long) 463L),
  FAULT_TYPE((long) 359L),
  FAULT_VALUES((long) 39L),
  FD_BBMD_ADDRESS((long) 418L),
  FD_SUBSCRIPTION_LIFETIME((long) 419L),
  FEEDBACK_VALUE((long) 40L),
  FILE_ACCESS_METHOD((long) 41L),
  FILE_SIZE((long) 42L),
  FILE_TYPE((long) 43L),
  FIRMWARE_REVISION((long) 44L),
  FLOOR_TEXT((long) 464L),
  FULL_DUTY_BASELINE((long) 215L),
  GLOBAL_IDENTIFIER((long) 323L),
  GROUP_ID((long) 465L),
  GROUP_MEMBER_NAMES((long) 346L),
  GROUP_MEMBERS((long) 345L),
  GROUP_MODE((long) 467L),
  HIGH_LIMIT((long) 45L),
  HIGHER_DECK((long) 468L),
  IN_PROCESS((long) 47L),
  IN_PROGRESS((long) 378L),
  INACTIVE_TEXT((long) 46L),
  INITIAL_TIMEOUT((long) 394L),
  INPUT_REFERENCE((long) 181L),
  INSTALLATION_ID((long) 469L),
  INSTANCE_OF((long) 48L),
  INSTANTANEOUS_POWER((long) 379L),
  INTEGRAL_CONSTANT((long) 49L),
  INTEGRAL_CONSTANT_UNITS((long) 50L),
  INTERFACE_VALUE((long) 387L),
  INTERVAL_OFFSET((long) 195L),
  IP_ADDRESS((long) 400L),
  IP_DEFAULT_GATEWAY((long) 401L),
  IP_DHCP_ENABLE((long) 402L),
  IP_DHCP_LEASE_TIME((long) 403L),
  IP_DHCP_LEASE_TIME_REMAINING((long) 404L),
  IP_DHCP_SERVER((long) 405L),
  IP_DNS_SERVER((long) 406L),
  IP_SUBNET_MASK((long) 411L),
  IPV6_ADDRESS((long) 436L),
  IPV6_AUTO_ADDRESSING_ENABLE((long) 442L),
  IPV6_DEFAULT_GATEWAY((long) 439L),
  IPV6_DHCP_LEASE_TIME((long) 443L),
  IPV6_DHCP_LEASE_TIME_REMAINING((long) 444L),
  IPV6_DHCP_SERVER((long) 445L),
  IPV6_DNS_SERVER((long) 441L),
  IPV6_PREFIX_LENGTH((long) 437L),
  IPV6_ZONE_INDEX((long) 446L),
  IS_UTC((long) 344L),
  KEY_SETS((long) 330L),
  LANDING_CALL_CONTROL((long) 471L),
  LANDING_CALLS((long) 470L),
  LANDING_DOOR_STATUS((long) 472L),
  LAST_ACCESS_EVENT((long) 275L),
  LAST_ACCESS_POINT((long) 276L),
  LAST_COMMAND_TIME((long) 432L),
  LAST_CREDENTIAL_ADDED((long) 277L),
  LAST_CREDENTIAL_ADDED_TIME((long) 278L),
  LAST_CREDENTIAL_REMOVED((long) 279L),
  LAST_CREDENTIAL_REMOVED_TIME((long) 280L),
  LAST_KEY_SERVER((long) 331L),
  LAST_NOTIFY_RECORD((long) 173L),
  LAST_PRIORITY((long) 369L),
  LAST_RESTART_REASON((long) 196L),
  LAST_RESTORE_TIME((long) 157L),
  LAST_STATE_CHANGE((long) 395L),
  LAST_USE_TIME((long) 281L),
  LIFE_SAFETY_ALARM_VALUES((long) 166L),
  LIGHTING_COMMAND((long) 380L),
  LIGHTING_COMMAND_DEFAULT_PRIORITY((long) 381L),
  LIMIT_ENABLE((long) 52L),
  LIMIT_MONITORING_INTERVAL((long) 182L),
  LINK_SPEED((long) 420L),
  LINK_SPEED_AUTONEGOTIATE((long) 422L),
  LINK_SPEEDS((long) 421L),
  LIST_OF_GROUP_MEMBERS((long) 53L),
  LIST_OF_OBJECT_PROPERTY_REFERENCES((long) 54L),
  LOCAL_DATE((long) 56L),
  LOCAL_FORWARDING_ONLY((long) 360L),
  LOCAL_TIME((long) 57L),
  LOCATION((long) 58L),
  LOCK_STATUS((long) 233L),
  LOCKOUT((long) 282L),
  LOCKOUT_RELINQUISH_TIME((long) 283L),
  LOG_BUFFER((long) 131L),
  LOG_DEVICE_OBJECT_PROPERTY((long) 132L),
  LOG_INTERVAL((long) 134L),
  LOGGING_OBJECT((long) 183L),
  LOGGING_RECORD((long) 184L),
  LOGGING_TYPE((long) 197L),
  LOW_DIFF_LIMIT((long) 390L),
  LOW_LIMIT((long) 59L),
  LOWER_DECK((long) 473L),
  MAC_ADDRESS((long) 423L),
  MACHINE_ROOM_ID((long) 474L),
  MAINTENANCE_REQUIRED((long) 158L),
  MAKING_CAR_CALL((long) 475L),
  MANIPULATED_VARIABLE_REFERENCE((long) 60L),
  MANUAL_SLAVE_ADDRESS_BINDING((long) 170L),
  MASKED_ALARM_VALUES((long) 234L),
  MAX_ACTUAL_VALUE((long) 382L),
  MAX_APDU_LENGTH_ACCEPTED((long) 62L),
  MAX_FAILED_ATTEMPTS((long) 285L),
  MAX_INFO_FRAMES((long) 63L),
  MAX_MASTER((long) 64L),
  MAX_PRES_VALUE((long) 65L),
  MAX_SEGMENTS_ACCEPTED((long) 167L),
  MAXIMUM_OUTPUT((long) 61L),
  MAXIMUM_VALUE((long) 135L),
  MAXIMUM_VALUE_TIMESTAMP((long) 149L),
  MEMBER_OF((long) 159L),
  MEMBER_STATUS_FLAGS((long) 347L),
  MEMBERS((long) 286L),
  MIN_ACTUAL_VALUE((long) 383L),
  MIN_PRES_VALUE((long) 69L),
  MINIMUM_OFF_TIME((long) 66L),
  MINIMUM_ON_TIME((long) 67L),
  MINIMUM_OUTPUT((long) 68L),
  MINIMUM_VALUE((long) 136L),
  MINIMUM_VALUE_TIMESTAMP((long) 150L),
  MODE((long) 160L),
  MODEL_NAME((long) 70L),
  MODIFICATION_DATE((long) 71L),
  MUSTER_POINT((long) 287L),
  NEGATIVE_ACCESS_RULES((long) 288L),
  NETWORK_ACCESS_SECURITY_POLICIES((long) 332L),
  NETWORK_INTERFACE_NAME((long) 424L),
  NETWORK_NUMBER((long) 425L),
  NETWORK_NUMBER_QUALITY((long) 426L),
  NETWORK_TYPE((long) 427L),
  NEXT_STOPPING_FLOOR((long) 476L),
  NODE_SUBTYPE((long) 207L),
  NODE_TYPE((long) 208L),
  NOTIFICATION_CLASS((long) 17L),
  NOTIFICATION_THRESHOLD((long) 137L),
  NOTIFY_TYPE((long) 72L),
  NUMBER_OF_APDU_RETRIES((long) 73L),
  NUMBER_OF_AUTHENTICATION_POLICIES((long) 289L),
  NUMBER_OF_STATES((long) 74L),
  OBJECT_IDENTIFIER((long) 75L),
  OBJECT_LIST((long) 76L),
  OBJECT_NAME((long) 77L),
  OBJECT_PROPERTY_REFERENCE((long) 78L),
  OBJECT_TYPE((long) 79L),
  OCCUPANCY_COUNT((long) 290L),
  OCCUPANCY_COUNT_ADJUST((long) 291L),
  OCCUPANCY_COUNT_ENABLE((long) 292L),
  OCCUPANCY_LOWER_LIMIT((long) 294L),
  OCCUPANCY_LOWER_LIMIT_ENFORCED((long) 295L),
  OCCUPANCY_STATE((long) 296L),
  OCCUPANCY_UPPER_LIMIT((long) 297L),
  OCCUPANCY_UPPER_LIMIT_ENFORCED((long) 298L),
  OPERATION_DIRECTION((long) 477L),
  OPERATION_EXPECTED((long) 161L),
  OPTIONAL((long) 80L),
  OUT_OF_SERVICE((long) 81L),
  OUTPUT_UNITS((long) 82L),
  PACKET_REORDER_TIME((long) 333L),
  PASSBACK_MODE((long) 300L),
  PASSBACK_TIMEOUT((long) 301L),
  PASSENGER_ALARM((long) 478L),
  POLARITY((long) 84L),
  PORT_FILTER((long) 363L),
  POSITIVE_ACCESS_RULES((long) 302L),
  POWER((long) 384L),
  POWER_MODE((long) 479L),
  PRESCALE((long) 185L),
  PRESENT_VALUE((long) 85L),
  PRIORITY((long) 86L),
  PRIORITY_ARRAY((long) 87L),
  PRIORITY_FOR_WRITING((long) 88L),
  PROCESS_IDENTIFIER((long) 89L),
  PROCESS_IDENTIFIER_FILTER((long) 361L),
  PROFILE_LOCATION((long) 485L),
  PROFILE_NAME((long) 168L),
  PROGRAM_CHANGE((long) 90L),
  PROGRAM_LOCATION((long) 91L),
  PROGRAM_STATE((long) 92L),
  PROPERTY_LIST((long) 371L),
  PROPORTIONAL_CONSTANT((long) 93L),
  PROPORTIONAL_CONSTANT_UNITS((long) 94L),
  PROTOCOL_LEVEL((long) 482L),
  PROTOCOL_CONFORMANCE_CLASS((long) 95L),
  PROTOCOL_OBJECT_TYPES_SUPPORTED((long) 96L),
  PROTOCOL_REVISION((long) 139L),
  PROTOCOL_SERVICES_SUPPORTED((long) 97L),
  PROTOCOL_VERSION((long) 98L),
  PULSE_RATE((long) 186L),
  READ_ONLY((long) 99L),
  REASON_FOR_DISABLE((long) 303L),
  REASON_FOR_HALT((long) 100L),
  RECIPIENT_LIST((long) 102L),
  RECORD_COUNT((long) 141L),
  RECORDS_SINCE_NOTIFICATION((long) 140L),
  REFERENCE_PORT((long) 483L),
  REGISTERED_CAR_CALL((long) 480L),
  RELIABILITY((long) 103L),
  RELIABILITY_EVALUATION_INHIBIT((long) 357L),
  RELINQUISH_DEFAULT((long) 104L),
  REPRESENTS((long) 491L),
  REQUESTED_SHED_LEVEL((long) 218L),
  REQUESTED_UPDATE_INTERVAL((long) 348L),
  REQUIRED((long) 105L),
  RESOLUTION((long) 106L),
  RESTART_NOTIFICATION_RECIPIENTS((long) 202L),
  RESTORE_COMPLETION_TIME((long) 340L),
  RESTORE_PREPARATION_TIME((long) 341L),
  ROUTING_TABLE((long) 428L),
  SCALE((long) 187L),
  SCALE_FACTOR((long) 188L),
  SCHEDULE_DEFAULT((long) 174L),
  SECURED_STATUS((long) 235L),
  SECURITY_PDU_TIMEOUT((long) 334L),
  SECURITY_TIME_WINDOW((long) 335L),
  SEGMENTATION_SUPPORTED((long) 107L),
  SERIAL_NUMBER((long) 372L),
  SETPOINT((long) 108L),
  SETPOINT_REFERENCE((long) 109L),
  SETTING((long) 162L),
  SHED_DURATION((long) 219L),
  SHED_LEVEL_DESCRIPTIONS((long) 220L),
  SHED_LEVELS((long) 221L),
  SILENCED((long) 163L),
  SLAVE_ADDRESS_BINDING((long) 171L),
  SLAVE_PROXY_ENABLE((long) 172L),
  START_TIME((long) 142L),
  STATE_CHANGE_VALUES((long) 396L),
  STATE_DESCRIPTION((long) 222L),
  STATE_TEXT((long) 110L),
  STATUS_FLAGS((long) 111L),
  STOP_TIME((long) 143L),
  STOP_WHEN_FULL((long) 144L),
  STRIKE_COUNT((long) 391L),
  STRUCTURED_OBJECT_LIST((long) 209L),
  SUBORDINATE_ANNOTATIONS((long) 210L),
  SUBORDINATE_LIST((long) 211L),
  SUBORDINATE_NODE_TYPES((long) 487L),
  SUBORDINATE_RELATIONSHIPS((long) 489L),
  SUBORDINATE_TAGS((long) 488L),
  SUBSCRIBED_RECIPIENTS((long) 362L),
  SUPPORTED_FORMAT_CLASSES((long) 305L),
  SUPPORTED_FORMATS((long) 304L),
  SUPPORTED_SECURITY_ALGORITHMS((long) 336L),
  SYSTEM_STATUS((long) 112L),
  TAGS((long) 486L),
  THREAT_AUTHORITY((long) 306L),
  THREAT_LEVEL((long) 307L),
  TIME_DELAY((long) 113L),
  TIME_DELAY_NORMAL((long) 356L),
  TIME_OF_ACTIVE_TIME_RESET((long) 114L),
  TIME_OF_DEVICE_RESTART((long) 203L),
  TIME_OF_STATE_COUNT_RESET((long) 115L),
  TIME_OF_STRIKE_COUNT_RESET((long) 392L),
  TIME_SYNCHRONIZATION_INTERVAL((long) 204L),
  TIME_SYNCHRONIZATION_RECIPIENTS((long) 116L),
  TIMER_RUNNING((long) 397L),
  TIMER_STATE((long) 398L),
  TOTAL_RECORD_COUNT((long) 145L),
  TRACE_FLAG((long) 308L),
  TRACKING_VALUE((long) 164L),
  TRANSACTION_NOTIFICATION_CLASS((long) 309L),
  TRANSITION((long) 385L),
  TRIGGER((long) 205L),
  UNITS((long) 117L),
  UPDATE_INTERVAL((long) 118L),
  UPDATE_KEY_SET_TIMEOUT((long) 337L),
  UPDATE_TIME((long) 189L),
  USER_EXTERNAL_IDENTIFIER((long) 310L),
  USER_INFORMATION_REFERENCE((long) 311L),
  USER_NAME((long) 317L),
  USER_TYPE((long) 318L),
  USES_REMAINING((long) 319L),
  UTC_OFFSET((long) 119L),
  UTC_TIME_SYNCHRONIZATION_RECIPIENTS((long) 206L),
  VALID_SAMPLES((long) 146L),
  VALUE_BEFORE_CHANGE((long) 190L),
  VALUE_CHANGE_TIME((long) 192L),
  VALUE_SET((long) 191L),
  VALUE_SOURCE((long) 433L),
  VALUE_SOURCE_ARRAY((long) 434L),
  VARIANCE_VALUE((long) 151L),
  VENDOR_IDENTIFIER((long) 120L),
  VENDOR_NAME((long) 121L),
  VERIFICATION_TIME((long) 326L),
  VIRTUAL_MAC_ADDRESS_TABLE((long) 429L),
  VT_CLASSES_SUPPORTED((long) 122L),
  WEEKLY_SCHEDULE((long) 123L),
  WINDOW_INTERVAL((long) 147L),
  WINDOW_SAMPLES((long) 148L),
  WRITE_STATUS((long) 370L),
  ZONE_FROM((long) 320L),
  ZONE_MEMBERS((long) 165L),
  ZONE_TO((long) 321L),
  VENDOR_PROPRIETARY_VALUE((long) 9999L);
  private static final Map<Long, BACnetPropertyIdentifier> map;

  static {
    map = new HashMap<>();
    for (BACnetPropertyIdentifier value : BACnetPropertyIdentifier.values()) {
      map.put((long) value.getValue(), value);
    }
  }

  private final long value;

  BACnetPropertyIdentifier(long value) {
    this.value = value;
  }

  public long getValue() {
    return value;
  }

  public static BACnetPropertyIdentifier enumForValue(long value) {
    return map.get(value);
  }

  public static Boolean isDefined(long value) {
    return map.containsKey(value);
  }
}
