/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package org.apache.plc4x.java.bacnetip.readwrite;

import java.util.HashMap;
import java.util.Map;

// Code generated by code-generation. DO NOT EDIT.

public enum BACnetNetworkType {
  ETHERNET((short) 0x0),
  ARCNET((short) 0x1),
  MSTP((short) 0x2),
  PTP((short) 0x3),
  LONTALK((short) 0x4),
  IPV4((short) 0x5),
  ZIGBEE((short) 0x6),
  VIRTUAL((short) 0x7),
  REMOVED_NON_BACNET((short) 0x8),
  IPV6((short) 0x9),
  SERIAL((short) 0xA),
  VENDOR_PROPRIETARY_VALUE((short) 0XFF);
  private static final Map<Short, BACnetNetworkType> map;

  static {
    map = new HashMap<>();
    for (BACnetNetworkType value : BACnetNetworkType.values()) {
      map.put((short) value.getValue(), value);
    }
  }

  private final short value;

  BACnetNetworkType(short value) {
    this.value = value;
  }

  public short getValue() {
    return value;
  }

  public static BACnetNetworkType enumForValue(short value) {
    return map.get(value);
  }

  public static Boolean isDefined(short value) {
    return map.containsKey(value);
  }
}
