/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package org.apache.plc4x.java.ads.discovery.readwrite;

import static org.apache.plc4x.java.spi.codegen.fields.FieldReaderFactory.*;
import static org.apache.plc4x.java.spi.codegen.fields.FieldWriterFactory.*;
import static org.apache.plc4x.java.spi.codegen.io.DataReaderFactory.*;
import static org.apache.plc4x.java.spi.codegen.io.DataWriterFactory.*;
import static org.apache.plc4x.java.spi.generation.StaticHelper.*;

import java.time.*;
import java.util.*;
import org.apache.plc4x.java.api.exceptions.*;
import org.apache.plc4x.java.api.value.*;
import org.apache.plc4x.java.spi.codegen.*;
import org.apache.plc4x.java.spi.codegen.fields.*;
import org.apache.plc4x.java.spi.codegen.io.*;
import org.apache.plc4x.java.spi.generation.*;

// Code generated by code-generation. DO NOT EDIT.

public class AdsDiscoveryBlockStatus extends AdsDiscoveryBlock implements Message {

  // Accessors for discriminator values.
  public AdsDiscoveryBlockType getBlockType() {
    return AdsDiscoveryBlockType.STATUS;
  }

  // Constant values.
  public static final Integer STATUSLENGTH = 0x0004;

  // Properties.
  protected final Status status;

  public AdsDiscoveryBlockStatus(Status status) {
    super();
    this.status = status;
  }

  public Status getStatus() {
    return status;
  }

  public int getStatusLength() {
    return STATUSLENGTH;
  }

  @Override
  protected void serializeAdsDiscoveryBlockChild(WriteBuffer writeBuffer)
      throws SerializationException {
    PositionAware positionAware = writeBuffer;
    boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();
    writeBuffer.pushContext("AdsDiscoveryBlockStatus");

    // Const Field (statusLength)
    writeConstField("statusLength", STATUSLENGTH, writeUnsignedInt(writeBuffer, 16));

    // Simple Field (status)
    writeSimpleEnumField(
        "status",
        "Status",
        status,
        writeEnum(Status::getValue, Status::name, writeUnsignedLong(writeBuffer, 32)));

    writeBuffer.popContext("AdsDiscoveryBlockStatus");
  }

  @Override
  public int getLengthInBytes() {
    return (int) Math.ceil((float) getLengthInBits() / 8.0);
  }

  @Override
  public int getLengthInBits() {
    int lengthInBits = super.getLengthInBits();
    AdsDiscoveryBlockStatus _value = this;
    boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();

    // Const Field (statusLength)
    lengthInBits += 16;

    // Simple field (status)
    lengthInBits += 32;

    return lengthInBits;
  }

  public static AdsDiscoveryBlockBuilder staticParseAdsDiscoveryBlockBuilder(ReadBuffer readBuffer)
      throws ParseException {
    readBuffer.pullContext("AdsDiscoveryBlockStatus");
    PositionAware positionAware = readBuffer;
    boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();

    int statusLength =
        readConstField(
            "statusLength", readUnsignedInt(readBuffer, 16), AdsDiscoveryBlockStatus.STATUSLENGTH);

    Status status =
        readEnumField(
            "status", "Status", readEnum(Status::enumForValue, readUnsignedLong(readBuffer, 32)));

    readBuffer.closeContext("AdsDiscoveryBlockStatus");
    // Create the instance
    return new AdsDiscoveryBlockStatusBuilderImpl(status);
  }

  public static class AdsDiscoveryBlockStatusBuilderImpl
      implements AdsDiscoveryBlock.AdsDiscoveryBlockBuilder {
    private final Status status;

    public AdsDiscoveryBlockStatusBuilderImpl(Status status) {
      this.status = status;
    }

    public AdsDiscoveryBlockStatus build() {
      AdsDiscoveryBlockStatus adsDiscoveryBlockStatus = new AdsDiscoveryBlockStatus(status);
      return adsDiscoveryBlockStatus;
    }
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (!(o instanceof AdsDiscoveryBlockStatus)) {
      return false;
    }
    AdsDiscoveryBlockStatus that = (AdsDiscoveryBlockStatus) o;
    return (getStatus() == that.getStatus()) && super.equals(that) && true;
  }

  @Override
  public int hashCode() {
    return Objects.hash(super.hashCode(), getStatus());
  }

  @Override
  public String toString() {
    WriteBufferBoxBased writeBufferBoxBased = new WriteBufferBoxBased(true, true);
    try {
      writeBufferBoxBased.writeSerializable(this);
    } catch (SerializationException e) {
      throw new RuntimeException(e);
    }
    return "\n" + writeBufferBoxBased.getBox().toString() + "\n";
  }
}
