/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

// Code generated by mockery v2.42.2. DO NOT EDIT.

package utils

import (
	time "time"

	mock "github.com/stretchr/testify/mock"

	values "github.com/apache/plc4x/plc4go/pkg/api/values"
)

// MockPlcValue is an autogenerated mock type for the PlcValue type
type MockPlcValue struct {
	mock.Mock
}

type MockPlcValue_Expecter struct {
	mock *mock.Mock
}

func (_m *MockPlcValue) EXPECT() *MockPlcValue_Expecter {
	return &MockPlcValue_Expecter{mock: &_m.Mock}
}

// GetBool provides a mock function with given fields:
func (_m *MockPlcValue) GetBool() bool {
	ret := _m.Called()

	if len(ret) == 0 {
		panic("no return value specified for GetBool")
	}

	var r0 bool
	if rf, ok := ret.Get(0).(func() bool); ok {
		r0 = rf()
	} else {
		r0 = ret.Get(0).(bool)
	}

	return r0
}

// MockPlcValue_GetBool_Call is a *mock.Call that shadows Run/Return methods with type explicit version for method 'GetBool'
type MockPlcValue_GetBool_Call struct {
	*mock.Call
}

// GetBool is a helper method to define mock.On call
func (_e *MockPlcValue_Expecter) GetBool() *MockPlcValue_GetBool_Call {
	return &MockPlcValue_GetBool_Call{Call: _e.mock.On("GetBool")}
}

func (_c *MockPlcValue_GetBool_Call) Run(run func()) *MockPlcValue_GetBool_Call {
	_c.Call.Run(func(args mock.Arguments) {
		run()
	})
	return _c
}

func (_c *MockPlcValue_GetBool_Call) Return(_a0 bool) *MockPlcValue_GetBool_Call {
	_c.Call.Return(_a0)
	return _c
}

func (_c *MockPlcValue_GetBool_Call) RunAndReturn(run func() bool) *MockPlcValue_GetBool_Call {
	_c.Call.Return(run)
	return _c
}

// GetBoolArray provides a mock function with given fields:
func (_m *MockPlcValue) GetBoolArray() []bool {
	ret := _m.Called()

	if len(ret) == 0 {
		panic("no return value specified for GetBoolArray")
	}

	var r0 []bool
	if rf, ok := ret.Get(0).(func() []bool); ok {
		r0 = rf()
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).([]bool)
		}
	}

	return r0
}

// MockPlcValue_GetBoolArray_Call is a *mock.Call that shadows Run/Return methods with type explicit version for method 'GetBoolArray'
type MockPlcValue_GetBoolArray_Call struct {
	*mock.Call
}

// GetBoolArray is a helper method to define mock.On call
func (_e *MockPlcValue_Expecter) GetBoolArray() *MockPlcValue_GetBoolArray_Call {
	return &MockPlcValue_GetBoolArray_Call{Call: _e.mock.On("GetBoolArray")}
}

func (_c *MockPlcValue_GetBoolArray_Call) Run(run func()) *MockPlcValue_GetBoolArray_Call {
	_c.Call.Run(func(args mock.Arguments) {
		run()
	})
	return _c
}

func (_c *MockPlcValue_GetBoolArray_Call) Return(_a0 []bool) *MockPlcValue_GetBoolArray_Call {
	_c.Call.Return(_a0)
	return _c
}

func (_c *MockPlcValue_GetBoolArray_Call) RunAndReturn(run func() []bool) *MockPlcValue_GetBoolArray_Call {
	_c.Call.Return(run)
	return _c
}

// GetBoolAt provides a mock function with given fields: index
func (_m *MockPlcValue) GetBoolAt(index uint32) bool {
	ret := _m.Called(index)

	if len(ret) == 0 {
		panic("no return value specified for GetBoolAt")
	}

	var r0 bool
	if rf, ok := ret.Get(0).(func(uint32) bool); ok {
		r0 = rf(index)
	} else {
		r0 = ret.Get(0).(bool)
	}

	return r0
}

// MockPlcValue_GetBoolAt_Call is a *mock.Call that shadows Run/Return methods with type explicit version for method 'GetBoolAt'
type MockPlcValue_GetBoolAt_Call struct {
	*mock.Call
}

// GetBoolAt is a helper method to define mock.On call
//   - index uint32
func (_e *MockPlcValue_Expecter) GetBoolAt(index interface{}) *MockPlcValue_GetBoolAt_Call {
	return &MockPlcValue_GetBoolAt_Call{Call: _e.mock.On("GetBoolAt", index)}
}

func (_c *MockPlcValue_GetBoolAt_Call) Run(run func(index uint32)) *MockPlcValue_GetBoolAt_Call {
	_c.Call.Run(func(args mock.Arguments) {
		run(args[0].(uint32))
	})
	return _c
}

func (_c *MockPlcValue_GetBoolAt_Call) Return(_a0 bool) *MockPlcValue_GetBoolAt_Call {
	_c.Call.Return(_a0)
	return _c
}

func (_c *MockPlcValue_GetBoolAt_Call) RunAndReturn(run func(uint32) bool) *MockPlcValue_GetBoolAt_Call {
	_c.Call.Return(run)
	return _c
}

// GetBoolLength provides a mock function with given fields:
func (_m *MockPlcValue) GetBoolLength() uint32 {
	ret := _m.Called()

	if len(ret) == 0 {
		panic("no return value specified for GetBoolLength")
	}

	var r0 uint32
	if rf, ok := ret.Get(0).(func() uint32); ok {
		r0 = rf()
	} else {
		r0 = ret.Get(0).(uint32)
	}

	return r0
}

// MockPlcValue_GetBoolLength_Call is a *mock.Call that shadows Run/Return methods with type explicit version for method 'GetBoolLength'
type MockPlcValue_GetBoolLength_Call struct {
	*mock.Call
}

// GetBoolLength is a helper method to define mock.On call
func (_e *MockPlcValue_Expecter) GetBoolLength() *MockPlcValue_GetBoolLength_Call {
	return &MockPlcValue_GetBoolLength_Call{Call: _e.mock.On("GetBoolLength")}
}

func (_c *MockPlcValue_GetBoolLength_Call) Run(run func()) *MockPlcValue_GetBoolLength_Call {
	_c.Call.Run(func(args mock.Arguments) {
		run()
	})
	return _c
}

func (_c *MockPlcValue_GetBoolLength_Call) Return(_a0 uint32) *MockPlcValue_GetBoolLength_Call {
	_c.Call.Return(_a0)
	return _c
}

func (_c *MockPlcValue_GetBoolLength_Call) RunAndReturn(run func() uint32) *MockPlcValue_GetBoolLength_Call {
	_c.Call.Return(run)
	return _c
}

// GetByte provides a mock function with given fields:
func (_m *MockPlcValue) GetByte() byte {
	ret := _m.Called()

	if len(ret) == 0 {
		panic("no return value specified for GetByte")
	}

	var r0 byte
	if rf, ok := ret.Get(0).(func() byte); ok {
		r0 = rf()
	} else {
		r0 = ret.Get(0).(byte)
	}

	return r0
}

// MockPlcValue_GetByte_Call is a *mock.Call that shadows Run/Return methods with type explicit version for method 'GetByte'
type MockPlcValue_GetByte_Call struct {
	*mock.Call
}

// GetByte is a helper method to define mock.On call
func (_e *MockPlcValue_Expecter) GetByte() *MockPlcValue_GetByte_Call {
	return &MockPlcValue_GetByte_Call{Call: _e.mock.On("GetByte")}
}

func (_c *MockPlcValue_GetByte_Call) Run(run func()) *MockPlcValue_GetByte_Call {
	_c.Call.Run(func(args mock.Arguments) {
		run()
	})
	return _c
}

func (_c *MockPlcValue_GetByte_Call) Return(_a0 byte) *MockPlcValue_GetByte_Call {
	_c.Call.Return(_a0)
	return _c
}

func (_c *MockPlcValue_GetByte_Call) RunAndReturn(run func() byte) *MockPlcValue_GetByte_Call {
	_c.Call.Return(run)
	return _c
}

// GetDate provides a mock function with given fields:
func (_m *MockPlcValue) GetDate() time.Time {
	ret := _m.Called()

	if len(ret) == 0 {
		panic("no return value specified for GetDate")
	}

	var r0 time.Time
	if rf, ok := ret.Get(0).(func() time.Time); ok {
		r0 = rf()
	} else {
		r0 = ret.Get(0).(time.Time)
	}

	return r0
}

// MockPlcValue_GetDate_Call is a *mock.Call that shadows Run/Return methods with type explicit version for method 'GetDate'
type MockPlcValue_GetDate_Call struct {
	*mock.Call
}

// GetDate is a helper method to define mock.On call
func (_e *MockPlcValue_Expecter) GetDate() *MockPlcValue_GetDate_Call {
	return &MockPlcValue_GetDate_Call{Call: _e.mock.On("GetDate")}
}

func (_c *MockPlcValue_GetDate_Call) Run(run func()) *MockPlcValue_GetDate_Call {
	_c.Call.Run(func(args mock.Arguments) {
		run()
	})
	return _c
}

func (_c *MockPlcValue_GetDate_Call) Return(_a0 time.Time) *MockPlcValue_GetDate_Call {
	_c.Call.Return(_a0)
	return _c
}

func (_c *MockPlcValue_GetDate_Call) RunAndReturn(run func() time.Time) *MockPlcValue_GetDate_Call {
	_c.Call.Return(run)
	return _c
}

// GetDateTime provides a mock function with given fields:
func (_m *MockPlcValue) GetDateTime() time.Time {
	ret := _m.Called()

	if len(ret) == 0 {
		panic("no return value specified for GetDateTime")
	}

	var r0 time.Time
	if rf, ok := ret.Get(0).(func() time.Time); ok {
		r0 = rf()
	} else {
		r0 = ret.Get(0).(time.Time)
	}

	return r0
}

// MockPlcValue_GetDateTime_Call is a *mock.Call that shadows Run/Return methods with type explicit version for method 'GetDateTime'
type MockPlcValue_GetDateTime_Call struct {
	*mock.Call
}

// GetDateTime is a helper method to define mock.On call
func (_e *MockPlcValue_Expecter) GetDateTime() *MockPlcValue_GetDateTime_Call {
	return &MockPlcValue_GetDateTime_Call{Call: _e.mock.On("GetDateTime")}
}

func (_c *MockPlcValue_GetDateTime_Call) Run(run func()) *MockPlcValue_GetDateTime_Call {
	_c.Call.Run(func(args mock.Arguments) {
		run()
	})
	return _c
}

func (_c *MockPlcValue_GetDateTime_Call) Return(_a0 time.Time) *MockPlcValue_GetDateTime_Call {
	_c.Call.Return(_a0)
	return _c
}

func (_c *MockPlcValue_GetDateTime_Call) RunAndReturn(run func() time.Time) *MockPlcValue_GetDateTime_Call {
	_c.Call.Return(run)
	return _c
}

// GetDuration provides a mock function with given fields:
func (_m *MockPlcValue) GetDuration() time.Duration {
	ret := _m.Called()

	if len(ret) == 0 {
		panic("no return value specified for GetDuration")
	}

	var r0 time.Duration
	if rf, ok := ret.Get(0).(func() time.Duration); ok {
		r0 = rf()
	} else {
		r0 = ret.Get(0).(time.Duration)
	}

	return r0
}

// MockPlcValue_GetDuration_Call is a *mock.Call that shadows Run/Return methods with type explicit version for method 'GetDuration'
type MockPlcValue_GetDuration_Call struct {
	*mock.Call
}

// GetDuration is a helper method to define mock.On call
func (_e *MockPlcValue_Expecter) GetDuration() *MockPlcValue_GetDuration_Call {
	return &MockPlcValue_GetDuration_Call{Call: _e.mock.On("GetDuration")}
}

func (_c *MockPlcValue_GetDuration_Call) Run(run func()) *MockPlcValue_GetDuration_Call {
	_c.Call.Run(func(args mock.Arguments) {
		run()
	})
	return _c
}

func (_c *MockPlcValue_GetDuration_Call) Return(_a0 time.Duration) *MockPlcValue_GetDuration_Call {
	_c.Call.Return(_a0)
	return _c
}

func (_c *MockPlcValue_GetDuration_Call) RunAndReturn(run func() time.Duration) *MockPlcValue_GetDuration_Call {
	_c.Call.Return(run)
	return _c
}

// GetFloat32 provides a mock function with given fields:
func (_m *MockPlcValue) GetFloat32() float32 {
	ret := _m.Called()

	if len(ret) == 0 {
		panic("no return value specified for GetFloat32")
	}

	var r0 float32
	if rf, ok := ret.Get(0).(func() float32); ok {
		r0 = rf()
	} else {
		r0 = ret.Get(0).(float32)
	}

	return r0
}

// MockPlcValue_GetFloat32_Call is a *mock.Call that shadows Run/Return methods with type explicit version for method 'GetFloat32'
type MockPlcValue_GetFloat32_Call struct {
	*mock.Call
}

// GetFloat32 is a helper method to define mock.On call
func (_e *MockPlcValue_Expecter) GetFloat32() *MockPlcValue_GetFloat32_Call {
	return &MockPlcValue_GetFloat32_Call{Call: _e.mock.On("GetFloat32")}
}

func (_c *MockPlcValue_GetFloat32_Call) Run(run func()) *MockPlcValue_GetFloat32_Call {
	_c.Call.Run(func(args mock.Arguments) {
		run()
	})
	return _c
}

func (_c *MockPlcValue_GetFloat32_Call) Return(_a0 float32) *MockPlcValue_GetFloat32_Call {
	_c.Call.Return(_a0)
	return _c
}

func (_c *MockPlcValue_GetFloat32_Call) RunAndReturn(run func() float32) *MockPlcValue_GetFloat32_Call {
	_c.Call.Return(run)
	return _c
}

// GetFloat64 provides a mock function with given fields:
func (_m *MockPlcValue) GetFloat64() float64 {
	ret := _m.Called()

	if len(ret) == 0 {
		panic("no return value specified for GetFloat64")
	}

	var r0 float64
	if rf, ok := ret.Get(0).(func() float64); ok {
		r0 = rf()
	} else {
		r0 = ret.Get(0).(float64)
	}

	return r0
}

// MockPlcValue_GetFloat64_Call is a *mock.Call that shadows Run/Return methods with type explicit version for method 'GetFloat64'
type MockPlcValue_GetFloat64_Call struct {
	*mock.Call
}

// GetFloat64 is a helper method to define mock.On call
func (_e *MockPlcValue_Expecter) GetFloat64() *MockPlcValue_GetFloat64_Call {
	return &MockPlcValue_GetFloat64_Call{Call: _e.mock.On("GetFloat64")}
}

func (_c *MockPlcValue_GetFloat64_Call) Run(run func()) *MockPlcValue_GetFloat64_Call {
	_c.Call.Run(func(args mock.Arguments) {
		run()
	})
	return _c
}

func (_c *MockPlcValue_GetFloat64_Call) Return(_a0 float64) *MockPlcValue_GetFloat64_Call {
	_c.Call.Return(_a0)
	return _c
}

func (_c *MockPlcValue_GetFloat64_Call) RunAndReturn(run func() float64) *MockPlcValue_GetFloat64_Call {
	_c.Call.Return(run)
	return _c
}

// GetIndex provides a mock function with given fields: i
func (_m *MockPlcValue) GetIndex(i uint32) values.PlcValue {
	ret := _m.Called(i)

	if len(ret) == 0 {
		panic("no return value specified for GetIndex")
	}

	var r0 values.PlcValue
	if rf, ok := ret.Get(0).(func(uint32) values.PlcValue); ok {
		r0 = rf(i)
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).(values.PlcValue)
		}
	}

	return r0
}

// MockPlcValue_GetIndex_Call is a *mock.Call that shadows Run/Return methods with type explicit version for method 'GetIndex'
type MockPlcValue_GetIndex_Call struct {
	*mock.Call
}

// GetIndex is a helper method to define mock.On call
//   - i uint32
func (_e *MockPlcValue_Expecter) GetIndex(i interface{}) *MockPlcValue_GetIndex_Call {
	return &MockPlcValue_GetIndex_Call{Call: _e.mock.On("GetIndex", i)}
}

func (_c *MockPlcValue_GetIndex_Call) Run(run func(i uint32)) *MockPlcValue_GetIndex_Call {
	_c.Call.Run(func(args mock.Arguments) {
		run(args[0].(uint32))
	})
	return _c
}

func (_c *MockPlcValue_GetIndex_Call) Return(_a0 values.PlcValue) *MockPlcValue_GetIndex_Call {
	_c.Call.Return(_a0)
	return _c
}

func (_c *MockPlcValue_GetIndex_Call) RunAndReturn(run func(uint32) values.PlcValue) *MockPlcValue_GetIndex_Call {
	_c.Call.Return(run)
	return _c
}

// GetInt16 provides a mock function with given fields:
func (_m *MockPlcValue) GetInt16() int16 {
	ret := _m.Called()

	if len(ret) == 0 {
		panic("no return value specified for GetInt16")
	}

	var r0 int16
	if rf, ok := ret.Get(0).(func() int16); ok {
		r0 = rf()
	} else {
		r0 = ret.Get(0).(int16)
	}

	return r0
}

// MockPlcValue_GetInt16_Call is a *mock.Call that shadows Run/Return methods with type explicit version for method 'GetInt16'
type MockPlcValue_GetInt16_Call struct {
	*mock.Call
}

// GetInt16 is a helper method to define mock.On call
func (_e *MockPlcValue_Expecter) GetInt16() *MockPlcValue_GetInt16_Call {
	return &MockPlcValue_GetInt16_Call{Call: _e.mock.On("GetInt16")}
}

func (_c *MockPlcValue_GetInt16_Call) Run(run func()) *MockPlcValue_GetInt16_Call {
	_c.Call.Run(func(args mock.Arguments) {
		run()
	})
	return _c
}

func (_c *MockPlcValue_GetInt16_Call) Return(_a0 int16) *MockPlcValue_GetInt16_Call {
	_c.Call.Return(_a0)
	return _c
}

func (_c *MockPlcValue_GetInt16_Call) RunAndReturn(run func() int16) *MockPlcValue_GetInt16_Call {
	_c.Call.Return(run)
	return _c
}

// GetInt32 provides a mock function with given fields:
func (_m *MockPlcValue) GetInt32() int32 {
	ret := _m.Called()

	if len(ret) == 0 {
		panic("no return value specified for GetInt32")
	}

	var r0 int32
	if rf, ok := ret.Get(0).(func() int32); ok {
		r0 = rf()
	} else {
		r0 = ret.Get(0).(int32)
	}

	return r0
}

// MockPlcValue_GetInt32_Call is a *mock.Call that shadows Run/Return methods with type explicit version for method 'GetInt32'
type MockPlcValue_GetInt32_Call struct {
	*mock.Call
}

// GetInt32 is a helper method to define mock.On call
func (_e *MockPlcValue_Expecter) GetInt32() *MockPlcValue_GetInt32_Call {
	return &MockPlcValue_GetInt32_Call{Call: _e.mock.On("GetInt32")}
}

func (_c *MockPlcValue_GetInt32_Call) Run(run func()) *MockPlcValue_GetInt32_Call {
	_c.Call.Run(func(args mock.Arguments) {
		run()
	})
	return _c
}

func (_c *MockPlcValue_GetInt32_Call) Return(_a0 int32) *MockPlcValue_GetInt32_Call {
	_c.Call.Return(_a0)
	return _c
}

func (_c *MockPlcValue_GetInt32_Call) RunAndReturn(run func() int32) *MockPlcValue_GetInt32_Call {
	_c.Call.Return(run)
	return _c
}

// GetInt64 provides a mock function with given fields:
func (_m *MockPlcValue) GetInt64() int64 {
	ret := _m.Called()

	if len(ret) == 0 {
		panic("no return value specified for GetInt64")
	}

	var r0 int64
	if rf, ok := ret.Get(0).(func() int64); ok {
		r0 = rf()
	} else {
		r0 = ret.Get(0).(int64)
	}

	return r0
}

// MockPlcValue_GetInt64_Call is a *mock.Call that shadows Run/Return methods with type explicit version for method 'GetInt64'
type MockPlcValue_GetInt64_Call struct {
	*mock.Call
}

// GetInt64 is a helper method to define mock.On call
func (_e *MockPlcValue_Expecter) GetInt64() *MockPlcValue_GetInt64_Call {
	return &MockPlcValue_GetInt64_Call{Call: _e.mock.On("GetInt64")}
}

func (_c *MockPlcValue_GetInt64_Call) Run(run func()) *MockPlcValue_GetInt64_Call {
	_c.Call.Run(func(args mock.Arguments) {
		run()
	})
	return _c
}

func (_c *MockPlcValue_GetInt64_Call) Return(_a0 int64) *MockPlcValue_GetInt64_Call {
	_c.Call.Return(_a0)
	return _c
}

func (_c *MockPlcValue_GetInt64_Call) RunAndReturn(run func() int64) *MockPlcValue_GetInt64_Call {
	_c.Call.Return(run)
	return _c
}

// GetInt8 provides a mock function with given fields:
func (_m *MockPlcValue) GetInt8() int8 {
	ret := _m.Called()

	if len(ret) == 0 {
		panic("no return value specified for GetInt8")
	}

	var r0 int8
	if rf, ok := ret.Get(0).(func() int8); ok {
		r0 = rf()
	} else {
		r0 = ret.Get(0).(int8)
	}

	return r0
}

// MockPlcValue_GetInt8_Call is a *mock.Call that shadows Run/Return methods with type explicit version for method 'GetInt8'
type MockPlcValue_GetInt8_Call struct {
	*mock.Call
}

// GetInt8 is a helper method to define mock.On call
func (_e *MockPlcValue_Expecter) GetInt8() *MockPlcValue_GetInt8_Call {
	return &MockPlcValue_GetInt8_Call{Call: _e.mock.On("GetInt8")}
}

func (_c *MockPlcValue_GetInt8_Call) Run(run func()) *MockPlcValue_GetInt8_Call {
	_c.Call.Run(func(args mock.Arguments) {
		run()
	})
	return _c
}

func (_c *MockPlcValue_GetInt8_Call) Return(_a0 int8) *MockPlcValue_GetInt8_Call {
	_c.Call.Return(_a0)
	return _c
}

func (_c *MockPlcValue_GetInt8_Call) RunAndReturn(run func() int8) *MockPlcValue_GetInt8_Call {
	_c.Call.Return(run)
	return _c
}

// GetKeys provides a mock function with given fields:
func (_m *MockPlcValue) GetKeys() []string {
	ret := _m.Called()

	if len(ret) == 0 {
		panic("no return value specified for GetKeys")
	}

	var r0 []string
	if rf, ok := ret.Get(0).(func() []string); ok {
		r0 = rf()
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).([]string)
		}
	}

	return r0
}

// MockPlcValue_GetKeys_Call is a *mock.Call that shadows Run/Return methods with type explicit version for method 'GetKeys'
type MockPlcValue_GetKeys_Call struct {
	*mock.Call
}

// GetKeys is a helper method to define mock.On call
func (_e *MockPlcValue_Expecter) GetKeys() *MockPlcValue_GetKeys_Call {
	return &MockPlcValue_GetKeys_Call{Call: _e.mock.On("GetKeys")}
}

func (_c *MockPlcValue_GetKeys_Call) Run(run func()) *MockPlcValue_GetKeys_Call {
	_c.Call.Run(func(args mock.Arguments) {
		run()
	})
	return _c
}

func (_c *MockPlcValue_GetKeys_Call) Return(_a0 []string) *MockPlcValue_GetKeys_Call {
	_c.Call.Return(_a0)
	return _c
}

func (_c *MockPlcValue_GetKeys_Call) RunAndReturn(run func() []string) *MockPlcValue_GetKeys_Call {
	_c.Call.Return(run)
	return _c
}

// GetLength provides a mock function with given fields:
func (_m *MockPlcValue) GetLength() uint32 {
	ret := _m.Called()

	if len(ret) == 0 {
		panic("no return value specified for GetLength")
	}

	var r0 uint32
	if rf, ok := ret.Get(0).(func() uint32); ok {
		r0 = rf()
	} else {
		r0 = ret.Get(0).(uint32)
	}

	return r0
}

// MockPlcValue_GetLength_Call is a *mock.Call that shadows Run/Return methods with type explicit version for method 'GetLength'
type MockPlcValue_GetLength_Call struct {
	*mock.Call
}

// GetLength is a helper method to define mock.On call
func (_e *MockPlcValue_Expecter) GetLength() *MockPlcValue_GetLength_Call {
	return &MockPlcValue_GetLength_Call{Call: _e.mock.On("GetLength")}
}

func (_c *MockPlcValue_GetLength_Call) Run(run func()) *MockPlcValue_GetLength_Call {
	_c.Call.Run(func(args mock.Arguments) {
		run()
	})
	return _c
}

func (_c *MockPlcValue_GetLength_Call) Return(_a0 uint32) *MockPlcValue_GetLength_Call {
	_c.Call.Return(_a0)
	return _c
}

func (_c *MockPlcValue_GetLength_Call) RunAndReturn(run func() uint32) *MockPlcValue_GetLength_Call {
	_c.Call.Return(run)
	return _c
}

// GetList provides a mock function with given fields:
func (_m *MockPlcValue) GetList() []values.PlcValue {
	ret := _m.Called()

	if len(ret) == 0 {
		panic("no return value specified for GetList")
	}

	var r0 []values.PlcValue
	if rf, ok := ret.Get(0).(func() []values.PlcValue); ok {
		r0 = rf()
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).([]values.PlcValue)
		}
	}

	return r0
}

// MockPlcValue_GetList_Call is a *mock.Call that shadows Run/Return methods with type explicit version for method 'GetList'
type MockPlcValue_GetList_Call struct {
	*mock.Call
}

// GetList is a helper method to define mock.On call
func (_e *MockPlcValue_Expecter) GetList() *MockPlcValue_GetList_Call {
	return &MockPlcValue_GetList_Call{Call: _e.mock.On("GetList")}
}

func (_c *MockPlcValue_GetList_Call) Run(run func()) *MockPlcValue_GetList_Call {
	_c.Call.Run(func(args mock.Arguments) {
		run()
	})
	return _c
}

func (_c *MockPlcValue_GetList_Call) Return(_a0 []values.PlcValue) *MockPlcValue_GetList_Call {
	_c.Call.Return(_a0)
	return _c
}

func (_c *MockPlcValue_GetList_Call) RunAndReturn(run func() []values.PlcValue) *MockPlcValue_GetList_Call {
	_c.Call.Return(run)
	return _c
}

// GetPlcValueType provides a mock function with given fields:
func (_m *MockPlcValue) GetPlcValueType() values.PlcValueType {
	ret := _m.Called()

	if len(ret) == 0 {
		panic("no return value specified for GetPlcValueType")
	}

	var r0 values.PlcValueType
	if rf, ok := ret.Get(0).(func() values.PlcValueType); ok {
		r0 = rf()
	} else {
		r0 = ret.Get(0).(values.PlcValueType)
	}

	return r0
}

// MockPlcValue_GetPlcValueType_Call is a *mock.Call that shadows Run/Return methods with type explicit version for method 'GetPlcValueType'
type MockPlcValue_GetPlcValueType_Call struct {
	*mock.Call
}

// GetPlcValueType is a helper method to define mock.On call
func (_e *MockPlcValue_Expecter) GetPlcValueType() *MockPlcValue_GetPlcValueType_Call {
	return &MockPlcValue_GetPlcValueType_Call{Call: _e.mock.On("GetPlcValueType")}
}

func (_c *MockPlcValue_GetPlcValueType_Call) Run(run func()) *MockPlcValue_GetPlcValueType_Call {
	_c.Call.Run(func(args mock.Arguments) {
		run()
	})
	return _c
}

func (_c *MockPlcValue_GetPlcValueType_Call) Return(_a0 values.PlcValueType) *MockPlcValue_GetPlcValueType_Call {
	_c.Call.Return(_a0)
	return _c
}

func (_c *MockPlcValue_GetPlcValueType_Call) RunAndReturn(run func() values.PlcValueType) *MockPlcValue_GetPlcValueType_Call {
	_c.Call.Return(run)
	return _c
}

// GetRaw provides a mock function with given fields:
func (_m *MockPlcValue) GetRaw() []byte {
	ret := _m.Called()

	if len(ret) == 0 {
		panic("no return value specified for GetRaw")
	}

	var r0 []byte
	if rf, ok := ret.Get(0).(func() []byte); ok {
		r0 = rf()
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).([]byte)
		}
	}

	return r0
}

// MockPlcValue_GetRaw_Call is a *mock.Call that shadows Run/Return methods with type explicit version for method 'GetRaw'
type MockPlcValue_GetRaw_Call struct {
	*mock.Call
}

// GetRaw is a helper method to define mock.On call
func (_e *MockPlcValue_Expecter) GetRaw() *MockPlcValue_GetRaw_Call {
	return &MockPlcValue_GetRaw_Call{Call: _e.mock.On("GetRaw")}
}

func (_c *MockPlcValue_GetRaw_Call) Run(run func()) *MockPlcValue_GetRaw_Call {
	_c.Call.Run(func(args mock.Arguments) {
		run()
	})
	return _c
}

func (_c *MockPlcValue_GetRaw_Call) Return(_a0 []byte) *MockPlcValue_GetRaw_Call {
	_c.Call.Return(_a0)
	return _c
}

func (_c *MockPlcValue_GetRaw_Call) RunAndReturn(run func() []byte) *MockPlcValue_GetRaw_Call {
	_c.Call.Return(run)
	return _c
}

// GetString provides a mock function with given fields:
func (_m *MockPlcValue) GetString() string {
	ret := _m.Called()

	if len(ret) == 0 {
		panic("no return value specified for GetString")
	}

	var r0 string
	if rf, ok := ret.Get(0).(func() string); ok {
		r0 = rf()
	} else {
		r0 = ret.Get(0).(string)
	}

	return r0
}

// MockPlcValue_GetString_Call is a *mock.Call that shadows Run/Return methods with type explicit version for method 'GetString'
type MockPlcValue_GetString_Call struct {
	*mock.Call
}

// GetString is a helper method to define mock.On call
func (_e *MockPlcValue_Expecter) GetString() *MockPlcValue_GetString_Call {
	return &MockPlcValue_GetString_Call{Call: _e.mock.On("GetString")}
}

func (_c *MockPlcValue_GetString_Call) Run(run func()) *MockPlcValue_GetString_Call {
	_c.Call.Run(func(args mock.Arguments) {
		run()
	})
	return _c
}

func (_c *MockPlcValue_GetString_Call) Return(_a0 string) *MockPlcValue_GetString_Call {
	_c.Call.Return(_a0)
	return _c
}

func (_c *MockPlcValue_GetString_Call) RunAndReturn(run func() string) *MockPlcValue_GetString_Call {
	_c.Call.Return(run)
	return _c
}

// GetStruct provides a mock function with given fields:
func (_m *MockPlcValue) GetStruct() map[string]values.PlcValue {
	ret := _m.Called()

	if len(ret) == 0 {
		panic("no return value specified for GetStruct")
	}

	var r0 map[string]values.PlcValue
	if rf, ok := ret.Get(0).(func() map[string]values.PlcValue); ok {
		r0 = rf()
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).(map[string]values.PlcValue)
		}
	}

	return r0
}

// MockPlcValue_GetStruct_Call is a *mock.Call that shadows Run/Return methods with type explicit version for method 'GetStruct'
type MockPlcValue_GetStruct_Call struct {
	*mock.Call
}

// GetStruct is a helper method to define mock.On call
func (_e *MockPlcValue_Expecter) GetStruct() *MockPlcValue_GetStruct_Call {
	return &MockPlcValue_GetStruct_Call{Call: _e.mock.On("GetStruct")}
}

func (_c *MockPlcValue_GetStruct_Call) Run(run func()) *MockPlcValue_GetStruct_Call {
	_c.Call.Run(func(args mock.Arguments) {
		run()
	})
	return _c
}

func (_c *MockPlcValue_GetStruct_Call) Return(_a0 map[string]values.PlcValue) *MockPlcValue_GetStruct_Call {
	_c.Call.Return(_a0)
	return _c
}

func (_c *MockPlcValue_GetStruct_Call) RunAndReturn(run func() map[string]values.PlcValue) *MockPlcValue_GetStruct_Call {
	_c.Call.Return(run)
	return _c
}

// GetTime provides a mock function with given fields:
func (_m *MockPlcValue) GetTime() time.Time {
	ret := _m.Called()

	if len(ret) == 0 {
		panic("no return value specified for GetTime")
	}

	var r0 time.Time
	if rf, ok := ret.Get(0).(func() time.Time); ok {
		r0 = rf()
	} else {
		r0 = ret.Get(0).(time.Time)
	}

	return r0
}

// MockPlcValue_GetTime_Call is a *mock.Call that shadows Run/Return methods with type explicit version for method 'GetTime'
type MockPlcValue_GetTime_Call struct {
	*mock.Call
}

// GetTime is a helper method to define mock.On call
func (_e *MockPlcValue_Expecter) GetTime() *MockPlcValue_GetTime_Call {
	return &MockPlcValue_GetTime_Call{Call: _e.mock.On("GetTime")}
}

func (_c *MockPlcValue_GetTime_Call) Run(run func()) *MockPlcValue_GetTime_Call {
	_c.Call.Run(func(args mock.Arguments) {
		run()
	})
	return _c
}

func (_c *MockPlcValue_GetTime_Call) Return(_a0 time.Time) *MockPlcValue_GetTime_Call {
	_c.Call.Return(_a0)
	return _c
}

func (_c *MockPlcValue_GetTime_Call) RunAndReturn(run func() time.Time) *MockPlcValue_GetTime_Call {
	_c.Call.Return(run)
	return _c
}

// GetUint16 provides a mock function with given fields:
func (_m *MockPlcValue) GetUint16() uint16 {
	ret := _m.Called()

	if len(ret) == 0 {
		panic("no return value specified for GetUint16")
	}

	var r0 uint16
	if rf, ok := ret.Get(0).(func() uint16); ok {
		r0 = rf()
	} else {
		r0 = ret.Get(0).(uint16)
	}

	return r0
}

// MockPlcValue_GetUint16_Call is a *mock.Call that shadows Run/Return methods with type explicit version for method 'GetUint16'
type MockPlcValue_GetUint16_Call struct {
	*mock.Call
}

// GetUint16 is a helper method to define mock.On call
func (_e *MockPlcValue_Expecter) GetUint16() *MockPlcValue_GetUint16_Call {
	return &MockPlcValue_GetUint16_Call{Call: _e.mock.On("GetUint16")}
}

func (_c *MockPlcValue_GetUint16_Call) Run(run func()) *MockPlcValue_GetUint16_Call {
	_c.Call.Run(func(args mock.Arguments) {
		run()
	})
	return _c
}

func (_c *MockPlcValue_GetUint16_Call) Return(_a0 uint16) *MockPlcValue_GetUint16_Call {
	_c.Call.Return(_a0)
	return _c
}

func (_c *MockPlcValue_GetUint16_Call) RunAndReturn(run func() uint16) *MockPlcValue_GetUint16_Call {
	_c.Call.Return(run)
	return _c
}

// GetUint32 provides a mock function with given fields:
func (_m *MockPlcValue) GetUint32() uint32 {
	ret := _m.Called()

	if len(ret) == 0 {
		panic("no return value specified for GetUint32")
	}

	var r0 uint32
	if rf, ok := ret.Get(0).(func() uint32); ok {
		r0 = rf()
	} else {
		r0 = ret.Get(0).(uint32)
	}

	return r0
}

// MockPlcValue_GetUint32_Call is a *mock.Call that shadows Run/Return methods with type explicit version for method 'GetUint32'
type MockPlcValue_GetUint32_Call struct {
	*mock.Call
}

// GetUint32 is a helper method to define mock.On call
func (_e *MockPlcValue_Expecter) GetUint32() *MockPlcValue_GetUint32_Call {
	return &MockPlcValue_GetUint32_Call{Call: _e.mock.On("GetUint32")}
}

func (_c *MockPlcValue_GetUint32_Call) Run(run func()) *MockPlcValue_GetUint32_Call {
	_c.Call.Run(func(args mock.Arguments) {
		run()
	})
	return _c
}

func (_c *MockPlcValue_GetUint32_Call) Return(_a0 uint32) *MockPlcValue_GetUint32_Call {
	_c.Call.Return(_a0)
	return _c
}

func (_c *MockPlcValue_GetUint32_Call) RunAndReturn(run func() uint32) *MockPlcValue_GetUint32_Call {
	_c.Call.Return(run)
	return _c
}

// GetUint64 provides a mock function with given fields:
func (_m *MockPlcValue) GetUint64() uint64 {
	ret := _m.Called()

	if len(ret) == 0 {
		panic("no return value specified for GetUint64")
	}

	var r0 uint64
	if rf, ok := ret.Get(0).(func() uint64); ok {
		r0 = rf()
	} else {
		r0 = ret.Get(0).(uint64)
	}

	return r0
}

// MockPlcValue_GetUint64_Call is a *mock.Call that shadows Run/Return methods with type explicit version for method 'GetUint64'
type MockPlcValue_GetUint64_Call struct {
	*mock.Call
}

// GetUint64 is a helper method to define mock.On call
func (_e *MockPlcValue_Expecter) GetUint64() *MockPlcValue_GetUint64_Call {
	return &MockPlcValue_GetUint64_Call{Call: _e.mock.On("GetUint64")}
}

func (_c *MockPlcValue_GetUint64_Call) Run(run func()) *MockPlcValue_GetUint64_Call {
	_c.Call.Run(func(args mock.Arguments) {
		run()
	})
	return _c
}

func (_c *MockPlcValue_GetUint64_Call) Return(_a0 uint64) *MockPlcValue_GetUint64_Call {
	_c.Call.Return(_a0)
	return _c
}

func (_c *MockPlcValue_GetUint64_Call) RunAndReturn(run func() uint64) *MockPlcValue_GetUint64_Call {
	_c.Call.Return(run)
	return _c
}

// GetUint8 provides a mock function with given fields:
func (_m *MockPlcValue) GetUint8() uint8 {
	ret := _m.Called()

	if len(ret) == 0 {
		panic("no return value specified for GetUint8")
	}

	var r0 uint8
	if rf, ok := ret.Get(0).(func() uint8); ok {
		r0 = rf()
	} else {
		r0 = ret.Get(0).(uint8)
	}

	return r0
}

// MockPlcValue_GetUint8_Call is a *mock.Call that shadows Run/Return methods with type explicit version for method 'GetUint8'
type MockPlcValue_GetUint8_Call struct {
	*mock.Call
}

// GetUint8 is a helper method to define mock.On call
func (_e *MockPlcValue_Expecter) GetUint8() *MockPlcValue_GetUint8_Call {
	return &MockPlcValue_GetUint8_Call{Call: _e.mock.On("GetUint8")}
}

func (_c *MockPlcValue_GetUint8_Call) Run(run func()) *MockPlcValue_GetUint8_Call {
	_c.Call.Run(func(args mock.Arguments) {
		run()
	})
	return _c
}

func (_c *MockPlcValue_GetUint8_Call) Return(_a0 uint8) *MockPlcValue_GetUint8_Call {
	_c.Call.Return(_a0)
	return _c
}

func (_c *MockPlcValue_GetUint8_Call) RunAndReturn(run func() uint8) *MockPlcValue_GetUint8_Call {
	_c.Call.Return(run)
	return _c
}

// GetValue provides a mock function with given fields: key
func (_m *MockPlcValue) GetValue(key string) values.PlcValue {
	ret := _m.Called(key)

	if len(ret) == 0 {
		panic("no return value specified for GetValue")
	}

	var r0 values.PlcValue
	if rf, ok := ret.Get(0).(func(string) values.PlcValue); ok {
		r0 = rf(key)
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).(values.PlcValue)
		}
	}

	return r0
}

// MockPlcValue_GetValue_Call is a *mock.Call that shadows Run/Return methods with type explicit version for method 'GetValue'
type MockPlcValue_GetValue_Call struct {
	*mock.Call
}

// GetValue is a helper method to define mock.On call
//   - key string
func (_e *MockPlcValue_Expecter) GetValue(key interface{}) *MockPlcValue_GetValue_Call {
	return &MockPlcValue_GetValue_Call{Call: _e.mock.On("GetValue", key)}
}

func (_c *MockPlcValue_GetValue_Call) Run(run func(key string)) *MockPlcValue_GetValue_Call {
	_c.Call.Run(func(args mock.Arguments) {
		run(args[0].(string))
	})
	return _c
}

func (_c *MockPlcValue_GetValue_Call) Return(_a0 values.PlcValue) *MockPlcValue_GetValue_Call {
	_c.Call.Return(_a0)
	return _c
}

func (_c *MockPlcValue_GetValue_Call) RunAndReturn(run func(string) values.PlcValue) *MockPlcValue_GetValue_Call {
	_c.Call.Return(run)
	return _c
}

// HasKey provides a mock function with given fields: key
func (_m *MockPlcValue) HasKey(key string) bool {
	ret := _m.Called(key)

	if len(ret) == 0 {
		panic("no return value specified for HasKey")
	}

	var r0 bool
	if rf, ok := ret.Get(0).(func(string) bool); ok {
		r0 = rf(key)
	} else {
		r0 = ret.Get(0).(bool)
	}

	return r0
}

// MockPlcValue_HasKey_Call is a *mock.Call that shadows Run/Return methods with type explicit version for method 'HasKey'
type MockPlcValue_HasKey_Call struct {
	*mock.Call
}

// HasKey is a helper method to define mock.On call
//   - key string
func (_e *MockPlcValue_Expecter) HasKey(key interface{}) *MockPlcValue_HasKey_Call {
	return &MockPlcValue_HasKey_Call{Call: _e.mock.On("HasKey", key)}
}

func (_c *MockPlcValue_HasKey_Call) Run(run func(key string)) *MockPlcValue_HasKey_Call {
	_c.Call.Run(func(args mock.Arguments) {
		run(args[0].(string))
	})
	return _c
}

func (_c *MockPlcValue_HasKey_Call) Return(_a0 bool) *MockPlcValue_HasKey_Call {
	_c.Call.Return(_a0)
	return _c
}

func (_c *MockPlcValue_HasKey_Call) RunAndReturn(run func(string) bool) *MockPlcValue_HasKey_Call {
	_c.Call.Return(run)
	return _c
}

// IsBool provides a mock function with given fields:
func (_m *MockPlcValue) IsBool() bool {
	ret := _m.Called()

	if len(ret) == 0 {
		panic("no return value specified for IsBool")
	}

	var r0 bool
	if rf, ok := ret.Get(0).(func() bool); ok {
		r0 = rf()
	} else {
		r0 = ret.Get(0).(bool)
	}

	return r0
}

// MockPlcValue_IsBool_Call is a *mock.Call that shadows Run/Return methods with type explicit version for method 'IsBool'
type MockPlcValue_IsBool_Call struct {
	*mock.Call
}

// IsBool is a helper method to define mock.On call
func (_e *MockPlcValue_Expecter) IsBool() *MockPlcValue_IsBool_Call {
	return &MockPlcValue_IsBool_Call{Call: _e.mock.On("IsBool")}
}

func (_c *MockPlcValue_IsBool_Call) Run(run func()) *MockPlcValue_IsBool_Call {
	_c.Call.Run(func(args mock.Arguments) {
		run()
	})
	return _c
}

func (_c *MockPlcValue_IsBool_Call) Return(_a0 bool) *MockPlcValue_IsBool_Call {
	_c.Call.Return(_a0)
	return _c
}

func (_c *MockPlcValue_IsBool_Call) RunAndReturn(run func() bool) *MockPlcValue_IsBool_Call {
	_c.Call.Return(run)
	return _c
}

// IsByte provides a mock function with given fields:
func (_m *MockPlcValue) IsByte() bool {
	ret := _m.Called()

	if len(ret) == 0 {
		panic("no return value specified for IsByte")
	}

	var r0 bool
	if rf, ok := ret.Get(0).(func() bool); ok {
		r0 = rf()
	} else {
		r0 = ret.Get(0).(bool)
	}

	return r0
}

// MockPlcValue_IsByte_Call is a *mock.Call that shadows Run/Return methods with type explicit version for method 'IsByte'
type MockPlcValue_IsByte_Call struct {
	*mock.Call
}

// IsByte is a helper method to define mock.On call
func (_e *MockPlcValue_Expecter) IsByte() *MockPlcValue_IsByte_Call {
	return &MockPlcValue_IsByte_Call{Call: _e.mock.On("IsByte")}
}

func (_c *MockPlcValue_IsByte_Call) Run(run func()) *MockPlcValue_IsByte_Call {
	_c.Call.Run(func(args mock.Arguments) {
		run()
	})
	return _c
}

func (_c *MockPlcValue_IsByte_Call) Return(_a0 bool) *MockPlcValue_IsByte_Call {
	_c.Call.Return(_a0)
	return _c
}

func (_c *MockPlcValue_IsByte_Call) RunAndReturn(run func() bool) *MockPlcValue_IsByte_Call {
	_c.Call.Return(run)
	return _c
}

// IsDate provides a mock function with given fields:
func (_m *MockPlcValue) IsDate() bool {
	ret := _m.Called()

	if len(ret) == 0 {
		panic("no return value specified for IsDate")
	}

	var r0 bool
	if rf, ok := ret.Get(0).(func() bool); ok {
		r0 = rf()
	} else {
		r0 = ret.Get(0).(bool)
	}

	return r0
}

// MockPlcValue_IsDate_Call is a *mock.Call that shadows Run/Return methods with type explicit version for method 'IsDate'
type MockPlcValue_IsDate_Call struct {
	*mock.Call
}

// IsDate is a helper method to define mock.On call
func (_e *MockPlcValue_Expecter) IsDate() *MockPlcValue_IsDate_Call {
	return &MockPlcValue_IsDate_Call{Call: _e.mock.On("IsDate")}
}

func (_c *MockPlcValue_IsDate_Call) Run(run func()) *MockPlcValue_IsDate_Call {
	_c.Call.Run(func(args mock.Arguments) {
		run()
	})
	return _c
}

func (_c *MockPlcValue_IsDate_Call) Return(_a0 bool) *MockPlcValue_IsDate_Call {
	_c.Call.Return(_a0)
	return _c
}

func (_c *MockPlcValue_IsDate_Call) RunAndReturn(run func() bool) *MockPlcValue_IsDate_Call {
	_c.Call.Return(run)
	return _c
}

// IsDateTime provides a mock function with given fields:
func (_m *MockPlcValue) IsDateTime() bool {
	ret := _m.Called()

	if len(ret) == 0 {
		panic("no return value specified for IsDateTime")
	}

	var r0 bool
	if rf, ok := ret.Get(0).(func() bool); ok {
		r0 = rf()
	} else {
		r0 = ret.Get(0).(bool)
	}

	return r0
}

// MockPlcValue_IsDateTime_Call is a *mock.Call that shadows Run/Return methods with type explicit version for method 'IsDateTime'
type MockPlcValue_IsDateTime_Call struct {
	*mock.Call
}

// IsDateTime is a helper method to define mock.On call
func (_e *MockPlcValue_Expecter) IsDateTime() *MockPlcValue_IsDateTime_Call {
	return &MockPlcValue_IsDateTime_Call{Call: _e.mock.On("IsDateTime")}
}

func (_c *MockPlcValue_IsDateTime_Call) Run(run func()) *MockPlcValue_IsDateTime_Call {
	_c.Call.Run(func(args mock.Arguments) {
		run()
	})
	return _c
}

func (_c *MockPlcValue_IsDateTime_Call) Return(_a0 bool) *MockPlcValue_IsDateTime_Call {
	_c.Call.Return(_a0)
	return _c
}

func (_c *MockPlcValue_IsDateTime_Call) RunAndReturn(run func() bool) *MockPlcValue_IsDateTime_Call {
	_c.Call.Return(run)
	return _c
}

// IsDuration provides a mock function with given fields:
func (_m *MockPlcValue) IsDuration() bool {
	ret := _m.Called()

	if len(ret) == 0 {
		panic("no return value specified for IsDuration")
	}

	var r0 bool
	if rf, ok := ret.Get(0).(func() bool); ok {
		r0 = rf()
	} else {
		r0 = ret.Get(0).(bool)
	}

	return r0
}

// MockPlcValue_IsDuration_Call is a *mock.Call that shadows Run/Return methods with type explicit version for method 'IsDuration'
type MockPlcValue_IsDuration_Call struct {
	*mock.Call
}

// IsDuration is a helper method to define mock.On call
func (_e *MockPlcValue_Expecter) IsDuration() *MockPlcValue_IsDuration_Call {
	return &MockPlcValue_IsDuration_Call{Call: _e.mock.On("IsDuration")}
}

func (_c *MockPlcValue_IsDuration_Call) Run(run func()) *MockPlcValue_IsDuration_Call {
	_c.Call.Run(func(args mock.Arguments) {
		run()
	})
	return _c
}

func (_c *MockPlcValue_IsDuration_Call) Return(_a0 bool) *MockPlcValue_IsDuration_Call {
	_c.Call.Return(_a0)
	return _c
}

func (_c *MockPlcValue_IsDuration_Call) RunAndReturn(run func() bool) *MockPlcValue_IsDuration_Call {
	_c.Call.Return(run)
	return _c
}

// IsFloat32 provides a mock function with given fields:
func (_m *MockPlcValue) IsFloat32() bool {
	ret := _m.Called()

	if len(ret) == 0 {
		panic("no return value specified for IsFloat32")
	}

	var r0 bool
	if rf, ok := ret.Get(0).(func() bool); ok {
		r0 = rf()
	} else {
		r0 = ret.Get(0).(bool)
	}

	return r0
}

// MockPlcValue_IsFloat32_Call is a *mock.Call that shadows Run/Return methods with type explicit version for method 'IsFloat32'
type MockPlcValue_IsFloat32_Call struct {
	*mock.Call
}

// IsFloat32 is a helper method to define mock.On call
func (_e *MockPlcValue_Expecter) IsFloat32() *MockPlcValue_IsFloat32_Call {
	return &MockPlcValue_IsFloat32_Call{Call: _e.mock.On("IsFloat32")}
}

func (_c *MockPlcValue_IsFloat32_Call) Run(run func()) *MockPlcValue_IsFloat32_Call {
	_c.Call.Run(func(args mock.Arguments) {
		run()
	})
	return _c
}

func (_c *MockPlcValue_IsFloat32_Call) Return(_a0 bool) *MockPlcValue_IsFloat32_Call {
	_c.Call.Return(_a0)
	return _c
}

func (_c *MockPlcValue_IsFloat32_Call) RunAndReturn(run func() bool) *MockPlcValue_IsFloat32_Call {
	_c.Call.Return(run)
	return _c
}

// IsFloat64 provides a mock function with given fields:
func (_m *MockPlcValue) IsFloat64() bool {
	ret := _m.Called()

	if len(ret) == 0 {
		panic("no return value specified for IsFloat64")
	}

	var r0 bool
	if rf, ok := ret.Get(0).(func() bool); ok {
		r0 = rf()
	} else {
		r0 = ret.Get(0).(bool)
	}

	return r0
}

// MockPlcValue_IsFloat64_Call is a *mock.Call that shadows Run/Return methods with type explicit version for method 'IsFloat64'
type MockPlcValue_IsFloat64_Call struct {
	*mock.Call
}

// IsFloat64 is a helper method to define mock.On call
func (_e *MockPlcValue_Expecter) IsFloat64() *MockPlcValue_IsFloat64_Call {
	return &MockPlcValue_IsFloat64_Call{Call: _e.mock.On("IsFloat64")}
}

func (_c *MockPlcValue_IsFloat64_Call) Run(run func()) *MockPlcValue_IsFloat64_Call {
	_c.Call.Run(func(args mock.Arguments) {
		run()
	})
	return _c
}

func (_c *MockPlcValue_IsFloat64_Call) Return(_a0 bool) *MockPlcValue_IsFloat64_Call {
	_c.Call.Return(_a0)
	return _c
}

func (_c *MockPlcValue_IsFloat64_Call) RunAndReturn(run func() bool) *MockPlcValue_IsFloat64_Call {
	_c.Call.Return(run)
	return _c
}

// IsInt16 provides a mock function with given fields:
func (_m *MockPlcValue) IsInt16() bool {
	ret := _m.Called()

	if len(ret) == 0 {
		panic("no return value specified for IsInt16")
	}

	var r0 bool
	if rf, ok := ret.Get(0).(func() bool); ok {
		r0 = rf()
	} else {
		r0 = ret.Get(0).(bool)
	}

	return r0
}

// MockPlcValue_IsInt16_Call is a *mock.Call that shadows Run/Return methods with type explicit version for method 'IsInt16'
type MockPlcValue_IsInt16_Call struct {
	*mock.Call
}

// IsInt16 is a helper method to define mock.On call
func (_e *MockPlcValue_Expecter) IsInt16() *MockPlcValue_IsInt16_Call {
	return &MockPlcValue_IsInt16_Call{Call: _e.mock.On("IsInt16")}
}

func (_c *MockPlcValue_IsInt16_Call) Run(run func()) *MockPlcValue_IsInt16_Call {
	_c.Call.Run(func(args mock.Arguments) {
		run()
	})
	return _c
}

func (_c *MockPlcValue_IsInt16_Call) Return(_a0 bool) *MockPlcValue_IsInt16_Call {
	_c.Call.Return(_a0)
	return _c
}

func (_c *MockPlcValue_IsInt16_Call) RunAndReturn(run func() bool) *MockPlcValue_IsInt16_Call {
	_c.Call.Return(run)
	return _c
}

// IsInt32 provides a mock function with given fields:
func (_m *MockPlcValue) IsInt32() bool {
	ret := _m.Called()

	if len(ret) == 0 {
		panic("no return value specified for IsInt32")
	}

	var r0 bool
	if rf, ok := ret.Get(0).(func() bool); ok {
		r0 = rf()
	} else {
		r0 = ret.Get(0).(bool)
	}

	return r0
}

// MockPlcValue_IsInt32_Call is a *mock.Call that shadows Run/Return methods with type explicit version for method 'IsInt32'
type MockPlcValue_IsInt32_Call struct {
	*mock.Call
}

// IsInt32 is a helper method to define mock.On call
func (_e *MockPlcValue_Expecter) IsInt32() *MockPlcValue_IsInt32_Call {
	return &MockPlcValue_IsInt32_Call{Call: _e.mock.On("IsInt32")}
}

func (_c *MockPlcValue_IsInt32_Call) Run(run func()) *MockPlcValue_IsInt32_Call {
	_c.Call.Run(func(args mock.Arguments) {
		run()
	})
	return _c
}

func (_c *MockPlcValue_IsInt32_Call) Return(_a0 bool) *MockPlcValue_IsInt32_Call {
	_c.Call.Return(_a0)
	return _c
}

func (_c *MockPlcValue_IsInt32_Call) RunAndReturn(run func() bool) *MockPlcValue_IsInt32_Call {
	_c.Call.Return(run)
	return _c
}

// IsInt64 provides a mock function with given fields:
func (_m *MockPlcValue) IsInt64() bool {
	ret := _m.Called()

	if len(ret) == 0 {
		panic("no return value specified for IsInt64")
	}

	var r0 bool
	if rf, ok := ret.Get(0).(func() bool); ok {
		r0 = rf()
	} else {
		r0 = ret.Get(0).(bool)
	}

	return r0
}

// MockPlcValue_IsInt64_Call is a *mock.Call that shadows Run/Return methods with type explicit version for method 'IsInt64'
type MockPlcValue_IsInt64_Call struct {
	*mock.Call
}

// IsInt64 is a helper method to define mock.On call
func (_e *MockPlcValue_Expecter) IsInt64() *MockPlcValue_IsInt64_Call {
	return &MockPlcValue_IsInt64_Call{Call: _e.mock.On("IsInt64")}
}

func (_c *MockPlcValue_IsInt64_Call) Run(run func()) *MockPlcValue_IsInt64_Call {
	_c.Call.Run(func(args mock.Arguments) {
		run()
	})
	return _c
}

func (_c *MockPlcValue_IsInt64_Call) Return(_a0 bool) *MockPlcValue_IsInt64_Call {
	_c.Call.Return(_a0)
	return _c
}

func (_c *MockPlcValue_IsInt64_Call) RunAndReturn(run func() bool) *MockPlcValue_IsInt64_Call {
	_c.Call.Return(run)
	return _c
}

// IsInt8 provides a mock function with given fields:
func (_m *MockPlcValue) IsInt8() bool {
	ret := _m.Called()

	if len(ret) == 0 {
		panic("no return value specified for IsInt8")
	}

	var r0 bool
	if rf, ok := ret.Get(0).(func() bool); ok {
		r0 = rf()
	} else {
		r0 = ret.Get(0).(bool)
	}

	return r0
}

// MockPlcValue_IsInt8_Call is a *mock.Call that shadows Run/Return methods with type explicit version for method 'IsInt8'
type MockPlcValue_IsInt8_Call struct {
	*mock.Call
}

// IsInt8 is a helper method to define mock.On call
func (_e *MockPlcValue_Expecter) IsInt8() *MockPlcValue_IsInt8_Call {
	return &MockPlcValue_IsInt8_Call{Call: _e.mock.On("IsInt8")}
}

func (_c *MockPlcValue_IsInt8_Call) Run(run func()) *MockPlcValue_IsInt8_Call {
	_c.Call.Run(func(args mock.Arguments) {
		run()
	})
	return _c
}

func (_c *MockPlcValue_IsInt8_Call) Return(_a0 bool) *MockPlcValue_IsInt8_Call {
	_c.Call.Return(_a0)
	return _c
}

func (_c *MockPlcValue_IsInt8_Call) RunAndReturn(run func() bool) *MockPlcValue_IsInt8_Call {
	_c.Call.Return(run)
	return _c
}

// IsList provides a mock function with given fields:
func (_m *MockPlcValue) IsList() bool {
	ret := _m.Called()

	if len(ret) == 0 {
		panic("no return value specified for IsList")
	}

	var r0 bool
	if rf, ok := ret.Get(0).(func() bool); ok {
		r0 = rf()
	} else {
		r0 = ret.Get(0).(bool)
	}

	return r0
}

// MockPlcValue_IsList_Call is a *mock.Call that shadows Run/Return methods with type explicit version for method 'IsList'
type MockPlcValue_IsList_Call struct {
	*mock.Call
}

// IsList is a helper method to define mock.On call
func (_e *MockPlcValue_Expecter) IsList() *MockPlcValue_IsList_Call {
	return &MockPlcValue_IsList_Call{Call: _e.mock.On("IsList")}
}

func (_c *MockPlcValue_IsList_Call) Run(run func()) *MockPlcValue_IsList_Call {
	_c.Call.Run(func(args mock.Arguments) {
		run()
	})
	return _c
}

func (_c *MockPlcValue_IsList_Call) Return(_a0 bool) *MockPlcValue_IsList_Call {
	_c.Call.Return(_a0)
	return _c
}

func (_c *MockPlcValue_IsList_Call) RunAndReturn(run func() bool) *MockPlcValue_IsList_Call {
	_c.Call.Return(run)
	return _c
}

// IsNull provides a mock function with given fields:
func (_m *MockPlcValue) IsNull() bool {
	ret := _m.Called()

	if len(ret) == 0 {
		panic("no return value specified for IsNull")
	}

	var r0 bool
	if rf, ok := ret.Get(0).(func() bool); ok {
		r0 = rf()
	} else {
		r0 = ret.Get(0).(bool)
	}

	return r0
}

// MockPlcValue_IsNull_Call is a *mock.Call that shadows Run/Return methods with type explicit version for method 'IsNull'
type MockPlcValue_IsNull_Call struct {
	*mock.Call
}

// IsNull is a helper method to define mock.On call
func (_e *MockPlcValue_Expecter) IsNull() *MockPlcValue_IsNull_Call {
	return &MockPlcValue_IsNull_Call{Call: _e.mock.On("IsNull")}
}

func (_c *MockPlcValue_IsNull_Call) Run(run func()) *MockPlcValue_IsNull_Call {
	_c.Call.Run(func(args mock.Arguments) {
		run()
	})
	return _c
}

func (_c *MockPlcValue_IsNull_Call) Return(_a0 bool) *MockPlcValue_IsNull_Call {
	_c.Call.Return(_a0)
	return _c
}

func (_c *MockPlcValue_IsNull_Call) RunAndReturn(run func() bool) *MockPlcValue_IsNull_Call {
	_c.Call.Return(run)
	return _c
}

// IsNullable provides a mock function with given fields:
func (_m *MockPlcValue) IsNullable() bool {
	ret := _m.Called()

	if len(ret) == 0 {
		panic("no return value specified for IsNullable")
	}

	var r0 bool
	if rf, ok := ret.Get(0).(func() bool); ok {
		r0 = rf()
	} else {
		r0 = ret.Get(0).(bool)
	}

	return r0
}

// MockPlcValue_IsNullable_Call is a *mock.Call that shadows Run/Return methods with type explicit version for method 'IsNullable'
type MockPlcValue_IsNullable_Call struct {
	*mock.Call
}

// IsNullable is a helper method to define mock.On call
func (_e *MockPlcValue_Expecter) IsNullable() *MockPlcValue_IsNullable_Call {
	return &MockPlcValue_IsNullable_Call{Call: _e.mock.On("IsNullable")}
}

func (_c *MockPlcValue_IsNullable_Call) Run(run func()) *MockPlcValue_IsNullable_Call {
	_c.Call.Run(func(args mock.Arguments) {
		run()
	})
	return _c
}

func (_c *MockPlcValue_IsNullable_Call) Return(_a0 bool) *MockPlcValue_IsNullable_Call {
	_c.Call.Return(_a0)
	return _c
}

func (_c *MockPlcValue_IsNullable_Call) RunAndReturn(run func() bool) *MockPlcValue_IsNullable_Call {
	_c.Call.Return(run)
	return _c
}

// IsRaw provides a mock function with given fields:
func (_m *MockPlcValue) IsRaw() bool {
	ret := _m.Called()

	if len(ret) == 0 {
		panic("no return value specified for IsRaw")
	}

	var r0 bool
	if rf, ok := ret.Get(0).(func() bool); ok {
		r0 = rf()
	} else {
		r0 = ret.Get(0).(bool)
	}

	return r0
}

// MockPlcValue_IsRaw_Call is a *mock.Call that shadows Run/Return methods with type explicit version for method 'IsRaw'
type MockPlcValue_IsRaw_Call struct {
	*mock.Call
}

// IsRaw is a helper method to define mock.On call
func (_e *MockPlcValue_Expecter) IsRaw() *MockPlcValue_IsRaw_Call {
	return &MockPlcValue_IsRaw_Call{Call: _e.mock.On("IsRaw")}
}

func (_c *MockPlcValue_IsRaw_Call) Run(run func()) *MockPlcValue_IsRaw_Call {
	_c.Call.Run(func(args mock.Arguments) {
		run()
	})
	return _c
}

func (_c *MockPlcValue_IsRaw_Call) Return(_a0 bool) *MockPlcValue_IsRaw_Call {
	_c.Call.Return(_a0)
	return _c
}

func (_c *MockPlcValue_IsRaw_Call) RunAndReturn(run func() bool) *MockPlcValue_IsRaw_Call {
	_c.Call.Return(run)
	return _c
}

// IsSimple provides a mock function with given fields:
func (_m *MockPlcValue) IsSimple() bool {
	ret := _m.Called()

	if len(ret) == 0 {
		panic("no return value specified for IsSimple")
	}

	var r0 bool
	if rf, ok := ret.Get(0).(func() bool); ok {
		r0 = rf()
	} else {
		r0 = ret.Get(0).(bool)
	}

	return r0
}

// MockPlcValue_IsSimple_Call is a *mock.Call that shadows Run/Return methods with type explicit version for method 'IsSimple'
type MockPlcValue_IsSimple_Call struct {
	*mock.Call
}

// IsSimple is a helper method to define mock.On call
func (_e *MockPlcValue_Expecter) IsSimple() *MockPlcValue_IsSimple_Call {
	return &MockPlcValue_IsSimple_Call{Call: _e.mock.On("IsSimple")}
}

func (_c *MockPlcValue_IsSimple_Call) Run(run func()) *MockPlcValue_IsSimple_Call {
	_c.Call.Run(func(args mock.Arguments) {
		run()
	})
	return _c
}

func (_c *MockPlcValue_IsSimple_Call) Return(_a0 bool) *MockPlcValue_IsSimple_Call {
	_c.Call.Return(_a0)
	return _c
}

func (_c *MockPlcValue_IsSimple_Call) RunAndReturn(run func() bool) *MockPlcValue_IsSimple_Call {
	_c.Call.Return(run)
	return _c
}

// IsString provides a mock function with given fields:
func (_m *MockPlcValue) IsString() bool {
	ret := _m.Called()

	if len(ret) == 0 {
		panic("no return value specified for IsString")
	}

	var r0 bool
	if rf, ok := ret.Get(0).(func() bool); ok {
		r0 = rf()
	} else {
		r0 = ret.Get(0).(bool)
	}

	return r0
}

// MockPlcValue_IsString_Call is a *mock.Call that shadows Run/Return methods with type explicit version for method 'IsString'
type MockPlcValue_IsString_Call struct {
	*mock.Call
}

// IsString is a helper method to define mock.On call
func (_e *MockPlcValue_Expecter) IsString() *MockPlcValue_IsString_Call {
	return &MockPlcValue_IsString_Call{Call: _e.mock.On("IsString")}
}

func (_c *MockPlcValue_IsString_Call) Run(run func()) *MockPlcValue_IsString_Call {
	_c.Call.Run(func(args mock.Arguments) {
		run()
	})
	return _c
}

func (_c *MockPlcValue_IsString_Call) Return(_a0 bool) *MockPlcValue_IsString_Call {
	_c.Call.Return(_a0)
	return _c
}

func (_c *MockPlcValue_IsString_Call) RunAndReturn(run func() bool) *MockPlcValue_IsString_Call {
	_c.Call.Return(run)
	return _c
}

// IsStruct provides a mock function with given fields:
func (_m *MockPlcValue) IsStruct() bool {
	ret := _m.Called()

	if len(ret) == 0 {
		panic("no return value specified for IsStruct")
	}

	var r0 bool
	if rf, ok := ret.Get(0).(func() bool); ok {
		r0 = rf()
	} else {
		r0 = ret.Get(0).(bool)
	}

	return r0
}

// MockPlcValue_IsStruct_Call is a *mock.Call that shadows Run/Return methods with type explicit version for method 'IsStruct'
type MockPlcValue_IsStruct_Call struct {
	*mock.Call
}

// IsStruct is a helper method to define mock.On call
func (_e *MockPlcValue_Expecter) IsStruct() *MockPlcValue_IsStruct_Call {
	return &MockPlcValue_IsStruct_Call{Call: _e.mock.On("IsStruct")}
}

func (_c *MockPlcValue_IsStruct_Call) Run(run func()) *MockPlcValue_IsStruct_Call {
	_c.Call.Run(func(args mock.Arguments) {
		run()
	})
	return _c
}

func (_c *MockPlcValue_IsStruct_Call) Return(_a0 bool) *MockPlcValue_IsStruct_Call {
	_c.Call.Return(_a0)
	return _c
}

func (_c *MockPlcValue_IsStruct_Call) RunAndReturn(run func() bool) *MockPlcValue_IsStruct_Call {
	_c.Call.Return(run)
	return _c
}

// IsTime provides a mock function with given fields:
func (_m *MockPlcValue) IsTime() bool {
	ret := _m.Called()

	if len(ret) == 0 {
		panic("no return value specified for IsTime")
	}

	var r0 bool
	if rf, ok := ret.Get(0).(func() bool); ok {
		r0 = rf()
	} else {
		r0 = ret.Get(0).(bool)
	}

	return r0
}

// MockPlcValue_IsTime_Call is a *mock.Call that shadows Run/Return methods with type explicit version for method 'IsTime'
type MockPlcValue_IsTime_Call struct {
	*mock.Call
}

// IsTime is a helper method to define mock.On call
func (_e *MockPlcValue_Expecter) IsTime() *MockPlcValue_IsTime_Call {
	return &MockPlcValue_IsTime_Call{Call: _e.mock.On("IsTime")}
}

func (_c *MockPlcValue_IsTime_Call) Run(run func()) *MockPlcValue_IsTime_Call {
	_c.Call.Run(func(args mock.Arguments) {
		run()
	})
	return _c
}

func (_c *MockPlcValue_IsTime_Call) Return(_a0 bool) *MockPlcValue_IsTime_Call {
	_c.Call.Return(_a0)
	return _c
}

func (_c *MockPlcValue_IsTime_Call) RunAndReturn(run func() bool) *MockPlcValue_IsTime_Call {
	_c.Call.Return(run)
	return _c
}

// IsUint16 provides a mock function with given fields:
func (_m *MockPlcValue) IsUint16() bool {
	ret := _m.Called()

	if len(ret) == 0 {
		panic("no return value specified for IsUint16")
	}

	var r0 bool
	if rf, ok := ret.Get(0).(func() bool); ok {
		r0 = rf()
	} else {
		r0 = ret.Get(0).(bool)
	}

	return r0
}

// MockPlcValue_IsUint16_Call is a *mock.Call that shadows Run/Return methods with type explicit version for method 'IsUint16'
type MockPlcValue_IsUint16_Call struct {
	*mock.Call
}

// IsUint16 is a helper method to define mock.On call
func (_e *MockPlcValue_Expecter) IsUint16() *MockPlcValue_IsUint16_Call {
	return &MockPlcValue_IsUint16_Call{Call: _e.mock.On("IsUint16")}
}

func (_c *MockPlcValue_IsUint16_Call) Run(run func()) *MockPlcValue_IsUint16_Call {
	_c.Call.Run(func(args mock.Arguments) {
		run()
	})
	return _c
}

func (_c *MockPlcValue_IsUint16_Call) Return(_a0 bool) *MockPlcValue_IsUint16_Call {
	_c.Call.Return(_a0)
	return _c
}

func (_c *MockPlcValue_IsUint16_Call) RunAndReturn(run func() bool) *MockPlcValue_IsUint16_Call {
	_c.Call.Return(run)
	return _c
}

// IsUint32 provides a mock function with given fields:
func (_m *MockPlcValue) IsUint32() bool {
	ret := _m.Called()

	if len(ret) == 0 {
		panic("no return value specified for IsUint32")
	}

	var r0 bool
	if rf, ok := ret.Get(0).(func() bool); ok {
		r0 = rf()
	} else {
		r0 = ret.Get(0).(bool)
	}

	return r0
}

// MockPlcValue_IsUint32_Call is a *mock.Call that shadows Run/Return methods with type explicit version for method 'IsUint32'
type MockPlcValue_IsUint32_Call struct {
	*mock.Call
}

// IsUint32 is a helper method to define mock.On call
func (_e *MockPlcValue_Expecter) IsUint32() *MockPlcValue_IsUint32_Call {
	return &MockPlcValue_IsUint32_Call{Call: _e.mock.On("IsUint32")}
}

func (_c *MockPlcValue_IsUint32_Call) Run(run func()) *MockPlcValue_IsUint32_Call {
	_c.Call.Run(func(args mock.Arguments) {
		run()
	})
	return _c
}

func (_c *MockPlcValue_IsUint32_Call) Return(_a0 bool) *MockPlcValue_IsUint32_Call {
	_c.Call.Return(_a0)
	return _c
}

func (_c *MockPlcValue_IsUint32_Call) RunAndReturn(run func() bool) *MockPlcValue_IsUint32_Call {
	_c.Call.Return(run)
	return _c
}

// IsUint64 provides a mock function with given fields:
func (_m *MockPlcValue) IsUint64() bool {
	ret := _m.Called()

	if len(ret) == 0 {
		panic("no return value specified for IsUint64")
	}

	var r0 bool
	if rf, ok := ret.Get(0).(func() bool); ok {
		r0 = rf()
	} else {
		r0 = ret.Get(0).(bool)
	}

	return r0
}

// MockPlcValue_IsUint64_Call is a *mock.Call that shadows Run/Return methods with type explicit version for method 'IsUint64'
type MockPlcValue_IsUint64_Call struct {
	*mock.Call
}

// IsUint64 is a helper method to define mock.On call
func (_e *MockPlcValue_Expecter) IsUint64() *MockPlcValue_IsUint64_Call {
	return &MockPlcValue_IsUint64_Call{Call: _e.mock.On("IsUint64")}
}

func (_c *MockPlcValue_IsUint64_Call) Run(run func()) *MockPlcValue_IsUint64_Call {
	_c.Call.Run(func(args mock.Arguments) {
		run()
	})
	return _c
}

func (_c *MockPlcValue_IsUint64_Call) Return(_a0 bool) *MockPlcValue_IsUint64_Call {
	_c.Call.Return(_a0)
	return _c
}

func (_c *MockPlcValue_IsUint64_Call) RunAndReturn(run func() bool) *MockPlcValue_IsUint64_Call {
	_c.Call.Return(run)
	return _c
}

// IsUint8 provides a mock function with given fields:
func (_m *MockPlcValue) IsUint8() bool {
	ret := _m.Called()

	if len(ret) == 0 {
		panic("no return value specified for IsUint8")
	}

	var r0 bool
	if rf, ok := ret.Get(0).(func() bool); ok {
		r0 = rf()
	} else {
		r0 = ret.Get(0).(bool)
	}

	return r0
}

// MockPlcValue_IsUint8_Call is a *mock.Call that shadows Run/Return methods with type explicit version for method 'IsUint8'
type MockPlcValue_IsUint8_Call struct {
	*mock.Call
}

// IsUint8 is a helper method to define mock.On call
func (_e *MockPlcValue_Expecter) IsUint8() *MockPlcValue_IsUint8_Call {
	return &MockPlcValue_IsUint8_Call{Call: _e.mock.On("IsUint8")}
}

func (_c *MockPlcValue_IsUint8_Call) Run(run func()) *MockPlcValue_IsUint8_Call {
	_c.Call.Run(func(args mock.Arguments) {
		run()
	})
	return _c
}

func (_c *MockPlcValue_IsUint8_Call) Return(_a0 bool) *MockPlcValue_IsUint8_Call {
	_c.Call.Return(_a0)
	return _c
}

func (_c *MockPlcValue_IsUint8_Call) RunAndReturn(run func() bool) *MockPlcValue_IsUint8_Call {
	_c.Call.Return(run)
	return _c
}

// String provides a mock function with given fields:
func (_m *MockPlcValue) String() string {
	ret := _m.Called()

	if len(ret) == 0 {
		panic("no return value specified for String")
	}

	var r0 string
	if rf, ok := ret.Get(0).(func() string); ok {
		r0 = rf()
	} else {
		r0 = ret.Get(0).(string)
	}

	return r0
}

// MockPlcValue_String_Call is a *mock.Call that shadows Run/Return methods with type explicit version for method 'String'
type MockPlcValue_String_Call struct {
	*mock.Call
}

// String is a helper method to define mock.On call
func (_e *MockPlcValue_Expecter) String() *MockPlcValue_String_Call {
	return &MockPlcValue_String_Call{Call: _e.mock.On("String")}
}

func (_c *MockPlcValue_String_Call) Run(run func()) *MockPlcValue_String_Call {
	_c.Call.Run(func(args mock.Arguments) {
		run()
	})
	return _c
}

func (_c *MockPlcValue_String_Call) Return(_a0 string) *MockPlcValue_String_Call {
	_c.Call.Return(_a0)
	return _c
}

func (_c *MockPlcValue_String_Call) RunAndReturn(run func() string) *MockPlcValue_String_Call {
	_c.Call.Return(run)
	return _c
}

// NewMockPlcValue creates a new instance of MockPlcValue. It also registers a testing interface on the mock and a cleanup function to assert the mocks expectations.
// The first argument is typically a *testing.T value.
func NewMockPlcValue(t interface {
	mock.TestingT
	Cleanup(func())
}) *MockPlcValue {
	mock := &MockPlcValue{}
	mock.Mock.Test(t)

	t.Cleanup(func() { mock.AssertExpectations(t) })

	return mock
}
