/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

package model

import (
	"context"
	stdErrors "errors"
	"fmt"

	"github.com/pkg/errors"
	"github.com/rs/zerolog"

	. "github.com/apache/plc4x/plc4go/spi/codegen/fields"
	. "github.com/apache/plc4x/plc4go/spi/codegen/io"
	"github.com/apache/plc4x/plc4go/spi/utils"
)

// Code generated by code-generation. DO NOT EDIT.

// UnregisterNodesResponse is the corresponding interface of UnregisterNodesResponse
type UnregisterNodesResponse interface {
	fmt.Stringer
	utils.LengthAware
	utils.Serializable
	utils.Copyable
	ExtensionObjectDefinition
	// GetResponseHeader returns ResponseHeader (property field)
	GetResponseHeader() ResponseHeader
	// IsUnregisterNodesResponse is a marker method to prevent unintentional type checks (interfaces of same signature)
	IsUnregisterNodesResponse()
	// CreateBuilder creates a UnregisterNodesResponseBuilder
	CreateUnregisterNodesResponseBuilder() UnregisterNodesResponseBuilder
}

// _UnregisterNodesResponse is the data-structure of this message
type _UnregisterNodesResponse struct {
	ExtensionObjectDefinitionContract
	ResponseHeader ResponseHeader
}

var _ UnregisterNodesResponse = (*_UnregisterNodesResponse)(nil)
var _ ExtensionObjectDefinitionRequirements = (*_UnregisterNodesResponse)(nil)

// NewUnregisterNodesResponse factory function for _UnregisterNodesResponse
func NewUnregisterNodesResponse(responseHeader ResponseHeader) *_UnregisterNodesResponse {
	if responseHeader == nil {
		panic("responseHeader of type ResponseHeader for UnregisterNodesResponse must not be nil")
	}
	_result := &_UnregisterNodesResponse{
		ExtensionObjectDefinitionContract: NewExtensionObjectDefinition(),
		ResponseHeader:                    responseHeader,
	}
	_result.ExtensionObjectDefinitionContract.(*_ExtensionObjectDefinition)._SubType = _result
	return _result
}

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Builder
///////////////////////

// UnregisterNodesResponseBuilder is a builder for UnregisterNodesResponse
type UnregisterNodesResponseBuilder interface {
	utils.Copyable
	// WithMandatoryFields adds all mandatory fields (convenience for using multiple builder calls)
	WithMandatoryFields(responseHeader ResponseHeader) UnregisterNodesResponseBuilder
	// WithResponseHeader adds ResponseHeader (property field)
	WithResponseHeader(ResponseHeader) UnregisterNodesResponseBuilder
	// WithResponseHeaderBuilder adds ResponseHeader (property field) which is build by the builder
	WithResponseHeaderBuilder(func(ResponseHeaderBuilder) ResponseHeaderBuilder) UnregisterNodesResponseBuilder
	// Done is used to finish work on this child and return (or create one if none) to the parent builder
	Done() ExtensionObjectDefinitionBuilder
	// Build builds the UnregisterNodesResponse or returns an error if something is wrong
	Build() (UnregisterNodesResponse, error)
	// MustBuild does the same as Build but panics on error
	MustBuild() UnregisterNodesResponse
}

// NewUnregisterNodesResponseBuilder() creates a UnregisterNodesResponseBuilder
func NewUnregisterNodesResponseBuilder() UnregisterNodesResponseBuilder {
	return &_UnregisterNodesResponseBuilder{_UnregisterNodesResponse: new(_UnregisterNodesResponse)}
}

type _UnregisterNodesResponseBuilder struct {
	*_UnregisterNodesResponse

	parentBuilder *_ExtensionObjectDefinitionBuilder

	collectedErr []error
}

var _ (UnregisterNodesResponseBuilder) = (*_UnregisterNodesResponseBuilder)(nil)

func (b *_UnregisterNodesResponseBuilder) setParent(contract ExtensionObjectDefinitionContract) {
	b.ExtensionObjectDefinitionContract = contract
	contract.(*_ExtensionObjectDefinition)._SubType = b._UnregisterNodesResponse
}

func (b *_UnregisterNodesResponseBuilder) WithMandatoryFields(responseHeader ResponseHeader) UnregisterNodesResponseBuilder {
	return b.WithResponseHeader(responseHeader)
}

func (b *_UnregisterNodesResponseBuilder) WithResponseHeader(responseHeader ResponseHeader) UnregisterNodesResponseBuilder {
	b.ResponseHeader = responseHeader
	return b
}

func (b *_UnregisterNodesResponseBuilder) WithResponseHeaderBuilder(builderSupplier func(ResponseHeaderBuilder) ResponseHeaderBuilder) UnregisterNodesResponseBuilder {
	builder := builderSupplier(b.ResponseHeader.CreateResponseHeaderBuilder())
	var err error
	b.ResponseHeader, err = builder.Build()
	if err != nil {
		b.collectedErr = append(b.collectedErr, errors.Wrap(err, "ResponseHeaderBuilder failed"))
	}
	return b
}

func (b *_UnregisterNodesResponseBuilder) Build() (UnregisterNodesResponse, error) {
	if b.ResponseHeader == nil {
		b.collectedErr = append(b.collectedErr, errors.New("mandatory field 'responseHeader' not set"))
	}
	if err := stdErrors.Join(b.collectedErr...); err != nil {
		return nil, errors.Wrap(err, "error occurred during build")
	}
	return b._UnregisterNodesResponse.deepCopy(), nil
}

func (b *_UnregisterNodesResponseBuilder) MustBuild() UnregisterNodesResponse {
	build, err := b.Build()
	if err != nil {
		panic(err)
	}
	return build
}

func (b *_UnregisterNodesResponseBuilder) Done() ExtensionObjectDefinitionBuilder {
	if b.parentBuilder == nil {
		b.parentBuilder = NewExtensionObjectDefinitionBuilder().(*_ExtensionObjectDefinitionBuilder)
	}
	return b.parentBuilder
}

func (b *_UnregisterNodesResponseBuilder) buildForExtensionObjectDefinition() (ExtensionObjectDefinition, error) {
	return b.Build()
}

func (b *_UnregisterNodesResponseBuilder) DeepCopy() any {
	_copy := b.CreateUnregisterNodesResponseBuilder().(*_UnregisterNodesResponseBuilder)
	if b.collectedErr != nil {
		copy(_copy.collectedErr, b.collectedErr)
	}
	return _copy
}

// CreateUnregisterNodesResponseBuilder creates a UnregisterNodesResponseBuilder
func (b *_UnregisterNodesResponse) CreateUnregisterNodesResponseBuilder() UnregisterNodesResponseBuilder {
	if b == nil {
		return NewUnregisterNodesResponseBuilder()
	}
	return &_UnregisterNodesResponseBuilder{_UnregisterNodesResponse: b.deepCopy()}
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for discriminator values.
///////////////////////

func (m *_UnregisterNodesResponse) GetExtensionId() int32 {
	return int32(569)
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

func (m *_UnregisterNodesResponse) GetParent() ExtensionObjectDefinitionContract {
	return m.ExtensionObjectDefinitionContract
}

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for property fields.
///////////////////////

func (m *_UnregisterNodesResponse) GetResponseHeader() ResponseHeader {
	return m.ResponseHeader
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

// Deprecated: use the interface for direct cast
func CastUnregisterNodesResponse(structType any) UnregisterNodesResponse {
	if casted, ok := structType.(UnregisterNodesResponse); ok {
		return casted
	}
	if casted, ok := structType.(*UnregisterNodesResponse); ok {
		return *casted
	}
	return nil
}

func (m *_UnregisterNodesResponse) GetTypeName() string {
	return "UnregisterNodesResponse"
}

func (m *_UnregisterNodesResponse) GetLengthInBits(ctx context.Context) uint16 {
	lengthInBits := uint16(m.ExtensionObjectDefinitionContract.(*_ExtensionObjectDefinition).getLengthInBits(ctx))

	// Simple field (responseHeader)
	lengthInBits += m.ResponseHeader.GetLengthInBits(ctx)

	return lengthInBits
}

func (m *_UnregisterNodesResponse) GetLengthInBytes(ctx context.Context) uint16 {
	return m.GetLengthInBits(ctx) / 8
}

func (m *_UnregisterNodesResponse) parse(ctx context.Context, readBuffer utils.ReadBuffer, parent *_ExtensionObjectDefinition, extensionId int32) (__unregisterNodesResponse UnregisterNodesResponse, err error) {
	m.ExtensionObjectDefinitionContract = parent
	parent._SubType = m
	positionAware := readBuffer
	_ = positionAware
	if pullErr := readBuffer.PullContext("UnregisterNodesResponse"); pullErr != nil {
		return nil, errors.Wrap(pullErr, "Error pulling for UnregisterNodesResponse")
	}
	currentPos := positionAware.GetPos()
	_ = currentPos

	responseHeader, err := ReadSimpleField[ResponseHeader](ctx, "responseHeader", ReadComplex[ResponseHeader](ExtensionObjectDefinitionParseWithBufferProducer[ResponseHeader]((int32)(int32(394))), readBuffer))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'responseHeader' field"))
	}
	m.ResponseHeader = responseHeader

	if closeErr := readBuffer.CloseContext("UnregisterNodesResponse"); closeErr != nil {
		return nil, errors.Wrap(closeErr, "Error closing for UnregisterNodesResponse")
	}

	return m, nil
}

func (m *_UnregisterNodesResponse) Serialize() ([]byte, error) {
	wb := utils.NewWriteBufferByteBased(utils.WithInitialSizeForByteBasedBuffer(int(m.GetLengthInBytes(context.Background()))))
	if err := m.SerializeWithWriteBuffer(context.Background(), wb); err != nil {
		return nil, err
	}
	return wb.GetBytes(), nil
}

func (m *_UnregisterNodesResponse) SerializeWithWriteBuffer(ctx context.Context, writeBuffer utils.WriteBuffer) error {
	positionAware := writeBuffer
	_ = positionAware
	log := zerolog.Ctx(ctx)
	_ = log
	ser := func() error {
		if pushErr := writeBuffer.PushContext("UnregisterNodesResponse"); pushErr != nil {
			return errors.Wrap(pushErr, "Error pushing for UnregisterNodesResponse")
		}

		if err := WriteSimpleField[ResponseHeader](ctx, "responseHeader", m.GetResponseHeader(), WriteComplex[ResponseHeader](writeBuffer)); err != nil {
			return errors.Wrap(err, "Error serializing 'responseHeader' field")
		}

		if popErr := writeBuffer.PopContext("UnregisterNodesResponse"); popErr != nil {
			return errors.Wrap(popErr, "Error popping for UnregisterNodesResponse")
		}
		return nil
	}
	return m.ExtensionObjectDefinitionContract.(*_ExtensionObjectDefinition).serializeParent(ctx, writeBuffer, m, ser)
}

func (m *_UnregisterNodesResponse) IsUnregisterNodesResponse() {}

func (m *_UnregisterNodesResponse) DeepCopy() any {
	return m.deepCopy()
}

func (m *_UnregisterNodesResponse) deepCopy() *_UnregisterNodesResponse {
	if m == nil {
		return nil
	}
	_UnregisterNodesResponseCopy := &_UnregisterNodesResponse{
		m.ExtensionObjectDefinitionContract.(*_ExtensionObjectDefinition).deepCopy(),
		utils.DeepCopy[ResponseHeader](m.ResponseHeader),
	}
	_UnregisterNodesResponseCopy.ExtensionObjectDefinitionContract.(*_ExtensionObjectDefinition)._SubType = m
	return _UnregisterNodesResponseCopy
}

func (m *_UnregisterNodesResponse) String() string {
	if m == nil {
		return "<nil>"
	}
	wb := utils.NewWriteBufferBoxBased(
		utils.WithWriteBufferBoxBasedMergeSingleBoxes(),
		utils.WithWriteBufferBoxBasedOmitEmptyBoxes(),
		utils.WithWriteBufferBoxBasedPrintPosLengthFooter(),
	)
	if err := wb.WriteSerializable(context.Background(), m); err != nil {
		return err.Error()
	}
	return wb.GetBox().String()
}
