/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

package model

import (
	"context"

	"github.com/pkg/errors"
	"github.com/rs/zerolog"

	api "github.com/apache/plc4x/plc4go/pkg/api/values"
	"github.com/apache/plc4x/plc4go/spi/utils"
	"github.com/apache/plc4x/plc4go/spi/values"
)

// Code generated by code-generation. DO NOT EDIT.

func KnxPropertyParse(ctx context.Context, theBytes []byte, propertyType KnxPropertyDataType, dataLengthInBytes uint8) (api.PlcValue, error) {
	return KnxPropertyParseWithBuffer(ctx, utils.NewReadBufferByteBased(theBytes), propertyType, dataLengthInBytes)
}

func KnxPropertyParseWithBuffer(ctx context.Context, readBuffer utils.ReadBuffer, propertyType KnxPropertyDataType, dataLengthInBytes uint8) (api.PlcValue, error) {
	log := zerolog.Ctx(ctx)
	_ = log
	readBuffer.PullContext("KnxProperty")
	switch {
	case propertyType == KnxPropertyDataType_PDT_CONTROL: // BOOL
		// Reserved Field (Just skip the bytes)
		if _, _err := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadUint8("reserved", 7); _err != nil {
			return nil, errors.Wrap(_err, "Error parsing reserved field")
		}

		// Simple Field (value)
		value, _valueErr := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadBit("value")
		if _valueErr != nil {
			return nil, errors.Wrap(_valueErr, "Error parsing 'value' field")
		}
		_ = value // TODO: temporary till we fix TIME stuff in golang (see above in the template)
		readBuffer.CloseContext("KnxProperty")
		return values.NewPlcBOOL(value), nil
	case propertyType == KnxPropertyDataType_PDT_CHAR: // SINT
		// Simple Field (value)
		value, _valueErr := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadInt8("value", 8)
		if _valueErr != nil {
			return nil, errors.Wrap(_valueErr, "Error parsing 'value' field")
		}
		_ = value // TODO: temporary till we fix TIME stuff in golang (see above in the template)
		readBuffer.CloseContext("KnxProperty")
		return values.NewPlcSINT(value), nil
	case propertyType == KnxPropertyDataType_PDT_UNSIGNED_CHAR: // USINT
		// Simple Field (value)
		value, _valueErr := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadUint8("value", 8)
		if _valueErr != nil {
			return nil, errors.Wrap(_valueErr, "Error parsing 'value' field")
		}
		_ = value // TODO: temporary till we fix TIME stuff in golang (see above in the template)
		readBuffer.CloseContext("KnxProperty")
		return values.NewPlcUSINT(value), nil
	case propertyType == KnxPropertyDataType_PDT_INT: // INT
		// Simple Field (value)
		value, _valueErr := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadInt16("value", 16)
		if _valueErr != nil {
			return nil, errors.Wrap(_valueErr, "Error parsing 'value' field")
		}
		_ = value // TODO: temporary till we fix TIME stuff in golang (see above in the template)
		readBuffer.CloseContext("KnxProperty")
		return values.NewPlcINT(value), nil
	case propertyType == KnxPropertyDataType_PDT_UNSIGNED_INT && dataLengthInBytes == uint8(4): // UDINT
		// Simple Field (value)
		value, _valueErr := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadUint32("value", 32)
		if _valueErr != nil {
			return nil, errors.Wrap(_valueErr, "Error parsing 'value' field")
		}
		_ = value // TODO: temporary till we fix TIME stuff in golang (see above in the template)
		readBuffer.CloseContext("KnxProperty")
		return values.NewPlcUDINT(value), nil
	case propertyType == KnxPropertyDataType_PDT_UNSIGNED_INT: // UINT
		// Simple Field (value)
		value, _valueErr := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadUint16("value", 16)
		if _valueErr != nil {
			return nil, errors.Wrap(_valueErr, "Error parsing 'value' field")
		}
		_ = value // TODO: temporary till we fix TIME stuff in golang (see above in the template)
		readBuffer.CloseContext("KnxProperty")
		return values.NewPlcUINT(value), nil
	case propertyType == KnxPropertyDataType_PDT_KNX_FLOAT: // REAL
		// Simple Field (value)
		value, _valueErr := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadFloat32("value", 16)
		if _valueErr != nil {
			return nil, errors.Wrap(_valueErr, "Error parsing 'value' field")
		}
		_ = value // TODO: temporary till we fix TIME stuff in golang (see above in the template)
		readBuffer.CloseContext("KnxProperty")
		return values.NewPlcREAL(value), nil
	case propertyType == KnxPropertyDataType_PDT_DATE: // Struct
		// Struct
		_map := map[string]api.PlcValue{}

		// Reserved Field (Just skip the bytes)
		if _, _err := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadUint8("reserved", 3); _err != nil {
			return nil, errors.Wrap(_err, "Error parsing reserved field")
		}

		// Simple Field (dayOfMonth)
		dayOfMonth, _dayOfMonthErr := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadUint8("dayOfMonth", 5)
		if _dayOfMonthErr != nil {
			return nil, errors.Wrap(_dayOfMonthErr, "Error parsing 'dayOfMonth' field")
		}
		_map["Struct"] = values.NewPlcUSINT(dayOfMonth)
		_ = dayOfMonth // TODO: temporary till we fix TIME stuff in golang (see above in the template)

		// Reserved Field (Just skip the bytes)
		if _, _err := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadUint8("reserved", 4); _err != nil {
			return nil, errors.Wrap(_err, "Error parsing reserved field")
		}

		// Simple Field (month)
		month, _monthErr := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadUint8("month", 4)
		if _monthErr != nil {
			return nil, errors.Wrap(_monthErr, "Error parsing 'month' field")
		}
		_map["Struct"] = values.NewPlcUSINT(month)
		_ = month // TODO: temporary till we fix TIME stuff in golang (see above in the template)

		// Reserved Field (Just skip the bytes)
		if _, _err := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadUint8("reserved", 1); _err != nil {
			return nil, errors.Wrap(_err, "Error parsing reserved field")
		}

		// Simple Field (year)
		year, _yearErr := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadUint8("year", 7)
		if _yearErr != nil {
			return nil, errors.Wrap(_yearErr, "Error parsing 'year' field")
		}
		_map["Struct"] = values.NewPlcUSINT(year)
		_ = year // TODO: temporary till we fix TIME stuff in golang (see above in the template)
		readBuffer.CloseContext("KnxProperty")
		return values.NewPlcStruct(_map), nil
	case propertyType == KnxPropertyDataType_PDT_TIME: // Struct
		// Struct
		_map := map[string]api.PlcValue{}

		// Simple Field (day)
		day, _dayErr := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadUint8("day", 3)
		if _dayErr != nil {
			return nil, errors.Wrap(_dayErr, "Error parsing 'day' field")
		}
		_map["Struct"] = values.NewPlcUSINT(day)
		_ = day // TODO: temporary till we fix TIME stuff in golang (see above in the template)

		// Simple Field (hour)
		hour, _hourErr := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadUint8("hour", 5)
		if _hourErr != nil {
			return nil, errors.Wrap(_hourErr, "Error parsing 'hour' field")
		}
		_map["Struct"] = values.NewPlcUSINT(hour)
		_ = hour // TODO: temporary till we fix TIME stuff in golang (see above in the template)

		// Reserved Field (Just skip the bytes)
		if _, _err := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadUint8("reserved", 2); _err != nil {
			return nil, errors.Wrap(_err, "Error parsing reserved field")
		}

		// Simple Field (minutes)
		minutes, _minutesErr := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadUint8("minutes", 6)
		if _minutesErr != nil {
			return nil, errors.Wrap(_minutesErr, "Error parsing 'minutes' field")
		}
		_map["Struct"] = values.NewPlcUSINT(minutes)
		_ = minutes // TODO: temporary till we fix TIME stuff in golang (see above in the template)

		// Reserved Field (Just skip the bytes)
		if _, _err := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadUint8("reserved", 2); _err != nil {
			return nil, errors.Wrap(_err, "Error parsing reserved field")
		}

		// Simple Field (seconds)
		seconds, _secondsErr := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadUint8("seconds", 6)
		if _secondsErr != nil {
			return nil, errors.Wrap(_secondsErr, "Error parsing 'seconds' field")
		}
		_map["Struct"] = values.NewPlcUSINT(seconds)
		_ = seconds // TODO: temporary till we fix TIME stuff in golang (see above in the template)
		readBuffer.CloseContext("KnxProperty")
		return values.NewPlcStruct(_map), nil
	case propertyType == KnxPropertyDataType_PDT_LONG: // DINT
		// Simple Field (value)
		value, _valueErr := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadInt32("value", 32)
		if _valueErr != nil {
			return nil, errors.Wrap(_valueErr, "Error parsing 'value' field")
		}
		_ = value // TODO: temporary till we fix TIME stuff in golang (see above in the template)
		readBuffer.CloseContext("KnxProperty")
		return values.NewPlcDINT(value), nil
	case propertyType == KnxPropertyDataType_PDT_UNSIGNED_LONG: // UDINT
		// Simple Field (value)
		value, _valueErr := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadUint32("value", 32)
		if _valueErr != nil {
			return nil, errors.Wrap(_valueErr, "Error parsing 'value' field")
		}
		_ = value // TODO: temporary till we fix TIME stuff in golang (see above in the template)
		readBuffer.CloseContext("KnxProperty")
		return values.NewPlcUDINT(value), nil
	case propertyType == KnxPropertyDataType_PDT_FLOAT: // REAL
		// Simple Field (value)
		value, _valueErr := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadFloat32("value", 32)
		if _valueErr != nil {
			return nil, errors.Wrap(_valueErr, "Error parsing 'value' field")
		}
		_ = value // TODO: temporary till we fix TIME stuff in golang (see above in the template)
		readBuffer.CloseContext("KnxProperty")
		return values.NewPlcREAL(value), nil
	case propertyType == KnxPropertyDataType_PDT_DOUBLE: // LREAL
		// Simple Field (value)
		value, _valueErr := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadFloat64("value", 64)
		if _valueErr != nil {
			return nil, errors.Wrap(_valueErr, "Error parsing 'value' field")
		}
		_ = value // TODO: temporary till we fix TIME stuff in golang (see above in the template)
		readBuffer.CloseContext("KnxProperty")
		return values.NewPlcLREAL(value), nil
	case propertyType == KnxPropertyDataType_PDT_CHAR_BLOCK: // RawByteArray
		// Array Field (value)
		value, _valueErr := readBuffer.ReadByteArray("value", int((10)))
		if _valueErr != nil {
			return nil, errors.Wrap(_valueErr, "Error parsing 'value' field")
		}
		_ = value // TODO: temporary till we fix TIME stuff in golang (see above in the template)
		readBuffer.CloseContext("KnxProperty")
		return values.NewPlcRawByteArray(value), nil
	case propertyType == KnxPropertyDataType_PDT_POLL_GROUP_SETTINGS: // Struct
		// Struct
		_map := map[string]api.PlcValue{}

		// Array Field (groupAddress)
		groupAddress, _groupAddressErr := readBuffer.ReadByteArray("groupAddress", int((2)))
		if _groupAddressErr != nil {
			return nil, errors.Wrap(_groupAddressErr, "Error parsing 'groupAddress' field")
		}
		_ = groupAddress // TODO: temporary till we fix TIME stuff in golang (see above in the template)

		// Simple Field (disable)
		disable, _disableErr := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadBit("disable")
		if _disableErr != nil {
			return nil, errors.Wrap(_disableErr, "Error parsing 'disable' field")
		}
		_map["Struct"] = values.NewPlcBOOL(disable)
		_ = disable // TODO: temporary till we fix TIME stuff in golang (see above in the template)

		// Reserved Field (Just skip the bytes)
		if _, _err := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadUint8("reserved", 3); _err != nil {
			return nil, errors.Wrap(_err, "Error parsing reserved field")
		}

		// Simple Field (pollingSoftNr)
		pollingSoftNr, _pollingSoftNrErr := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadUint8("pollingSoftNr", 4)
		if _pollingSoftNrErr != nil {
			return nil, errors.Wrap(_pollingSoftNrErr, "Error parsing 'pollingSoftNr' field")
		}
		_map["Struct"] = values.NewPlcUSINT(pollingSoftNr)
		_ = pollingSoftNr // TODO: temporary till we fix TIME stuff in golang (see above in the template)
		readBuffer.CloseContext("KnxProperty")
		return values.NewPlcStruct(_map), nil
	case propertyType == KnxPropertyDataType_PDT_SHORT_CHAR_BLOCK: // RawByteArray
		// Array Field (value)
		value, _valueErr := readBuffer.ReadByteArray("value", int((5)))
		if _valueErr != nil {
			return nil, errors.Wrap(_valueErr, "Error parsing 'value' field")
		}
		_ = value // TODO: temporary till we fix TIME stuff in golang (see above in the template)
		readBuffer.CloseContext("KnxProperty")
		return values.NewPlcRawByteArray(value), nil
	case propertyType == KnxPropertyDataType_PDT_DATE_TIME: // Struct
		// Struct
		_map := map[string]api.PlcValue{}

		// Simple Field (year)
		year, _yearErr := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadUint8("year", 8)
		if _yearErr != nil {
			return nil, errors.Wrap(_yearErr, "Error parsing 'year' field")
		}
		_map["Struct"] = values.NewPlcUSINT(year)
		_ = year // TODO: temporary till we fix TIME stuff in golang (see above in the template)

		// Reserved Field (Just skip the bytes)
		if _, _err := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadUint8("reserved", 4); _err != nil {
			return nil, errors.Wrap(_err, "Error parsing reserved field")
		}

		// Simple Field (month)
		month, _monthErr := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadUint8("month", 4)
		if _monthErr != nil {
			return nil, errors.Wrap(_monthErr, "Error parsing 'month' field")
		}
		_map["Struct"] = values.NewPlcUSINT(month)
		_ = month // TODO: temporary till we fix TIME stuff in golang (see above in the template)

		// Reserved Field (Just skip the bytes)
		if _, _err := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadUint8("reserved", 3); _err != nil {
			return nil, errors.Wrap(_err, "Error parsing reserved field")
		}

		// Simple Field (dayOfMonth)
		dayOfMonth, _dayOfMonthErr := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadUint8("dayOfMonth", 5)
		if _dayOfMonthErr != nil {
			return nil, errors.Wrap(_dayOfMonthErr, "Error parsing 'dayOfMonth' field")
		}
		_map["Struct"] = values.NewPlcUSINT(dayOfMonth)
		_ = dayOfMonth // TODO: temporary till we fix TIME stuff in golang (see above in the template)

		// Simple Field (dayOfWeek)
		dayOfWeek, _dayOfWeekErr := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadUint8("dayOfWeek", 3)
		if _dayOfWeekErr != nil {
			return nil, errors.Wrap(_dayOfWeekErr, "Error parsing 'dayOfWeek' field")
		}
		_map["Struct"] = values.NewPlcUSINT(dayOfWeek)
		_ = dayOfWeek // TODO: temporary till we fix TIME stuff in golang (see above in the template)

		// Simple Field (hour)
		hour, _hourErr := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadUint8("hour", 5)
		if _hourErr != nil {
			return nil, errors.Wrap(_hourErr, "Error parsing 'hour' field")
		}
		_map["Struct"] = values.NewPlcUSINT(hour)
		_ = hour // TODO: temporary till we fix TIME stuff in golang (see above in the template)

		// Reserved Field (Just skip the bytes)
		if _, _err := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadUint8("reserved", 2); _err != nil {
			return nil, errors.Wrap(_err, "Error parsing reserved field")
		}

		// Simple Field (minutes)
		minutes, _minutesErr := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadUint8("minutes", 6)
		if _minutesErr != nil {
			return nil, errors.Wrap(_minutesErr, "Error parsing 'minutes' field")
		}
		_map["Struct"] = values.NewPlcUSINT(minutes)
		_ = minutes // TODO: temporary till we fix TIME stuff in golang (see above in the template)

		// Reserved Field (Just skip the bytes)
		if _, _err := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadUint8("reserved", 2); _err != nil {
			return nil, errors.Wrap(_err, "Error parsing reserved field")
		}

		// Simple Field (seconds)
		seconds, _secondsErr := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadUint8("seconds", 6)
		if _secondsErr != nil {
			return nil, errors.Wrap(_secondsErr, "Error parsing 'seconds' field")
		}
		_map["Struct"] = values.NewPlcUSINT(seconds)
		_ = seconds // TODO: temporary till we fix TIME stuff in golang (see above in the template)

		// Simple Field (fault)
		fault, _faultErr := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadBit("fault")
		if _faultErr != nil {
			return nil, errors.Wrap(_faultErr, "Error parsing 'fault' field")
		}
		_map["Struct"] = values.NewPlcBOOL(fault)
		_ = fault // TODO: temporary till we fix TIME stuff in golang (see above in the template)

		// Simple Field (workingDay)
		workingDay, _workingDayErr := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadBit("workingDay")
		if _workingDayErr != nil {
			return nil, errors.Wrap(_workingDayErr, "Error parsing 'workingDay' field")
		}
		_map["Struct"] = values.NewPlcBOOL(workingDay)
		_ = workingDay // TODO: temporary till we fix TIME stuff in golang (see above in the template)

		// Simple Field (noWd)
		noWd, _noWdErr := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadBit("noWd")
		if _noWdErr != nil {
			return nil, errors.Wrap(_noWdErr, "Error parsing 'noWd' field")
		}
		_map["Struct"] = values.NewPlcBOOL(noWd)
		_ = noWd // TODO: temporary till we fix TIME stuff in golang (see above in the template)

		// Simple Field (noYear)
		noYear, _noYearErr := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadBit("noYear")
		if _noYearErr != nil {
			return nil, errors.Wrap(_noYearErr, "Error parsing 'noYear' field")
		}
		_map["Struct"] = values.NewPlcBOOL(noYear)
		_ = noYear // TODO: temporary till we fix TIME stuff in golang (see above in the template)

		// Simple Field (noDate)
		noDate, _noDateErr := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadBit("noDate")
		if _noDateErr != nil {
			return nil, errors.Wrap(_noDateErr, "Error parsing 'noDate' field")
		}
		_map["Struct"] = values.NewPlcBOOL(noDate)
		_ = noDate // TODO: temporary till we fix TIME stuff in golang (see above in the template)

		// Simple Field (noDayOfWeek)
		noDayOfWeek, _noDayOfWeekErr := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadBit("noDayOfWeek")
		if _noDayOfWeekErr != nil {
			return nil, errors.Wrap(_noDayOfWeekErr, "Error parsing 'noDayOfWeek' field")
		}
		_map["Struct"] = values.NewPlcBOOL(noDayOfWeek)
		_ = noDayOfWeek // TODO: temporary till we fix TIME stuff in golang (see above in the template)

		// Simple Field (noTime)
		noTime, _noTimeErr := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadBit("noTime")
		if _noTimeErr != nil {
			return nil, errors.Wrap(_noTimeErr, "Error parsing 'noTime' field")
		}
		_map["Struct"] = values.NewPlcBOOL(noTime)
		_ = noTime // TODO: temporary till we fix TIME stuff in golang (see above in the template)

		// Simple Field (standardSummerTime)
		standardSummerTime, _standardSummerTimeErr := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadBit("standardSummerTime")
		if _standardSummerTimeErr != nil {
			return nil, errors.Wrap(_standardSummerTimeErr, "Error parsing 'standardSummerTime' field")
		}
		_map["Struct"] = values.NewPlcBOOL(standardSummerTime)
		_ = standardSummerTime // TODO: temporary till we fix TIME stuff in golang (see above in the template)

		// Simple Field (qualityOfClock)
		qualityOfClock, _qualityOfClockErr := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadBit("qualityOfClock")
		if _qualityOfClockErr != nil {
			return nil, errors.Wrap(_qualityOfClockErr, "Error parsing 'qualityOfClock' field")
		}
		_map["Struct"] = values.NewPlcBOOL(qualityOfClock)
		_ = qualityOfClock // TODO: temporary till we fix TIME stuff in golang (see above in the template)

		// Reserved Field (Just skip the bytes)
		if _, _err := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadUint8("reserved", 7); _err != nil {
			return nil, errors.Wrap(_err, "Error parsing reserved field")
		}
		readBuffer.CloseContext("KnxProperty")
		return values.NewPlcStruct(_map), nil
	case propertyType == KnxPropertyDataType_PDT_GENERIC_01: // RawByteArray
		// Array Field (value)
		value, _valueErr := readBuffer.ReadByteArray("value", int((1)))
		if _valueErr != nil {
			return nil, errors.Wrap(_valueErr, "Error parsing 'value' field")
		}
		_ = value // TODO: temporary till we fix TIME stuff in golang (see above in the template)
		readBuffer.CloseContext("KnxProperty")
		return values.NewPlcRawByteArray(value), nil
	case propertyType == KnxPropertyDataType_PDT_GENERIC_02: // RawByteArray
		// Array Field (value)
		value, _valueErr := readBuffer.ReadByteArray("value", int((2)))
		if _valueErr != nil {
			return nil, errors.Wrap(_valueErr, "Error parsing 'value' field")
		}
		_ = value // TODO: temporary till we fix TIME stuff in golang (see above in the template)
		readBuffer.CloseContext("KnxProperty")
		return values.NewPlcRawByteArray(value), nil
	case propertyType == KnxPropertyDataType_PDT_GENERIC_03: // RawByteArray
		// Array Field (value)
		value, _valueErr := readBuffer.ReadByteArray("value", int((3)))
		if _valueErr != nil {
			return nil, errors.Wrap(_valueErr, "Error parsing 'value' field")
		}
		_ = value // TODO: temporary till we fix TIME stuff in golang (see above in the template)
		readBuffer.CloseContext("KnxProperty")
		return values.NewPlcRawByteArray(value), nil
	case propertyType == KnxPropertyDataType_PDT_GENERIC_04: // RawByteArray
		// Array Field (value)
		value, _valueErr := readBuffer.ReadByteArray("value", int((4)))
		if _valueErr != nil {
			return nil, errors.Wrap(_valueErr, "Error parsing 'value' field")
		}
		_ = value // TODO: temporary till we fix TIME stuff in golang (see above in the template)
		readBuffer.CloseContext("KnxProperty")
		return values.NewPlcRawByteArray(value), nil
	case propertyType == KnxPropertyDataType_PDT_GENERIC_05: // RawByteArray
		// Array Field (value)
		value, _valueErr := readBuffer.ReadByteArray("value", int((5)))
		if _valueErr != nil {
			return nil, errors.Wrap(_valueErr, "Error parsing 'value' field")
		}
		_ = value // TODO: temporary till we fix TIME stuff in golang (see above in the template)
		readBuffer.CloseContext("KnxProperty")
		return values.NewPlcRawByteArray(value), nil
	case propertyType == KnxPropertyDataType_PDT_GENERIC_06: // RawByteArray
		// Array Field (value)
		value, _valueErr := readBuffer.ReadByteArray("value", int((6)))
		if _valueErr != nil {
			return nil, errors.Wrap(_valueErr, "Error parsing 'value' field")
		}
		_ = value // TODO: temporary till we fix TIME stuff in golang (see above in the template)
		readBuffer.CloseContext("KnxProperty")
		return values.NewPlcRawByteArray(value), nil
	case propertyType == KnxPropertyDataType_PDT_GENERIC_07: // RawByteArray
		// Array Field (value)
		value, _valueErr := readBuffer.ReadByteArray("value", int((7)))
		if _valueErr != nil {
			return nil, errors.Wrap(_valueErr, "Error parsing 'value' field")
		}
		_ = value // TODO: temporary till we fix TIME stuff in golang (see above in the template)
		readBuffer.CloseContext("KnxProperty")
		return values.NewPlcRawByteArray(value), nil
	case propertyType == KnxPropertyDataType_PDT_GENERIC_08: // RawByteArray
		// Array Field (value)
		value, _valueErr := readBuffer.ReadByteArray("value", int((8)))
		if _valueErr != nil {
			return nil, errors.Wrap(_valueErr, "Error parsing 'value' field")
		}
		_ = value // TODO: temporary till we fix TIME stuff in golang (see above in the template)
		readBuffer.CloseContext("KnxProperty")
		return values.NewPlcRawByteArray(value), nil
	case propertyType == KnxPropertyDataType_PDT_GENERIC_09: // RawByteArray
		// Array Field (value)
		value, _valueErr := readBuffer.ReadByteArray("value", int((9)))
		if _valueErr != nil {
			return nil, errors.Wrap(_valueErr, "Error parsing 'value' field")
		}
		_ = value // TODO: temporary till we fix TIME stuff in golang (see above in the template)
		readBuffer.CloseContext("KnxProperty")
		return values.NewPlcRawByteArray(value), nil
	case propertyType == KnxPropertyDataType_PDT_GENERIC_10: // RawByteArray
		// Array Field (value)
		value, _valueErr := readBuffer.ReadByteArray("value", int((10)))
		if _valueErr != nil {
			return nil, errors.Wrap(_valueErr, "Error parsing 'value' field")
		}
		_ = value // TODO: temporary till we fix TIME stuff in golang (see above in the template)
		readBuffer.CloseContext("KnxProperty")
		return values.NewPlcRawByteArray(value), nil
	case propertyType == KnxPropertyDataType_PDT_GENERIC_11: // RawByteArray
		// Array Field (value)
		value, _valueErr := readBuffer.ReadByteArray("value", int((11)))
		if _valueErr != nil {
			return nil, errors.Wrap(_valueErr, "Error parsing 'value' field")
		}
		_ = value // TODO: temporary till we fix TIME stuff in golang (see above in the template)
		readBuffer.CloseContext("KnxProperty")
		return values.NewPlcRawByteArray(value), nil
	case propertyType == KnxPropertyDataType_PDT_GENERIC_12: // RawByteArray
		// Array Field (value)
		value, _valueErr := readBuffer.ReadByteArray("value", int((12)))
		if _valueErr != nil {
			return nil, errors.Wrap(_valueErr, "Error parsing 'value' field")
		}
		_ = value // TODO: temporary till we fix TIME stuff in golang (see above in the template)
		readBuffer.CloseContext("KnxProperty")
		return values.NewPlcRawByteArray(value), nil
	case propertyType == KnxPropertyDataType_PDT_GENERIC_13: // RawByteArray
		// Array Field (value)
		value, _valueErr := readBuffer.ReadByteArray("value", int((13)))
		if _valueErr != nil {
			return nil, errors.Wrap(_valueErr, "Error parsing 'value' field")
		}
		_ = value // TODO: temporary till we fix TIME stuff in golang (see above in the template)
		readBuffer.CloseContext("KnxProperty")
		return values.NewPlcRawByteArray(value), nil
	case propertyType == KnxPropertyDataType_PDT_GENERIC_14: // RawByteArray
		// Array Field (value)
		value, _valueErr := readBuffer.ReadByteArray("value", int((14)))
		if _valueErr != nil {
			return nil, errors.Wrap(_valueErr, "Error parsing 'value' field")
		}
		_ = value // TODO: temporary till we fix TIME stuff in golang (see above in the template)
		readBuffer.CloseContext("KnxProperty")
		return values.NewPlcRawByteArray(value), nil
	case propertyType == KnxPropertyDataType_PDT_GENERIC_15: // RawByteArray
		// Array Field (value)
		value, _valueErr := readBuffer.ReadByteArray("value", int((15)))
		if _valueErr != nil {
			return nil, errors.Wrap(_valueErr, "Error parsing 'value' field")
		}
		_ = value // TODO: temporary till we fix TIME stuff in golang (see above in the template)
		readBuffer.CloseContext("KnxProperty")
		return values.NewPlcRawByteArray(value), nil
	case propertyType == KnxPropertyDataType_PDT_GENERIC_16: // RawByteArray
		// Array Field (value)
		value, _valueErr := readBuffer.ReadByteArray("value", int((16)))
		if _valueErr != nil {
			return nil, errors.Wrap(_valueErr, "Error parsing 'value' field")
		}
		_ = value // TODO: temporary till we fix TIME stuff in golang (see above in the template)
		readBuffer.CloseContext("KnxProperty")
		return values.NewPlcRawByteArray(value), nil
	case propertyType == KnxPropertyDataType_PDT_GENERIC_17: // RawByteArray
		// Array Field (value)
		value, _valueErr := readBuffer.ReadByteArray("value", int((17)))
		if _valueErr != nil {
			return nil, errors.Wrap(_valueErr, "Error parsing 'value' field")
		}
		_ = value // TODO: temporary till we fix TIME stuff in golang (see above in the template)
		readBuffer.CloseContext("KnxProperty")
		return values.NewPlcRawByteArray(value), nil
	case propertyType == KnxPropertyDataType_PDT_GENERIC_18: // RawByteArray
		// Array Field (value)
		value, _valueErr := readBuffer.ReadByteArray("value", int((18)))
		if _valueErr != nil {
			return nil, errors.Wrap(_valueErr, "Error parsing 'value' field")
		}
		_ = value // TODO: temporary till we fix TIME stuff in golang (see above in the template)
		readBuffer.CloseContext("KnxProperty")
		return values.NewPlcRawByteArray(value), nil
	case propertyType == KnxPropertyDataType_PDT_GENERIC_19: // RawByteArray
		// Array Field (value)
		value, _valueErr := readBuffer.ReadByteArray("value", int((19)))
		if _valueErr != nil {
			return nil, errors.Wrap(_valueErr, "Error parsing 'value' field")
		}
		_ = value // TODO: temporary till we fix TIME stuff in golang (see above in the template)
		readBuffer.CloseContext("KnxProperty")
		return values.NewPlcRawByteArray(value), nil
	case propertyType == KnxPropertyDataType_PDT_GENERIC_20: // RawByteArray
		// Array Field (value)
		value, _valueErr := readBuffer.ReadByteArray("value", int((20)))
		if _valueErr != nil {
			return nil, errors.Wrap(_valueErr, "Error parsing 'value' field")
		}
		_ = value // TODO: temporary till we fix TIME stuff in golang (see above in the template)
		readBuffer.CloseContext("KnxProperty")
		return values.NewPlcRawByteArray(value), nil
	case propertyType == KnxPropertyDataType_PDT_VERSION: // Struct
		// Struct
		_map := map[string]api.PlcValue{}

		// Simple Field (magicNumber)
		magicNumber, _magicNumberErr := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadUint8("magicNumber", 5)
		if _magicNumberErr != nil {
			return nil, errors.Wrap(_magicNumberErr, "Error parsing 'magicNumber' field")
		}
		_map["Struct"] = values.NewPlcUSINT(magicNumber)
		_ = magicNumber // TODO: temporary till we fix TIME stuff in golang (see above in the template)

		// Simple Field (versionNumber)
		versionNumber, _versionNumberErr := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadUint8("versionNumber", 5)
		if _versionNumberErr != nil {
			return nil, errors.Wrap(_versionNumberErr, "Error parsing 'versionNumber' field")
		}
		_map["Struct"] = values.NewPlcUSINT(versionNumber)
		_ = versionNumber // TODO: temporary till we fix TIME stuff in golang (see above in the template)

		// Simple Field (revisionNumber)
		revisionNumber, _revisionNumberErr := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadUint8("revisionNumber", 6)
		if _revisionNumberErr != nil {
			return nil, errors.Wrap(_revisionNumberErr, "Error parsing 'revisionNumber' field")
		}
		_map["Struct"] = values.NewPlcUSINT(revisionNumber)
		_ = revisionNumber // TODO: temporary till we fix TIME stuff in golang (see above in the template)
		readBuffer.CloseContext("KnxProperty")
		return values.NewPlcStruct(_map), nil
	case propertyType == KnxPropertyDataType_PDT_ALARM_INFO: // Struct
		// Struct
		_map := map[string]api.PlcValue{}

		// Simple Field (logNumber)
		logNumber, _logNumberErr := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadUint8("logNumber", 8)
		if _logNumberErr != nil {
			return nil, errors.Wrap(_logNumberErr, "Error parsing 'logNumber' field")
		}
		_map["Struct"] = values.NewPlcUSINT(logNumber)
		_ = logNumber // TODO: temporary till we fix TIME stuff in golang (see above in the template)

		// Simple Field (alarmPriority)
		alarmPriority, _alarmPriorityErr := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadUint8("alarmPriority", 8)
		if _alarmPriorityErr != nil {
			return nil, errors.Wrap(_alarmPriorityErr, "Error parsing 'alarmPriority' field")
		}
		_map["Struct"] = values.NewPlcUSINT(alarmPriority)
		_ = alarmPriority // TODO: temporary till we fix TIME stuff in golang (see above in the template)

		// Simple Field (applicationArea)
		applicationArea, _applicationAreaErr := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadUint8("applicationArea", 8)
		if _applicationAreaErr != nil {
			return nil, errors.Wrap(_applicationAreaErr, "Error parsing 'applicationArea' field")
		}
		_map["Struct"] = values.NewPlcUSINT(applicationArea)
		_ = applicationArea // TODO: temporary till we fix TIME stuff in golang (see above in the template)

		// Simple Field (errorClass)
		errorClass, _errorClassErr := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadUint8("errorClass", 8)
		if _errorClassErr != nil {
			return nil, errors.Wrap(_errorClassErr, "Error parsing 'errorClass' field")
		}
		_map["Struct"] = values.NewPlcUSINT(errorClass)
		_ = errorClass // TODO: temporary till we fix TIME stuff in golang (see above in the template)

		// Reserved Field (Just skip the bytes)
		if _, _err := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadUint8("reserved", 4); _err != nil {
			return nil, errors.Wrap(_err, "Error parsing reserved field")
		}

		// Simple Field (errorcodeSup)
		errorcodeSup, _errorcodeSupErr := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadBit("errorcodeSup")
		if _errorcodeSupErr != nil {
			return nil, errors.Wrap(_errorcodeSupErr, "Error parsing 'errorcodeSup' field")
		}
		_map["Struct"] = values.NewPlcBOOL(errorcodeSup)
		_ = errorcodeSup // TODO: temporary till we fix TIME stuff in golang (see above in the template)

		// Simple Field (alarmtextSup)
		alarmtextSup, _alarmtextSupErr := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadBit("alarmtextSup")
		if _alarmtextSupErr != nil {
			return nil, errors.Wrap(_alarmtextSupErr, "Error parsing 'alarmtextSup' field")
		}
		_map["Struct"] = values.NewPlcBOOL(alarmtextSup)
		_ = alarmtextSup // TODO: temporary till we fix TIME stuff in golang (see above in the template)

		// Simple Field (timestampSup)
		timestampSup, _timestampSupErr := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadBit("timestampSup")
		if _timestampSupErr != nil {
			return nil, errors.Wrap(_timestampSupErr, "Error parsing 'timestampSup' field")
		}
		_map["Struct"] = values.NewPlcBOOL(timestampSup)
		_ = timestampSup // TODO: temporary till we fix TIME stuff in golang (see above in the template)

		// Simple Field (ackSup)
		ackSup, _ackSupErr := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadBit("ackSup")
		if _ackSupErr != nil {
			return nil, errors.Wrap(_ackSupErr, "Error parsing 'ackSup' field")
		}
		_map["Struct"] = values.NewPlcBOOL(ackSup)
		_ = ackSup // TODO: temporary till we fix TIME stuff in golang (see above in the template)

		// Reserved Field (Just skip the bytes)
		if _, _err := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadUint8("reserved", 5); _err != nil {
			return nil, errors.Wrap(_err, "Error parsing reserved field")
		}

		// Simple Field (locked)
		locked, _lockedErr := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadBit("locked")
		if _lockedErr != nil {
			return nil, errors.Wrap(_lockedErr, "Error parsing 'locked' field")
		}
		_map["Struct"] = values.NewPlcBOOL(locked)
		_ = locked // TODO: temporary till we fix TIME stuff in golang (see above in the template)

		// Simple Field (alarmunack)
		alarmunack, _alarmunackErr := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadBit("alarmunack")
		if _alarmunackErr != nil {
			return nil, errors.Wrap(_alarmunackErr, "Error parsing 'alarmunack' field")
		}
		_map["Struct"] = values.NewPlcBOOL(alarmunack)
		_ = alarmunack // TODO: temporary till we fix TIME stuff in golang (see above in the template)

		// Simple Field (inalarm)
		inalarm, _inalarmErr := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadBit("inalarm")
		if _inalarmErr != nil {
			return nil, errors.Wrap(_inalarmErr, "Error parsing 'inalarm' field")
		}
		_map["Struct"] = values.NewPlcBOOL(inalarm)
		_ = inalarm // TODO: temporary till we fix TIME stuff in golang (see above in the template)
		readBuffer.CloseContext("KnxProperty")
		return values.NewPlcStruct(_map), nil
	case propertyType == KnxPropertyDataType_PDT_BINARY_INFORMATION: // BOOL
		// Reserved Field (Just skip the bytes)
		if _, _err := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadUint8("reserved", 7); _err != nil {
			return nil, errors.Wrap(_err, "Error parsing reserved field")
		}

		// Simple Field (value)
		value, _valueErr := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadBit("value")
		if _valueErr != nil {
			return nil, errors.Wrap(_valueErr, "Error parsing 'value' field")
		}
		_ = value // TODO: temporary till we fix TIME stuff in golang (see above in the template)
		readBuffer.CloseContext("KnxProperty")
		return values.NewPlcBOOL(value), nil
	case propertyType == KnxPropertyDataType_PDT_BITSET8: // BYTE
		// Simple Field (value)
		value, _valueErr := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadUint8("value", 8)
		if _valueErr != nil {
			return nil, errors.Wrap(_valueErr, "Error parsing 'value' field")
		}
		_ = value // TODO: temporary till we fix TIME stuff in golang (see above in the template)
		readBuffer.CloseContext("KnxProperty")
		return values.NewPlcBYTE(value), nil
	case propertyType == KnxPropertyDataType_PDT_BITSET16: // WORD
		// Simple Field (value)
		value, _valueErr := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadUint16("value", 16)
		if _valueErr != nil {
			return nil, errors.Wrap(_valueErr, "Error parsing 'value' field")
		}
		_ = value // TODO: temporary till we fix TIME stuff in golang (see above in the template)
		readBuffer.CloseContext("KnxProperty")
		return values.NewPlcWORD(value), nil
	case propertyType == KnxPropertyDataType_PDT_ENUM8: // USINT
		// Simple Field (value)
		value, _valueErr := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadUint8("value", 8)
		if _valueErr != nil {
			return nil, errors.Wrap(_valueErr, "Error parsing 'value' field")
		}
		_ = value // TODO: temporary till we fix TIME stuff in golang (see above in the template)
		readBuffer.CloseContext("KnxProperty")
		return values.NewPlcUSINT(value), nil
	case propertyType == KnxPropertyDataType_PDT_SCALING: // USINT
		// Simple Field (value)
		value, _valueErr := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadUint8("value", 8)
		if _valueErr != nil {
			return nil, errors.Wrap(_valueErr, "Error parsing 'value' field")
		}
		_ = value // TODO: temporary till we fix TIME stuff in golang (see above in the template)
		readBuffer.CloseContext("KnxProperty")
		return values.NewPlcUSINT(value), nil
	default: // RawByteArray
		// Array Field (value)
		value, _valueErr := readBuffer.ReadByteArray("value", int(dataLengthInBytes))
		if _valueErr != nil {
			return nil, errors.Wrap(_valueErr, "Error parsing 'value' field")
		}
		_ = value // TODO: temporary till we fix TIME stuff in golang (see above in the template)
		readBuffer.CloseContext("KnxProperty")
		return values.NewPlcRawByteArray(value), nil
	}
	// TODO: add more info which type it is actually
	return nil, errors.New("unsupported type")
}

func KnxPropertySerialize(value api.PlcValue, propertyType KnxPropertyDataType, dataLengthInBytes uint8) ([]byte, error) {
	wb := utils.NewWriteBufferByteBased()
	if err := KnxPropertySerializeWithWriteBuffer(context.Background(), wb, value, propertyType, dataLengthInBytes); err != nil {
		return nil, err
	}
	return wb.GetBytes(), nil
}

type _KnxProperty struct {
	PropertyType      KnxPropertyDataType
	DataLengthInBytes uint8
}

func (m _KnxProperty) GetPropertyType() KnxPropertyDataType {
	return m.PropertyType
}

func (m _KnxProperty) GetDataLengthInBytes() uint8 {
	return m.DataLengthInBytes
}

func KnxPropertySerializeWithWriteBuffer(ctx context.Context, writeBuffer utils.WriteBuffer, value api.PlcValue, propertyType KnxPropertyDataType, dataLengthInBytes uint8) error {
	log := zerolog.Ctx(ctx)
	_ = log
	m := _KnxProperty{
		PropertyType:      propertyType,
		DataLengthInBytes: dataLengthInBytes,
	}
	_ = m
	writeBuffer.PushContext("KnxProperty")
	switch {
	case propertyType == KnxPropertyDataType_PDT_CONTROL: // BOOL
		// Reserved Field (Just skip the bytes)
		if _err := /*TODO: migrate me*/ writeBuffer.WriteUint8("reserved", 7, uint8(uint8(0x00))); _err != nil {
			return errors.Wrap(_err, "Error serializing reserved field")
		}

		// Simple Field (value)
		if _err := /*TODO: migrate me*/ writeBuffer.WriteBit("value", value.GetBool()); _err != nil {
			return errors.Wrap(_err, "Error serializing 'value' field")
		}
	case propertyType == KnxPropertyDataType_PDT_CHAR: // SINT
		// Simple Field (value)
		if _err := /*TODO: migrate me*/ writeBuffer.WriteInt8("value", 8, int8(value.GetInt8())); _err != nil {
			return errors.Wrap(_err, "Error serializing 'value' field")
		}
	case propertyType == KnxPropertyDataType_PDT_UNSIGNED_CHAR: // USINT
		// Simple Field (value)
		if _err := /*TODO: migrate me*/ writeBuffer.WriteUint8("value", 8, uint8(value.GetUint8())); _err != nil {
			return errors.Wrap(_err, "Error serializing 'value' field")
		}
	case propertyType == KnxPropertyDataType_PDT_INT: // INT
		// Simple Field (value)
		if _err := /*TODO: migrate me*/ writeBuffer.WriteInt16("value", 16, int16(value.GetInt16())); _err != nil {
			return errors.Wrap(_err, "Error serializing 'value' field")
		}
	case propertyType == KnxPropertyDataType_PDT_UNSIGNED_INT && dataLengthInBytes == uint8(4): // UDINT
		// Simple Field (value)
		if _err := /*TODO: migrate me*/ writeBuffer.WriteUint32("value", 32, uint32(value.GetUint32())); _err != nil {
			return errors.Wrap(_err, "Error serializing 'value' field")
		}
	case propertyType == KnxPropertyDataType_PDT_UNSIGNED_INT: // UINT
		// Simple Field (value)
		if _err := /*TODO: migrate me*/ writeBuffer.WriteUint16("value", 16, uint16(value.GetUint16())); _err != nil {
			return errors.Wrap(_err, "Error serializing 'value' field")
		}
	case propertyType == KnxPropertyDataType_PDT_KNX_FLOAT: // REAL
		// Simple Field (value)
		if _err := /*TODO: migrate me*/ writeBuffer.WriteFloat32("value", 16, value.GetFloat32()); _err != nil {
			return errors.Wrap(_err, "Error serializing 'value' field")
		}
	case propertyType == KnxPropertyDataType_PDT_DATE: // Struct
		// Reserved Field (Just skip the bytes)
		if _err := /*TODO: migrate me*/ writeBuffer.WriteUint8("reserved", 3, uint8(uint8(0x00))); _err != nil {
			return errors.Wrap(_err, "Error serializing reserved field")
		}

		// Simple Field (dayOfMonth)
		if _err := /*TODO: migrate me*/ writeBuffer.WriteUint8("dayOfMonth", 5, uint8(value.GetUint8())); _err != nil {
			return errors.Wrap(_err, "Error serializing 'dayOfMonth' field")
		}

		// Reserved Field (Just skip the bytes)
		if _err := /*TODO: migrate me*/ writeBuffer.WriteUint8("reserved", 4, uint8(uint8(0x00))); _err != nil {
			return errors.Wrap(_err, "Error serializing reserved field")
		}

		// Simple Field (month)
		if _err := /*TODO: migrate me*/ writeBuffer.WriteUint8("month", 4, uint8(value.GetUint8())); _err != nil {
			return errors.Wrap(_err, "Error serializing 'month' field")
		}

		// Reserved Field (Just skip the bytes)
		if _err := /*TODO: migrate me*/ writeBuffer.WriteUint8("reserved", 1, uint8(uint8(0x00))); _err != nil {
			return errors.Wrap(_err, "Error serializing reserved field")
		}

		// Simple Field (year)
		if _err := /*TODO: migrate me*/ writeBuffer.WriteUint8("year", 7, uint8(value.GetUint8())); _err != nil {
			return errors.Wrap(_err, "Error serializing 'year' field")
		}
	case propertyType == KnxPropertyDataType_PDT_TIME: // Struct
		// Simple Field (day)
		if _err := /*TODO: migrate me*/ writeBuffer.WriteUint8("day", 3, uint8(value.GetUint8())); _err != nil {
			return errors.Wrap(_err, "Error serializing 'day' field")
		}

		// Simple Field (hour)
		if _err := /*TODO: migrate me*/ writeBuffer.WriteUint8("hour", 5, uint8(value.GetUint8())); _err != nil {
			return errors.Wrap(_err, "Error serializing 'hour' field")
		}

		// Reserved Field (Just skip the bytes)
		if _err := /*TODO: migrate me*/ writeBuffer.WriteUint8("reserved", 2, uint8(uint8(0x00))); _err != nil {
			return errors.Wrap(_err, "Error serializing reserved field")
		}

		// Simple Field (minutes)
		if _err := /*TODO: migrate me*/ writeBuffer.WriteUint8("minutes", 6, uint8(value.GetUint8())); _err != nil {
			return errors.Wrap(_err, "Error serializing 'minutes' field")
		}

		// Reserved Field (Just skip the bytes)
		if _err := /*TODO: migrate me*/ writeBuffer.WriteUint8("reserved", 2, uint8(uint8(0x00))); _err != nil {
			return errors.Wrap(_err, "Error serializing reserved field")
		}

		// Simple Field (seconds)
		if _err := /*TODO: migrate me*/ writeBuffer.WriteUint8("seconds", 6, uint8(value.GetUint8())); _err != nil {
			return errors.Wrap(_err, "Error serializing 'seconds' field")
		}
	case propertyType == KnxPropertyDataType_PDT_LONG: // DINT
		// Simple Field (value)
		if _err := /*TODO: migrate me*/ writeBuffer.WriteInt32("value", 32, int32(value.GetInt32())); _err != nil {
			return errors.Wrap(_err, "Error serializing 'value' field")
		}
	case propertyType == KnxPropertyDataType_PDT_UNSIGNED_LONG: // UDINT
		// Simple Field (value)
		if _err := /*TODO: migrate me*/ writeBuffer.WriteUint32("value", 32, uint32(value.GetUint32())); _err != nil {
			return errors.Wrap(_err, "Error serializing 'value' field")
		}
	case propertyType == KnxPropertyDataType_PDT_FLOAT: // REAL
		// Simple Field (value)
		if _err := /*TODO: migrate me*/ writeBuffer.WriteFloat32("value", 32, value.GetFloat32()); _err != nil {
			return errors.Wrap(_err, "Error serializing 'value' field")
		}
	case propertyType == KnxPropertyDataType_PDT_DOUBLE: // LREAL
		// Simple Field (value)
		if _err := /*TODO: migrate me*/ writeBuffer.WriteFloat64("value", 64, value.GetFloat64()); _err != nil {
			return errors.Wrap(_err, "Error serializing 'value' field")
		}
	case propertyType == KnxPropertyDataType_PDT_CHAR_BLOCK: // RawByteArray
		// Array Field (value)
		for i := uint32(0); i < uint32((10)); i++ {
			_itemErr := /*TODO: migrate me*/ writeBuffer.WriteByte("", value.GetIndex(i).GetByte())
			if _itemErr != nil {
				return errors.Wrap(_itemErr, "Error serializing 'value' field")
			}
		}
	case propertyType == KnxPropertyDataType_PDT_POLL_GROUP_SETTINGS: // Struct
		// Array Field (groupAddress)
		for i := uint32(0); i < uint32((2)); i++ {
			groupAddress := value.GetValue("groupAddress")
			_itemErr := /*TODO: migrate me*/ writeBuffer.WriteByte("", groupAddress.GetIndex(i).GetByte())
			if _itemErr != nil {
				return errors.Wrap(_itemErr, "Error serializing 'value' field")
			}
		}

		// Simple Field (disable)
		if _err := /*TODO: migrate me*/ writeBuffer.WriteBit("disable", value.GetBool()); _err != nil {
			return errors.Wrap(_err, "Error serializing 'disable' field")
		}

		// Reserved Field (Just skip the bytes)
		if _err := /*TODO: migrate me*/ writeBuffer.WriteUint8("reserved", 3, uint8(uint8(0x0))); _err != nil {
			return errors.Wrap(_err, "Error serializing reserved field")
		}

		// Simple Field (pollingSoftNr)
		if _err := /*TODO: migrate me*/ writeBuffer.WriteUint8("pollingSoftNr", 4, uint8(value.GetUint8())); _err != nil {
			return errors.Wrap(_err, "Error serializing 'pollingSoftNr' field")
		}
	case propertyType == KnxPropertyDataType_PDT_SHORT_CHAR_BLOCK: // RawByteArray
		// Array Field (value)
		for i := uint32(0); i < uint32((5)); i++ {
			_itemErr := /*TODO: migrate me*/ writeBuffer.WriteByte("", value.GetIndex(i).GetByte())
			if _itemErr != nil {
				return errors.Wrap(_itemErr, "Error serializing 'value' field")
			}
		}
	case propertyType == KnxPropertyDataType_PDT_DATE_TIME: // Struct
		// Simple Field (year)
		if _err := /*TODO: migrate me*/ writeBuffer.WriteUint8("year", 8, uint8(value.GetUint8())); _err != nil {
			return errors.Wrap(_err, "Error serializing 'year' field")
		}

		// Reserved Field (Just skip the bytes)
		if _err := /*TODO: migrate me*/ writeBuffer.WriteUint8("reserved", 4, uint8(uint8(0x00))); _err != nil {
			return errors.Wrap(_err, "Error serializing reserved field")
		}

		// Simple Field (month)
		if _err := /*TODO: migrate me*/ writeBuffer.WriteUint8("month", 4, uint8(value.GetUint8())); _err != nil {
			return errors.Wrap(_err, "Error serializing 'month' field")
		}

		// Reserved Field (Just skip the bytes)
		if _err := /*TODO: migrate me*/ writeBuffer.WriteUint8("reserved", 3, uint8(uint8(0x00))); _err != nil {
			return errors.Wrap(_err, "Error serializing reserved field")
		}

		// Simple Field (dayOfMonth)
		if _err := /*TODO: migrate me*/ writeBuffer.WriteUint8("dayOfMonth", 5, uint8(value.GetUint8())); _err != nil {
			return errors.Wrap(_err, "Error serializing 'dayOfMonth' field")
		}

		// Simple Field (dayOfWeek)
		if _err := /*TODO: migrate me*/ writeBuffer.WriteUint8("dayOfWeek", 3, uint8(value.GetUint8())); _err != nil {
			return errors.Wrap(_err, "Error serializing 'dayOfWeek' field")
		}

		// Simple Field (hour)
		if _err := /*TODO: migrate me*/ writeBuffer.WriteUint8("hour", 5, uint8(value.GetUint8())); _err != nil {
			return errors.Wrap(_err, "Error serializing 'hour' field")
		}

		// Reserved Field (Just skip the bytes)
		if _err := /*TODO: migrate me*/ writeBuffer.WriteUint8("reserved", 2, uint8(uint8(0x00))); _err != nil {
			return errors.Wrap(_err, "Error serializing reserved field")
		}

		// Simple Field (minutes)
		if _err := /*TODO: migrate me*/ writeBuffer.WriteUint8("minutes", 6, uint8(value.GetUint8())); _err != nil {
			return errors.Wrap(_err, "Error serializing 'minutes' field")
		}

		// Reserved Field (Just skip the bytes)
		if _err := /*TODO: migrate me*/ writeBuffer.WriteUint8("reserved", 2, uint8(uint8(0x00))); _err != nil {
			return errors.Wrap(_err, "Error serializing reserved field")
		}

		// Simple Field (seconds)
		if _err := /*TODO: migrate me*/ writeBuffer.WriteUint8("seconds", 6, uint8(value.GetUint8())); _err != nil {
			return errors.Wrap(_err, "Error serializing 'seconds' field")
		}

		// Simple Field (fault)
		if _err := /*TODO: migrate me*/ writeBuffer.WriteBit("fault", value.GetBool()); _err != nil {
			return errors.Wrap(_err, "Error serializing 'fault' field")
		}

		// Simple Field (workingDay)
		if _err := /*TODO: migrate me*/ writeBuffer.WriteBit("workingDay", value.GetBool()); _err != nil {
			return errors.Wrap(_err, "Error serializing 'workingDay' field")
		}

		// Simple Field (noWd)
		if _err := /*TODO: migrate me*/ writeBuffer.WriteBit("noWd", value.GetBool()); _err != nil {
			return errors.Wrap(_err, "Error serializing 'noWd' field")
		}

		// Simple Field (noYear)
		if _err := /*TODO: migrate me*/ writeBuffer.WriteBit("noYear", value.GetBool()); _err != nil {
			return errors.Wrap(_err, "Error serializing 'noYear' field")
		}

		// Simple Field (noDate)
		if _err := /*TODO: migrate me*/ writeBuffer.WriteBit("noDate", value.GetBool()); _err != nil {
			return errors.Wrap(_err, "Error serializing 'noDate' field")
		}

		// Simple Field (noDayOfWeek)
		if _err := /*TODO: migrate me*/ writeBuffer.WriteBit("noDayOfWeek", value.GetBool()); _err != nil {
			return errors.Wrap(_err, "Error serializing 'noDayOfWeek' field")
		}

		// Simple Field (noTime)
		if _err := /*TODO: migrate me*/ writeBuffer.WriteBit("noTime", value.GetBool()); _err != nil {
			return errors.Wrap(_err, "Error serializing 'noTime' field")
		}

		// Simple Field (standardSummerTime)
		if _err := /*TODO: migrate me*/ writeBuffer.WriteBit("standardSummerTime", value.GetBool()); _err != nil {
			return errors.Wrap(_err, "Error serializing 'standardSummerTime' field")
		}

		// Simple Field (qualityOfClock)
		if _err := /*TODO: migrate me*/ writeBuffer.WriteBit("qualityOfClock", value.GetBool()); _err != nil {
			return errors.Wrap(_err, "Error serializing 'qualityOfClock' field")
		}

		// Reserved Field (Just skip the bytes)
		if _err := /*TODO: migrate me*/ writeBuffer.WriteUint8("reserved", 7, uint8(uint8(0x00))); _err != nil {
			return errors.Wrap(_err, "Error serializing reserved field")
		}
	case propertyType == KnxPropertyDataType_PDT_GENERIC_01: // RawByteArray
		// Array Field (value)
		for i := uint32(0); i < uint32((1)); i++ {
			_itemErr := /*TODO: migrate me*/ writeBuffer.WriteByte("", value.GetIndex(i).GetByte())
			if _itemErr != nil {
				return errors.Wrap(_itemErr, "Error serializing 'value' field")
			}
		}
	case propertyType == KnxPropertyDataType_PDT_GENERIC_02: // RawByteArray
		// Array Field (value)
		for i := uint32(0); i < uint32((2)); i++ {
			_itemErr := /*TODO: migrate me*/ writeBuffer.WriteByte("", value.GetIndex(i).GetByte())
			if _itemErr != nil {
				return errors.Wrap(_itemErr, "Error serializing 'value' field")
			}
		}
	case propertyType == KnxPropertyDataType_PDT_GENERIC_03: // RawByteArray
		// Array Field (value)
		for i := uint32(0); i < uint32((3)); i++ {
			_itemErr := /*TODO: migrate me*/ writeBuffer.WriteByte("", value.GetIndex(i).GetByte())
			if _itemErr != nil {
				return errors.Wrap(_itemErr, "Error serializing 'value' field")
			}
		}
	case propertyType == KnxPropertyDataType_PDT_GENERIC_04: // RawByteArray
		// Array Field (value)
		for i := uint32(0); i < uint32((4)); i++ {
			_itemErr := /*TODO: migrate me*/ writeBuffer.WriteByte("", value.GetIndex(i).GetByte())
			if _itemErr != nil {
				return errors.Wrap(_itemErr, "Error serializing 'value' field")
			}
		}
	case propertyType == KnxPropertyDataType_PDT_GENERIC_05: // RawByteArray
		// Array Field (value)
		for i := uint32(0); i < uint32((5)); i++ {
			_itemErr := /*TODO: migrate me*/ writeBuffer.WriteByte("", value.GetIndex(i).GetByte())
			if _itemErr != nil {
				return errors.Wrap(_itemErr, "Error serializing 'value' field")
			}
		}
	case propertyType == KnxPropertyDataType_PDT_GENERIC_06: // RawByteArray
		// Array Field (value)
		for i := uint32(0); i < uint32((6)); i++ {
			_itemErr := /*TODO: migrate me*/ writeBuffer.WriteByte("", value.GetIndex(i).GetByte())
			if _itemErr != nil {
				return errors.Wrap(_itemErr, "Error serializing 'value' field")
			}
		}
	case propertyType == KnxPropertyDataType_PDT_GENERIC_07: // RawByteArray
		// Array Field (value)
		for i := uint32(0); i < uint32((7)); i++ {
			_itemErr := /*TODO: migrate me*/ writeBuffer.WriteByte("", value.GetIndex(i).GetByte())
			if _itemErr != nil {
				return errors.Wrap(_itemErr, "Error serializing 'value' field")
			}
		}
	case propertyType == KnxPropertyDataType_PDT_GENERIC_08: // RawByteArray
		// Array Field (value)
		for i := uint32(0); i < uint32((8)); i++ {
			_itemErr := /*TODO: migrate me*/ writeBuffer.WriteByte("", value.GetIndex(i).GetByte())
			if _itemErr != nil {
				return errors.Wrap(_itemErr, "Error serializing 'value' field")
			}
		}
	case propertyType == KnxPropertyDataType_PDT_GENERIC_09: // RawByteArray
		// Array Field (value)
		for i := uint32(0); i < uint32((9)); i++ {
			_itemErr := /*TODO: migrate me*/ writeBuffer.WriteByte("", value.GetIndex(i).GetByte())
			if _itemErr != nil {
				return errors.Wrap(_itemErr, "Error serializing 'value' field")
			}
		}
	case propertyType == KnxPropertyDataType_PDT_GENERIC_10: // RawByteArray
		// Array Field (value)
		for i := uint32(0); i < uint32((10)); i++ {
			_itemErr := /*TODO: migrate me*/ writeBuffer.WriteByte("", value.GetIndex(i).GetByte())
			if _itemErr != nil {
				return errors.Wrap(_itemErr, "Error serializing 'value' field")
			}
		}
	case propertyType == KnxPropertyDataType_PDT_GENERIC_11: // RawByteArray
		// Array Field (value)
		for i := uint32(0); i < uint32((11)); i++ {
			_itemErr := /*TODO: migrate me*/ writeBuffer.WriteByte("", value.GetIndex(i).GetByte())
			if _itemErr != nil {
				return errors.Wrap(_itemErr, "Error serializing 'value' field")
			}
		}
	case propertyType == KnxPropertyDataType_PDT_GENERIC_12: // RawByteArray
		// Array Field (value)
		for i := uint32(0); i < uint32((12)); i++ {
			_itemErr := /*TODO: migrate me*/ writeBuffer.WriteByte("", value.GetIndex(i).GetByte())
			if _itemErr != nil {
				return errors.Wrap(_itemErr, "Error serializing 'value' field")
			}
		}
	case propertyType == KnxPropertyDataType_PDT_GENERIC_13: // RawByteArray
		// Array Field (value)
		for i := uint32(0); i < uint32((13)); i++ {
			_itemErr := /*TODO: migrate me*/ writeBuffer.WriteByte("", value.GetIndex(i).GetByte())
			if _itemErr != nil {
				return errors.Wrap(_itemErr, "Error serializing 'value' field")
			}
		}
	case propertyType == KnxPropertyDataType_PDT_GENERIC_14: // RawByteArray
		// Array Field (value)
		for i := uint32(0); i < uint32((14)); i++ {
			_itemErr := /*TODO: migrate me*/ writeBuffer.WriteByte("", value.GetIndex(i).GetByte())
			if _itemErr != nil {
				return errors.Wrap(_itemErr, "Error serializing 'value' field")
			}
		}
	case propertyType == KnxPropertyDataType_PDT_GENERIC_15: // RawByteArray
		// Array Field (value)
		for i := uint32(0); i < uint32((15)); i++ {
			_itemErr := /*TODO: migrate me*/ writeBuffer.WriteByte("", value.GetIndex(i).GetByte())
			if _itemErr != nil {
				return errors.Wrap(_itemErr, "Error serializing 'value' field")
			}
		}
	case propertyType == KnxPropertyDataType_PDT_GENERIC_16: // RawByteArray
		// Array Field (value)
		for i := uint32(0); i < uint32((16)); i++ {
			_itemErr := /*TODO: migrate me*/ writeBuffer.WriteByte("", value.GetIndex(i).GetByte())
			if _itemErr != nil {
				return errors.Wrap(_itemErr, "Error serializing 'value' field")
			}
		}
	case propertyType == KnxPropertyDataType_PDT_GENERIC_17: // RawByteArray
		// Array Field (value)
		for i := uint32(0); i < uint32((17)); i++ {
			_itemErr := /*TODO: migrate me*/ writeBuffer.WriteByte("", value.GetIndex(i).GetByte())
			if _itemErr != nil {
				return errors.Wrap(_itemErr, "Error serializing 'value' field")
			}
		}
	case propertyType == KnxPropertyDataType_PDT_GENERIC_18: // RawByteArray
		// Array Field (value)
		for i := uint32(0); i < uint32((18)); i++ {
			_itemErr := /*TODO: migrate me*/ writeBuffer.WriteByte("", value.GetIndex(i).GetByte())
			if _itemErr != nil {
				return errors.Wrap(_itemErr, "Error serializing 'value' field")
			}
		}
	case propertyType == KnxPropertyDataType_PDT_GENERIC_19: // RawByteArray
		// Array Field (value)
		for i := uint32(0); i < uint32((19)); i++ {
			_itemErr := /*TODO: migrate me*/ writeBuffer.WriteByte("", value.GetIndex(i).GetByte())
			if _itemErr != nil {
				return errors.Wrap(_itemErr, "Error serializing 'value' field")
			}
		}
	case propertyType == KnxPropertyDataType_PDT_GENERIC_20: // RawByteArray
		// Array Field (value)
		for i := uint32(0); i < uint32((20)); i++ {
			_itemErr := /*TODO: migrate me*/ writeBuffer.WriteByte("", value.GetIndex(i).GetByte())
			if _itemErr != nil {
				return errors.Wrap(_itemErr, "Error serializing 'value' field")
			}
		}
	case propertyType == KnxPropertyDataType_PDT_VERSION: // Struct
		// Simple Field (magicNumber)
		if _err := /*TODO: migrate me*/ writeBuffer.WriteUint8("magicNumber", 5, uint8(value.GetUint8())); _err != nil {
			return errors.Wrap(_err, "Error serializing 'magicNumber' field")
		}

		// Simple Field (versionNumber)
		if _err := /*TODO: migrate me*/ writeBuffer.WriteUint8("versionNumber", 5, uint8(value.GetUint8())); _err != nil {
			return errors.Wrap(_err, "Error serializing 'versionNumber' field")
		}

		// Simple Field (revisionNumber)
		if _err := /*TODO: migrate me*/ writeBuffer.WriteUint8("revisionNumber", 6, uint8(value.GetUint8())); _err != nil {
			return errors.Wrap(_err, "Error serializing 'revisionNumber' field")
		}
	case propertyType == KnxPropertyDataType_PDT_ALARM_INFO: // Struct
		// Simple Field (logNumber)
		if _err := /*TODO: migrate me*/ writeBuffer.WriteUint8("logNumber", 8, uint8(value.GetUint8())); _err != nil {
			return errors.Wrap(_err, "Error serializing 'logNumber' field")
		}

		// Simple Field (alarmPriority)
		if _err := /*TODO: migrate me*/ writeBuffer.WriteUint8("alarmPriority", 8, uint8(value.GetUint8())); _err != nil {
			return errors.Wrap(_err, "Error serializing 'alarmPriority' field")
		}

		// Simple Field (applicationArea)
		if _err := /*TODO: migrate me*/ writeBuffer.WriteUint8("applicationArea", 8, uint8(value.GetUint8())); _err != nil {
			return errors.Wrap(_err, "Error serializing 'applicationArea' field")
		}

		// Simple Field (errorClass)
		if _err := /*TODO: migrate me*/ writeBuffer.WriteUint8("errorClass", 8, uint8(value.GetUint8())); _err != nil {
			return errors.Wrap(_err, "Error serializing 'errorClass' field")
		}

		// Reserved Field (Just skip the bytes)
		if _err := /*TODO: migrate me*/ writeBuffer.WriteUint8("reserved", 4, uint8(uint8(0x00))); _err != nil {
			return errors.Wrap(_err, "Error serializing reserved field")
		}

		// Simple Field (errorcodeSup)
		if _err := /*TODO: migrate me*/ writeBuffer.WriteBit("errorcodeSup", value.GetBool()); _err != nil {
			return errors.Wrap(_err, "Error serializing 'errorcodeSup' field")
		}

		// Simple Field (alarmtextSup)
		if _err := /*TODO: migrate me*/ writeBuffer.WriteBit("alarmtextSup", value.GetBool()); _err != nil {
			return errors.Wrap(_err, "Error serializing 'alarmtextSup' field")
		}

		// Simple Field (timestampSup)
		if _err := /*TODO: migrate me*/ writeBuffer.WriteBit("timestampSup", value.GetBool()); _err != nil {
			return errors.Wrap(_err, "Error serializing 'timestampSup' field")
		}

		// Simple Field (ackSup)
		if _err := /*TODO: migrate me*/ writeBuffer.WriteBit("ackSup", value.GetBool()); _err != nil {
			return errors.Wrap(_err, "Error serializing 'ackSup' field")
		}

		// Reserved Field (Just skip the bytes)
		if _err := /*TODO: migrate me*/ writeBuffer.WriteUint8("reserved", 5, uint8(uint8(0x00))); _err != nil {
			return errors.Wrap(_err, "Error serializing reserved field")
		}

		// Simple Field (locked)
		if _err := /*TODO: migrate me*/ writeBuffer.WriteBit("locked", value.GetBool()); _err != nil {
			return errors.Wrap(_err, "Error serializing 'locked' field")
		}

		// Simple Field (alarmunack)
		if _err := /*TODO: migrate me*/ writeBuffer.WriteBit("alarmunack", value.GetBool()); _err != nil {
			return errors.Wrap(_err, "Error serializing 'alarmunack' field")
		}

		// Simple Field (inalarm)
		if _err := /*TODO: migrate me*/ writeBuffer.WriteBit("inalarm", value.GetBool()); _err != nil {
			return errors.Wrap(_err, "Error serializing 'inalarm' field")
		}
	case propertyType == KnxPropertyDataType_PDT_BINARY_INFORMATION: // BOOL
		// Reserved Field (Just skip the bytes)
		if _err := /*TODO: migrate me*/ writeBuffer.WriteUint8("reserved", 7, uint8(uint8(0x00))); _err != nil {
			return errors.Wrap(_err, "Error serializing reserved field")
		}

		// Simple Field (value)
		if _err := /*TODO: migrate me*/ writeBuffer.WriteBit("value", value.GetBool()); _err != nil {
			return errors.Wrap(_err, "Error serializing 'value' field")
		}
	case propertyType == KnxPropertyDataType_PDT_BITSET8: // BYTE
		// Simple Field (value)
		if _err := /*TODO: migrate me*/ writeBuffer.WriteUint8("value", 8, uint8(value.GetUint8())); _err != nil {
			return errors.Wrap(_err, "Error serializing 'value' field")
		}
	case propertyType == KnxPropertyDataType_PDT_BITSET16: // WORD
		// Simple Field (value)
		if _err := /*TODO: migrate me*/ writeBuffer.WriteUint16("value", 16, uint16(value.GetUint16())); _err != nil {
			return errors.Wrap(_err, "Error serializing 'value' field")
		}
	case propertyType == KnxPropertyDataType_PDT_ENUM8: // USINT
		// Simple Field (value)
		if _err := /*TODO: migrate me*/ writeBuffer.WriteUint8("value", 8, uint8(value.GetUint8())); _err != nil {
			return errors.Wrap(_err, "Error serializing 'value' field")
		}
	case propertyType == KnxPropertyDataType_PDT_SCALING: // USINT
		// Simple Field (value)
		if _err := /*TODO: migrate me*/ writeBuffer.WriteUint8("value", 8, uint8(value.GetUint8())); _err != nil {
			return errors.Wrap(_err, "Error serializing 'value' field")
		}
	default: // RawByteArray
		// Array Field (value)
		for i := uint32(0); i < uint32(m.GetDataLengthInBytes()); i++ {
			_itemErr := /*TODO: migrate me*/ writeBuffer.WriteByte("", value.GetIndex(i).GetByte())
			if _itemErr != nil {
				return errors.Wrap(_itemErr, "Error serializing 'value' field")
			}
		}
	}
	writeBuffer.PopContext("KnxProperty")
	return nil
}
