/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

package model

import (
	"context"
	stdErrors "errors"
	"fmt"

	"github.com/pkg/errors"
	"github.com/rs/zerolog"

	"github.com/apache/plc4x/plc4go/spi/utils"
)

// Code generated by code-generation. DO NOT EDIT.

// ApduDataExtLinkResponse is the corresponding interface of ApduDataExtLinkResponse
type ApduDataExtLinkResponse interface {
	fmt.Stringer
	utils.LengthAware
	utils.Serializable
	utils.Copyable
	ApduDataExt
	// IsApduDataExtLinkResponse is a marker method to prevent unintentional type checks (interfaces of same signature)
	IsApduDataExtLinkResponse()
	// CreateBuilder creates a ApduDataExtLinkResponseBuilder
	CreateApduDataExtLinkResponseBuilder() ApduDataExtLinkResponseBuilder
}

// _ApduDataExtLinkResponse is the data-structure of this message
type _ApduDataExtLinkResponse struct {
	ApduDataExtContract
}

var _ ApduDataExtLinkResponse = (*_ApduDataExtLinkResponse)(nil)
var _ ApduDataExtRequirements = (*_ApduDataExtLinkResponse)(nil)

// NewApduDataExtLinkResponse factory function for _ApduDataExtLinkResponse
func NewApduDataExtLinkResponse(length uint8) *_ApduDataExtLinkResponse {
	_result := &_ApduDataExtLinkResponse{
		ApduDataExtContract: NewApduDataExt(length),
	}
	_result.ApduDataExtContract.(*_ApduDataExt)._SubType = _result
	return _result
}

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Builder
///////////////////////

// ApduDataExtLinkResponseBuilder is a builder for ApduDataExtLinkResponse
type ApduDataExtLinkResponseBuilder interface {
	utils.Copyable
	// WithMandatoryFields adds all mandatory fields (convenience for using multiple builder calls)
	WithMandatoryFields() ApduDataExtLinkResponseBuilder
	// Done is used to finish work on this child and return (or create one if none) to the parent builder
	Done() ApduDataExtBuilder
	// Build builds the ApduDataExtLinkResponse or returns an error if something is wrong
	Build() (ApduDataExtLinkResponse, error)
	// MustBuild does the same as Build but panics on error
	MustBuild() ApduDataExtLinkResponse
}

// NewApduDataExtLinkResponseBuilder() creates a ApduDataExtLinkResponseBuilder
func NewApduDataExtLinkResponseBuilder() ApduDataExtLinkResponseBuilder {
	return &_ApduDataExtLinkResponseBuilder{_ApduDataExtLinkResponse: new(_ApduDataExtLinkResponse)}
}

type _ApduDataExtLinkResponseBuilder struct {
	*_ApduDataExtLinkResponse

	parentBuilder *_ApduDataExtBuilder

	collectedErr []error
}

var _ (ApduDataExtLinkResponseBuilder) = (*_ApduDataExtLinkResponseBuilder)(nil)

func (b *_ApduDataExtLinkResponseBuilder) setParent(contract ApduDataExtContract) {
	b.ApduDataExtContract = contract
	contract.(*_ApduDataExt)._SubType = b._ApduDataExtLinkResponse
}

func (b *_ApduDataExtLinkResponseBuilder) WithMandatoryFields() ApduDataExtLinkResponseBuilder {
	return b
}

func (b *_ApduDataExtLinkResponseBuilder) Build() (ApduDataExtLinkResponse, error) {
	if err := stdErrors.Join(b.collectedErr...); err != nil {
		return nil, errors.Wrap(err, "error occurred during build")
	}
	return b._ApduDataExtLinkResponse.deepCopy(), nil
}

func (b *_ApduDataExtLinkResponseBuilder) MustBuild() ApduDataExtLinkResponse {
	build, err := b.Build()
	if err != nil {
		panic(err)
	}
	return build
}

func (b *_ApduDataExtLinkResponseBuilder) Done() ApduDataExtBuilder {
	if b.parentBuilder == nil {
		b.parentBuilder = NewApduDataExtBuilder().(*_ApduDataExtBuilder)
	}
	return b.parentBuilder
}

func (b *_ApduDataExtLinkResponseBuilder) buildForApduDataExt() (ApduDataExt, error) {
	return b.Build()
}

func (b *_ApduDataExtLinkResponseBuilder) DeepCopy() any {
	_copy := b.CreateApduDataExtLinkResponseBuilder().(*_ApduDataExtLinkResponseBuilder)
	if b.collectedErr != nil {
		copy(_copy.collectedErr, b.collectedErr)
	}
	return _copy
}

// CreateApduDataExtLinkResponseBuilder creates a ApduDataExtLinkResponseBuilder
func (b *_ApduDataExtLinkResponse) CreateApduDataExtLinkResponseBuilder() ApduDataExtLinkResponseBuilder {
	if b == nil {
		return NewApduDataExtLinkResponseBuilder()
	}
	return &_ApduDataExtLinkResponseBuilder{_ApduDataExtLinkResponse: b.deepCopy()}
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for discriminator values.
///////////////////////

func (m *_ApduDataExtLinkResponse) GetExtApciType() uint8 {
	return 0x26
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

func (m *_ApduDataExtLinkResponse) GetParent() ApduDataExtContract {
	return m.ApduDataExtContract
}

// Deprecated: use the interface for direct cast
func CastApduDataExtLinkResponse(structType any) ApduDataExtLinkResponse {
	if casted, ok := structType.(ApduDataExtLinkResponse); ok {
		return casted
	}
	if casted, ok := structType.(*ApduDataExtLinkResponse); ok {
		return *casted
	}
	return nil
}

func (m *_ApduDataExtLinkResponse) GetTypeName() string {
	return "ApduDataExtLinkResponse"
}

func (m *_ApduDataExtLinkResponse) GetLengthInBits(ctx context.Context) uint16 {
	lengthInBits := uint16(m.ApduDataExtContract.(*_ApduDataExt).getLengthInBits(ctx))

	return lengthInBits
}

func (m *_ApduDataExtLinkResponse) GetLengthInBytes(ctx context.Context) uint16 {
	return m.GetLengthInBits(ctx) / 8
}

func (m *_ApduDataExtLinkResponse) parse(ctx context.Context, readBuffer utils.ReadBuffer, parent *_ApduDataExt, length uint8) (__apduDataExtLinkResponse ApduDataExtLinkResponse, err error) {
	m.ApduDataExtContract = parent
	parent._SubType = m
	positionAware := readBuffer
	_ = positionAware
	if pullErr := readBuffer.PullContext("ApduDataExtLinkResponse"); pullErr != nil {
		return nil, errors.Wrap(pullErr, "Error pulling for ApduDataExtLinkResponse")
	}
	currentPos := positionAware.GetPos()
	_ = currentPos

	if closeErr := readBuffer.CloseContext("ApduDataExtLinkResponse"); closeErr != nil {
		return nil, errors.Wrap(closeErr, "Error closing for ApduDataExtLinkResponse")
	}

	return m, nil
}

func (m *_ApduDataExtLinkResponse) Serialize() ([]byte, error) {
	wb := utils.NewWriteBufferByteBased(utils.WithInitialSizeForByteBasedBuffer(int(m.GetLengthInBytes(context.Background()))))
	if err := m.SerializeWithWriteBuffer(context.Background(), wb); err != nil {
		return nil, err
	}
	return wb.GetBytes(), nil
}

func (m *_ApduDataExtLinkResponse) SerializeWithWriteBuffer(ctx context.Context, writeBuffer utils.WriteBuffer) error {
	positionAware := writeBuffer
	_ = positionAware
	log := zerolog.Ctx(ctx)
	_ = log
	ser := func() error {
		if pushErr := writeBuffer.PushContext("ApduDataExtLinkResponse"); pushErr != nil {
			return errors.Wrap(pushErr, "Error pushing for ApduDataExtLinkResponse")
		}

		if popErr := writeBuffer.PopContext("ApduDataExtLinkResponse"); popErr != nil {
			return errors.Wrap(popErr, "Error popping for ApduDataExtLinkResponse")
		}
		return nil
	}
	return m.ApduDataExtContract.(*_ApduDataExt).serializeParent(ctx, writeBuffer, m, ser)
}

func (m *_ApduDataExtLinkResponse) IsApduDataExtLinkResponse() {}

func (m *_ApduDataExtLinkResponse) DeepCopy() any {
	return m.deepCopy()
}

func (m *_ApduDataExtLinkResponse) deepCopy() *_ApduDataExtLinkResponse {
	if m == nil {
		return nil
	}
	_ApduDataExtLinkResponseCopy := &_ApduDataExtLinkResponse{
		m.ApduDataExtContract.(*_ApduDataExt).deepCopy(),
	}
	_ApduDataExtLinkResponseCopy.ApduDataExtContract.(*_ApduDataExt)._SubType = m
	return _ApduDataExtLinkResponseCopy
}

func (m *_ApduDataExtLinkResponse) String() string {
	if m == nil {
		return "<nil>"
	}
	wb := utils.NewWriteBufferBoxBased(
		utils.WithWriteBufferBoxBasedMergeSingleBoxes(),
		utils.WithWriteBufferBoxBasedOmitEmptyBoxes(),
		utils.WithWriteBufferBoxBasedPrintPosLengthFooter(),
	)
	if err := wb.WriteSerializable(context.Background(), m); err != nil {
		return err.Error()
	}
	return wb.GetBox().String()
}
