/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

package model

import (
	"context"
	stdErrors "errors"
	"fmt"

	"github.com/pkg/errors"
	"github.com/rs/zerolog"

	"github.com/apache/plc4x/plc4go/spi/utils"
)

// Code generated by code-generation. DO NOT EDIT.

// SetAttributeAllRequest is the corresponding interface of SetAttributeAllRequest
type SetAttributeAllRequest interface {
	fmt.Stringer
	utils.LengthAware
	utils.Serializable
	utils.Copyable
	CipService
	// IsSetAttributeAllRequest is a marker method to prevent unintentional type checks (interfaces of same signature)
	IsSetAttributeAllRequest()
	// CreateBuilder creates a SetAttributeAllRequestBuilder
	CreateSetAttributeAllRequestBuilder() SetAttributeAllRequestBuilder
}

// _SetAttributeAllRequest is the data-structure of this message
type _SetAttributeAllRequest struct {
	CipServiceContract
}

var _ SetAttributeAllRequest = (*_SetAttributeAllRequest)(nil)
var _ CipServiceRequirements = (*_SetAttributeAllRequest)(nil)

// NewSetAttributeAllRequest factory function for _SetAttributeAllRequest
func NewSetAttributeAllRequest(serviceLen uint16) *_SetAttributeAllRequest {
	_result := &_SetAttributeAllRequest{
		CipServiceContract: NewCipService(serviceLen),
	}
	_result.CipServiceContract.(*_CipService)._SubType = _result
	return _result
}

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Builder
///////////////////////

// SetAttributeAllRequestBuilder is a builder for SetAttributeAllRequest
type SetAttributeAllRequestBuilder interface {
	utils.Copyable
	// WithMandatoryFields adds all mandatory fields (convenience for using multiple builder calls)
	WithMandatoryFields() SetAttributeAllRequestBuilder
	// Done is used to finish work on this child and return (or create one if none) to the parent builder
	Done() CipServiceBuilder
	// Build builds the SetAttributeAllRequest or returns an error if something is wrong
	Build() (SetAttributeAllRequest, error)
	// MustBuild does the same as Build but panics on error
	MustBuild() SetAttributeAllRequest
}

// NewSetAttributeAllRequestBuilder() creates a SetAttributeAllRequestBuilder
func NewSetAttributeAllRequestBuilder() SetAttributeAllRequestBuilder {
	return &_SetAttributeAllRequestBuilder{_SetAttributeAllRequest: new(_SetAttributeAllRequest)}
}

type _SetAttributeAllRequestBuilder struct {
	*_SetAttributeAllRequest

	parentBuilder *_CipServiceBuilder

	collectedErr []error
}

var _ (SetAttributeAllRequestBuilder) = (*_SetAttributeAllRequestBuilder)(nil)

func (b *_SetAttributeAllRequestBuilder) setParent(contract CipServiceContract) {
	b.CipServiceContract = contract
	contract.(*_CipService)._SubType = b._SetAttributeAllRequest
}

func (b *_SetAttributeAllRequestBuilder) WithMandatoryFields() SetAttributeAllRequestBuilder {
	return b
}

func (b *_SetAttributeAllRequestBuilder) Build() (SetAttributeAllRequest, error) {
	if err := stdErrors.Join(b.collectedErr...); err != nil {
		return nil, errors.Wrap(err, "error occurred during build")
	}
	return b._SetAttributeAllRequest.deepCopy(), nil
}

func (b *_SetAttributeAllRequestBuilder) MustBuild() SetAttributeAllRequest {
	build, err := b.Build()
	if err != nil {
		panic(err)
	}
	return build
}

func (b *_SetAttributeAllRequestBuilder) Done() CipServiceBuilder {
	if b.parentBuilder == nil {
		b.parentBuilder = NewCipServiceBuilder().(*_CipServiceBuilder)
	}
	return b.parentBuilder
}

func (b *_SetAttributeAllRequestBuilder) buildForCipService() (CipService, error) {
	return b.Build()
}

func (b *_SetAttributeAllRequestBuilder) DeepCopy() any {
	_copy := b.CreateSetAttributeAllRequestBuilder().(*_SetAttributeAllRequestBuilder)
	if b.collectedErr != nil {
		copy(_copy.collectedErr, b.collectedErr)
	}
	return _copy
}

// CreateSetAttributeAllRequestBuilder creates a SetAttributeAllRequestBuilder
func (b *_SetAttributeAllRequest) CreateSetAttributeAllRequestBuilder() SetAttributeAllRequestBuilder {
	if b == nil {
		return NewSetAttributeAllRequestBuilder()
	}
	return &_SetAttributeAllRequestBuilder{_SetAttributeAllRequest: b.deepCopy()}
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for discriminator values.
///////////////////////

func (m *_SetAttributeAllRequest) GetService() uint8 {
	return 0x02
}

func (m *_SetAttributeAllRequest) GetResponse() bool {
	return bool(false)
}

func (m *_SetAttributeAllRequest) GetConnected() bool {
	return false
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

func (m *_SetAttributeAllRequest) GetParent() CipServiceContract {
	return m.CipServiceContract
}

// Deprecated: use the interface for direct cast
func CastSetAttributeAllRequest(structType any) SetAttributeAllRequest {
	if casted, ok := structType.(SetAttributeAllRequest); ok {
		return casted
	}
	if casted, ok := structType.(*SetAttributeAllRequest); ok {
		return *casted
	}
	return nil
}

func (m *_SetAttributeAllRequest) GetTypeName() string {
	return "SetAttributeAllRequest"
}

func (m *_SetAttributeAllRequest) GetLengthInBits(ctx context.Context) uint16 {
	lengthInBits := uint16(m.CipServiceContract.(*_CipService).getLengthInBits(ctx))

	return lengthInBits
}

func (m *_SetAttributeAllRequest) GetLengthInBytes(ctx context.Context) uint16 {
	return m.GetLengthInBits(ctx) / 8
}

func (m *_SetAttributeAllRequest) parse(ctx context.Context, readBuffer utils.ReadBuffer, parent *_CipService, connected bool, serviceLen uint16) (__setAttributeAllRequest SetAttributeAllRequest, err error) {
	m.CipServiceContract = parent
	parent._SubType = m
	positionAware := readBuffer
	_ = positionAware
	if pullErr := readBuffer.PullContext("SetAttributeAllRequest"); pullErr != nil {
		return nil, errors.Wrap(pullErr, "Error pulling for SetAttributeAllRequest")
	}
	currentPos := positionAware.GetPos()
	_ = currentPos

	if closeErr := readBuffer.CloseContext("SetAttributeAllRequest"); closeErr != nil {
		return nil, errors.Wrap(closeErr, "Error closing for SetAttributeAllRequest")
	}

	return m, nil
}

func (m *_SetAttributeAllRequest) Serialize() ([]byte, error) {
	wb := utils.NewWriteBufferByteBased(utils.WithInitialSizeForByteBasedBuffer(int(m.GetLengthInBytes(context.Background()))))
	if err := m.SerializeWithWriteBuffer(context.Background(), wb); err != nil {
		return nil, err
	}
	return wb.GetBytes(), nil
}

func (m *_SetAttributeAllRequest) SerializeWithWriteBuffer(ctx context.Context, writeBuffer utils.WriteBuffer) error {
	positionAware := writeBuffer
	_ = positionAware
	log := zerolog.Ctx(ctx)
	_ = log
	ser := func() error {
		if pushErr := writeBuffer.PushContext("SetAttributeAllRequest"); pushErr != nil {
			return errors.Wrap(pushErr, "Error pushing for SetAttributeAllRequest")
		}

		if popErr := writeBuffer.PopContext("SetAttributeAllRequest"); popErr != nil {
			return errors.Wrap(popErr, "Error popping for SetAttributeAllRequest")
		}
		return nil
	}
	return m.CipServiceContract.(*_CipService).serializeParent(ctx, writeBuffer, m, ser)
}

func (m *_SetAttributeAllRequest) IsSetAttributeAllRequest() {}

func (m *_SetAttributeAllRequest) DeepCopy() any {
	return m.deepCopy()
}

func (m *_SetAttributeAllRequest) deepCopy() *_SetAttributeAllRequest {
	if m == nil {
		return nil
	}
	_SetAttributeAllRequestCopy := &_SetAttributeAllRequest{
		m.CipServiceContract.(*_CipService).deepCopy(),
	}
	_SetAttributeAllRequestCopy.CipServiceContract.(*_CipService)._SubType = m
	return _SetAttributeAllRequestCopy
}

func (m *_SetAttributeAllRequest) String() string {
	if m == nil {
		return "<nil>"
	}
	wb := utils.NewWriteBufferBoxBased(
		utils.WithWriteBufferBoxBasedMergeSingleBoxes(),
		utils.WithWriteBufferBoxBasedOmitEmptyBoxes(),
		utils.WithWriteBufferBoxBasedPrintPosLengthFooter(),
	)
	if err := wb.WriteSerializable(context.Background(), m); err != nil {
		return err.Error()
	}
	return wb.GetBox().String()
}
