/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

package model

import (
	"context"
	stdErrors "errors"
	"fmt"

	"github.com/pkg/errors"
	"github.com/rs/zerolog"

	. "github.com/apache/plc4x/plc4go/spi/codegen/fields"
	. "github.com/apache/plc4x/plc4go/spi/codegen/io"
	"github.com/apache/plc4x/plc4go/spi/utils"
)

// Code generated by code-generation. DO NOT EDIT.

// CALDataIdentifyReply is the corresponding interface of CALDataIdentifyReply
type CALDataIdentifyReply interface {
	fmt.Stringer
	utils.LengthAware
	utils.Serializable
	utils.Copyable
	CALData
	// GetAttribute returns Attribute (property field)
	GetAttribute() Attribute
	// GetIdentifyReplyCommand returns IdentifyReplyCommand (property field)
	GetIdentifyReplyCommand() IdentifyReplyCommand
	// IsCALDataIdentifyReply is a marker method to prevent unintentional type checks (interfaces of same signature)
	IsCALDataIdentifyReply()
	// CreateBuilder creates a CALDataIdentifyReplyBuilder
	CreateCALDataIdentifyReplyBuilder() CALDataIdentifyReplyBuilder
}

// _CALDataIdentifyReply is the data-structure of this message
type _CALDataIdentifyReply struct {
	CALDataContract
	Attribute            Attribute
	IdentifyReplyCommand IdentifyReplyCommand
}

var _ CALDataIdentifyReply = (*_CALDataIdentifyReply)(nil)
var _ CALDataRequirements = (*_CALDataIdentifyReply)(nil)

// NewCALDataIdentifyReply factory function for _CALDataIdentifyReply
func NewCALDataIdentifyReply(commandTypeContainer CALCommandTypeContainer, additionalData CALData, attribute Attribute, identifyReplyCommand IdentifyReplyCommand, requestContext RequestContext) *_CALDataIdentifyReply {
	if identifyReplyCommand == nil {
		panic("identifyReplyCommand of type IdentifyReplyCommand for CALDataIdentifyReply must not be nil")
	}
	_result := &_CALDataIdentifyReply{
		CALDataContract:      NewCALData(commandTypeContainer, additionalData, requestContext),
		Attribute:            attribute,
		IdentifyReplyCommand: identifyReplyCommand,
	}
	_result.CALDataContract.(*_CALData)._SubType = _result
	return _result
}

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Builder
///////////////////////

// CALDataIdentifyReplyBuilder is a builder for CALDataIdentifyReply
type CALDataIdentifyReplyBuilder interface {
	utils.Copyable
	// WithMandatoryFields adds all mandatory fields (convenience for using multiple builder calls)
	WithMandatoryFields(attribute Attribute, identifyReplyCommand IdentifyReplyCommand) CALDataIdentifyReplyBuilder
	// WithAttribute adds Attribute (property field)
	WithAttribute(Attribute) CALDataIdentifyReplyBuilder
	// WithIdentifyReplyCommand adds IdentifyReplyCommand (property field)
	WithIdentifyReplyCommand(IdentifyReplyCommand) CALDataIdentifyReplyBuilder
	// WithIdentifyReplyCommandBuilder adds IdentifyReplyCommand (property field) which is build by the builder
	WithIdentifyReplyCommandBuilder(func(IdentifyReplyCommandBuilder) IdentifyReplyCommandBuilder) CALDataIdentifyReplyBuilder
	// Done is used to finish work on this child and return (or create one if none) to the parent builder
	Done() CALDataBuilder
	// Build builds the CALDataIdentifyReply or returns an error if something is wrong
	Build() (CALDataIdentifyReply, error)
	// MustBuild does the same as Build but panics on error
	MustBuild() CALDataIdentifyReply
}

// NewCALDataIdentifyReplyBuilder() creates a CALDataIdentifyReplyBuilder
func NewCALDataIdentifyReplyBuilder() CALDataIdentifyReplyBuilder {
	return &_CALDataIdentifyReplyBuilder{_CALDataIdentifyReply: new(_CALDataIdentifyReply)}
}

type _CALDataIdentifyReplyBuilder struct {
	*_CALDataIdentifyReply

	parentBuilder *_CALDataBuilder

	collectedErr []error
}

var _ (CALDataIdentifyReplyBuilder) = (*_CALDataIdentifyReplyBuilder)(nil)

func (b *_CALDataIdentifyReplyBuilder) setParent(contract CALDataContract) {
	b.CALDataContract = contract
	contract.(*_CALData)._SubType = b._CALDataIdentifyReply
}

func (b *_CALDataIdentifyReplyBuilder) WithMandatoryFields(attribute Attribute, identifyReplyCommand IdentifyReplyCommand) CALDataIdentifyReplyBuilder {
	return b.WithAttribute(attribute).WithIdentifyReplyCommand(identifyReplyCommand)
}

func (b *_CALDataIdentifyReplyBuilder) WithAttribute(attribute Attribute) CALDataIdentifyReplyBuilder {
	b.Attribute = attribute
	return b
}

func (b *_CALDataIdentifyReplyBuilder) WithIdentifyReplyCommand(identifyReplyCommand IdentifyReplyCommand) CALDataIdentifyReplyBuilder {
	b.IdentifyReplyCommand = identifyReplyCommand
	return b
}

func (b *_CALDataIdentifyReplyBuilder) WithIdentifyReplyCommandBuilder(builderSupplier func(IdentifyReplyCommandBuilder) IdentifyReplyCommandBuilder) CALDataIdentifyReplyBuilder {
	builder := builderSupplier(b.IdentifyReplyCommand.CreateIdentifyReplyCommandBuilder())
	var err error
	b.IdentifyReplyCommand, err = builder.Build()
	if err != nil {
		b.collectedErr = append(b.collectedErr, errors.Wrap(err, "IdentifyReplyCommandBuilder failed"))
	}
	return b
}

func (b *_CALDataIdentifyReplyBuilder) Build() (CALDataIdentifyReply, error) {
	if b.IdentifyReplyCommand == nil {
		b.collectedErr = append(b.collectedErr, errors.New("mandatory field 'identifyReplyCommand' not set"))
	}
	if err := stdErrors.Join(b.collectedErr...); err != nil {
		return nil, errors.Wrap(err, "error occurred during build")
	}
	return b._CALDataIdentifyReply.deepCopy(), nil
}

func (b *_CALDataIdentifyReplyBuilder) MustBuild() CALDataIdentifyReply {
	build, err := b.Build()
	if err != nil {
		panic(err)
	}
	return build
}

func (b *_CALDataIdentifyReplyBuilder) Done() CALDataBuilder {
	if b.parentBuilder == nil {
		b.parentBuilder = NewCALDataBuilder().(*_CALDataBuilder)
	}
	return b.parentBuilder
}

func (b *_CALDataIdentifyReplyBuilder) buildForCALData() (CALData, error) {
	return b.Build()
}

func (b *_CALDataIdentifyReplyBuilder) DeepCopy() any {
	_copy := b.CreateCALDataIdentifyReplyBuilder().(*_CALDataIdentifyReplyBuilder)
	if b.collectedErr != nil {
		copy(_copy.collectedErr, b.collectedErr)
	}
	return _copy
}

// CreateCALDataIdentifyReplyBuilder creates a CALDataIdentifyReplyBuilder
func (b *_CALDataIdentifyReply) CreateCALDataIdentifyReplyBuilder() CALDataIdentifyReplyBuilder {
	if b == nil {
		return NewCALDataIdentifyReplyBuilder()
	}
	return &_CALDataIdentifyReplyBuilder{_CALDataIdentifyReply: b.deepCopy()}
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for discriminator values.
///////////////////////

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

func (m *_CALDataIdentifyReply) GetParent() CALDataContract {
	return m.CALDataContract
}

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for property fields.
///////////////////////

func (m *_CALDataIdentifyReply) GetAttribute() Attribute {
	return m.Attribute
}

func (m *_CALDataIdentifyReply) GetIdentifyReplyCommand() IdentifyReplyCommand {
	return m.IdentifyReplyCommand
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

// Deprecated: use the interface for direct cast
func CastCALDataIdentifyReply(structType any) CALDataIdentifyReply {
	if casted, ok := structType.(CALDataIdentifyReply); ok {
		return casted
	}
	if casted, ok := structType.(*CALDataIdentifyReply); ok {
		return *casted
	}
	return nil
}

func (m *_CALDataIdentifyReply) GetTypeName() string {
	return "CALDataIdentifyReply"
}

func (m *_CALDataIdentifyReply) GetLengthInBits(ctx context.Context) uint16 {
	lengthInBits := uint16(m.CALDataContract.(*_CALData).getLengthInBits(ctx))

	// Simple field (attribute)
	lengthInBits += 8

	// Simple field (identifyReplyCommand)
	lengthInBits += m.IdentifyReplyCommand.GetLengthInBits(ctx)

	return lengthInBits
}

func (m *_CALDataIdentifyReply) GetLengthInBytes(ctx context.Context) uint16 {
	return m.GetLengthInBits(ctx) / 8
}

func (m *_CALDataIdentifyReply) parse(ctx context.Context, readBuffer utils.ReadBuffer, parent *_CALData, commandTypeContainer CALCommandTypeContainer, requestContext RequestContext) (__cALDataIdentifyReply CALDataIdentifyReply, err error) {
	m.CALDataContract = parent
	parent._SubType = m
	positionAware := readBuffer
	_ = positionAware
	if pullErr := readBuffer.PullContext("CALDataIdentifyReply"); pullErr != nil {
		return nil, errors.Wrap(pullErr, "Error pulling for CALDataIdentifyReply")
	}
	currentPos := positionAware.GetPos()
	_ = currentPos

	attribute, err := ReadEnumField[Attribute](ctx, "attribute", "Attribute", ReadEnum(AttributeByValue, ReadUnsignedByte(readBuffer, uint8(8))))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'attribute' field"))
	}
	m.Attribute = attribute

	identifyReplyCommand, err := ReadSimpleField[IdentifyReplyCommand](ctx, "identifyReplyCommand", ReadComplex[IdentifyReplyCommand](IdentifyReplyCommandParseWithBufferProducer[IdentifyReplyCommand]((Attribute)(attribute), (uint8)(uint8(commandTypeContainer.NumBytes())-uint8(uint8(1)))), readBuffer))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'identifyReplyCommand' field"))
	}
	m.IdentifyReplyCommand = identifyReplyCommand

	if closeErr := readBuffer.CloseContext("CALDataIdentifyReply"); closeErr != nil {
		return nil, errors.Wrap(closeErr, "Error closing for CALDataIdentifyReply")
	}

	return m, nil
}

func (m *_CALDataIdentifyReply) Serialize() ([]byte, error) {
	wb := utils.NewWriteBufferByteBased(utils.WithInitialSizeForByteBasedBuffer(int(m.GetLengthInBytes(context.Background()))))
	if err := m.SerializeWithWriteBuffer(context.Background(), wb); err != nil {
		return nil, err
	}
	return wb.GetBytes(), nil
}

func (m *_CALDataIdentifyReply) SerializeWithWriteBuffer(ctx context.Context, writeBuffer utils.WriteBuffer) error {
	positionAware := writeBuffer
	_ = positionAware
	log := zerolog.Ctx(ctx)
	_ = log
	ser := func() error {
		if pushErr := writeBuffer.PushContext("CALDataIdentifyReply"); pushErr != nil {
			return errors.Wrap(pushErr, "Error pushing for CALDataIdentifyReply")
		}

		if err := WriteSimpleEnumField[Attribute](ctx, "attribute", "Attribute", m.GetAttribute(), WriteEnum[Attribute, uint8](Attribute.GetValue, Attribute.PLC4XEnumName, WriteUnsignedByte(writeBuffer, 8))); err != nil {
			return errors.Wrap(err, "Error serializing 'attribute' field")
		}

		if err := WriteSimpleField[IdentifyReplyCommand](ctx, "identifyReplyCommand", m.GetIdentifyReplyCommand(), WriteComplex[IdentifyReplyCommand](writeBuffer)); err != nil {
			return errors.Wrap(err, "Error serializing 'identifyReplyCommand' field")
		}

		if popErr := writeBuffer.PopContext("CALDataIdentifyReply"); popErr != nil {
			return errors.Wrap(popErr, "Error popping for CALDataIdentifyReply")
		}
		return nil
	}
	return m.CALDataContract.(*_CALData).serializeParent(ctx, writeBuffer, m, ser)
}

func (m *_CALDataIdentifyReply) IsCALDataIdentifyReply() {}

func (m *_CALDataIdentifyReply) DeepCopy() any {
	return m.deepCopy()
}

func (m *_CALDataIdentifyReply) deepCopy() *_CALDataIdentifyReply {
	if m == nil {
		return nil
	}
	_CALDataIdentifyReplyCopy := &_CALDataIdentifyReply{
		m.CALDataContract.(*_CALData).deepCopy(),
		m.Attribute,
		utils.DeepCopy[IdentifyReplyCommand](m.IdentifyReplyCommand),
	}
	_CALDataIdentifyReplyCopy.CALDataContract.(*_CALData)._SubType = m
	return _CALDataIdentifyReplyCopy
}

func (m *_CALDataIdentifyReply) String() string {
	if m == nil {
		return "<nil>"
	}
	wb := utils.NewWriteBufferBoxBased(
		utils.WithWriteBufferBoxBasedMergeSingleBoxes(),
		utils.WithWriteBufferBoxBasedOmitEmptyBoxes(),
		utils.WithWriteBufferBoxBasedPrintPosLengthFooter(),
	)
	if err := wb.WriteSerializable(context.Background(), m); err != nil {
		return err.Error()
	}
	return wb.GetBox().String()
}
