/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

package model

import (
	"context"
	stdErrors "errors"
	"fmt"

	"github.com/pkg/errors"
	"github.com/rs/zerolog"

	. "github.com/apache/plc4x/plc4go/spi/codegen/fields"
	. "github.com/apache/plc4x/plc4go/spi/codegen/io"
	"github.com/apache/plc4x/plc4go/spi/utils"
)

// Code generated by code-generation. DO NOT EDIT.

// BACnetVTClassTagged is the corresponding interface of BACnetVTClassTagged
type BACnetVTClassTagged interface {
	fmt.Stringer
	utils.LengthAware
	utils.Serializable
	utils.Copyable
	// GetHeader returns Header (property field)
	GetHeader() BACnetTagHeader
	// GetValue returns Value (property field)
	GetValue() BACnetVTClass
	// GetProprietaryValue returns ProprietaryValue (property field)
	GetProprietaryValue() uint32
	// GetIsProprietary returns IsProprietary (virtual field)
	GetIsProprietary() bool
	// IsBACnetVTClassTagged is a marker method to prevent unintentional type checks (interfaces of same signature)
	IsBACnetVTClassTagged()
	// CreateBuilder creates a BACnetVTClassTaggedBuilder
	CreateBACnetVTClassTaggedBuilder() BACnetVTClassTaggedBuilder
}

// _BACnetVTClassTagged is the data-structure of this message
type _BACnetVTClassTagged struct {
	Header           BACnetTagHeader
	Value            BACnetVTClass
	ProprietaryValue uint32

	// Arguments.
	TagNumber uint8
	TagClass  TagClass
}

var _ BACnetVTClassTagged = (*_BACnetVTClassTagged)(nil)

// NewBACnetVTClassTagged factory function for _BACnetVTClassTagged
func NewBACnetVTClassTagged(header BACnetTagHeader, value BACnetVTClass, proprietaryValue uint32, tagNumber uint8, tagClass TagClass) *_BACnetVTClassTagged {
	if header == nil {
		panic("header of type BACnetTagHeader for BACnetVTClassTagged must not be nil")
	}
	return &_BACnetVTClassTagged{Header: header, Value: value, ProprietaryValue: proprietaryValue, TagNumber: tagNumber, TagClass: tagClass}
}

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Builder
///////////////////////

// BACnetVTClassTaggedBuilder is a builder for BACnetVTClassTagged
type BACnetVTClassTaggedBuilder interface {
	utils.Copyable
	// WithMandatoryFields adds all mandatory fields (convenience for using multiple builder calls)
	WithMandatoryFields(header BACnetTagHeader, value BACnetVTClass, proprietaryValue uint32) BACnetVTClassTaggedBuilder
	// WithHeader adds Header (property field)
	WithHeader(BACnetTagHeader) BACnetVTClassTaggedBuilder
	// WithHeaderBuilder adds Header (property field) which is build by the builder
	WithHeaderBuilder(func(BACnetTagHeaderBuilder) BACnetTagHeaderBuilder) BACnetVTClassTaggedBuilder
	// WithValue adds Value (property field)
	WithValue(BACnetVTClass) BACnetVTClassTaggedBuilder
	// WithProprietaryValue adds ProprietaryValue (property field)
	WithProprietaryValue(uint32) BACnetVTClassTaggedBuilder
	// WithArgTagNumber sets a parser argument
	WithArgTagNumber(uint8) BACnetVTClassTaggedBuilder
	// WithArgTagClass sets a parser argument
	WithArgTagClass(TagClass) BACnetVTClassTaggedBuilder
	// Build builds the BACnetVTClassTagged or returns an error if something is wrong
	Build() (BACnetVTClassTagged, error)
	// MustBuild does the same as Build but panics on error
	MustBuild() BACnetVTClassTagged
}

// NewBACnetVTClassTaggedBuilder() creates a BACnetVTClassTaggedBuilder
func NewBACnetVTClassTaggedBuilder() BACnetVTClassTaggedBuilder {
	return &_BACnetVTClassTaggedBuilder{_BACnetVTClassTagged: new(_BACnetVTClassTagged)}
}

type _BACnetVTClassTaggedBuilder struct {
	*_BACnetVTClassTagged

	collectedErr []error
}

var _ (BACnetVTClassTaggedBuilder) = (*_BACnetVTClassTaggedBuilder)(nil)

func (b *_BACnetVTClassTaggedBuilder) WithMandatoryFields(header BACnetTagHeader, value BACnetVTClass, proprietaryValue uint32) BACnetVTClassTaggedBuilder {
	return b.WithHeader(header).WithValue(value).WithProprietaryValue(proprietaryValue)
}

func (b *_BACnetVTClassTaggedBuilder) WithHeader(header BACnetTagHeader) BACnetVTClassTaggedBuilder {
	b.Header = header
	return b
}

func (b *_BACnetVTClassTaggedBuilder) WithHeaderBuilder(builderSupplier func(BACnetTagHeaderBuilder) BACnetTagHeaderBuilder) BACnetVTClassTaggedBuilder {
	builder := builderSupplier(b.Header.CreateBACnetTagHeaderBuilder())
	var err error
	b.Header, err = builder.Build()
	if err != nil {
		b.collectedErr = append(b.collectedErr, errors.Wrap(err, "BACnetTagHeaderBuilder failed"))
	}
	return b
}

func (b *_BACnetVTClassTaggedBuilder) WithValue(value BACnetVTClass) BACnetVTClassTaggedBuilder {
	b.Value = value
	return b
}

func (b *_BACnetVTClassTaggedBuilder) WithProprietaryValue(proprietaryValue uint32) BACnetVTClassTaggedBuilder {
	b.ProprietaryValue = proprietaryValue
	return b
}

func (b *_BACnetVTClassTaggedBuilder) WithArgTagNumber(tagNumber uint8) BACnetVTClassTaggedBuilder {
	b.TagNumber = tagNumber
	return b
}
func (b *_BACnetVTClassTaggedBuilder) WithArgTagClass(tagClass TagClass) BACnetVTClassTaggedBuilder {
	b.TagClass = tagClass
	return b
}

func (b *_BACnetVTClassTaggedBuilder) Build() (BACnetVTClassTagged, error) {
	if b.Header == nil {
		b.collectedErr = append(b.collectedErr, errors.New("mandatory field 'header' not set"))
	}
	if err := stdErrors.Join(b.collectedErr...); err != nil {
		return nil, errors.Wrap(err, "error occurred during build")
	}
	return b._BACnetVTClassTagged.deepCopy(), nil
}

func (b *_BACnetVTClassTaggedBuilder) MustBuild() BACnetVTClassTagged {
	build, err := b.Build()
	if err != nil {
		panic(err)
	}
	return build
}

func (b *_BACnetVTClassTaggedBuilder) DeepCopy() any {
	_copy := b.CreateBACnetVTClassTaggedBuilder().(*_BACnetVTClassTaggedBuilder)
	if b.collectedErr != nil {
		copy(_copy.collectedErr, b.collectedErr)
	}
	return _copy
}

// CreateBACnetVTClassTaggedBuilder creates a BACnetVTClassTaggedBuilder
func (b *_BACnetVTClassTagged) CreateBACnetVTClassTaggedBuilder() BACnetVTClassTaggedBuilder {
	if b == nil {
		return NewBACnetVTClassTaggedBuilder()
	}
	return &_BACnetVTClassTaggedBuilder{_BACnetVTClassTagged: b.deepCopy()}
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for property fields.
///////////////////////

func (m *_BACnetVTClassTagged) GetHeader() BACnetTagHeader {
	return m.Header
}

func (m *_BACnetVTClassTagged) GetValue() BACnetVTClass {
	return m.Value
}

func (m *_BACnetVTClassTagged) GetProprietaryValue() uint32 {
	return m.ProprietaryValue
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for virtual fields.
///////////////////////

func (m *_BACnetVTClassTagged) GetIsProprietary() bool {
	ctx := context.Background()
	_ = ctx
	return bool(bool((m.GetValue()) == (BACnetVTClass_VENDOR_PROPRIETARY_VALUE)))
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

// Deprecated: use the interface for direct cast
func CastBACnetVTClassTagged(structType any) BACnetVTClassTagged {
	if casted, ok := structType.(BACnetVTClassTagged); ok {
		return casted
	}
	if casted, ok := structType.(*BACnetVTClassTagged); ok {
		return *casted
	}
	return nil
}

func (m *_BACnetVTClassTagged) GetTypeName() string {
	return "BACnetVTClassTagged"
}

func (m *_BACnetVTClassTagged) GetLengthInBits(ctx context.Context) uint16 {
	lengthInBits := uint16(0)

	// Simple field (header)
	lengthInBits += m.Header.GetLengthInBits(ctx)

	// Manual Field (value)
	lengthInBits += uint16(utils.InlineIf(m.GetIsProprietary(), func() any { return int32(int32(0)) }, func() any { return int32((int32(m.GetHeader().GetActualLength()) * int32(int32(8)))) }).(int32))

	// A virtual field doesn't have any in- or output.

	// Manual Field (proprietaryValue)
	lengthInBits += uint16(utils.InlineIf(m.GetIsProprietary(), func() any { return int32((int32(m.GetHeader().GetActualLength()) * int32(int32(8)))) }, func() any { return int32(int32(0)) }).(int32))

	return lengthInBits
}

func (m *_BACnetVTClassTagged) GetLengthInBytes(ctx context.Context) uint16 {
	return m.GetLengthInBits(ctx) / 8
}

func BACnetVTClassTaggedParse(ctx context.Context, theBytes []byte, tagNumber uint8, tagClass TagClass) (BACnetVTClassTagged, error) {
	return BACnetVTClassTaggedParseWithBuffer(ctx, utils.NewReadBufferByteBased(theBytes), tagNumber, tagClass)
}

func BACnetVTClassTaggedParseWithBufferProducer(tagNumber uint8, tagClass TagClass) func(ctx context.Context, readBuffer utils.ReadBuffer) (BACnetVTClassTagged, error) {
	return func(ctx context.Context, readBuffer utils.ReadBuffer) (BACnetVTClassTagged, error) {
		return BACnetVTClassTaggedParseWithBuffer(ctx, readBuffer, tagNumber, tagClass)
	}
}

func BACnetVTClassTaggedParseWithBuffer(ctx context.Context, readBuffer utils.ReadBuffer, tagNumber uint8, tagClass TagClass) (BACnetVTClassTagged, error) {
	v, err := (&_BACnetVTClassTagged{TagNumber: tagNumber, TagClass: tagClass}).parse(ctx, readBuffer, tagNumber, tagClass)
	if err != nil {
		return nil, err
	}
	return v, nil
}

func (m *_BACnetVTClassTagged) parse(ctx context.Context, readBuffer utils.ReadBuffer, tagNumber uint8, tagClass TagClass) (__bACnetVTClassTagged BACnetVTClassTagged, err error) {
	positionAware := readBuffer
	_ = positionAware
	if pullErr := readBuffer.PullContext("BACnetVTClassTagged"); pullErr != nil {
		return nil, errors.Wrap(pullErr, "Error pulling for BACnetVTClassTagged")
	}
	currentPos := positionAware.GetPos()
	_ = currentPos

	header, err := ReadSimpleField[BACnetTagHeader](ctx, "header", ReadComplex[BACnetTagHeader](BACnetTagHeaderParseWithBuffer, readBuffer))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'header' field"))
	}
	m.Header = header

	// Validation
	if !(bool((header.GetTagClass()) == (tagClass))) {
		return nil, errors.WithStack(utils.ParseValidationError{Message: "tag class doesn't match"})
	}

	// Validation
	if !(bool((bool((header.GetTagClass()) == (TagClass_APPLICATION_TAGS)))) || bool((bool((header.GetActualTagNumber()) == (tagNumber))))) {
		return nil, errors.WithStack(utils.ParseAssertError{Message: "tagnumber doesn't match"})
	}

	value, err := ReadManualField[BACnetVTClass](ctx, "value", readBuffer, EnsureType[BACnetVTClass](ReadEnumGeneric(ctx, readBuffer, header.GetActualLength(), BACnetVTClass_VENDOR_PROPRIETARY_VALUE)))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'value' field"))
	}
	m.Value = value

	isProprietary, err := ReadVirtualField[bool](ctx, "isProprietary", (*bool)(nil), bool((value) == (BACnetVTClass_VENDOR_PROPRIETARY_VALUE)))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'isProprietary' field"))
	}
	_ = isProprietary

	proprietaryValue, err := ReadManualField[uint32](ctx, "proprietaryValue", readBuffer, EnsureType[uint32](ReadProprietaryEnumGeneric(ctx, readBuffer, header.GetActualLength(), isProprietary)))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'proprietaryValue' field"))
	}
	m.ProprietaryValue = proprietaryValue

	if closeErr := readBuffer.CloseContext("BACnetVTClassTagged"); closeErr != nil {
		return nil, errors.Wrap(closeErr, "Error closing for BACnetVTClassTagged")
	}

	return m, nil
}

func (m *_BACnetVTClassTagged) Serialize() ([]byte, error) {
	wb := utils.NewWriteBufferByteBased(utils.WithInitialSizeForByteBasedBuffer(int(m.GetLengthInBytes(context.Background()))))
	if err := m.SerializeWithWriteBuffer(context.Background(), wb); err != nil {
		return nil, err
	}
	return wb.GetBytes(), nil
}

func (m *_BACnetVTClassTagged) SerializeWithWriteBuffer(ctx context.Context, writeBuffer utils.WriteBuffer) error {
	positionAware := writeBuffer
	_ = positionAware
	log := zerolog.Ctx(ctx)
	_ = log
	if pushErr := writeBuffer.PushContext("BACnetVTClassTagged"); pushErr != nil {
		return errors.Wrap(pushErr, "Error pushing for BACnetVTClassTagged")
	}

	if err := WriteSimpleField[BACnetTagHeader](ctx, "header", m.GetHeader(), WriteComplex[BACnetTagHeader](writeBuffer)); err != nil {
		return errors.Wrap(err, "Error serializing 'header' field")
	}

	if err := WriteManualField[BACnetVTClass](ctx, "value", func(ctx context.Context) error { return WriteEnumGeneric(ctx, writeBuffer, m.GetValue()) }, writeBuffer); err != nil {
		return errors.Wrap(err, "Error serializing 'value' field")
	}
	// Virtual field
	isProprietary := m.GetIsProprietary()
	_ = isProprietary
	if _isProprietaryErr := writeBuffer.WriteVirtual(ctx, "isProprietary", m.GetIsProprietary()); _isProprietaryErr != nil {
		return errors.Wrap(_isProprietaryErr, "Error serializing 'isProprietary' field")
	}

	if err := WriteManualField[uint32](ctx, "proprietaryValue", func(ctx context.Context) error {
		return WriteProprietaryEnumGeneric(ctx, writeBuffer, m.GetProprietaryValue(), m.GetIsProprietary())
	}, writeBuffer); err != nil {
		return errors.Wrap(err, "Error serializing 'proprietaryValue' field")
	}

	if popErr := writeBuffer.PopContext("BACnetVTClassTagged"); popErr != nil {
		return errors.Wrap(popErr, "Error popping for BACnetVTClassTagged")
	}
	return nil
}

////
// Arguments Getter

func (m *_BACnetVTClassTagged) GetTagNumber() uint8 {
	return m.TagNumber
}
func (m *_BACnetVTClassTagged) GetTagClass() TagClass {
	return m.TagClass
}

//
////

func (m *_BACnetVTClassTagged) IsBACnetVTClassTagged() {}

func (m *_BACnetVTClassTagged) DeepCopy() any {
	return m.deepCopy()
}

func (m *_BACnetVTClassTagged) deepCopy() *_BACnetVTClassTagged {
	if m == nil {
		return nil
	}
	_BACnetVTClassTaggedCopy := &_BACnetVTClassTagged{
		utils.DeepCopy[BACnetTagHeader](m.Header),
		m.Value,
		m.ProprietaryValue,
		m.TagNumber,
		m.TagClass,
	}
	return _BACnetVTClassTaggedCopy
}

func (m *_BACnetVTClassTagged) String() string {
	if m == nil {
		return "<nil>"
	}
	wb := utils.NewWriteBufferBoxBased(
		utils.WithWriteBufferBoxBasedMergeSingleBoxes(),
		utils.WithWriteBufferBoxBasedOmitEmptyBoxes(),
		utils.WithWriteBufferBoxBasedPrintPosLengthFooter(),
	)
	if err := wb.WriteSerializable(context.Background(), m); err != nil {
		return err.Error()
	}
	return wb.GetBox().String()
}
