/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.internal.schedulers;

import io.reactivex.disposables.Disposable;
import io.reactivex.internal.disposables.DisposableContainer;
import io.reactivex.plugins.RxJavaPlugins;
import java.util.concurrent.Callable;
import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicReferenceArray;

public final class ScheduledRunnable
extends AtomicReferenceArray<Object>
implements Runnable,
Callable<Object>,
Disposable {
    private static final long serialVersionUID = -6120223772001106981L;
    final Runnable actual;
    static final Object DISPOSED = new Object();
    static final Object DONE = new Object();
    static final int PARENT_INDEX = 0;
    static final int FUTURE_INDEX = 1;

    public ScheduledRunnable(Runnable actual, DisposableContainer parent) {
        super(2);
        this.actual = actual;
        this.lazySet(0, parent);
    }

    @Override
    public Object call() {
        this.run();
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        try {
            try {
                this.actual.run();
            }
            catch (Throwable e) {
                RxJavaPlugins.onError(e);
            }
        }
        finally {
            Object o = this.get(0);
            if (o != DISPOSED && o != null && this.compareAndSet(0, o, DONE)) {
                ((DisposableContainer)o).delete(this);
            }
            while ((o = this.get(1)) != DISPOSED && !this.compareAndSet(1, o, DONE)) {
            }
        }
    }

    public void setFuture(Future<?> f) {
        Object o;
        do {
            if ((o = this.get(1)) == DONE) {
                return;
            }
            if (o != DISPOSED) continue;
            f.cancel(true);
            return;
        } while (!this.compareAndSet(1, o, f));
    }

    @Override
    public void dispose() {
        Object o;
        while ((o = this.get(1)) != DONE && o != DISPOSED) {
            if (!this.compareAndSet(1, o, DISPOSED)) continue;
            if (o == null) break;
            ((Future)o).cancel(true);
            break;
        }
        do {
            if ((o = this.get(0)) != DONE && o != DISPOSED && o != null) continue;
            return;
        } while (!this.compareAndSet(0, o, DISPOSED));
        ((DisposableContainer)o).delete(this);
    }

    @Override
    public boolean isDisposed() {
        Object o = this.get(1);
        return o == DISPOSED || o == DONE;
    }
}

