/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.http.header;

import org.apache.juneau.commons.utils.AssertionUtils;
import org.apache.juneau.commons.utils.StringUtils;
import org.apache.juneau.commons.utils.ThrowableUtils;
import org.apache.juneau.commons.utils.Utils;

public class EntityTag {
    private final String value;
    private final boolean isWeak;
    private final boolean isAny;

    public static EntityTag of(Object value) {
        Object o = Utils.unwrap((Object)value);
        return o == null ? null : new EntityTag(o.toString());
    }

    public EntityTag(String value) {
        AssertionUtils.assertArgNotNull((String)"value", (Object)value);
        value = StringUtils.trim((String)StringUtils.emptyIfNull((String)value));
        this.isWeak = value.startsWith("W/");
        this.isAny = "*".equals(value);
        if (!this.isAny) {
            if (this.isWeak) {
                value = value.substring(2);
            }
            if (value.length() > 1 && value.charAt(0) == '\"' && value.charAt(value.length() - 1) == '\"') {
                value = value.substring(1, value.length() - 1);
            } else {
                throw ThrowableUtils.illegalArg((String)"Invalid value for entity-tag: [{0}]", (Object[])new Object[]{this.isWeak ? "W/" + value : value});
            }
        }
        this.value = value;
    }

    public String getEntityValue() {
        return this.value;
    }

    public boolean isAny() {
        return this.isAny;
    }

    public boolean isWeak() {
        return this.isWeak;
    }

    public String toString() {
        return (this.isWeak ? "W/" : "") + (String)(this.isAny() ? "*" : "\"" + this.value + "\"");
    }
}

