/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.swap;

import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.Map;
import java.util.Set;
import org.apache.juneau.BeanContext;
import org.apache.juneau.BeanSession;
import org.apache.juneau.ClassMeta;
import org.apache.juneau.annotation.BeanIgnore;
import org.apache.juneau.commons.reflect.AnnotationTraversal;
import org.apache.juneau.commons.reflect.ClassInfo;
import org.apache.juneau.commons.reflect.ConstructorInfo;
import org.apache.juneau.commons.reflect.MethodInfo;
import org.apache.juneau.commons.utils.CollectionUtils;
import org.apache.juneau.commons.utils.Utils;
import org.apache.juneau.internal.ClassUtils2;
import org.apache.juneau.parser.ParseException;
import org.apache.juneau.serializer.SerializeException;
import org.apache.juneau.swap.ObjectSwap;

public class AutoMapSwap<T>
extends ObjectSwap<T, Map<?, ?>> {
    private static final Set<String> SWAP_METHOD_NAMES = CollectionUtils.u(CollectionUtils.set("toMap", "toJsonMap"));
    private static final Set<String> UNSWAP_METHOD_NAMES = CollectionUtils.u(CollectionUtils.set("fromMap", "fromJsonMap", "create", "valueOf"));
    private final Method swapMethod;
    private final Method unswapMethod;
    private final Constructor<?> unswapConstructor;

    public static ObjectSwap<?, ?> find(BeanContext bc, ClassInfo ci) {
        if (AutoMapSwap.shouldIgnore(bc, ci)) {
            return null;
        }
        for (MethodInfo m : ci.getAllMethods()) {
            if (!AutoMapSwap.isSwapMethod(bc, m)) continue;
            ClassInfo rt = m.getReturnType();
            MethodInfo mi = ci.getMethod(x -> AutoMapSwap.isUnswapMethod(bc, x, ci, rt)).orElse(null);
            if (Utils.nn(mi)) {
                return new AutoMapSwap(bc, ci, m, mi, null);
            }
            ConstructorInfo cs = ci.getDeclaredConstructor(x -> AutoMapSwap.isUnswapConstructor(bc, x, rt)).orElse(null);
            if (Utils.nn(cs)) {
                return new AutoMapSwap(bc, ci, m, null, cs);
            }
            return new AutoMapSwap(bc, ci, m, null, null);
        }
        return null;
    }

    private static boolean isSwapMethod(BeanContext bc, MethodInfo mi) {
        return mi.isNotDeprecated() && mi.isNotStatic() && mi.isVisible(bc.getBeanMethodVisibility()) && mi.hasAnyName(SWAP_METHOD_NAMES) && mi.hasReturnTypeParent(Map.class) && mi.hasParameterTypesLenient(BeanSession.class) && !mi.getMatchingMethods().stream().anyMatch(m2 -> bc.getAnnotationProvider().has(BeanIgnore.class, (MethodInfo)m2, new AnnotationTraversal[0]));
    }

    private static boolean isUnswapConstructor(BeanContext bc, ConstructorInfo cs, ClassInfo rt) {
        return cs.isNotDeprecated() && cs.isVisible(bc.getBeanConstructorVisibility()) && cs.hasParameterTypeParents(rt) && !bc.getAnnotationProvider().has(BeanIgnore.class, cs, new AnnotationTraversal[0]);
    }

    private static boolean isUnswapMethod(BeanContext bc, MethodInfo mi, ClassInfo ci, ClassInfo rt) {
        return mi.isNotDeprecated() && mi.isStatic() && mi.isVisible(bc.getBeanMethodVisibility()) && mi.hasAnyName(UNSWAP_METHOD_NAMES) && mi.hasParameterTypesLenient(BeanSession.class, rt.inner()) && mi.hasReturnTypeParent(ci) && !mi.getMatchingMethods().stream().anyMatch(m2 -> bc.getAnnotationProvider().has(BeanIgnore.class, (MethodInfo)m2, new AnnotationTraversal[0]));
    }

    private static boolean shouldIgnore(BeanContext bc, ClassInfo ci) {
        return ci.isNonStaticMemberClass() || bc.getAnnotationProvider().has(BeanIgnore.class, ci, new AnnotationTraversal[0]);
    }

    private AutoMapSwap(BeanContext bc, ClassInfo ci, MethodInfo swapMethod, MethodInfo unswapMethod, ConstructorInfo unswapConstructor) {
        super(ci.inner(), swapMethod.inner().getReturnType());
        this.swapMethod = bc.getBeanMethodVisibility().transform(swapMethod.inner());
        this.unswapMethod = unswapMethod == null ? null : bc.getBeanMethodVisibility().transform(unswapMethod.inner());
        this.unswapConstructor = unswapConstructor == null ? null : bc.getBeanConstructorVisibility().transform(unswapConstructor.inner());
    }

    @Override
    public Map<?, ?> swap(BeanSession session, Object o) throws SerializeException {
        try {
            return (Map)this.swapMethod.invoke(o, ClassUtils2.getMatchingArgs(this.swapMethod.getParameterTypes(), session));
        }
        catch (Exception e) {
            throw SerializeException.create(e);
        }
    }

    @Override
    public T unswap(BeanSession session, Map<?, ?> o, ClassMeta<?> hint) throws ParseException {
        try {
            if (Utils.nn(this.unswapMethod)) {
                return (T)this.unswapMethod.invoke(null, ClassUtils2.getMatchingArgs(this.unswapMethod.getParameterTypes(), session, o));
            }
            if (Utils.nn(this.unswapConstructor)) {
                return (T)this.unswapConstructor.newInstance(o);
            }
            return super.unswap(session, o, hint);
        }
        catch (Exception e) {
            throw ParseException.create(e);
        }
    }
}

