/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.bean.swagger;

import java.util.Comparator;
import java.util.Map;
import java.util.TreeMap;
import org.apache.juneau.bean.swagger.Operation;
import org.apache.juneau.commons.utils.CollectionUtils;
import org.apache.juneau.commons.utils.StringUtils;
import org.apache.juneau.commons.utils.Utils;

public class OperationMap
extends TreeMap<String, Operation> {
    private static final long serialVersionUID = 1L;
    private static final Comparator<String> OP_SORTER = new Comparator<String>(){
        private final Map<String, String> methods = CollectionUtils.mapb(String.class, String.class).add("get", "0").add("put", "1").add("post", "2").add("delete", "3").add("options", "4").add("head", "5").add("patch", "6").build();

        @Override
        public int compare(String o1, String o2) {
            String s1 = this.methods.get(Utils.emptyIfNull(o1).toLowerCase());
            String s2 = this.methods.get(Utils.emptyIfNull(o2).toLowerCase());
            if (s1 == null) {
                s1 = Utils.emptyIfNull(o1).toLowerCase();
            }
            if (s2 == null) {
                s2 = Utils.emptyIfNull(o2).toLowerCase();
            }
            return StringUtils.compare(s1, s2);
        }
    };

    public OperationMap() {
        super(OP_SORTER);
    }

    public OperationMap append(String httpMethodName, Operation operation) {
        this.put(httpMethodName, operation);
        return this;
    }

    @Override
    public Operation put(String key, Operation value) {
        return super.put(Utils.emptyIfNull(key).toLowerCase(), value);
    }
}

