/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.xml;

import org.apache.juneau.BeanPropertyMeta;
import org.apache.juneau.ClassMeta;
import org.apache.juneau.ExtendedBeanPropertyMeta;
import org.apache.juneau.commons.collections.MultiList;
import org.apache.juneau.commons.reflect.AnnotationInfo;
import org.apache.juneau.commons.reflect.AnnotationProvider;
import org.apache.juneau.commons.reflect.AnnotationTraversal;
import org.apache.juneau.commons.utils.CollectionUtils;
import org.apache.juneau.commons.utils.ThrowableUtils;
import org.apache.juneau.commons.utils.Utils;
import org.apache.juneau.xml.Namespace;
import org.apache.juneau.xml.XmlMetaProvider;
import org.apache.juneau.xml.XmlUtils;
import org.apache.juneau.xml.annotation.Xml;
import org.apache.juneau.xml.annotation.XmlFormat;
import org.apache.juneau.xml.annotation.XmlSchema;

public class XmlBeanPropertyMeta
extends ExtendedBeanPropertyMeta {
    public static final XmlBeanPropertyMeta DEFAULT = new XmlBeanPropertyMeta();
    private Namespace namespace;
    private XmlFormat xmlFormat = XmlFormat.DEFAULT;
    private String childName;
    private final XmlMetaProvider xmlMetaProvider;

    public XmlBeanPropertyMeta(BeanPropertyMeta bpm, XmlMetaProvider mp) {
        super(bpm);
        this.xmlMetaProvider = mp;
        bpm.getAnnotations(Xml.class).forEach(x -> this.findXmlInfo((Xml)x.inner(), bpm.getClassMeta().getBeanContext().getAnnotationProvider()));
        if (this.namespace == null) {
            this.namespace = mp.getXmlClassMeta(bpm.getBeanMeta().getClassMeta()).getNamespace();
        }
    }

    private XmlBeanPropertyMeta() {
        super(null);
        this.xmlMetaProvider = null;
    }

    public String getChildName() {
        return this.childName;
    }

    public Namespace getNamespace() {
        return this.namespace;
    }

    public XmlFormat getXmlFormat() {
        return this.xmlFormat;
    }

    private void findXmlInfo(Xml xml, AnnotationProvider mp) {
        if (xml == null) {
            return;
        }
        BeanPropertyMeta bpm = this.getBeanPropertyMeta();
        ClassMeta<?> cmProperty = bpm.getClassMeta();
        ClassMeta<?> cmBean = bpm.getBeanMeta().getClassMeta();
        String name = bpm.getName();
        AnnotationProvider ap = bpm.getClassMeta().getBeanContext().getAnnotationProvider();
        MultiList<Xml> xmls = new MultiList<Xml>(CollectionUtils.rstream(ap.find(Xml.class, bpm.getBeanMeta().getClassMeta(), new AnnotationTraversal[0])).map(AnnotationInfo::inner).toList(), CollectionUtils.reverse(bpm.getAnnotations(Xml.class).map(AnnotationInfo::inner).toList()));
        MultiList<XmlSchema> schemas = new MultiList<XmlSchema>(CollectionUtils.rstream(ap.find(XmlSchema.class, bpm.getBeanMeta().getClassMeta(), new AnnotationTraversal[0])).map(AnnotationInfo::inner).toList(), CollectionUtils.reverse(bpm.getAnnotations(XmlSchema.class).map(AnnotationInfo::inner).toList()));
        this.namespace = XmlUtils.findNamespace(xmls, schemas);
        if (this.xmlFormat == XmlFormat.DEFAULT) {
            this.xmlFormat = xml.format();
        }
        boolean isCollection = cmProperty.isCollectionOrArray();
        String cen = xml.childName();
        if (!cen.isEmpty() && !isCollection) {
            throw ThrowableUtils.bex(cmProperty.inner(), "Annotation error on property ''{0}''.  @Xml.childName can only be specified on collections and arrays.", name);
        }
        if (this.xmlFormat == XmlFormat.COLLAPSED) {
            if (isCollection) {
                if (cen.isEmpty() && Utils.nn(this.xmlMetaProvider)) {
                    cen = this.xmlMetaProvider.getXmlClassMeta(cmProperty).getChildName();
                }
                if (cen == null || cen.isEmpty()) {
                    cen = cmProperty.getElementType().getBeanDictionaryName();
                }
                if (cen == null || cen.isEmpty()) {
                    cen = name;
                }
            } else {
                throw ThrowableUtils.bex(cmBean.inner(), "Annotation error on property ''{0}''.  @Xml.format=COLLAPSED can only be specified on collections and arrays.", name);
            }
            if (cen.isEmpty() && isCollection) {
                cen = cmProperty.getBeanDictionaryName();
            }
        }
        if (!cen.isEmpty()) {
            this.childName = cen;
        }
    }
}

