/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.bean.openapi3;

import java.util.Collection;
import java.util.Map;
import java.util.Set;
import org.apache.juneau.bean.openapi3.OpenApiElement;
import org.apache.juneau.commons.collections.MultiSet;
import org.apache.juneau.commons.utils.AssertionUtils;
import org.apache.juneau.commons.utils.CollectionUtils;
import org.apache.juneau.commons.utils.Utils;
import org.apache.juneau.internal.ConverterUtils;

public class Discriminator
extends OpenApiElement {
    private String propertyName;
    private Map<String, String> mapping = CollectionUtils.map();

    public Discriminator() {
    }

    public Discriminator(Discriminator copyFrom) {
        super(copyFrom);
        this.propertyName = copyFrom.propertyName;
        this.mapping = CollectionUtils.copyOf(copyFrom.mapping);
    }

    public Discriminator addMapping(String key, String value) {
        AssertionUtils.assertArgNotNull((String)"key", (Object)key);
        AssertionUtils.assertArgNotNull((String)"value", (Object)value);
        this.mapping.put(key, value);
        return this;
    }

    public Discriminator copy() {
        return new Discriminator(this);
    }

    @Override
    public <T> T get(String property, Class<T> type) {
        AssertionUtils.assertArgNotNull((String)"property", (Object)property);
        return (T)(switch (property) {
            case "propertyName" -> ConverterUtils.toType((Object)this.getPropertyName(), type);
            case "mapping" -> ConverterUtils.toType(this.getMapping(), type);
            default -> super.get(property, type);
        });
    }

    public Map<String, String> getMapping() {
        return Utils.nullIfEmpty(this.mapping);
    }

    public String getPropertyName() {
        return this.propertyName;
    }

    @Override
    public Set<String> keySet() {
        Set s = CollectionUtils.setb(String.class).addIf(Utils.ne(this.mapping), (Object)"mapping").addIf(Utils.nn((Object)this.propertyName), (Object)"propertyName").build();
        return new MultiSet(new Collection[]{s, super.keySet()});
    }

    @Override
    public Discriminator set(String property, Object value) {
        AssertionUtils.assertArgNotNull((String)"property", (Object)property);
        return switch (property) {
            case "mapping" -> this.setMapping(ConverterUtils.toMapBuilder((Object)value, String.class, String.class).sparse().build());
            case "propertyName" -> this.setPropertyName(Utils.s((Object)value));
            default -> {
                super.set(property, value);
                yield this;
            }
        };
    }

    public Discriminator setMapping(Map<String, String> value) {
        this.mapping.clear();
        if (Utils.nn(value)) {
            this.mapping.putAll(value);
        }
        return this;
    }

    public Discriminator setPropertyName(String value) {
        this.propertyName = value;
        return this;
    }

    @Override
    public Discriminator strict() {
        super.strict();
        return this;
    }

    @Override
    public Discriminator strict(Object value) {
        super.strict(value);
        return this;
    }
}

