/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.storageengine.dataregion.read.filescan.impl;

import java.io.IOException;
import org.apache.iotdb.db.storageengine.dataregion.read.filescan.IChunkHandle;
import org.apache.tsfile.file.metadata.IDeviceID;

public class MemChunkHandleImpl
implements IChunkHandle {
    protected final long[] dataOfTimestamp;
    protected final String measurement;
    protected boolean hasRead = false;
    protected IDeviceID deviceID;

    public MemChunkHandleImpl(IDeviceID deviceID, String measurement, long[] dataOfTimestamp) {
        this.deviceID = deviceID;
        this.measurement = measurement;
        this.dataOfTimestamp = dataOfTimestamp;
    }

    @Override
    public boolean hasNextPage() throws IOException {
        return !this.hasRead;
    }

    @Override
    public void nextPage() throws IOException {
    }

    @Override
    public void skipCurrentPage() {
        this.hasRead = true;
    }

    @Override
    public long[] getPageStatisticsTime() {
        return new long[]{this.dataOfTimestamp[0], this.dataOfTimestamp[this.dataOfTimestamp.length - 1]};
    }

    @Override
    public long[] getDataTime() throws IOException {
        this.hasRead = true;
        return this.dataOfTimestamp;
    }

    @Override
    public IDeviceID getDeviceID() {
        return this.deviceID;
    }

    @Override
    public String getMeasurement() {
        return this.measurement;
    }
}

