<!--
 Licensed to the Apache Software Foundation (ASF) under one or more
 contributor license agreements.  See the NOTICE file distributed with
 this work for additional information regarding copyright ownership.
 The ASF licenses this file to You under the Apache License, Version 2.0
 (the "License"); you may not use this file except in compliance with
 the License.  You may obtain a copy of the License at

     http://www.apache.org/licenses/LICENSE-2.0

 Unless required by applicable law or agreed to in writing, software
 distributed under the License is distributed on an "AS IS" BASIS,
 WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 See the License for the specific language governing permissions and
 limitations under the License.
 -->

### 1.0.2-RC1

<details>	
  <summary><mark>Release notes</mark></summary>

  ### Seata-go 1.0.2-RC1	

Seata-go 1.0.2-RC1 发布。

Seata-go 是一款开源的分布式事务解决方案，提供高性能和简单易用的分布式事务服务。

此版本更新如下：

### feature：

- [[#190](https://github.com/apache/incubator-seata-go/pull/190)] 添加分支状态上报接口
- [[#158](https://github.com/apache/incubator-seata-go/pull/158)] TCC 模式支持 grapc 调用
- [[#213](https://github.com/apache/incubator-seata-go/pull/213)] 支持数据源代理功能
- [[#240](https://github.com/apache/incubator-seata-go/pull/240)] 删除日志管理功能
- [[#243](https://github.com/apache/incubator-seata-go/pull/243)] 添加 Update SQL 语法解析器
- [[#191](https://github.com/apache/incubator-seata-go/pull/191)] 支持 TCC 防悬挂、空回滚处理功能
- [[#264](https://github.com/apache/incubator-seata-go/pull/264)] 添加更新sql解析器并删除 tidb 解析器
- [[#280](https://github.com/apache/incubator-seata-go/pull/280)] TCC 支持 http 调用
- [[#245](https://github.com/apache/incubator-seata-go/pull/245)] 支持 hasLogTable 判断逻辑
- [[#288](https://github.com/apache/incubator-seata-go/pull/288)] 添加 update SQL 的 undo log 生成功能
- [[#296](https://github.com/apache/incubator-seata-go/pull/296)] 添加 delete SQL 的 undo log 生成功能
- [[#303](https://github.com/apache/incubator-seata-go/pull/303)] 添加异步处理器
- [[#289](https://github.com/apache/incubator-seata-go/pull/289)] 撤消日志生成器后添加 MySQL 更新
- [[#294](https://github.com/apache/incubator-seata-go/pull/294)] 添加 MySQL 元数据查询
- [[#309](https://github.com/apache/incubator-seata-go/pull/309)] 初始化压缩类型
- [[#301](https://github.com/apache/incubator-seata-go/pull/301)] 添加 Multi SQL 的 undo log 生成功能
- [[#321](https://github.com/apache/incubator-seata-go/pull/321)] 添加 deflate 压缩功能
- [[#324](https://github.com/apache/incubator-seata-go/pull/324)] 添加 lz4 压缩功能
- [[#327](https://github.com/apache/incubator-seata-go/pull/327)] 添加 zstd 压缩功能
- [[#322](https://github.com/apache/incubator-seata-go/pull/322)] 添加 gzip 压缩功能
- [[#307](https://github.com/apache/incubator-seata-go/pull/307)] 添加 flush undo log 功能
- [[#329](https://github.com/apache/incubator-seata-go/pull/329)] 添加 zip 压缩功能
- [[#325](https://github.com/apache/incubator-seata-go/pull/325)] 添加 Multi update SQL 的 undo log 生成功能
- [[#330](https://github.com/apache/incubator-seata-go/pull/330)] 添加 Multi delete SQL 的 undo log 生成功能
- [[#319](https://github.com/apache/incubator-seata-go/pull/319)] 添加选择更新执行器
- [[#320](https://github.com/apache/incubator-seata-go/pull/320)] 添加 undo 逻辑
- [[#337](https://github.com/apache/incubator-seata-go/pull/337)] 添加插入 undo log 逻辑
- [[#355](https://github.com/apache/incubator-seata-go/pull/355)] 支持根据配置判断 undo log 保存字段个数
- [[#365](https://github.com/apache/incubator-seata-go/pull/365)] 回滚 AT 之前做脏数据校验



### bugfix：

- [[#176](https://github.com/apache/incubator-seata-go/pull/176)] 修复 message 的单测的 bug
- [[#237](https://github.com/apache/incubator-seata-go/pull/237)] 修复在执行 OpenConnector 函数时候注册资源的 bug
- [[#230](https://github.com/apache/incubator-seata-go/pull/230)] 修复远程异步调用无限循环的bug
- [[#258](https://github.com/apache/incubator-seata-go/pull/258)] 修复全局事务超时的 bug
- [[#263](https://github.com/apache/incubator-seata-go/pull/263)] 修复 mock 数据的 bug
- [[#326](https://github.com/apache/incubator-seata-go/pull/326)] 修复 fanout 单元测试 bug
- [[#350](https://github.com/apache/incubator-seata-go/pull/350)] 修复 panic 的bug
- [[#359](https://github.com/apache/incubator-seata-go/pull/359)] 修复插入 undo log 的 MySQL 参数 bug
- [[#360](https://github.com/apache/incubator-seata-go/pull/360)] 修复 AT 回滚例子 bug
- [[#363](https://github.com/apache/incubator-seata-go/pull/363)] 修复 meta data bug
- [[#365](https://github.com/apache/incubator-seata-go/pull/365)] 修复反序列化 undo log bug


### optimize：	

- [[#187](https://github.com/apache/incubator-seata-go/pull/187)] 优化 seata-go 初始化流程
- [[#196](https://github.com/apache/incubator-seata-go/pull/196)] 优化远程调用方法参数
- [[#200](https://github.com/apache/incubator-seata-go/pull/200)] 添加 tcc grpc 样例，优化注册资源和分支注册
- [[#208](https://github.com/apache/incubator-seata-go/pull/208)] 优化删除不必要代码
- [[#215](https://github.com/apache/incubator-seata-go/pull/215)] 优化使时间参数，提高可读性
- [[#179](https://github.com/apache/incubator-seata-go/pull/179)] 支持 TCC 一阶段传入用户自定义参数
- [[#198](https://github.com/apache/incubator-seata-go/pull/198)] 优化远程调用方法的传参
- [[#235](https://github.com/apache/incubator-seata-go/pull/235)] 调整 MessageType 枚举值命名规范
- [[#238](https://github.com/apache/incubator-seata-go/pull/238)] 添加一些待办事项注释，添加 hook 例子
- [[#261](https://github.com/apache/incubator-seata-go/pull/261)] 优化嵌套循环重试
- [[#284](https://github.com/apache/incubator-seata-go/pull/284)] 优化重试逻辑
- [[#286](https://github.com/apache/incubator-seata-go/pull/286)] 将 rm 和 tm 的初始化逻辑拆分
- [[#287](https://github.com/apache/incubator-seata-go/pull/287)] 重构 seata conn 逻辑
- [[#281](https://github.com/apache/incubator-seata-go/pull/281)] 优化全局事务使用
- [[#295](https://github.com/apache/incubator-seata-go/pull/295)] 重构 seata conn 逻辑
- [[#302](https://github.com/apache/incubator-seata-go/pull/302)] 修改 dubbo-go 版本
- [[#336](https://github.com/apache/incubator-seata-go/pull/336)] 优化 at 整体流程
- [[#346](https://github.com/apache/incubator-seata-go/pull/346)] 优化 at 事务提交流程
- [[#352](https://github.com/apache/incubator-seata-go/pull/352)] 优化获取元数据流程
- [[#354](https://github.com/apache/incubator-seata-go/pull/354)] 优化 at 事务提交流程
- [[#353](https://github.com/apache/incubator-seata-go/pull/353)] 修改方法接收者命名规范
- [[#356](https://github.com/apache/incubator-seata-go/pull/356)] 优化 at 事务回滚流程

### test:

- [[#154](https://github.com/apache/incubator-seata-go/pull/154)] 添加 message 单元单测
- [[#163](https://github.com/apache/incubator-seata-go/pull/163)] 添加 tm 单元单测
- [[#203](https://github.com/apache/incubator-seata-go/pull/203)] 添加 getty 单元测试
- [[#204](https://github.com/apache/incubator-seata-go/pull/204)] 添加 dubbo filter 单元测试
- [[#210](https://github.com/apache/incubator-seata-go/pull/210)] 添加 Tcc 分支报告测试
- [[#192](https://github.com/apache/incubator-seata-go/pull/192)] 添加 rm 单元测试
- [[#229](https://github.com/apache/incubator-seata-go/pull/229)] 添加 common 单元测试
- [[#299](https://github.com/apache/incubator-seata-go/pull/299)] 添加 SQL Parser 单元测试
- [[#332](https://github.com/apache/incubator-seata-go/pull/332)] 添加 multi delete undo log 单元测试
- [[#358](https://github.com/apache/incubator-seata-go/pull/358)] 添加 AT 回滚的例子


### doc:

- [[#202](https://github.com/apache/incubator-seata-go/pull/202)] 优化 github CI 流程，添加 condecov 、 issue CI 工作流
- [[#254](https://github.com/apache/incubator-seata-go/pull/254)] 添加自动检查 licence 的脚本
- [[#305](https://github.com/apache/incubator-seata-go/pull/305)] 修改 CI 不要自动关闭 issue 和 pr




### contributors:

非常感谢以下 contributors 的代码贡献。若有无意遗漏，请报告。

- [AlexStocks](https://github.com/AlexStocks)
- [luky116](https://github.com/luky116)
- [106umao](https://github.com/106umao)
- [liiibpm](https://github.com/liiibpm)
- [elrond-g](https://github.com/elrond-g)
- [wang1309](https://github.com/wang1309)
- [iSuperCoder](https://github.com/apache/incubator-seata-go/commits?author=iSuperCoder)
- [a631807682](https://github.com/apache/incubator-seata-go/commits?author=a631807682)
- [betterwinsone](https://github.com/apache/incubator-seata-go/commits?author=betterwinsone) 
- [jasondeng1997](https://github.com/apache/incubator-seata-go/commits?author=jasondeng1997)
- [chuntaojun](https://github.com/apache/incubator-seata-go/commits?author=chuntaojun) 
- [complone](https://github.com/apache/incubator-seata-go/commits?author=complone) 
- [miaoxueyu](https://github.com/apache/incubator-seata-go/commits?author=miaoxueyu)
- [PangXing](https://github.com/apache/incubator-seata-go/commits?author=PangXing)
- [georgehao](https://github.com/apache/incubator-seata-go/commits?author=georgehao)
- [baerwang](https://github.com/apache/incubator-seata-go/commits?author=baerwang)
- [raspberry-hu](https://github.com/apache/incubator-seata-go/commits?author=raspberry-hu)
- [WyattJia](https://github.com/apache/incubator-seata-go/commits?author=WyattJia)
- [Code-Fight](https://github.com/Code-Fight)
- [betterwinsone](https://github.com/betterwinsonet)


同时，我们收到了社区反馈的很多有价值的issue和建议，非常感谢大家。

</detail>

