<!--
  Licensed to the Apache Software Foundation (ASF) under one
  or more contributor license agreements.  See the NOTICE file
  distributed with this work for additional information
  regarding copyright ownership.  The ASF licenses this file
  to you under the Apache License, Version 2.0 (the
  "License"); you may not use this file except in compliance
  with the License.  You may obtain a copy of the License at

   http://www.apache.org/licenses/LICENSE-2.0

  Unless required by applicable law or agreed to in writing,
  software distributed under the License is distributed on an
  "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
  KIND, either express or implied.  See the License for the
  specific language governing permissions and limitations
  under the License.
-->

# Apache Polaris - Project Chat Bylaws

Apache Polaris is currently undergoing Incubation at the Apache Software Foundation.

## Motivation

Apache Polaris uses public Slack workspace (join [here](https://join.slack.com/t/apache-polaris/shared_invite/zt-2y3l3r0fr-VtoW42ltir~nSzCYOrQgfw)).

A few rules shall ensure that the chat conforms to the rules and best
practices of the Apache Software Foundation and serves well as a collaboration tool for the project.

Organizations and other open-source projects that contribute continuously and significantly to Polaris are welcome, but
shall not use the Polaris chat as a vehicle for their own marketing without explicit approval of the project (P)PMC.

## Code of Conduct

The [Apache Software Foundation’s Code of Conduct](https://www.apache.org/foundation/policies/conduct.html) applies to
the Polaris project public chat.

## Governance

* The Polaris project’s chat tool is not provided by the ASF - the Polaris project (P)PMC members govern and monitor the
  chat service.
* Everybody is welcome to join the Polaris project chat. Invites are not needed.
* Polaris project (P)PMC members have “administrator” privileges on the Slack chat. Polaris project committers are granted
  “moderator” or “administrator” privileges for moderation purposes.
* This bylaws document shall be published on the project’s web site and linked from relevant public channels.
* Only (P)PMC members are allowed to create new channels. The number of channels shall be limited to #general (user
  discussions), #dev (development discussions), #announcements (release announcements), and #noise (GitHub feed).
* Only (P)PMC members are allowed to notify a large number of users (aka @here).

## 3rd Parties

Definition: “3rd party” means any (other) open-source project or any commercial vendor or any other organization.

### 3rd Party Channels

* 3rd parties who contribute to or use the Polaris project may ask the (P)PMC to get a dedicated public channel, for
  example #vendor-<vendor-name> or #project-<project-name>.
* Promotion of 3rd party content is only permitted in these 3rd party channels, and only if the content primarily covers
  Polaris. Commercial advertisements in any form are prohibited.
* Interaction with users of 3rd party OSS projects or commercial products should be directed to these 3rd party
  channels.

## Content moderation

* Any content which violates the Apache “Code of Conduct” will be removed.
* Any commercial advertisements will be removed.
* All other content will not be moderated.
