#
# Licensed to the Apache Software Foundation (ASF) under one
# or more contributor license agreements.  See the NOTICE file
# distributed with this work for additional information
# regarding copyright ownership.  The ASF licenses this file
# to you under the Apache License, Version 2.0 (the
# "License"); you may not use this file except in compliance
# with the License.  You may obtain a copy of the License at
#
#   http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing,
# software distributed under the License is distributed on an
# "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
# KIND, either express or implied.  See the License for the
# specific language governing permissions and limitations
# under the License.
#

# coding: utf-8

"""
    Apache Iceberg REST Catalog API

    Defines the specification for the first version of the REST Catalog API. Implementations should ideally support both Iceberg table specs v1 and v2, with priority given to v2.

    The version of the OpenAPI document: 0.0.1
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictInt, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from polaris.catalog.models.expression import Expression
from polaris.catalog.models.metric_result import MetricResult
from typing import Optional, Set
from typing_extensions import Self

class ScanReport(BaseModel):
    """
    ScanReport
    """ # noqa: E501
    table_name: StrictStr = Field(alias="table-name")
    snapshot_id: StrictInt = Field(alias="snapshot-id")
    filter: Expression
    schema_id: StrictInt = Field(alias="schema-id")
    projected_field_ids: List[StrictInt] = Field(alias="projected-field-ids")
    projected_field_names: List[StrictStr] = Field(alias="projected-field-names")
    metrics: Dict[str, MetricResult]
    metadata: Optional[Dict[str, StrictStr]] = None
    __properties: ClassVar[List[str]] = ["table-name", "snapshot-id", "filter", "schema-id", "projected-field-ids", "projected-field-names", "metrics", "metadata"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of ScanReport from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of filter
        if self.filter:
            _dict['filter'] = self.filter.to_dict()
        # override the default output from pydantic by calling `to_dict()` of each value in metrics (dict)
        _field_dict = {}
        if self.metrics:
            for _key_metrics in self.metrics:
                if self.metrics[_key_metrics]:
                    _field_dict[_key_metrics] = self.metrics[_key_metrics].to_dict()
            _dict['metrics'] = _field_dict
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of ScanReport from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "table-name": obj.get("table-name"),
            "snapshot-id": obj.get("snapshot-id"),
            "filter": Expression.from_dict(obj["filter"]) if obj.get("filter") is not None else None,
            "schema-id": obj.get("schema-id"),
            "projected-field-ids": obj.get("projected-field-ids"),
            "projected-field-names": obj.get("projected-field-names"),
            "metrics": dict(
                (_k, MetricResult.from_dict(_v))
                for _k, _v in obj["metrics"].items()
            )
            if obj.get("metrics") is not None
            else None,
            "metadata": obj.get("metadata")
        })
        return _obj


