/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gravitino.trino.connector.system;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.trino.spi.HostAddress;
import io.trino.spi.Page;
import io.trino.spi.connector.ColumnHandle;
import io.trino.spi.connector.Connector;
import io.trino.spi.connector.ConnectorMetadata;
import io.trino.spi.connector.ConnectorPageSource;
import io.trino.spi.connector.ConnectorPageSourceProvider;
import io.trino.spi.connector.ConnectorSession;
import io.trino.spi.connector.ConnectorSplit;
import io.trino.spi.connector.ConnectorSplitManager;
import io.trino.spi.connector.ConnectorSplitSource;
import io.trino.spi.connector.ConnectorTableHandle;
import io.trino.spi.connector.ConnectorTransactionHandle;
import io.trino.spi.connector.Constraint;
import io.trino.spi.connector.DynamicFilter;
import io.trino.spi.connector.FixedSplitSource;
import io.trino.spi.connector.SchemaTableName;
import io.trino.spi.procedure.Procedure;
import io.trino.spi.transaction.IsolationLevel;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.apache.gravitino.trino.connector.system.GravitinoSystemConnectorMetadata;
import org.apache.gravitino.trino.connector.system.storedprocdure.GravitinoStoredProcedureFactory;
import org.apache.gravitino.trino.connector.system.table.GravitinoSystemTableFactory;

public class GravitinoSystemConnector
implements Connector {
    private final GravitinoStoredProcedureFactory gravitinoStoredProcedureFactory;

    public GravitinoSystemConnector(GravitinoStoredProcedureFactory gravitinoStoredProcedureFactory) {
        this.gravitinoStoredProcedureFactory = gravitinoStoredProcedureFactory;
    }

    public ConnectorTransactionHandle beginTransaction(IsolationLevel isolationLevel, boolean readOnly, boolean autoCommit) {
        return TransactionHandle.INSTANCE;
    }

    public Set<Procedure> getProcedures() {
        return this.gravitinoStoredProcedureFactory.getStoredProcedures();
    }

    public ConnectorMetadata getMetadata(ConnectorSession session, ConnectorTransactionHandle transactionHandle) {
        return new GravitinoSystemConnectorMetadata();
    }

    public ConnectorSplitManager getSplitManager() {
        return new SplitManager();
    }

    public ConnectorPageSourceProvider getPageSourceProvider() {
        return new DatasourceProvider();
    }

    public static enum TransactionHandle implements ConnectorTransactionHandle
    {
        INSTANCE;

    }

    public static class SplitManager
    implements ConnectorSplitManager {
        public ConnectorSplitSource getSplits(ConnectorTransactionHandle transaction, ConnectorSession session, ConnectorTableHandle connectorTableHandle, DynamicFilter dynamicFilter, Constraint constraint) {
            SchemaTableName tableName = ((GravitinoSystemConnectorMetadata.SystemTableHandle)connectorTableHandle).getName();
            return new FixedSplitSource((ConnectorSplit)new Split(tableName));
        }
    }

    public static class DatasourceProvider
    implements ConnectorPageSourceProvider {
        public ConnectorPageSource createPageSource(ConnectorTransactionHandle transaction, ConnectorSession session, ConnectorSplit split, ConnectorTableHandle table, List<ColumnHandle> columns, DynamicFilter dynamicFilter) {
            SchemaTableName tableName = ((GravitinoSystemConnectorMetadata.SystemTableHandle)table).getName();
            return new SystemTablePageSource(GravitinoSystemTableFactory.loadPageData(tableName));
        }
    }

    public static class SystemTablePageSource
    implements ConnectorPageSource {
        private boolean isFinished = false;
        private final Page page;

        public SystemTablePageSource(Page page) {
            this.page = page;
        }

        public long getCompletedBytes() {
            return 0L;
        }

        public long getReadTimeNanos() {
            return 0L;
        }

        public boolean isFinished() {
            return this.isFinished;
        }

        public Page getNextPage() {
            this.isFinished = true;
            return this.page;
        }

        public long getMemoryUsage() {
            return 0L;
        }

        public void close() throws IOException {
        }
    }

    public static class Split
    implements ConnectorSplit {
        private final SchemaTableName tableName;

        @JsonCreator
        public Split(@JsonProperty(value="tableName") SchemaTableName tableName) {
            this.tableName = tableName;
        }

        @JsonProperty
        public SchemaTableName getTableName() {
            return this.tableName;
        }

        public boolean isRemotelyAccessible() {
            return true;
        }

        public List<HostAddress> getAddresses() {
            return Collections.emptyList();
        }

        public Object getInfo() {
            return this;
        }
    }
}

