/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gravitino.trino.connector;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import io.trino.spi.ErrorCodeSupplier;
import io.trino.spi.TrinoException;
import io.trino.spi.connector.Connector;
import io.trino.spi.connector.ConnectorContext;
import io.trino.spi.connector.ConnectorFactory;
import java.util.Map;
import java.util.function.Supplier;
import org.apache.commons.lang3.StringUtils;
import org.apache.gravitino.client.GravitinoAdminClient;
import org.apache.gravitino.trino.connector.GravitinoConfig;
import org.apache.gravitino.trino.connector.GravitinoErrorCode;
import org.apache.gravitino.trino.connector.catalog.CatalogConnectorFactory;
import org.apache.gravitino.trino.connector.catalog.CatalogConnectorManager;
import org.apache.gravitino.trino.connector.catalog.CatalogRegister;
import org.apache.gravitino.trino.connector.catalog.DefaultCatalogConnectorFactory;
import org.apache.gravitino.trino.connector.system.GravitinoSystemConnector;
import org.apache.gravitino.trino.connector.system.storedprocdure.GravitinoStoredProcedureFactory;
import org.apache.gravitino.trino.connector.system.table.GravitinoSystemTableFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GravitinoConnectorFactory
implements ConnectorFactory {
    private static final Logger LOG = LoggerFactory.getLogger(GravitinoConnectorFactory.class);
    public static final String DEFAULT_CONNECTOR_NAME = "gravitino";
    private GravitinoSystemTableFactory gravitinoSystemTableFactory;
    private CatalogConnectorManager catalogConnectorManager;

    public String getName() {
        return DEFAULT_CONNECTOR_NAME;
    }

    @VisibleForTesting
    public CatalogConnectorManager getCatalogConnectorManager() {
        return this.catalogConnectorManager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Connector create(String catalogName, Map<String, String> requiredConfig, ConnectorContext context) {
        Preconditions.checkArgument((requiredConfig != null ? 1 : 0) != 0, (Object)"requiredConfig is not null");
        GravitinoConfig config = new GravitinoConfig(requiredConfig);
        GravitinoConnectorFactory gravitinoConnectorFactory = this;
        synchronized (gravitinoConnectorFactory) {
            if (this.catalogConnectorManager == null) {
                try {
                    CatalogRegister catalogRegister = new CatalogRegister();
                    CatalogConnectorFactory catalogConnectorFactory = this.createCatalogConnectorFactory(config);
                    this.catalogConnectorManager = new CatalogConnectorManager(catalogRegister, catalogConnectorFactory);
                    this.catalogConnectorManager.config(config, this.clientProvider().get());
                    this.catalogConnectorManager.start(context);
                    this.gravitinoSystemTableFactory = new GravitinoSystemTableFactory(this.catalogConnectorManager);
                }
                catch (Exception e) {
                    String message = "Initialization of the GravitinoConnector failed " + e.getMessage();
                    LOG.error(message);
                    throw new TrinoException((ErrorCodeSupplier)GravitinoErrorCode.GRAVITINO_RUNTIME_ERROR, message, (Throwable)e);
                }
            }
        }
        if (config.isDynamicConnector()) {
            return this.catalogConnectorManager.createConnector(catalogName, config, context);
        }
        String metalake = config.getMetalake();
        if (Strings.isNullOrEmpty((String)metalake)) {
            throw new TrinoException((ErrorCodeSupplier)GravitinoErrorCode.GRAVITINO_METALAKE_NOT_EXISTS, "No gravitino metalake selected");
        }
        if (config.simplifyCatalogNames() && !this.catalogConnectorManager.getUsedMetalakes().isEmpty()) {
            throw new TrinoException((ErrorCodeSupplier)GravitinoErrorCode.GRAVITINO_MISSING_CONFIG, "Multiple metalakes are not supported when setting gravitino.simplify-catalog-names = true");
        }
        this.catalogConnectorManager.addMetalake(metalake);
        GravitinoStoredProcedureFactory gravitinoStoredProcedureFactory = new GravitinoStoredProcedureFactory(this.catalogConnectorManager, metalake);
        return new GravitinoSystemConnector(gravitinoStoredProcedureFactory);
    }

    @VisibleForTesting
    Supplier<GravitinoAdminClient> clientProvider() {
        return () -> null;
    }

    private CatalogConnectorFactory createCatalogConnectorFactory(GravitinoConfig config) {
        String className = config.getCatalogConnectorFactoryClassName();
        if (StringUtils.isEmpty((CharSequence)className)) {
            return new DefaultCatalogConnectorFactory(config);
        }
        try {
            Class<?> clazz = Class.forName(className);
            Object obj = clazz.getDeclaredConstructor(GravitinoConfig.class).newInstance(config);
            return (CatalogConnectorFactory)obj;
        }
        catch (Exception e) {
            throw new TrinoException((ErrorCodeSupplier)GravitinoErrorCode.GRAVITINO_RUNTIME_ERROR, "Can not create CatalogConnectorFactory ", (Throwable)e);
        }
    }
}

