/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gravitino.client;

import java.util.Arrays;
import java.util.Collections;
import java.util.Locale;
import org.apache.gravitino.MetadataObject;
import org.apache.gravitino.client.ErrorHandlers;
import org.apache.gravitino.client.GenericTag;
import org.apache.gravitino.client.RESTClient;
import org.apache.gravitino.dto.requests.TagsAssociateRequest;
import org.apache.gravitino.dto.responses.NameListResponse;
import org.apache.gravitino.dto.responses.TagListResponse;
import org.apache.gravitino.dto.responses.TagResponse;
import org.apache.gravitino.dto.tag.TagDTO;
import org.apache.gravitino.exceptions.NoSuchTagException;
import org.apache.gravitino.rest.RESTRequest;
import org.apache.gravitino.rest.RESTUtils;
import org.apache.gravitino.shaded.com.google.common.base.Preconditions;
import org.apache.gravitino.shaded.com.google.common.collect.ImmutableMap;
import org.apache.gravitino.shaded.org.apache.commons.lang3.StringUtils;
import org.apache.gravitino.tag.SupportsTags;
import org.apache.gravitino.tag.Tag;

class MetadataObjectTagOperations
implements SupportsTags {
    private final String metalakeName;
    private final RESTClient restClient;
    private final String tagRequestPath;

    MetadataObjectTagOperations(String metalakeName, MetadataObject metadataObject, RESTClient restClient) {
        this.metalakeName = metalakeName;
        this.restClient = restClient;
        this.tagRequestPath = String.format("api/metalakes/%s/objects/%s/%s/tags", metalakeName, metadataObject.type().name().toLowerCase(Locale.ROOT), metadataObject.fullName());
    }

    @Override
    public String[] listTags() {
        NameListResponse resp = this.restClient.get(this.tagRequestPath, NameListResponse.class, Collections.emptyMap(), ErrorHandlers.tagErrorHandler());
        resp.validate();
        return resp.getNames();
    }

    @Override
    public Tag[] listTagsInfo() {
        TagListResponse resp = this.restClient.get(this.tagRequestPath, ImmutableMap.of("details", "true"), TagListResponse.class, Collections.emptyMap(), ErrorHandlers.tagErrorHandler());
        resp.validate();
        return (Tag[])Arrays.stream(resp.getTags()).map(tagDTO -> new GenericTag((TagDTO)tagDTO, this.restClient, this.metalakeName)).toArray(Tag[]::new);
    }

    @Override
    public Tag getTag(String name) throws NoSuchTagException {
        Preconditions.checkArgument(StringUtils.isNotBlank(name), "Tag name must not be null or empty");
        TagResponse resp = this.restClient.get(this.tagRequestPath + "/" + RESTUtils.encodeString(name), TagResponse.class, Collections.emptyMap(), ErrorHandlers.tagErrorHandler());
        resp.validate();
        return new GenericTag(resp.getTag(), this.restClient, this.metalakeName);
    }

    @Override
    public String[] associateTags(String[] tagsToAdd, String[] tagsToRemove) {
        TagsAssociateRequest request = new TagsAssociateRequest(tagsToAdd, tagsToRemove);
        request.validate();
        NameListResponse resp = this.restClient.post(this.tagRequestPath, (RESTRequest)request, NameListResponse.class, Collections.emptyMap(), ErrorHandlers.tagErrorHandler());
        resp.validate();
        return resp.getNames();
    }
}

