/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gravitino.dto.responses;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Preconditions;
import org.apache.commons.lang3.StringUtils;
import org.apache.gravitino.dto.messaging.TopicDTO;
import org.apache.gravitino.dto.responses.BaseResponse;

public class TopicResponse
extends BaseResponse {
    @JsonProperty(value="topic")
    private final TopicDTO topic;

    public TopicResponse(TopicDTO topic) {
        super(0);
        this.topic = topic;
    }

    public TopicResponse() {
        this.topic = null;
    }

    @Override
    public void validate() throws IllegalArgumentException {
        super.validate();
        Preconditions.checkArgument((this.topic != null ? 1 : 0) != 0, (Object)"topic must not be null");
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)this.topic.name()), (Object)"topic 'name' must not be null and empty");
    }

    public TopicDTO getTopic() {
        return this.topic;
    }

    @Override
    public String toString() {
        return "TopicResponse(topic=" + this.getTopic() + ")";
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof TopicResponse)) {
            return false;
        }
        TopicResponse other = (TopicResponse)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        TopicDTO this$topic = this.getTopic();
        TopicDTO other$topic = other.getTopic();
        return !(this$topic == null ? other$topic != null : !((Object)this$topic).equals(other$topic));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof TopicResponse;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        TopicDTO $topic = this.getTopic();
        result = result * 59 + ($topic == null ? 43 : ((Object)$topic).hashCode());
        return result;
    }
}

