/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gravitino.listener;

import java.util.Map;
import org.apache.gravitino.NameIdentifier;
import org.apache.gravitino.Namespace;
import org.apache.gravitino.catalog.ModelDispatcher;
import org.apache.gravitino.exceptions.ModelAlreadyExistsException;
import org.apache.gravitino.exceptions.ModelVersionAliasesAlreadyExistException;
import org.apache.gravitino.exceptions.NoSuchModelException;
import org.apache.gravitino.exceptions.NoSuchModelVersionException;
import org.apache.gravitino.exceptions.NoSuchSchemaException;
import org.apache.gravitino.listener.EventBus;
import org.apache.gravitino.listener.api.event.AlterModelEvent;
import org.apache.gravitino.listener.api.event.AlterModelFailureEvent;
import org.apache.gravitino.listener.api.event.AlterModelPreEvent;
import org.apache.gravitino.listener.api.event.AlterModelVersionEvent;
import org.apache.gravitino.listener.api.event.AlterModelVersionFailureEvent;
import org.apache.gravitino.listener.api.event.AlterModelVersionPreEvent;
import org.apache.gravitino.listener.api.event.DeleteModelEvent;
import org.apache.gravitino.listener.api.event.DeleteModelFailureEvent;
import org.apache.gravitino.listener.api.event.DeleteModelPreEvent;
import org.apache.gravitino.listener.api.event.DeleteModelVersionEvent;
import org.apache.gravitino.listener.api.event.DeleteModelVersionFailureEvent;
import org.apache.gravitino.listener.api.event.DeleteModelVersionPreEvent;
import org.apache.gravitino.listener.api.event.GetModelEvent;
import org.apache.gravitino.listener.api.event.GetModelFailureEvent;
import org.apache.gravitino.listener.api.event.GetModelPreEvent;
import org.apache.gravitino.listener.api.event.GetModelVersionEvent;
import org.apache.gravitino.listener.api.event.GetModelVersionFailureEvent;
import org.apache.gravitino.listener.api.event.GetModelVersionPreEvent;
import org.apache.gravitino.listener.api.event.LinkModelVersionEvent;
import org.apache.gravitino.listener.api.event.LinkModelVersionFailureEvent;
import org.apache.gravitino.listener.api.event.LinkModelVersionPreEvent;
import org.apache.gravitino.listener.api.event.ListModelEvent;
import org.apache.gravitino.listener.api.event.ListModelFailureEvent;
import org.apache.gravitino.listener.api.event.ListModelPreEvent;
import org.apache.gravitino.listener.api.event.ListModelVersionFailureEvent;
import org.apache.gravitino.listener.api.event.ListModelVersionPreEvent;
import org.apache.gravitino.listener.api.event.ListModelVersionsEvent;
import org.apache.gravitino.listener.api.event.RegisterAndLinkModelEvent;
import org.apache.gravitino.listener.api.event.RegisterAndLinkModelFailureEvent;
import org.apache.gravitino.listener.api.event.RegisterAndLinkModelPreEvent;
import org.apache.gravitino.listener.api.event.RegisterModelEvent;
import org.apache.gravitino.listener.api.event.RegisterModelFailureEvent;
import org.apache.gravitino.listener.api.event.RegisterModelPreEvent;
import org.apache.gravitino.listener.api.info.Either;
import org.apache.gravitino.listener.api.info.ModelInfo;
import org.apache.gravitino.listener.api.info.ModelVersionInfo;
import org.apache.gravitino.model.Model;
import org.apache.gravitino.model.ModelChange;
import org.apache.gravitino.model.ModelVersion;
import org.apache.gravitino.model.ModelVersionChange;
import org.apache.gravitino.utils.PrincipalUtils;

public class ModelEventDispatcher
implements ModelDispatcher {
    private final EventBus eventBus;
    private final ModelDispatcher dispatcher;

    public ModelEventDispatcher(EventBus eventBus, ModelDispatcher dispatcher) {
        this.eventBus = eventBus;
        this.dispatcher = dispatcher;
    }

    public Model registerModel(NameIdentifier ident, String comment, Map<String, String> properties) throws NoSuchSchemaException, ModelAlreadyExistsException {
        String user = PrincipalUtils.getCurrentUserName();
        ModelInfo registerRequest = new ModelInfo(ident.name(), properties, comment);
        this.eventBus.dispatchEvent(new RegisterModelPreEvent(user, ident, registerRequest));
        try {
            Model model = this.dispatcher.registerModel(ident, comment, properties);
            ModelInfo registeredModel = new ModelInfo(model);
            this.eventBus.dispatchEvent(new RegisterModelEvent(user, ident, registeredModel));
            return model;
        }
        catch (Exception e) {
            this.eventBus.dispatchEvent(new RegisterModelFailureEvent(user, ident, e, registerRequest));
            throw e;
        }
    }

    public Model registerModel(NameIdentifier ident, String uri, String[] aliases, String comment, Map<String, String> properties) throws NoSuchSchemaException, ModelAlreadyExistsException, ModelVersionAliasesAlreadyExistException {
        ModelInfo registerModelRequest = new ModelInfo(ident.name(), properties, comment);
        ModelVersionInfo linkModelVersionRequest = new ModelVersionInfo(uri, comment, properties, aliases);
        String user = PrincipalUtils.getCurrentUserName();
        RegisterAndLinkModelPreEvent registerAndLinkModelPreEvent = new RegisterAndLinkModelPreEvent(user, ident, registerModelRequest, linkModelVersionRequest);
        this.eventBus.dispatchEvent(registerAndLinkModelPreEvent);
        try {
            Model registeredModel = this.dispatcher.registerModel(ident, uri, aliases, comment, properties);
            ModelInfo registeredModelInfo = new ModelInfo(registeredModel);
            this.eventBus.dispatchEvent(new RegisterAndLinkModelEvent(user, ident, registeredModelInfo, uri));
            return registeredModel;
        }
        catch (Exception e) {
            this.eventBus.dispatchEvent(new RegisterAndLinkModelFailureEvent(user, ident, e, registerModelRequest, linkModelVersionRequest));
            throw e;
        }
    }

    public Model getModel(NameIdentifier ident) throws NoSuchModelException {
        String user = PrincipalUtils.getCurrentUserName();
        this.eventBus.dispatchEvent(new GetModelPreEvent(user, ident));
        try {
            Model model = this.dispatcher.getModel(ident);
            ModelInfo modelInfo = new ModelInfo(model);
            this.eventBus.dispatchEvent(new GetModelEvent(user, ident, modelInfo));
            return model;
        }
        catch (Exception e) {
            this.eventBus.dispatchEvent(new GetModelFailureEvent(user, ident, e));
            throw e;
        }
    }

    public boolean deleteModel(NameIdentifier ident) {
        String user = PrincipalUtils.getCurrentUserName();
        this.eventBus.dispatchEvent(new DeleteModelPreEvent(user, ident));
        try {
            boolean isExists = this.dispatcher.deleteModel(ident);
            this.eventBus.dispatchEvent(new DeleteModelEvent(user, ident, isExists));
            return isExists;
        }
        catch (Exception e) {
            this.eventBus.dispatchEvent(new DeleteModelFailureEvent(user, ident, e));
            throw e;
        }
    }

    public NameIdentifier[] listModels(Namespace namespace) throws NoSuchSchemaException {
        String user = PrincipalUtils.getCurrentUserName();
        this.eventBus.dispatchEvent(new ListModelPreEvent(user, namespace));
        try {
            NameIdentifier[] models = this.dispatcher.listModels(namespace);
            this.eventBus.dispatchEvent(new ListModelEvent(user, namespace));
            return models;
        }
        catch (Exception e) {
            this.eventBus.dispatchEvent(new ListModelFailureEvent(user, namespace, e));
            throw e;
        }
    }

    public void linkModelVersion(NameIdentifier ident, String uri, String[] aliases, String comment, Map<String, String> properties) throws NoSuchModelException, ModelVersionAliasesAlreadyExistException {
        ModelVersionInfo linkModelRequest = new ModelVersionInfo(uri, comment, properties, aliases);
        String user = PrincipalUtils.getCurrentUserName();
        this.eventBus.dispatchEvent(new LinkModelVersionPreEvent(user, ident, linkModelRequest));
        try {
            this.dispatcher.linkModelVersion(ident, uri, aliases, comment, properties);
            this.eventBus.dispatchEvent(new LinkModelVersionEvent(user, ident, linkModelRequest));
        }
        catch (Exception e) {
            this.eventBus.dispatchEvent(new LinkModelVersionFailureEvent(user, ident, e, linkModelRequest));
            throw e;
        }
    }

    public ModelVersion getModelVersion(NameIdentifier ident, int version) throws NoSuchModelVersionException {
        String user = PrincipalUtils.getCurrentUserName();
        this.eventBus.dispatchEvent(new GetModelVersionPreEvent(user, ident, null, version));
        try {
            ModelVersion modelVersion = this.dispatcher.getModelVersion(ident, version);
            ModelVersionInfo modelVersionInfo = new ModelVersionInfo(modelVersion);
            this.eventBus.dispatchEvent(new GetModelVersionEvent(user, ident, modelVersionInfo, null, version));
            return modelVersion;
        }
        catch (Exception e) {
            this.eventBus.dispatchEvent(new GetModelVersionFailureEvent(user, ident, e, null, version));
            throw e;
        }
    }

    public ModelVersion getModelVersion(NameIdentifier ident, String alias) throws NoSuchModelVersionException {
        String user = PrincipalUtils.getCurrentUserName();
        this.eventBus.dispatchEvent(new GetModelVersionPreEvent(user, ident, alias, null));
        try {
            ModelVersion modelVersion = this.dispatcher.getModelVersion(ident, alias);
            ModelVersionInfo modelVersionInfo = new ModelVersionInfo(modelVersion);
            this.eventBus.dispatchEvent(new GetModelVersionEvent(user, ident, modelVersionInfo, alias, null));
            return modelVersion;
        }
        catch (Exception e) {
            this.eventBus.dispatchEvent(new GetModelVersionFailureEvent(user, ident, e, alias, null));
            throw e;
        }
    }

    public boolean deleteModelVersion(NameIdentifier ident, int version) {
        String user = PrincipalUtils.getCurrentUserName();
        this.eventBus.dispatchEvent(new DeleteModelVersionPreEvent(user, ident, null, version));
        try {
            boolean isExists = this.dispatcher.deleteModelVersion(ident, version);
            this.eventBus.dispatchEvent(new DeleteModelVersionEvent(user, ident, isExists, null, version));
            return isExists;
        }
        catch (Exception e) {
            this.eventBus.dispatchEvent(new DeleteModelVersionFailureEvent(user, ident, e, null, version));
            throw e;
        }
    }

    public boolean deleteModelVersion(NameIdentifier ident, String alias) {
        String user = PrincipalUtils.getCurrentUserName();
        this.eventBus.dispatchEvent(new DeleteModelVersionPreEvent(user, ident, alias, null));
        try {
            boolean isExists = this.dispatcher.deleteModelVersion(ident, alias);
            this.eventBus.dispatchEvent(new DeleteModelVersionEvent(user, ident, isExists, alias, null));
            return isExists;
        }
        catch (Exception e) {
            this.eventBus.dispatchEvent(new DeleteModelVersionFailureEvent(user, ident, e, alias, null));
            throw e;
        }
    }

    public Model alterModel(NameIdentifier ident, ModelChange ... changes) throws NoSuchModelException, IllegalArgumentException {
        String user = PrincipalUtils.getCurrentUserName();
        this.eventBus.dispatchEvent(new AlterModelPreEvent(user, ident, changes));
        try {
            Model modelObject = this.dispatcher.alterModel(ident, changes);
            ModelInfo modelInfo = new ModelInfo(modelObject);
            this.eventBus.dispatchEvent(new AlterModelEvent(user, ident, modelInfo, changes));
            return modelObject;
        }
        catch (Exception e) {
            this.eventBus.dispatchEvent(new AlterModelFailureEvent(user, ident, e, changes));
            throw e;
        }
    }

    public ModelVersion alterModelVersion(NameIdentifier ident, int version, ModelVersionChange ... changes) throws NoSuchModelException, NoSuchModelVersionException, IllegalArgumentException {
        String initiator = PrincipalUtils.getCurrentUserName();
        this.eventBus.dispatchEvent(new AlterModelVersionPreEvent(initiator, ident, Either.right(version), changes));
        try {
            ModelVersion modelVersion = this.dispatcher.alterModelVersion(ident, version, changes);
            this.eventBus.dispatchEvent(new AlterModelVersionEvent(initiator, ident, new ModelVersionInfo(modelVersion), changes));
            return modelVersion;
        }
        catch (Exception e) {
            this.eventBus.dispatchEvent(new AlterModelVersionFailureEvent(initiator, ident, e, Either.right(version), changes));
            throw e;
        }
    }

    public ModelVersion alterModelVersion(NameIdentifier ident, String alias, ModelVersionChange ... changes) throws NoSuchModelException, IllegalArgumentException {
        String initiator = PrincipalUtils.getCurrentUserName();
        this.eventBus.dispatchEvent(new AlterModelVersionPreEvent(initiator, ident, Either.left(alias), changes));
        try {
            ModelVersion modelVersion = this.dispatcher.alterModelVersion(ident, alias, changes);
            this.eventBus.dispatchEvent(new AlterModelVersionEvent(initiator, ident, new ModelVersionInfo(modelVersion), changes));
            return modelVersion;
        }
        catch (Exception e) {
            this.eventBus.dispatchEvent(new AlterModelVersionFailureEvent(initiator, ident, e, Either.left(alias), changes));
            throw e;
        }
    }

    public int[] listModelVersions(NameIdentifier ident) throws NoSuchModelException {
        String user = PrincipalUtils.getCurrentUserName();
        this.eventBus.dispatchEvent(new ListModelVersionPreEvent(user, ident));
        try {
            int[] versions = this.dispatcher.listModelVersions(ident);
            this.eventBus.dispatchEvent(new ListModelVersionsEvent(user, ident, versions));
            return versions;
        }
        catch (Exception e) {
            this.eventBus.dispatchEvent(new ListModelVersionFailureEvent(user, ident, e));
            throw e;
        }
    }

    public boolean modelExists(NameIdentifier ident) {
        return this.dispatcher.modelExists(ident);
    }

    public boolean modelVersionExists(NameIdentifier ident, int version) {
        return this.dispatcher.modelVersionExists(ident, version);
    }

    public boolean modelVersionExists(NameIdentifier ident, String alias) {
        return this.dispatcher.modelVersionExists(ident, alias);
    }
}

