/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gravitino.connector;

import javax.annotation.Nullable;
import org.apache.gravitino.annotation.Evolving;
import org.apache.gravitino.rel.Column;
import org.apache.gravitino.rel.expressions.Expression;
import org.apache.gravitino.rel.types.Type;

@Evolving
public abstract class BaseColumn
implements Column {
    protected String name;
    @Nullable
    protected String comment;
    protected Type dataType;
    protected boolean nullable;
    protected boolean autoIncrement;
    protected Expression defaultValue;

    public String name() {
        return this.name;
    }

    public Type dataType() {
        return this.dataType;
    }

    @Nullable
    public String comment() {
        return this.comment;
    }

    public boolean nullable() {
        return this.nullable;
    }

    public boolean autoIncrement() {
        return this.autoIncrement;
    }

    public Expression defaultValue() {
        return this.defaultValue;
    }

    public String toString() {
        return "BaseColumn(name=" + this.name + ", comment=" + this.comment + ", dataType=" + this.dataType + ", nullable=" + this.nullable + ", autoIncrement=" + this.autoIncrement + ", defaultValue=" + this.defaultValue + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof BaseColumn)) {
            return false;
        }
        BaseColumn other = (BaseColumn)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.nullable != other.nullable) {
            return false;
        }
        if (this.autoIncrement != other.autoIncrement) {
            return false;
        }
        String this$name = this.name;
        String other$name = other.name;
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        String this$comment = this.comment;
        String other$comment = other.comment;
        if (this$comment == null ? other$comment != null : !this$comment.equals(other$comment)) {
            return false;
        }
        Type this$dataType = this.dataType;
        Type other$dataType = other.dataType;
        if (this$dataType == null ? other$dataType != null : !this$dataType.equals(other$dataType)) {
            return false;
        }
        Expression this$defaultValue = this.defaultValue;
        Expression other$defaultValue = other.defaultValue;
        return !(this$defaultValue == null ? other$defaultValue != null : !this$defaultValue.equals(other$defaultValue));
    }

    protected boolean canEqual(Object other) {
        return other instanceof BaseColumn;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.nullable ? 79 : 97);
        result = result * 59 + (this.autoIncrement ? 79 : 97);
        String $name = this.name;
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        String $comment = this.comment;
        result = result * 59 + ($comment == null ? 43 : $comment.hashCode());
        Type $dataType = this.dataType;
        result = result * 59 + ($dataType == null ? 43 : $dataType.hashCode());
        Expression $defaultValue = this.defaultValue;
        result = result * 59 + ($defaultValue == null ? 43 : $defaultValue.hashCode());
        return result;
    }

    public static abstract class BaseColumnBuilder<SELF extends Builder<SELF, T>, T extends BaseColumn>
    implements Builder<SELF, T> {
        protected String name;
        protected String comment;
        protected Type dataType;
        protected boolean nullable = true;
        protected boolean autoIncrement = false;
        protected Expression defaultValue;

        @Override
        public SELF withName(String name) {
            this.name = name;
            return this.self();
        }

        @Override
        public SELF withComment(String comment) {
            this.comment = comment;
            return this.self();
        }

        @Override
        public SELF withType(Type dataType) {
            this.dataType = dataType;
            return this.self();
        }

        @Override
        public SELF withNullable(boolean nullable) {
            this.nullable = nullable;
            return this.self();
        }

        @Override
        public SELF withAutoIncrement(boolean autoIncrement) {
            this.autoIncrement = autoIncrement;
            return this.self();
        }

        @Override
        public SELF withDefaultValue(Expression defaultValue) {
            this.defaultValue = defaultValue;
            return this.self();
        }

        @Override
        public T build() {
            T t = this.internalBuild();
            return t;
        }

        private SELF self() {
            return (SELF)this;
        }

        @Evolving
        protected abstract T internalBuild();
    }

    static interface Builder<SELF extends Builder<SELF, T>, T extends BaseColumn> {
        public SELF withName(String var1);

        public SELF withComment(String var1);

        public SELF withType(Type var1);

        public SELF withNullable(boolean var1);

        public SELF withAutoIncrement(boolean var1);

        public SELF withDefaultValue(Expression var1);

        public T build();
    }
}

