/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gravitino.authorization;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.gravitino.Entity;
import org.apache.gravitino.EntityStore;
import org.apache.gravitino.MetadataObject;
import org.apache.gravitino.MetadataObjects;
import org.apache.gravitino.NameIdentifier;
import org.apache.gravitino.SupportsRelationOperations;
import org.apache.gravitino.authorization.AuthorizationUtils;
import org.apache.gravitino.authorization.Group;
import org.apache.gravitino.authorization.Owner;
import org.apache.gravitino.authorization.OwnerManager;
import org.apache.gravitino.authorization.SecurableObject;
import org.apache.gravitino.authorization.User;
import org.apache.gravitino.connector.BaseCatalog;
import org.apache.gravitino.connector.authorization.AuthorizationPlugin;
import org.apache.gravitino.meta.GroupEntity;
import org.apache.gravitino.meta.RoleEntity;
import org.apache.gravitino.meta.UserEntity;

public class FutureGrantManager {
    EntityStore entityStore;
    OwnerManager ownerManager;

    public FutureGrantManager(EntityStore entityStore, OwnerManager ownerManager) {
        this.entityStore = entityStore;
        this.ownerManager = ownerManager;
    }

    public void grantNewlyCreatedCatalog(String metalake, BaseCatalog catalog) {
        try {
            MetadataObject metalakeObject = MetadataObjects.of(null, (String)metalake, (MetadataObject.Type)MetadataObject.Type.METALAKE);
            Optional<Owner> ownerOptional = this.ownerManager.getOwner(metalake, metalakeObject);
            ownerOptional.ifPresent(owner -> {
                AuthorizationPlugin authorizationPlugin = catalog.getAuthorizationPlugin();
                if (authorizationPlugin != null) {
                    authorizationPlugin.onOwnerSet(metalakeObject, null, (Owner)owner);
                }
            });
            HashMap userGrantRoles = Maps.newHashMap();
            HashMap groupGrantRoles = Maps.newHashMap();
            List roles = this.entityStore.relationOperations().listEntitiesByRelation(SupportsRelationOperations.Type.METADATA_OBJECT_ROLE_REL, NameIdentifier.of((String[])new String[]{metalake}), Entity.EntityType.METALAKE).stream().map(entity -> (RoleEntity)entity).collect(Collectors.toList());
            for (RoleEntity roleEntity : roles) {
                boolean supportsFutureGrant = false;
                for (SecurableObject securableObject : roleEntity.securableObjects()) {
                    if (!AuthorizationUtils.needApplyAuthorizationPluginAllCatalogs(securableObject)) continue;
                    supportsFutureGrant = true;
                    break;
                }
                if (!supportsFutureGrant) continue;
                List users = this.entityStore.relationOperations().listEntitiesByRelation(SupportsRelationOperations.Type.ROLE_USER_REL, roleEntity.nameIdentifier(), Entity.EntityType.ROLE).stream().map(entity -> (UserEntity)entity).collect(Collectors.toList());
                for (UserEntity user : users) {
                    Set roleSet = userGrantRoles.computeIfAbsent(user, k -> Sets.newHashSet());
                    roleSet.add(roleEntity);
                }
                List list = this.entityStore.relationOperations().listEntitiesByRelation(SupportsRelationOperations.Type.ROLE_GROUP_REL, roleEntity.nameIdentifier(), Entity.EntityType.ROLE).stream().map(entity -> (GroupEntity)entity).collect(Collectors.toList());
                for (GroupEntity group : list) {
                    Set roleSet = groupGrantRoles.computeIfAbsent(group, k -> Sets.newHashSet());
                    roleSet.add(roleEntity);
                }
            }
            for (Map.Entry entry : userGrantRoles.entrySet()) {
                AuthorizationPlugin authorizationPlugin = catalog.getAuthorizationPlugin();
                if (authorizationPlugin == null) continue;
                authorizationPlugin.onGrantedRolesToUser(Lists.newArrayList((Iterable)((Iterable)entry.getValue())), (User)entry.getKey());
            }
            for (Map.Entry entry : groupGrantRoles.entrySet()) {
                AuthorizationPlugin authorizationPlugin = catalog.getAuthorizationPlugin();
                if (authorizationPlugin == null) continue;
                authorizationPlugin.onGrantedRolesToGroup(Lists.newArrayList((Iterable)((Iterable)entry.getValue())), (Group)entry.getKey());
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

