/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg;

import java.nio.charset.StandardCharsets;
import java.util.Map;
import org.apache.hadoop.fs.Path;
import org.apache.iceberg.PartitionSpec;
import org.apache.iceberg.StructLike;
import org.apache.iceberg.common.DynConstructors;
import org.apache.iceberg.io.LocationProvider;
import org.apache.iceberg.relocated.com.google.common.base.Preconditions;
import org.apache.iceberg.relocated.com.google.common.hash.HashCode;
import org.apache.iceberg.relocated.com.google.common.hash.HashFunction;
import org.apache.iceberg.relocated.com.google.common.hash.Hashing;
import org.apache.iceberg.relocated.com.google.common.io.BaseEncoding;
import org.apache.iceberg.util.LocationUtil;
import org.apache.iceberg.util.PropertyUtil;

public class LocationProviders {
    private LocationProviders() {
    }

    public static LocationProvider locationsFor(String inputLocation, Map<String, String> properties) {
        String location = LocationUtil.stripTrailingSlash(inputLocation);
        if (properties.containsKey("write.location-provider.impl")) {
            DynConstructors.Ctor ctor;
            String impl = properties.get("write.location-provider.impl");
            try {
                ctor = DynConstructors.builder(LocationProvider.class).impl(impl, new Class[]{String.class, Map.class}).impl(impl, new Class[0]).buildChecked();
            }
            catch (NoSuchMethodException e) {
                throw new IllegalArgumentException(String.format("Unable to find a constructor for implementation %s of %s. Make sure the implementation is in classpath, and that it either has a public no-arg constructor or a two-arg constructor taking in the string base table location and its property string map.", impl, LocationProvider.class), e);
            }
            try {
                return (LocationProvider)ctor.newInstance(new Object[]{location, properties});
            }
            catch (ClassCastException e) {
                throw new IllegalArgumentException(String.format("Provided implementation for dynamic instantiation should implement %s.", LocationProvider.class), e);
            }
        }
        if (PropertyUtil.propertyAsBoolean(properties, "write.object-storage.enabled", false)) {
            return new ObjectStoreLocationProvider(location, properties);
        }
        return new DefaultLocationProvider(location, properties);
    }

    static class ObjectStoreLocationProvider
    implements LocationProvider {
        private static final HashFunction HASH_FUNC = Hashing.murmur3_32_fixed();
        private static final BaseEncoding BASE64_ENCODER = BaseEncoding.base64Url().omitPadding();
        private static final ThreadLocal<byte[]> TEMP = ThreadLocal.withInitial(() -> new byte[4]);
        private final String storageLocation;
        private final String context;

        ObjectStoreLocationProvider(String tableLocation, Map<String, String> properties) {
            this.storageLocation = LocationUtil.stripTrailingSlash(ObjectStoreLocationProvider.dataLocation(properties, tableLocation));
            this.context = this.storageLocation.startsWith(tableLocation) ? null : ObjectStoreLocationProvider.pathContext(tableLocation);
        }

        private static String dataLocation(Map<String, String> properties, String tableLocation) {
            String dataLocation = properties.get("write.data.path");
            if (dataLocation == null && (dataLocation = properties.get("write.object-storage.path")) == null && (dataLocation = properties.get("write.folder-storage.path")) == null) {
                dataLocation = String.format("%s/data", tableLocation);
            }
            return dataLocation;
        }

        public String newDataLocation(PartitionSpec spec, StructLike partitionData, String filename) {
            return this.newDataLocation(String.format("%s/%s", spec.partitionToPath(partitionData), filename));
        }

        public String newDataLocation(String filename) {
            String hash = this.computeHash(filename);
            if (this.context != null) {
                return String.format("%s/%s/%s/%s", this.storageLocation, hash, this.context, filename);
            }
            return String.format("%s/%s/%s", this.storageLocation, hash, filename);
        }

        private static String pathContext(String tableLocation) {
            Path dataPath = new Path(tableLocation);
            Path parent = dataPath.getParent();
            String resolvedContext = parent != null ? String.format("%s/%s", parent.getName(), dataPath.getName()) : dataPath.getName();
            Preconditions.checkState((!resolvedContext.endsWith("/") ? 1 : 0) != 0, (Object)"Path context must not end with a slash.");
            return resolvedContext;
        }

        private String computeHash(String fileName) {
            byte[] bytes = TEMP.get();
            HashCode hash = HASH_FUNC.hashString((CharSequence)fileName, StandardCharsets.UTF_8);
            hash.writeBytesTo(bytes, 0, 4);
            return BASE64_ENCODER.encode(bytes);
        }
    }

    static class DefaultLocationProvider
    implements LocationProvider {
        private final String dataLocation;

        DefaultLocationProvider(String tableLocation, Map<String, String> properties) {
            this.dataLocation = LocationUtil.stripTrailingSlash(DefaultLocationProvider.dataLocation(properties, tableLocation));
        }

        private static String dataLocation(Map<String, String> properties, String tableLocation) {
            String dataLocation = properties.get("write.data.path");
            if (dataLocation == null && (dataLocation = properties.get("write.folder-storage.path")) == null) {
                dataLocation = String.format("%s/data", tableLocation);
            }
            return dataLocation;
        }

        public String newDataLocation(PartitionSpec spec, StructLike partitionData, String filename) {
            return String.format("%s/%s/%s", this.dataLocation, spec.partitionToPath(partitionData), filename);
        }

        public String newDataLocation(String filename) {
            return String.format("%s/%s", this.dataLocation, filename);
        }
    }
}

