/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gravitino.storage.relational.mapper.provider.base;

import java.util.List;
import org.apache.gravitino.storage.relational.po.SecurableObjectPO;
import org.apache.ibatis.annotations.Param;

public class SecurableObjectBaseSQLProvider {
    public String batchInsertSecurableObjects(@Param(value="securableObjects") List<SecurableObjectPO> securableObjectPOs) {
        return "<script>INSERT INTO role_meta_securable_object(role_id, metadata_object_id, type, privilege_names, privilege_conditions,  current_version, last_version, deleted_at) VALUES <foreach collection='securableObjects' item='item' separator=','>(#{item.roleId}, #{item.metadataObjectId}, #{item.type}, #{item.privilegeNames}, #{item.privilegeConditions}, #{item.currentVersion}, #{item.lastVersion}, #{item.deletedAt})</foreach></script>";
    }

    public String batchSoftDeleteSecurableObjects(@Param(value="securableObjects") List<SecurableObjectPO> securableObjectPOs) {
        return "<script>UPDATE role_meta_securable_object SET deleted_at = (UNIX_TIMESTAMP() * 1000.0) + EXTRACT(MICROSECOND FROM CURRENT_TIMESTAMP(3)) / 1000 WHERE FALSE <foreach collection='securableObjects' item='item' separator=' '> OR (metadata_object_id = #{item.metadataObjectId} AND role_id = #{item.roleId} AND deleted_at = 0 )</foreach></script>";
    }

    public String softDeleteSecurableObjectsByRoleId(@Param(value="roleId") Long roleId) {
        return "UPDATE role_meta_securable_object SET deleted_at = (UNIX_TIMESTAMP() * 1000.0) + EXTRACT(MICROSECOND FROM CURRENT_TIMESTAMP(3)) / 1000 WHERE role_id = #{roleId} AND deleted_at = 0";
    }

    public String softDeleteSecurableObjectsByMetalakeId(@Param(value="metalakeId") Long metalakeId) {
        return "UPDATE role_meta_securable_object ob SET ob.deleted_at = (UNIX_TIMESTAMP() * 1000.0) + EXTRACT(MICROSECOND FROM CURRENT_TIMESTAMP(3)) / 1000 WHERE exists (SELECT * from role_meta ro WHERE ro.metalake_id = #{metalakeId} AND ro.role_id = ob.role_id AND ro.deleted_at = 0) AND ob.deleted_at = 0";
    }

    public String softDeleteObjectRelsByMetadataObject(@Param(value="metadataObjectId") Long metadataObjectId, @Param(value="metadataObjectType") String metadataObjectType) {
        return "UPDATE role_meta_securable_object SET deleted_at = (UNIX_TIMESTAMP() * 1000.0) + EXTRACT(MICROSECOND FROM CURRENT_TIMESTAMP(3)) / 1000 WHERE metadata_object_id = #{metadataObjectId} AND deleted_at = 0 AND type = #{metadataObjectType}";
    }

    public String softDeleteObjectRelsByCatalogId(@Param(value="catalogId") Long catalogId) {
        return "UPDATE role_meta_securable_object sect SET deleted_at = (UNIX_TIMESTAMP() * 1000.0) + EXTRACT(MICROSECOND FROM CURRENT_TIMESTAMP(3)) / 1000 WHERE sect.deleted_at = 0 AND EXISTS ( SELECT ct.catalog_id FROM catalog_meta ct WHERE ct.catalog_id = #{catalogId}  AND  ct.catalog_id = sect.metadata_object_id AND sect.type = 'CATALOG' UNION  SELECT st.catalog_id FROM schema_meta st WHERE st.catalog_id = #{catalogId} AND  st.schema_id = sect.metadata_object_id AND sect.type = 'SCHEMA' UNION  SELECT tt.catalog_id FROM topic_meta tt WHERE tt.catalog_id = #{catalogId} AND  tt.topic_id = sect.metadata_object_id AND sect.type = 'TOPIC' UNION  SELECT tat.catalog_id FROM table_meta tat WHERE tat.catalog_id = #{catalogId} AND  tat.table_id = sect.metadata_object_id AND sect.type = 'TABLE' UNION  SELECT ft.catalog_id FROM fileset_meta ft WHERE ft.catalog_id = #{catalogId} AND ft.fileset_id = sect.metadata_object_id AND sect.type = 'FILESET')";
    }

    public String softDeleteObjectRelsBySchemaId(@Param(value="schemaId") Long schemaId) {
        return "UPDATE role_meta_securable_object sect SET deleted_at = (UNIX_TIMESTAMP() * 1000.0) + EXTRACT(MICROSECOND FROM CURRENT_TIMESTAMP(3)) / 1000 WHERE sect.deleted_at = 0 AND EXISTS ( SELECT st.schema_id FROM schema_meta st WHERE st.schema_id = #{schemaId}  AND st.schema_id = sect.metadata_object_id AND sect.type = 'SCHEMA' UNION  SELECT tt.schema_id FROM topic_meta tt WHERE tt.schema_id = #{schemaId} AND  tt.topic_id = sect.metadata_object_id AND sect.type = 'TOPIC' UNION  SELECT tat.schema_id FROM table_meta tat WHERE tat.schema_id = #{schemaId} AND  tat.table_id = sect.metadata_object_id AND sect.type = 'TABLE' UNION  SELECT ft.schema_id FROM fileset_meta ft WHERE ft.schema_id = #{schemaId} AND  ft.fileset_id = sect.metadata_object_id AND sect.type = 'FILESET')";
    }

    public String listSecurableObjectsByRoleId(@Param(value="roleId") Long roleId) {
        return "SELECT role_id as roleId, metadata_object_id as metadataObjectId, type as type, privilege_names as privilegeNames, privilege_conditions as privilegeConditions, current_version as currentVersion, last_version as lastVersion, deleted_at as deletedAt FROM role_meta_securable_object WHERE role_id = #{roleId} AND deleted_at = 0";
    }

    public String deleteSecurableObjectsByLegacyTimeline(@Param(value="legacyTimeline") Long legacyTimeline, @Param(value="limit") int limit) {
        return "DELETE FROM role_meta_securable_object WHERE deleted_at > 0 AND deleted_at < #{legacyTimeline} LIMIT #{limit}";
    }
}

