/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gravitino.storage.relational.mapper;

import com.google.common.collect.ImmutableMap;
import java.util.Map;
import org.apache.gravitino.storage.relational.JDBCBackend;
import org.apache.gravitino.storage.relational.mapper.provider.base.SchemaMetaBaseSQLProvider;
import org.apache.gravitino.storage.relational.mapper.provider.postgresql.SchemaMetaPostgreSQLProvider;
import org.apache.gravitino.storage.relational.po.SchemaPO;
import org.apache.gravitino.storage.relational.session.SqlSessionFactoryHelper;
import org.apache.ibatis.annotations.Param;

public class SchemaMetaSQLProviderFactory {
    private static final Map<JDBCBackend.JDBCBackendType, SchemaMetaBaseSQLProvider> SCHEMA_META_SQL_PROVIDER_MAP = ImmutableMap.of((Object)((Object)JDBCBackend.JDBCBackendType.MYSQL), (Object)new SchemaMetaMySQLProvider(), (Object)((Object)JDBCBackend.JDBCBackendType.H2), (Object)new SchemaMetaH2Provider(), (Object)((Object)JDBCBackend.JDBCBackendType.POSTGRESQL), (Object)new SchemaMetaPostgreSQLProvider());

    public static SchemaMetaBaseSQLProvider getProvider() {
        String databaseId = SqlSessionFactoryHelper.getInstance().getSqlSessionFactory().getConfiguration().getDatabaseId();
        JDBCBackend.JDBCBackendType jdbcBackendType = JDBCBackend.JDBCBackendType.fromString(databaseId);
        return SCHEMA_META_SQL_PROVIDER_MAP.get((Object)jdbcBackendType);
    }

    public static String listSchemaPOsByCatalogId(@Param(value="catalogId") Long catalogId) {
        return SchemaMetaSQLProviderFactory.getProvider().listSchemaPOsByCatalogId(catalogId);
    }

    public static String selectSchemaIdByCatalogIdAndName(@Param(value="catalogId") Long catalogId, @Param(value="schemaName") String name) {
        return SchemaMetaSQLProviderFactory.getProvider().selectSchemaIdByCatalogIdAndName(catalogId, name);
    }

    public static String selectSchemaMetaByCatalogIdAndName(@Param(value="catalogId") Long catalogId, @Param(value="schemaName") String name) {
        return SchemaMetaSQLProviderFactory.getProvider().selectSchemaMetaByCatalogIdAndName(catalogId, name);
    }

    public static String selectSchemaMetaById(@Param(value="schemaId") Long schemaId) {
        return SchemaMetaSQLProviderFactory.getProvider().selectSchemaMetaById(schemaId);
    }

    public static String insertSchemaMeta(@Param(value="schemaMeta") SchemaPO schemaPO) {
        return SchemaMetaSQLProviderFactory.getProvider().insertSchemaMeta(schemaPO);
    }

    public static String insertSchemaMetaOnDuplicateKeyUpdate(@Param(value="schemaMeta") SchemaPO schemaPO) {
        return SchemaMetaSQLProviderFactory.getProvider().insertSchemaMetaOnDuplicateKeyUpdate(schemaPO);
    }

    public static String updateSchemaMeta(@Param(value="newSchemaMeta") SchemaPO newSchemaPO, @Param(value="oldSchemaMeta") SchemaPO oldSchemaPO) {
        return SchemaMetaSQLProviderFactory.getProvider().updateSchemaMeta(newSchemaPO, oldSchemaPO);
    }

    public static String softDeleteSchemaMetasBySchemaId(@Param(value="schemaId") Long schemaId) {
        return SchemaMetaSQLProviderFactory.getProvider().softDeleteSchemaMetasBySchemaId(schemaId);
    }

    public static String softDeleteSchemaMetasByMetalakeId(@Param(value="metalakeId") Long metalakeId) {
        return SchemaMetaSQLProviderFactory.getProvider().softDeleteSchemaMetasByMetalakeId(metalakeId);
    }

    public static String softDeleteSchemaMetasByCatalogId(@Param(value="catalogId") Long catalogId) {
        return SchemaMetaSQLProviderFactory.getProvider().softDeleteSchemaMetasByCatalogId(catalogId);
    }

    public static String deleteSchemaMetasByLegacyTimeline(@Param(value="legacyTimeline") Long legacyTimeline, @Param(value="limit") int limit) {
        return SchemaMetaSQLProviderFactory.getProvider().deleteSchemaMetasByLegacyTimeline(legacyTimeline, limit);
    }

    static class SchemaMetaH2Provider
    extends SchemaMetaBaseSQLProvider {
        SchemaMetaH2Provider() {
        }
    }

    static class SchemaMetaMySQLProvider
    extends SchemaMetaBaseSQLProvider {
        SchemaMetaMySQLProvider() {
        }
    }
}

