/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gravitino.credential.config;

import java.util.Map;
import javax.validation.constraints.NotNull;
import org.apache.commons.lang3.StringUtils;
import org.apache.gravitino.Config;
import org.apache.gravitino.config.ConfigBuilder;
import org.apache.gravitino.config.ConfigEntry;

public class AzureCredentialConfig
extends Config {
    public static final ConfigEntry<String> AZURE_STORAGE_ACCOUNT_NAME = new ConfigBuilder("azure-storage-account-name").doc("The name of the Azure Data Lake Storage account.").version("0.7.0").stringConf().checkValue(StringUtils::isNotBlank, "The value can't be blank").create();
    public static final ConfigEntry<String> AZURE_STORAGE_ACCOUNT_KEY = new ConfigBuilder("azure-storage-account-key").doc("The key of the Azure Data Lake Storage account.").version("0.7.0").stringConf().checkValue(StringUtils::isNotBlank, "The value can't be blank").create();
    public static final ConfigEntry<String> AZURE_TENANT_ID = new ConfigBuilder("azure-tenant-id").doc("The Azure Active Directory (AAD) tenant ID used for authentication.").version("0.7.0").stringConf().checkValue(StringUtils::isNotBlank, "The value can't be blank").create();
    public static final ConfigEntry<String> AZURE_CLIENT_ID = new ConfigBuilder("azure-client-id").doc("The client ID used for authenticating with Azure Active Directory (AAD).").version("0.7.0").stringConf().checkValue(StringUtils::isNotBlank, "The value can't be blank").create();
    public static final ConfigEntry<String> AZURE_CLIENT_SECRET = new ConfigBuilder("azure-client-secret").doc("The client secret used for authenticating with Azure Active Directory (AAD).").version("0.7.0").stringConf().checkValue(StringUtils::isNotBlank, "The value can't be blank").create();
    public static final ConfigEntry<Integer> ADLS_TOKEN_EXPIRE_IN_SECS = new ConfigBuilder("adls-token-expire-in-secs").doc("The expiration time (in seconds) for the Azure Active Directory (AAD) authentication token.").version("0.7.0").intConf().createWithDefault(3600);

    public AzureCredentialConfig(Map<String, String> properties) {
        super(false);
        this.loadFromMap(properties, k -> true);
    }

    @NotNull
    public String storageAccountName() {
        return this.get(AZURE_STORAGE_ACCOUNT_NAME);
    }

    @NotNull
    public String storageAccountKey() {
        return this.get(AZURE_STORAGE_ACCOUNT_KEY);
    }

    @NotNull
    public String tenantId() {
        return this.get(AZURE_TENANT_ID);
    }

    @NotNull
    public String clientId() {
        return this.get(AZURE_CLIENT_ID);
    }

    @NotNull
    public String clientSecret() {
        return this.get(AZURE_CLIENT_SECRET);
    }

    @NotNull
    public Integer adlsTokenExpireInSecs() {
        return this.get(ADLS_TOKEN_EXPIRE_IN_SECS);
    }
}

