/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.servlets;

import java.io.IOException;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import javax.servlet.AsyncContext;
import javax.servlet.AsyncEvent;
import javax.servlet.AsyncListener;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.eclipse.jetty.util.annotation.ManagedAttribute;
import org.eclipse.jetty.util.annotation.ManagedObject;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;

@ManagedObject(value="Quality of Service Filter")
public class QoSFilter
implements Filter {
    private static final Logger LOG = Log.getLogger(QoSFilter.class);
    static final int DEFAULT_MAX_PRIORITY = 10;
    static final int DEFAULT_PASSES = 10;
    static final int DEFAULT_WAIT_MS = 50;
    static final long DEFAULT_TIMEOUT_MS = -1L;
    static final String MANAGED_ATTR_INIT_PARAM = "managedAttr";
    static final String MAX_REQUESTS_INIT_PARAM = "maxRequests";
    static final String MAX_PRIORITY_INIT_PARAM = "maxPriority";
    static final String MAX_WAIT_INIT_PARAM = "waitMs";
    static final String SUSPEND_INIT_PARAM = "suspendMs";
    private final String _suspended = "QoSFilter@" + Integer.toHexString(this.hashCode()) + ".SUSPENDED";
    private final String _resumed = "QoSFilter@" + Integer.toHexString(this.hashCode()) + ".RESUMED";
    private long _waitMs;
    private long _suspendMs;
    private int _maxRequests;
    private Semaphore _passes;
    private Queue<AsyncContext>[] _queues;
    private AsyncListener[] _listeners;

    public void init(FilterConfig filterConfig) {
        int maxPriority = 10;
        if (filterConfig.getInitParameter(MAX_PRIORITY_INIT_PARAM) != null) {
            maxPriority = Integer.parseInt(filterConfig.getInitParameter(MAX_PRIORITY_INIT_PARAM));
        }
        this._queues = new Queue[maxPriority + 1];
        this._listeners = new AsyncListener[this._queues.length];
        for (int p = 0; p < this._queues.length; ++p) {
            this._queues[p] = new ConcurrentLinkedQueue<AsyncContext>();
            this._listeners[p] = new QoSAsyncListener(p);
        }
        int maxRequests = 10;
        if (filterConfig.getInitParameter(MAX_REQUESTS_INIT_PARAM) != null) {
            maxRequests = Integer.parseInt(filterConfig.getInitParameter(MAX_REQUESTS_INIT_PARAM));
        }
        this._passes = new Semaphore(maxRequests, true);
        this._maxRequests = maxRequests;
        long wait = 50L;
        if (filterConfig.getInitParameter(MAX_WAIT_INIT_PARAM) != null) {
            wait = Integer.parseInt(filterConfig.getInitParameter(MAX_WAIT_INIT_PARAM));
        }
        this._waitMs = wait;
        long suspend = -1L;
        if (filterConfig.getInitParameter(SUSPEND_INIT_PARAM) != null) {
            suspend = Integer.parseInt(filterConfig.getInitParameter(SUSPEND_INIT_PARAM));
        }
        this._suspendMs = suspend;
        ServletContext context = filterConfig.getServletContext();
        if (context != null && Boolean.parseBoolean(filterConfig.getInitParameter(MANAGED_ATTR_INIT_PARAM))) {
            context.setAttribute(filterConfig.getFilterName(), (Object)this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        boolean accepted = false;
        try {
            block28: {
                block29: {
                    Boolean suspended;
                    block27: {
                        suspended = (Boolean)request.getAttribute(this._suspended);
                        if (suspended != null) break block27;
                        accepted = this._passes.tryAcquire(this.getWaitMs(), TimeUnit.MILLISECONDS);
                        if (accepted) {
                            request.setAttribute(this._suspended, (Object)Boolean.FALSE);
                            if (LOG.isDebugEnabled()) {
                                LOG.debug("Accepted {}", new Object[]{request});
                            }
                            break block28;
                        } else {
                            request.setAttribute(this._suspended, (Object)Boolean.TRUE);
                            int priority = this.getPriority(request);
                            AsyncContext asyncContext = request.startAsync();
                            long suspendMs = this.getSuspendMs();
                            if (suspendMs > 0L) {
                                asyncContext.setTimeout(suspendMs);
                            }
                            asyncContext.addListener(this._listeners[priority]);
                            this._queues[priority].add(asyncContext);
                            if (!LOG.isDebugEnabled()) return;
                            LOG.debug("Suspended {}", new Object[]{request});
                            return;
                        }
                    }
                    if (!suspended.booleanValue()) break block29;
                    request.setAttribute(this._suspended, (Object)Boolean.FALSE);
                    Boolean resumed = (Boolean)request.getAttribute(this._resumed);
                    if (Boolean.TRUE.equals(resumed)) {
                        this._passes.acquire();
                        accepted = true;
                        if (LOG.isDebugEnabled()) {
                            LOG.debug("Resumed {}", new Object[]{request});
                        }
                        break block28;
                    } else {
                        accepted = this._passes.tryAcquire(this.getWaitMs(), TimeUnit.MILLISECONDS);
                        if (LOG.isDebugEnabled()) {
                            LOG.debug("Timeout {}", new Object[]{request});
                        }
                    }
                    break block28;
                }
                this._passes.acquire();
                accepted = true;
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Passthrough {}", new Object[]{request});
                }
            }
            if (accepted) {
                chain.doFilter(request, response);
                return;
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug("Rejected {}", new Object[]{request});
            }
            ((HttpServletResponse)response).sendError(503);
            return;
        }
        catch (InterruptedException e) {
            ((HttpServletResponse)response).sendError(503);
            return;
        }
        finally {
            if (accepted) {
                this._passes.release();
                for (int p = this._queues.length - 1; p >= 0; --p) {
                    ServletRequest candidate;
                    Boolean suspended;
                    AsyncContext asyncContext = this._queues[p].poll();
                    if (asyncContext == null || !Boolean.TRUE.equals(suspended = (Boolean)(candidate = asyncContext.getRequest()).getAttribute(this._suspended))) continue;
                    try {
                        candidate.setAttribute(this._resumed, (Object)Boolean.TRUE);
                        asyncContext.dispatch();
                        break;
                    }
                    catch (IllegalStateException x) {
                        if (!LOG.isDebugEnabled()) continue;
                        LOG.debug((Throwable)x);
                    }
                }
            }
        }
    }

    protected int getPriority(ServletRequest request) {
        HttpServletRequest baseRequest = (HttpServletRequest)request;
        if (baseRequest.getUserPrincipal() != null) {
            return 2;
        }
        HttpSession session = baseRequest.getSession(false);
        if (session != null && !session.isNew()) {
            return 1;
        }
        return 0;
    }

    public void destroy() {
    }

    @ManagedAttribute(value="(short) amount of time filter will wait before suspending request (in ms)")
    public long getWaitMs() {
        return this._waitMs;
    }

    public void setWaitMs(long value) {
        this._waitMs = value;
    }

    @ManagedAttribute(value="amount of time filter will suspend a request for while waiting for the semaphore to become available (in ms)")
    public long getSuspendMs() {
        return this._suspendMs;
    }

    public void setSuspendMs(long value) {
        this._suspendMs = value;
    }

    @ManagedAttribute(value="maximum number of requests to allow processing of at the same time")
    public int getMaxRequests() {
        return this._maxRequests;
    }

    public void setMaxRequests(int value) {
        this._passes = new Semaphore(value - this.getMaxRequests() + this._passes.availablePermits(), true);
        this._maxRequests = value;
    }

    private class QoSAsyncListener
    implements AsyncListener {
        private final int priority;

        public QoSAsyncListener(int priority) {
            this.priority = priority;
        }

        public void onStartAsync(AsyncEvent event) throws IOException {
        }

        public void onComplete(AsyncEvent event) throws IOException {
        }

        public void onTimeout(AsyncEvent event) throws IOException {
            AsyncContext asyncContext = event.getAsyncContext();
            QoSFilter.this._queues[this.priority].remove(asyncContext);
            ((HttpServletResponse)event.getSuppliedResponse()).sendError(503);
            asyncContext.complete();
        }

        public void onError(AsyncEvent event) throws IOException {
        }
    }
}

