/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gravitino.dto.rel.indexes;

import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.google.common.base.Preconditions;
import java.util.Arrays;
import java.util.Objects;
import org.apache.gravitino.json.JsonUtils;
import org.apache.gravitino.rel.indexes.Index;

@JsonSerialize(using=JsonUtils.IndexSerializer.class)
@JsonDeserialize(using=JsonUtils.IndexDeserializer.class)
public class IndexDTO
implements Index {
    public static final IndexDTO[] EMPTY_INDEXES = new IndexDTO[0];
    private Index.IndexType indexType;
    private String name;
    private String[][] fieldNames;

    public IndexDTO() {
    }

    public IndexDTO(Index.IndexType indexType, String name, String[][] fieldNames) {
        this.indexType = indexType;
        this.name = name;
        this.fieldNames = fieldNames;
    }

    public Index.IndexType type() {
        return this.indexType;
    }

    public String name() {
        return this.name;
    }

    public String[][] fieldNames() {
        return this.fieldNames;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof IndexDTO)) {
            return false;
        }
        IndexDTO indexDTO = (IndexDTO)o;
        return this.indexType == indexDTO.indexType && Objects.equals(this.name, indexDTO.name) && IndexDTO.compareStringArrays(this.fieldNames, indexDTO.fieldNames);
    }

    private static boolean compareStringArrays(String[][] array1, String[][] array2) {
        if (array1.length != array2.length) {
            return false;
        }
        for (int i = 0; i < array1.length; ++i) {
            if (Arrays.equals(array1[i], array2[i])) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        int result = Objects.hash(this.indexType, this.name);
        result = 31 * result + Arrays.hashCode((Object[])this.fieldNames);
        return result;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder<S extends Builder> {
        protected Index.IndexType indexType;
        protected String name;
        protected String[][] fieldNames;

        public S withIndexType(Index.IndexType indexType) {
            this.indexType = indexType;
            return (S)this;
        }

        public S withName(String name) {
            this.name = name;
            return (S)this;
        }

        public S withFieldNames(String[][] fieldNames) {
            this.fieldNames = fieldNames;
            return (S)this;
        }

        public IndexDTO build() {
            Preconditions.checkArgument((this.indexType != null ? 1 : 0) != 0, (Object)"Index type cannot be null");
            Preconditions.checkArgument((this.fieldNames != null && this.fieldNames.length > 0 ? 1 : 0) != 0, (Object)"The index must be set with corresponding column names");
            return new IndexDTO(this.indexType, this.name, this.fieldNames);
        }
    }
}

