/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gravitino.iceberg.common.authentication.kerberos;

import java.io.IOException;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Map;
import net.sf.cglib.proxy.Callback;
import net.sf.cglib.proxy.Enhancer;
import net.sf.cglib.proxy.MethodInterceptor;
import net.sf.cglib.proxy.MethodProxy;
import org.apache.gravitino.iceberg.common.utils.IcebergHiveCachedClientPool;
import org.apache.gravitino.utils.PrincipalUtils;
import org.apache.hadoop.hive.metastore.IMetaStoreClient;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.security.token.Token;
import org.apache.iceberg.ClientPool;
import org.apache.iceberg.hive.HiveCatalog;
import org.apache.thrift.TException;

public class HiveBackendProxy
implements MethodInterceptor {
    private final HiveCatalog target;
    private final String kerberosRealm;
    private final UserGroupInformation proxyUser;
    private final Map<String, String> properties;
    private final ClientPool<IMetaStoreClient, TException> newClientPool;

    public HiveBackendProxy(Map<String, String> properties, HiveCatalog target, String kerberosRealm) {
        this.target = target;
        this.properties = properties;
        this.kerberosRealm = kerberosRealm;
        try {
            this.proxyUser = UserGroupInformation.getCurrentUser();
            this.newClientPool = this.resetIcebergHiveClientPool();
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to get current user", e);
        }
        catch (IllegalAccessException | NoSuchFieldException e) {
            throw new RuntimeException("Failed to reset IcebergHiveClientPool", e);
        }
    }

    public Object intercept(Object o, Method method, Object[] objects, MethodProxy methodProxy) throws Throwable {
        String proxyKerberosPrincipalName = PrincipalUtils.getCurrentPrincipal().getName();
        if (!proxyKerberosPrincipalName.contains("@")) {
            proxyKerberosPrincipalName = String.format("%s@%s", proxyKerberosPrincipalName, this.kerberosRealm);
        }
        UserGroupInformation realUser = UserGroupInformation.createProxyUser((String)proxyKerberosPrincipalName, (UserGroupInformation)this.proxyUser);
        String token = (String)this.newClientPool.run(client -> client.getDelegationToken(PrincipalUtils.getCurrentPrincipal().getName(), this.proxyUser.getShortUserName()));
        Token delegationToken = new Token();
        delegationToken.decodeFromUrlString(token);
        realUser.addToken(delegationToken);
        return realUser.doAs(() -> {
            try {
                return methodProxy.invoke((Object)this.target, objects);
            }
            catch (Throwable e) {
                if (RuntimeException.class.isAssignableFrom(e.getClass())) {
                    throw (RuntimeException)e;
                }
                throw new RuntimeException("Failed to invoke method", e);
            }
        });
    }

    private ClientPool<IMetaStoreClient, TException> resetIcebergHiveClientPool() throws IllegalAccessException, NoSuchFieldException {
        Field m = HiveCatalog.class.getDeclaredField("clients");
        m.setAccessible(true);
        IcebergHiveCachedClientPool newClientPool = new IcebergHiveCachedClientPool(this.target.getConf(), this.properties);
        m.set(this.target, newClientPool);
        return newClientPool;
    }

    public HiveCatalog getProxy() {
        Enhancer e = new Enhancer();
        e.setClassLoader(this.target.getClass().getClassLoader());
        e.setSuperclass(this.target.getClass());
        e.setCallback((Callback)this);
        return (HiveCatalog)e.create();
    }
}

