
# Project Governance

This document describes how the GeaFlow project is governed, following the [Apache Software Foundation (ASF) Governance](https://www.apache.org/foundation/governance/).

## Overview
GeaFlow is an Apache project. We follow the [Apache Way](https://www.apache.org/foundation/how-it-works.html) and ASF best practices for open, community-driven development.

## Roles and Responsibilities
See [ROLES.md](community/ROLES.md) for detailed descriptions of project roles and how to progress.

- **Users:** Use the project, report issues, and provide feedback.
- **Contributors:** Submit code, documentation, or suggestions. Participate in discussions and reviews. See [CONTRIBUTING.md](community/CONTRIBUTING.md).
- **Committers:** Review and merge contributions, maintain code quality, and help guide the project.
- **PMC (Project Management Committee):** Provide overall project direction, approve releases, and ensure the project follows ASF rules.

## Decision Making
- Most decisions are made by consensus in public discussions (mailing list, GitHub, etc.).
- For important changes, the PMC may call a vote. See [ASF Voting Process](https://www.apache.org/foundation/voting.html).
- Community input is always welcome and valued.

## Code of Conduct

We are the ASF incubation project and adhere to the [Apache Code of Conduct](https://www.apache.org/foundation/policies/conduct). For more details, please refer to our [Code of Conduct](CODE_OF_CONDUCT.md).

## Communication Channels
- **GitHub Issues:** For bug reports and feature requests ([Issue Tracker](https://github.com/apache/geaflow/issues))
- **GitHub Discussions:** For general questions and community topics
- **Pull Requests:** For code and documentation contributions
- **Mailing List:** dev@geaflow.apache.org

## Documentation
- [Project Documentation](docs/)
- [ASF Governance](https://www.apache.org/foundation/governance/)
- [The Apache Way](https://www.apache.org/foundation/how-it-works.html)

## License
This project is licensed under the [Apache License 2.0](LICENSE).