/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bifromq.plugin.settingprovider;

import io.micrometer.core.instrument.Counter;
import io.micrometer.core.instrument.Meter;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.Metrics;
import io.micrometer.core.instrument.Timer;
import lombok.Generated;
import org.apache.bifromq.plugin.settingprovider.ISettingProvider;
import org.apache.bifromq.plugin.settingprovider.Setting;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MonitoredSettingProvider
implements ISettingProvider {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(MonitoredSettingProvider.class);
    private static final Logger pluginLog = LoggerFactory.getLogger((String)"plugin.manager");
    private final Timer provideCallTimer;
    private final Counter provideCallErrorCounter;
    private final ISettingProvider delegate;

    public MonitoredSettingProvider(ISettingProvider delegate) {
        this.delegate = delegate;
        this.provideCallTimer = Timer.builder((String)"call.exec.timer").tag("method", "SettingProvider/provide").tag("type", delegate.getClass().getName()).register((MeterRegistry)Metrics.globalRegistry);
        this.provideCallErrorCounter = Counter.builder((String)"call.exec.fail.count").tag("method", "SettingProvider/provide").tag("type", delegate.getClass().getName()).register((MeterRegistry)Metrics.globalRegistry);
    }

    public <R> R provide(Setting setting, String tenantId) {
        try {
            Timer.Sample sample = Timer.start();
            Object newVal = this.delegate.provide(setting, tenantId);
            sample.stop(this.provideCallTimer);
            if (newVal == null || setting.isValid(newVal, tenantId)) {
                return (R)newVal;
            }
            pluginLog.warn("Invalid setting value: setting={}, value={}", (Object)setting.name(), newVal);
            this.provideCallErrorCounter.increment();
            return null;
        }
        catch (Throwable e) {
            pluginLog.error("Setting provider throws exception: setting={}", (Object)setting.name(), (Object)e);
            this.provideCallErrorCounter.increment();
            return null;
        }
    }

    public void close() {
        try {
            this.delegate.close();
        }
        catch (Throwable e) {
            pluginLog.error("Setting provider close throws exception", e);
        }
        Metrics.globalRegistry.remove((Meter)this.provideCallTimer);
        Metrics.globalRegistry.remove((Meter)this.provideCallErrorCounter);
    }
}

