/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bifromq.starter;

import com.google.inject.Inject;
import java.util.Optional;
import lombok.Generated;
import org.apache.bifromq.apiserver.IAPIServer;
import org.apache.bifromq.baserpc.server.IRPCServer;
import org.apache.bifromq.baserpc.server.RPCServerBuilder;
import org.apache.bifromq.dist.server.IDistServer;
import org.apache.bifromq.dist.worker.IDistWorker;
import org.apache.bifromq.inbox.server.IInboxServer;
import org.apache.bifromq.inbox.store.IInboxStore;
import org.apache.bifromq.mqtt.IMQTTBroker;
import org.apache.bifromq.retain.server.IRetainServer;
import org.apache.bifromq.retain.store.IRetainStore;
import org.apache.bifromq.sessiondict.server.ISessionDictServer;
import org.apache.bifromq.starter.module.ServiceInjector;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class ServiceBootstrapper {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ServiceBootstrapper.class);
    private final Optional<IAPIServer> apiServerOpt;
    private final Optional<IMQTTBroker> mqttBrokerOpt;
    private final Optional<IDistServer> distServerOpt;
    private final Optional<IDistWorker> distWorkerOpt;
    private final Optional<IInboxServer> inboxServerOpt;
    private final Optional<IInboxStore> inboxStoreOpt;
    private final Optional<IRetainServer> retainServerOpt;
    private final Optional<IRetainStore> retainStoreOpt;
    private final Optional<ISessionDictServer> sessionDictServerOpt;
    private final ServiceInjector serviceInjector;

    @Inject
    ServiceBootstrapper(Optional<IAPIServer> apiServerOpt, Optional<IMQTTBroker> mqttBrokerOpt, Optional<IDistServer> distServerOpt, Optional<IDistWorker> distWorkerOpt, Optional<IInboxServer> inboxServerOpt, Optional<IInboxStore> inboxStoreOpt, Optional<IRetainServer> retainServerOpt, Optional<IRetainStore> retainStoreOpt, Optional<ISessionDictServer> sessionDictServerOpt, ServiceInjector serviceInjector) {
        this.apiServerOpt = apiServerOpt;
        this.mqttBrokerOpt = mqttBrokerOpt;
        this.distServerOpt = distServerOpt;
        this.distWorkerOpt = distWorkerOpt;
        this.inboxServerOpt = inboxServerOpt;
        this.inboxStoreOpt = inboxStoreOpt;
        this.retainServerOpt = retainServerOpt;
        this.retainStoreOpt = retainStoreOpt;
        this.sessionDictServerOpt = sessionDictServerOpt;
        this.serviceInjector = serviceInjector;
    }

    public BootstrappedServices bootstrap() {
        if (this.distServerOpt.isPresent() || this.distWorkerOpt.isPresent() || this.inboxServerOpt.isPresent() || this.inboxStoreOpt.isPresent() || this.retainServerOpt.isPresent() || this.retainStoreOpt.isPresent() || this.sessionDictServerOpt.isPresent()) {
            return new BootstrappedServices(this.serviceInjector.getInstance(RPCServerBuilder.class).build(), this.apiServerOpt, this.mqttBrokerOpt, this.distServerOpt, this.distWorkerOpt, this.inboxServerOpt, this.inboxStoreOpt, this.retainServerOpt, this.retainStoreOpt, this.sessionDictServerOpt);
        }
        return new BootstrappedServices(null, this.apiServerOpt, this.mqttBrokerOpt, this.distServerOpt, this.distWorkerOpt, this.inboxServerOpt, this.inboxStoreOpt, this.retainServerOpt, this.retainStoreOpt, this.sessionDictServerOpt);
    }

    static class BootstrappedServices {
        private final IRPCServer rpcServer;
        private final Optional<IAPIServer> apiServerOpt;
        private final Optional<IMQTTBroker> mqttBrokerOpt;
        private final Optional<IDistServer> distServerOpt;
        private final Optional<IDistWorker> distWorkerOpt;
        private final Optional<IInboxServer> inboxServerOpt;
        private final Optional<IInboxStore> inboxStoreOpt;
        private final Optional<IRetainServer> retainServerOpt;
        private final Optional<IRetainStore> retainStoreOpt;
        private final Optional<ISessionDictServer> sessionDictServerOpt;

        private BootstrappedServices(IRPCServer rpcServer, Optional<IAPIServer> apiServerOpt, Optional<IMQTTBroker> mqttBrokerOpt, Optional<IDistServer> distServerOpt, Optional<IDistWorker> distWorkerOpt, Optional<IInboxServer> inboxServerOpt, Optional<IInboxStore> inboxStoreOpt, Optional<IRetainServer> retainServerOpt, Optional<IRetainStore> retainStoreOpt, Optional<ISessionDictServer> sessionDictServerOpt) {
            this.rpcServer = rpcServer;
            this.apiServerOpt = apiServerOpt;
            this.mqttBrokerOpt = mqttBrokerOpt;
            this.distServerOpt = distServerOpt;
            this.distWorkerOpt = distWorkerOpt;
            this.inboxServerOpt = inboxServerOpt;
            this.inboxStoreOpt = inboxStoreOpt;
            this.retainServerOpt = retainServerOpt;
            this.retainStoreOpt = retainStoreOpt;
            this.sessionDictServerOpt = sessionDictServerOpt;
        }

        void start() {
            if (this.rpcServer != null) {
                log.info("Start RPC server");
                this.rpcServer.start();
            }
            this.apiServerOpt.ifPresent(IAPIServer::start);
            this.mqttBrokerOpt.ifPresent(IMQTTBroker::start);
        }

        void stop() {
            this.mqttBrokerOpt.ifPresent(IMQTTBroker::close);
            this.apiServerOpt.ifPresent(IAPIServer::close);
            if (this.rpcServer != null) {
                log.info("Stop RPC server");
                this.rpcServer.shutdown();
            }
            this.distServerOpt.ifPresent(IDistServer::close);
            this.distWorkerOpt.ifPresent(IDistWorker::close);
            this.inboxServerOpt.ifPresent(IInboxServer::close);
            this.inboxStoreOpt.ifPresent(IInboxStore::close);
            this.retainServerOpt.ifPresent(IRetainServer::close);
            this.retainStoreOpt.ifPresent(IRetainStore::close);
            this.sessionDictServerOpt.ifPresent(ISessionDictServer::close);
        }
    }
}

