/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bifromq.basekv.raft;

import com.google.protobuf.ByteString;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ThreadLocalRandom;
import java.util.stream.Collectors;
import org.apache.bifromq.basekv.raft.ILogEntryIterator;
import org.apache.bifromq.basekv.raft.IRaftNode;
import org.apache.bifromq.basekv.raft.IRaftNodeState;
import org.apache.bifromq.basekv.raft.IRaftStateStore;
import org.apache.bifromq.basekv.raft.RaftConfig;
import org.apache.bifromq.basekv.raft.RaftLogger;
import org.apache.bifromq.basekv.raft.event.CommitEvent;
import org.apache.bifromq.basekv.raft.event.ElectionEvent;
import org.apache.bifromq.basekv.raft.event.SnapshotRestoredEvent;
import org.apache.bifromq.basekv.raft.event.StatusChangedEvent;
import org.apache.bifromq.basekv.raft.exception.CompactionException;
import org.apache.bifromq.basekv.raft.exception.DropProposalException;
import org.apache.bifromq.basekv.raft.proto.AppendEntriesReply;
import org.apache.bifromq.basekv.raft.proto.ClusterConfig;
import org.apache.bifromq.basekv.raft.proto.LogEntry;
import org.apache.bifromq.basekv.raft.proto.RaftMessage;
import org.apache.bifromq.basekv.raft.proto.RequestPreVote;
import org.apache.bifromq.basekv.raft.proto.RequestPreVoteReply;
import org.apache.bifromq.basekv.raft.proto.RequestVoteReply;
import org.apache.bifromq.basekv.raft.proto.Snapshot;
import org.apache.bifromq.basekv.raft.proto.Voting;
import org.slf4j.Logger;

abstract class RaftNodeState
implements IRaftNodeState {
    protected final String id;
    protected final RaftConfig config;
    protected final IRaftStateStore stateStorage;
    protected final Logger log;
    protected final IRaftNode.IRaftMessageSender sender;
    protected final IRaftNode.IRaftEventListener listener;
    protected final IRaftNode.ISnapshotInstaller snapshotInstaller;
    protected final OnSnapshotInstalled onSnapshotInstalled;
    protected final LinkedHashMap<Long, ProposeTask> uncommittedProposals;
    protected final int maxUncommittedProposals;
    protected final String[] tags;
    protected volatile long commitIndex;

    public RaftNodeState(long currentTerm, long commitIndex, RaftConfig config, IRaftStateStore stateStorage, LinkedHashMap<Long, ProposeTask> uncommittedProposals, IRaftNode.IRaftMessageSender sender, IRaftNode.IRaftEventListener listener, IRaftNode.ISnapshotInstaller installer, OnSnapshotInstalled onSnapshotInstalled, String ... tags) {
        this.stateStorage = stateStorage;
        this.id = stateStorage.local();
        this.tags = tags;
        this.uncommittedProposals = uncommittedProposals;
        this.maxUncommittedProposals = config.getMaxUncommittedProposals() == 0 ? Integer.MAX_VALUE : config.getMaxUncommittedProposals();
        this.commitIndex = commitIndex;
        this.config = config;
        this.log = new RaftLogger(this, tags);
        this.sender = sender;
        this.listener = listener;
        this.snapshotInstaller = installer;
        this.onSnapshotInstalled = onSnapshotInstalled;
        if (currentTerm > this.currentTerm()) {
            this.stateStorage.saveTerm(currentTerm);
        }
    }

    @Override
    public final String id() {
        return this.id;
    }

    abstract RaftNodeState stepDown();

    abstract void recover(CompletableFuture<Void> var1);

    abstract RaftNodeState tick();

    abstract void propose(ByteString var1, CompletableFuture<Long> var2);

    abstract RaftNodeState stableTo(long var1);

    abstract RaftNodeState receive(String var1, RaftMessage var2);

    abstract void readIndex(CompletableFuture<Long> var1);

    abstract void transferLeadership(String var1, CompletableFuture<Void> var2);

    abstract void changeClusterConfig(String var1, Set<String> var2, Set<String> var3, CompletableFuture<Void> var4);

    abstract void onSnapshotRestored(ByteString var1, ByteString var2, Throwable var3, CompletableFuture<Void> var4);

    @Override
    public final long currentTerm() {
        return this.stateStorage.currentTerm();
    }

    @Override
    public long firstIndex() {
        return this.stateStorage.firstIndex();
    }

    @Override
    public long lastIndex() {
        return this.stateStorage.lastIndex();
    }

    @Override
    public long commitIndex() {
        return this.commitIndex;
    }

    final Optional<String> currentVote() {
        Optional<Voting> voting = this.stateStorage.currentVoting();
        return voting.map(Voting::getFor);
    }

    @Override
    public final ClusterConfig latestClusterConfig() {
        return this.stateStorage.latestClusterConfig();
    }

    @Override
    public void stop() {
        this.uncommittedProposals.forEach((index, task) -> task.future.completeExceptionally(DropProposalException.cancelled()));
    }

    final ByteString latestSnapshot() {
        return this.stateStorage.latestSnapshot().getData();
    }

    final void retrieveCommitted(long fromIndex, long maxSize, CompletableFuture<ILogEntryIterator> onDone) {
        if (fromIndex < this.stateStorage.firstIndex() || fromIndex > this.stateStorage.lastIndex()) {
            onDone.completeExceptionally(new IndexOutOfBoundsException("Index out of range"));
        } else {
            onDone.complete(this.stateStorage.entries(fromIndex, this.commitIndex + 1L, maxSize));
        }
    }

    final void entryAt(long index, CompletableFuture<Optional<LogEntry>> onDone) {
        onDone.complete(this.stateStorage.entryAt(index));
    }

    final void compact(ByteString fsmSnapshot, long compactIndex, CompletableFuture<Void> onDone) {
        Optional<LogEntry> compactEntry = this.stateStorage.entryAt(compactIndex);
        if (compactEntry.isPresent() || this.stateStorage.latestSnapshot().getIndex() == compactIndex) {
            Snapshot newSnapshot = Snapshot.newBuilder().setClusterConfig(this.stateStorage.latestClusterConfig()).setIndex(compactIndex).setTerm(compactEntry.map(LogEntry::getTerm).orElse(this.stateStorage.latestSnapshot().getTerm()).longValue()).setData(fsmSnapshot).build();
            this.onSnapshotReady(newSnapshot, onDone);
        } else {
            onDone.completeExceptionally(CompactionException.staleSnapshot());
        }
    }

    protected void onSnapshotReady(Snapshot snapshot, CompletableFuture<Void> onDone) {
        this.applySnapshot(snapshot, onDone);
    }

    protected final void applySnapshot(Snapshot snapshot, CompletableFuture<Void> onDone) {
        try {
            long firstIndex = this.stateStorage.firstIndex();
            this.stateStorage.applySnapshot(snapshot);
            this.log.debug("Compacted entries[{},{}]", (Object)firstIndex, (Object)snapshot.getIndex());
            onDone.complete(null);
        }
        catch (Throwable e) {
            onDone.completeExceptionally(new CompactionException("Failed to apply snapshot", e));
        }
    }

    protected Set<String> voters() {
        ClusterConfig clusterConfig = this.stateStorage.latestClusterConfig();
        HashSet<String> voters = new HashSet<String>((Collection<String>)clusterConfig.getVotersList());
        voters.addAll((Collection<String>)clusterConfig.getNextVotersList());
        return voters;
    }

    protected Set<String> remoteVoters() {
        ClusterConfig clusterConfig = this.stateStorage.latestClusterConfig();
        HashSet<String> all = new HashSet<String>((Collection<String>)clusterConfig.getVotersList());
        all.addAll((Collection<String>)clusterConfig.getNextVotersList());
        all.remove(this.stateStorage.local());
        return all;
    }

    protected boolean promotable() {
        return this.voters().contains(this.id);
    }

    protected int randomizeElectionTimeoutTick() {
        return this.config.getElectionTimeoutTick() + ThreadLocalRandom.current().nextInt(1, this.config.getElectionTimeoutTick() + 1);
    }

    protected void submitRaftMessages(Map<String, List<RaftMessage>> messages) {
        Map<String, List<RaftMessage>> sendMessages = messages.entrySet().stream().filter(entry -> !((List)entry.getValue()).isEmpty()).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
        if (!sendMessages.isEmpty()) {
            this.sender.send(sendMessages);
        }
    }

    protected void submitRaftMessages(final String remotePeer, final RaftMessage message) {
        this.submitRaftMessages((Map<String, List<RaftMessage>>)new HashMap<String, List<RaftMessage>>(){
            {
                this.put(remotePeer, Collections.singletonList(message));
            }
        });
    }

    protected void submitRaftMessages(final String remotePeer, final List<RaftMessage> messages) {
        this.submitRaftMessages((Map<String, List<RaftMessage>>)new HashMap<String, List<RaftMessage>>(){
            {
                this.put(remotePeer, messages);
            }
        });
    }

    protected void submitSnapshot(ByteString requested, String fromLeader) {
        this.snapshotInstaller.install(requested, fromLeader, (installed, ex) -> this.onSnapshotInstalled.done(requested, installed, ex));
    }

    protected void notifyCommit(boolean isLeader) {
        this.log.trace("Notify commit index[{}]", (Object)this.commitIndex);
        Iterator<Map.Entry<Long, ProposeTask>> it = this.uncommittedProposals.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry<Long, ProposeTask> entry = it.next();
            long proposalIndex = entry.getKey();
            ProposeTask task = entry.getValue();
            long proposalTerm = task.term;
            Optional<LogEntry> proposalEntry = this.stateStorage.entryAt(proposalIndex);
            if (proposalEntry.isPresent()) {
                if (proposalIndex <= this.commitIndex) {
                    it.remove();
                    if (proposalTerm == proposalEntry.get().getTerm()) {
                        task.future.complete(proposalIndex);
                        continue;
                    }
                    task.future.completeExceptionally(DropProposalException.overridden());
                    continue;
                }
                if (proposalTerm >= this.currentTerm()) break;
                it.remove();
                task.future.completeExceptionally(DropProposalException.overridden());
                continue;
            }
            it.remove();
            task.future.completeExceptionally(DropProposalException.overridden());
        }
        this.listener.onEvent(new CommitEvent(this.id, this.commitIndex, isLeader));
    }

    protected void notifyLeaderElected(String leaderId, long term) {
        this.listener.onEvent(new ElectionEvent(this.id, leaderId, term));
    }

    protected void notifyStateChanged() {
        this.listener.onEvent(new StatusChangedEvent(this.id, this.getState()));
    }

    protected void notifySnapshotRestored() {
        this.listener.onEvent(new SnapshotRestoredEvent(this.id, this.stateStorage.latestSnapshot()));
    }

    protected boolean isUpToDate(long term, long index) {
        long localLastTerm = this.stateStorage.latestSnapshot().getTerm();
        long localLastIndex = this.stateStorage.latestSnapshot().getIndex();
        if (this.stateStorage.lastIndex() >= this.stateStorage.firstIndex()) {
            localLastTerm = this.stateStorage.entryAt(this.stateStorage.lastIndex()).get().getTerm();
            localLastIndex = this.stateStorage.lastIndex();
        }
        return term > localLastTerm || term == localLastTerm && index >= localLastIndex;
    }

    protected boolean isProposeThrottled() {
        return this.uncommittedProposals.size() > this.maxUncommittedProposals;
    }

    protected void handlePreVote(String fromPeer, long askedTerm, RequestPreVote request) {
        this.sendRequestPreVoteReply(fromPeer, askedTerm, this.isUpToDate(request.getLastLogTerm(), request.getLastLogIndex()));
    }

    protected void sendRequestPreVoteReply(String fromPeer, long term, boolean granted) {
        this.log.debug("Answering pre-vote request from peer[{}] of term[{}], granted?: {}", new Object[]{fromPeer, term, granted});
        RaftMessage reply = RaftMessage.newBuilder().setTerm(term).setRequestPreVoteReply(RequestPreVoteReply.newBuilder().setVoteCouldGranted(granted).build()).build();
        this.submitRaftMessages(fromPeer, reply);
    }

    protected void sendRequestVoteReply(String fromPeer, long term, boolean granted) {
        RaftMessage requestVoteReply = RaftMessage.newBuilder().setTerm(term).setRequestVoteReply(RequestVoteReply.newBuilder().setVoteGranted(granted).build()).build();
        this.submitRaftMessages(fromPeer, requestVoteReply);
    }

    protected void handleLowTermMessage(String fromPeer, RaftMessage message) {
        switch (message.getMessageTypeCase()) {
            case APPENDENTRIES: 
            case INSTALLSNAPSHOT: {
                this.log.debug("Reply to the leader[{}] of lower term[{}] to let it step down", (Object)fromPeer, (Object)message.getTerm());
                this.submitRaftMessages(fromPeer, RaftMessage.newBuilder().setTerm(this.currentTerm()).setAppendEntriesReply(AppendEntriesReply.getDefaultInstance()).build());
                break;
            }
            case REQUESTPREVOTE: {
                this.log.debug("Reject pre-vote from candidate[{}] of lower term[{}]", (Object)fromPeer, (Object)message.getTerm());
                this.submitRaftMessages(fromPeer, RaftMessage.newBuilder().setTerm(this.currentTerm()).setRequestPreVoteReply(RequestPreVoteReply.newBuilder().setVoteCouldGranted(false).build()).build());
                break;
            }
            default: {
                this.log.debug("Ignore message[{}] with lower term[{}] from peer[{}]", new Object[]{message.getMessageTypeCase(), message.getTerm(), fromPeer});
            }
        }
    }

    static interface OnSnapshotInstalled {
        public CompletableFuture<Void> done(ByteString var1, ByteString var2, Throwable var3);
    }

    protected static class ProposeTask {
        final long term;
        final CompletableFuture<Long> future;

        ProposeTask(long term, CompletableFuture<Long> future) {
            this.term = term;
            this.future = future;
        }
    }
}

