/*
 * Decompiled with CFR 0.152.
 */
package com.vesoft.nebula.storage;

import com.facebook.thrift.TBase;
import com.facebook.thrift.TBaseHelper;
import com.facebook.thrift.TException;
import com.facebook.thrift.meta_data.FieldMetaData;
import com.facebook.thrift.meta_data.FieldValueMetaData;
import com.facebook.thrift.meta_data.MapMetaData;
import com.facebook.thrift.meta_data.StructMetaData;
import com.facebook.thrift.protocol.TField;
import com.facebook.thrift.protocol.TMap;
import com.facebook.thrift.protocol.TProtocol;
import com.facebook.thrift.protocol.TProtocolException;
import com.facebook.thrift.protocol.TProtocolUtil;
import com.facebook.thrift.protocol.TStruct;
import com.vesoft.nebula.storage.ResponseCommon;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public class KVGetResponse
implements TBase,
Serializable,
Cloneable,
Comparable<KVGetResponse> {
    private static final TStruct STRUCT_DESC = new TStruct("KVGetResponse");
    private static final TField RESULT_FIELD_DESC = new TField("result", 12, 1);
    private static final TField KEY_VALUES_FIELD_DESC = new TField("key_values", 13, 2);
    public ResponseCommon result;
    public Map<byte[], byte[]> key_values;
    public static final int RESULT = 1;
    public static final int KEY_VALUES = 2;
    public static final Map<Integer, FieldMetaData> metaDataMap;

    public KVGetResponse() {
    }

    public KVGetResponse(ResponseCommon result) {
        this();
        this.result = result;
    }

    public KVGetResponse(ResponseCommon result, Map<byte[], byte[]> key_values) {
        this();
        this.result = result;
        this.key_values = key_values;
    }

    public static Builder builder() {
        return new Builder();
    }

    public KVGetResponse(KVGetResponse other) {
        if (other.isSetResult()) {
            this.result = TBaseHelper.deepCopy(other.result);
        }
        if (other.isSetKey_values()) {
            this.key_values = TBaseHelper.deepCopy(other.key_values);
        }
    }

    @Override
    public KVGetResponse deepCopy() {
        return new KVGetResponse(this);
    }

    public ResponseCommon getResult() {
        return this.result;
    }

    public KVGetResponse setResult(ResponseCommon result) {
        this.result = result;
        return this;
    }

    public void unsetResult() {
        this.result = null;
    }

    public boolean isSetResult() {
        return this.result != null;
    }

    public void setResultIsSet(boolean __value) {
        if (!__value) {
            this.result = null;
        }
    }

    public Map<byte[], byte[]> getKey_values() {
        return this.key_values;
    }

    public KVGetResponse setKey_values(Map<byte[], byte[]> key_values) {
        this.key_values = key_values;
        return this;
    }

    public void unsetKey_values() {
        this.key_values = null;
    }

    public boolean isSetKey_values() {
        return this.key_values != null;
    }

    public void setKey_valuesIsSet(boolean __value) {
        if (!__value) {
            this.key_values = null;
        }
    }

    public void setFieldValue(int fieldID, Object __value) {
        switch (fieldID) {
            case 1: {
                if (__value == null) {
                    this.unsetResult();
                    break;
                }
                this.setResult((ResponseCommon)__value);
                break;
            }
            case 2: {
                if (__value == null) {
                    this.unsetKey_values();
                    break;
                }
                this.setKey_values((Map)__value);
                break;
            }
            default: {
                throw new IllegalArgumentException("Field " + fieldID + " doesn't exist!");
            }
        }
    }

    public Object getFieldValue(int fieldID) {
        switch (fieldID) {
            case 1: {
                return this.getResult();
            }
            case 2: {
                return this.getKey_values();
            }
        }
        throw new IllegalArgumentException("Field " + fieldID + " doesn't exist!");
    }

    public boolean equals(Object _that) {
        if (_that == null) {
            return false;
        }
        if (this == _that) {
            return true;
        }
        if (!(_that instanceof KVGetResponse)) {
            return false;
        }
        KVGetResponse that = (KVGetResponse)_that;
        if (!TBaseHelper.equalsNobinary(this.isSetResult(), that.isSetResult(), this.result, that.result)) {
            return false;
        }
        return TBaseHelper.equalsSlow(this.isSetKey_values(), that.isSetKey_values(), this.key_values, that.key_values);
    }

    public int hashCode() {
        return Arrays.deepHashCode(new Object[]{this.result, this.key_values});
    }

    @Override
    public int compareTo(KVGetResponse other) {
        if (other == null) {
            throw new NullPointerException();
        }
        if (other == this) {
            return 0;
        }
        int lastComparison = 0;
        lastComparison = Boolean.valueOf(this.isSetResult()).compareTo(other.isSetResult());
        if (lastComparison != 0) {
            return lastComparison;
        }
        lastComparison = TBaseHelper.compareTo(this.result, other.result);
        if (lastComparison != 0) {
            return lastComparison;
        }
        lastComparison = Boolean.valueOf(this.isSetKey_values()).compareTo(other.isSetKey_values());
        if (lastComparison != 0) {
            return lastComparison;
        }
        lastComparison = TBaseHelper.compareTo(this.key_values, other.key_values);
        if (lastComparison != 0) {
            return lastComparison;
        }
        return 0;
    }

    @Override
    public void read(TProtocol iprot) throws TException {
        iprot.readStructBegin(metaDataMap);
        while (true) {
            TField __field = iprot.readFieldBegin();
            if (__field.type == 0) break;
            switch (__field.id) {
                case 1: {
                    if (__field.type == 12) {
                        this.result = new ResponseCommon();
                        this.result.read(iprot);
                        break;
                    }
                    TProtocolUtil.skip(iprot, __field.type);
                    break;
                }
                case 2: {
                    if (__field.type == 13) {
                        TMap _map250 = iprot.readMapBegin();
                        this.key_values = new HashMap<byte[], byte[]>(Math.max(0, 2 * _map250.size));
                        int _i251 = 0;
                        while (_map250.size < 0 ? iprot.peekMap() : _i251 < _map250.size) {
                            byte[] _key252 = iprot.readBinary();
                            byte[] _val253 = iprot.readBinary();
                            this.key_values.put(_key252, _val253);
                            ++_i251;
                        }
                        iprot.readMapEnd();
                        break;
                    }
                    TProtocolUtil.skip(iprot, __field.type);
                    break;
                }
                default: {
                    TProtocolUtil.skip(iprot, __field.type);
                }
            }
            iprot.readFieldEnd();
        }
        iprot.readStructEnd();
        this.validate();
    }

    @Override
    public void write(TProtocol oprot) throws TException {
        this.validate();
        oprot.writeStructBegin(STRUCT_DESC);
        if (this.result != null) {
            oprot.writeFieldBegin(RESULT_FIELD_DESC);
            this.result.write(oprot);
            oprot.writeFieldEnd();
        }
        if (this.key_values != null) {
            oprot.writeFieldBegin(KEY_VALUES_FIELD_DESC);
            oprot.writeMapBegin(new TMap(11, 11, this.key_values.size()));
            for (Map.Entry<byte[], byte[]> _iter254 : this.key_values.entrySet()) {
                oprot.writeBinary(_iter254.getKey());
                oprot.writeBinary(_iter254.getValue());
            }
            oprot.writeMapEnd();
            oprot.writeFieldEnd();
        }
        oprot.writeFieldStop();
        oprot.writeStructEnd();
    }

    public String toString() {
        return this.toString(1, true);
    }

    @Override
    public String toString(int indent, boolean prettyPrint) {
        String indentStr = prettyPrint ? TBaseHelper.getIndentedString(indent) : "";
        String newLine = prettyPrint ? "\n" : "";
        String space = prettyPrint ? " " : "";
        StringBuilder sb = new StringBuilder("KVGetResponse");
        sb.append(space);
        sb.append("(");
        sb.append(newLine);
        boolean first = true;
        sb.append(indentStr);
        sb.append("result");
        sb.append(space);
        sb.append(":").append(space);
        if (this.getResult() == null) {
            sb.append("null");
        } else {
            sb.append(TBaseHelper.toString(this.getResult(), indent + 1, prettyPrint));
        }
        first = false;
        if (!first) {
            sb.append("," + newLine);
        }
        sb.append(indentStr);
        sb.append("key_values");
        sb.append(space);
        sb.append(":").append(space);
        if (this.getKey_values() == null) {
            sb.append("null");
        } else {
            sb.append(TBaseHelper.toString(this.getKey_values(), indent + 1, prettyPrint));
        }
        first = false;
        sb.append(newLine + TBaseHelper.reduceIndent(indentStr));
        sb.append(")");
        return sb.toString();
    }

    public void validate() throws TException {
        if (this.result == null) {
            throw new TProtocolException(6, "Required field 'result' was not present! Struct: " + this.toString());
        }
    }

    static {
        HashMap<Integer, FieldMetaData> tmpMetaDataMap = new HashMap<Integer, FieldMetaData>();
        tmpMetaDataMap.put(1, new FieldMetaData("result", 1, new StructMetaData(12, ResponseCommon.class)));
        tmpMetaDataMap.put(2, new FieldMetaData("key_values", 3, new MapMetaData(13, new FieldValueMetaData(11), new FieldValueMetaData(11))));
        metaDataMap = Collections.unmodifiableMap(tmpMetaDataMap);
        FieldMetaData.addStructMetaDataMap(KVGetResponse.class, metaDataMap);
    }

    public static class Builder {
        private ResponseCommon result;
        private Map<byte[], byte[]> key_values;

        public Builder setResult(ResponseCommon result) {
            this.result = result;
            return this;
        }

        public Builder setKey_values(Map<byte[], byte[]> key_values) {
            this.key_values = key_values;
            return this;
        }

        public KVGetResponse build() {
            KVGetResponse result = new KVGetResponse();
            result.setResult(this.result);
            result.setKey_values(this.key_values);
            return result;
        }
    }
}

