/*
 * Decompiled with CFR 0.152.
 */
package dm.jdbc.filter.stat;

import dm.jdbc.enums.ExecuteType;
import dm.jdbc.filter.stat.BaseStat;
import dm.jdbc.filter.stat.SqlStatValue;
import dm.jdbc.util.DriverUtil;
import dm.jdbc.util.IDGenerator;
import java.lang.reflect.Method;
import java.util.Date;
import java.util.Map;
import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;
import java.util.concurrent.atomic.AtomicLongFieldUpdater;

public final class SqlStat
extends BaseStat {
    private final String sql;
    private long sqlHash;
    private String id;
    private long executeLastStartTime;
    private volatile long executeBatchSizeTotal;
    private volatile int executeBatchSizeMax;
    private volatile long executeSuccessCount;
    private volatile long executeSpanNanoTotal;
    private volatile long executeSpanNanoMax;
    private volatile int runningCount;
    private volatile int concurrentMax;
    private volatile long resultSetHoldTimeNano;
    private volatile long executeAndResultSetHoldTime;
    static final AtomicLongFieldUpdater executeBatchSizeTotalUpdater = AtomicLongFieldUpdater.newUpdater(SqlStat.class, "executeBatchSizeTotal");
    static final AtomicIntegerFieldUpdater executeBatchSizeMaxUpdater = AtomicIntegerFieldUpdater.newUpdater(SqlStat.class, "executeBatchSizeMax");
    static final AtomicLongFieldUpdater executeSuccessCountUpdater = AtomicLongFieldUpdater.newUpdater(SqlStat.class, "executeSuccessCount");
    static final AtomicLongFieldUpdater executeSpanNanoTotalUpdater = AtomicLongFieldUpdater.newUpdater(SqlStat.class, "executeSpanNanoTotal");
    static final AtomicLongFieldUpdater executeSpanNanoMaxUpdater = AtomicLongFieldUpdater.newUpdater(SqlStat.class, "executeSpanNanoMax");
    static final AtomicIntegerFieldUpdater runningCountUpdater = AtomicIntegerFieldUpdater.newUpdater(SqlStat.class, "runningCount");
    static final AtomicIntegerFieldUpdater concurrentMaxUpdater = AtomicIntegerFieldUpdater.newUpdater(SqlStat.class, "concurrentMax");
    static final AtomicLongFieldUpdater resultSetHoldTimeNanoUpdater = AtomicLongFieldUpdater.newUpdater(SqlStat.class, "resultSetHoldTimeNano");
    static final AtomicLongFieldUpdater executeAndResultSetHoldTimeUpdater = AtomicLongFieldUpdater.newUpdater(SqlStat.class, "executeAndResultSetHoldTime");
    private String dataSource;
    private String file;
    private volatile long executeNanoSpanMaxOccurTime;
    private volatile long executeErrorCount;
    private volatile Throwable executeErrorLast;
    private volatile long executeErrorLastTime;
    private volatile long updateCount;
    private volatile long updateCountMax;
    private volatile long fetchRowCount;
    private volatile long fetchRowCountMax;
    private volatile long inTransactionCount;
    private volatile String lastSlowParameters;
    private boolean removed = false;
    private volatile long clobOpenCount;
    private volatile long blobOpenCount;
    private volatile long readStringLength;
    private volatile long readBytesLength;
    private volatile long inputStreamOpenCount;
    private volatile long readerOpenCount;
    static final AtomicLongFieldUpdater executeErrorCountUpdater = AtomicLongFieldUpdater.newUpdater(SqlStat.class, "executeErrorCount");
    static final AtomicLongFieldUpdater updateCountUpdater = AtomicLongFieldUpdater.newUpdater(SqlStat.class, "updateCount");
    static final AtomicLongFieldUpdater updateCountMaxUpdater = AtomicLongFieldUpdater.newUpdater(SqlStat.class, "updateCountMax");
    static final AtomicLongFieldUpdater fetchRowCountUpdater = AtomicLongFieldUpdater.newUpdater(SqlStat.class, "fetchRowCount");
    static final AtomicLongFieldUpdater fetchRowCountMaxUpdater = AtomicLongFieldUpdater.newUpdater(SqlStat.class, "fetchRowCountMax");
    static final AtomicLongFieldUpdater inTransactionCountUpdater = AtomicLongFieldUpdater.newUpdater(SqlStat.class, "inTransactionCount");
    static final AtomicLongFieldUpdater clobOpenCountUpdater = AtomicLongFieldUpdater.newUpdater(SqlStat.class, "clobOpenCount");
    static final AtomicLongFieldUpdater blobOpenCountUpdater = AtomicLongFieldUpdater.newUpdater(SqlStat.class, "blobOpenCount");
    static final AtomicLongFieldUpdater readStringLengthUpdater = AtomicLongFieldUpdater.newUpdater(SqlStat.class, "readStringLength");
    static final AtomicLongFieldUpdater readBytesLengthUpdater = AtomicLongFieldUpdater.newUpdater(SqlStat.class, "readBytesLength");
    static final AtomicLongFieldUpdater inputStreamOpenCountUpdater = AtomicLongFieldUpdater.newUpdater(SqlStat.class, "inputStreamOpenCount");
    static final AtomicLongFieldUpdater readerOpenCountUpdater = AtomicLongFieldUpdater.newUpdater(SqlStat.class, "readerOpenCount");
    private volatile long histogram_0_1;
    private volatile long histogram_1_10;
    private volatile int histogram_10_100;
    private volatile int histogram_100_1000;
    private volatile int histogram_1000_10000;
    private volatile int histogram_10000_100000;
    private volatile int histogram_100000_1000000;
    private volatile int histogram_1000000_more;
    static final AtomicLongFieldUpdater histogram_0_1_Updater = AtomicLongFieldUpdater.newUpdater(SqlStat.class, "histogram_0_1");
    static final AtomicLongFieldUpdater histogram_1_10_Updater = AtomicLongFieldUpdater.newUpdater(SqlStat.class, "histogram_1_10");
    static final AtomicIntegerFieldUpdater histogram_10_100_Updater = AtomicIntegerFieldUpdater.newUpdater(SqlStat.class, "histogram_10_100");
    static final AtomicIntegerFieldUpdater histogram_100_1000_Updater = AtomicIntegerFieldUpdater.newUpdater(SqlStat.class, "histogram_100_1000");
    static final AtomicIntegerFieldUpdater histogram_1000_10000_Updater = AtomicIntegerFieldUpdater.newUpdater(SqlStat.class, "histogram_1000_10000");
    static final AtomicIntegerFieldUpdater histogram_10000_100000_Updater = AtomicIntegerFieldUpdater.newUpdater(SqlStat.class, "histogram_10000_100000");
    static final AtomicIntegerFieldUpdater histogram_100000_1000000_Updater = AtomicIntegerFieldUpdater.newUpdater(SqlStat.class, "histogram_100000_1000000");
    static final AtomicIntegerFieldUpdater histogram_1000000_more_Updater = AtomicIntegerFieldUpdater.newUpdater(SqlStat.class, "histogram_1000000_more");
    private volatile long executeAndResultHoldTime_0_1;
    private volatile long executeAndResultHoldTime_1_10;
    private volatile int executeAndResultHoldTime_10_100;
    private volatile int executeAndResultHoldTime_100_1000;
    private volatile int executeAndResultHoldTime_1000_10000;
    private volatile int executeAndResultHoldTime_10000_100000;
    private volatile int executeAndResultHoldTime_100000_1000000;
    private volatile int executeAndResultHoldTime_1000000_more;
    static final AtomicLongFieldUpdater executeAndResultHoldTime_0_1_Updater = AtomicLongFieldUpdater.newUpdater(SqlStat.class, "executeAndResultHoldTime_0_1");
    static final AtomicLongFieldUpdater executeAndResultHoldTime_1_10_Updater = AtomicLongFieldUpdater.newUpdater(SqlStat.class, "executeAndResultHoldTime_1_10");
    static final AtomicIntegerFieldUpdater executeAndResultHoldTime_10_100_Updater = AtomicIntegerFieldUpdater.newUpdater(SqlStat.class, "executeAndResultHoldTime_10_100");
    static final AtomicIntegerFieldUpdater executeAndResultHoldTime_100_1000_Updater = AtomicIntegerFieldUpdater.newUpdater(SqlStat.class, "executeAndResultHoldTime_100_1000");
    static final AtomicIntegerFieldUpdater executeAndResultHoldTime_1000_10000_Updater = AtomicIntegerFieldUpdater.newUpdater(SqlStat.class, "executeAndResultHoldTime_1000_10000");
    static final AtomicIntegerFieldUpdater executeAndResultHoldTime_10000_100000_Updater = AtomicIntegerFieldUpdater.newUpdater(SqlStat.class, "executeAndResultHoldTime_10000_100000");
    static final AtomicIntegerFieldUpdater executeAndResultHoldTime_100000_1000000_Updater = AtomicIntegerFieldUpdater.newUpdater(SqlStat.class, "executeAndResultHoldTime_100000_1000000");
    static final AtomicIntegerFieldUpdater executeAndResultHoldTime_1000000_more_Updater = AtomicIntegerFieldUpdater.newUpdater(SqlStat.class, "executeAndResultHoldTime_1000000_more");
    private volatile long fetchRowCount_0_1;
    private volatile long fetchRowCount_1_10;
    private volatile long fetchRowCount_10_100;
    private volatile int fetchRowCount_100_1000;
    private volatile int fetchRowCount_1000_10000;
    private volatile int fetchRowCount_10000_more;
    static final AtomicLongFieldUpdater fetchRowCount_0_1_Updater = AtomicLongFieldUpdater.newUpdater(SqlStat.class, "fetchRowCount_0_1");
    static final AtomicLongFieldUpdater fetchRowCount_1_10_Updater = AtomicLongFieldUpdater.newUpdater(SqlStat.class, "fetchRowCount_1_10");
    static final AtomicLongFieldUpdater fetchRowCount_10_100_Updater = AtomicLongFieldUpdater.newUpdater(SqlStat.class, "fetchRowCount_10_100");
    static final AtomicIntegerFieldUpdater fetchRowCount_100_1000_Updater = AtomicIntegerFieldUpdater.newUpdater(SqlStat.class, "fetchRowCount_100_1000");
    static final AtomicIntegerFieldUpdater fetchRowCount_1000_10000_Updater = AtomicIntegerFieldUpdater.newUpdater(SqlStat.class, "fetchRowCount_1000_10000");
    static final AtomicIntegerFieldUpdater fetchRowCount_10000_more_Updater = AtomicIntegerFieldUpdater.newUpdater(SqlStat.class, "fetchRowCount_10000_more");
    private volatile long updateCount_0_1;
    private volatile long updateCount_1_10;
    private volatile long updateCount_10_100;
    private volatile int updateCount_100_1000;
    private volatile int updateCount_1000_10000;
    private volatile int updateCount_10000_more;
    private String dataSourceId;
    static final AtomicLongFieldUpdater updateCount_0_1_Updater = AtomicLongFieldUpdater.newUpdater(SqlStat.class, "updateCount_0_1");
    static final AtomicLongFieldUpdater updateCount_1_10_Updater = AtomicLongFieldUpdater.newUpdater(SqlStat.class, "updateCount_1_10");
    static final AtomicLongFieldUpdater updateCount_10_100_Updater = AtomicLongFieldUpdater.newUpdater(SqlStat.class, "updateCount_10_100");
    static final AtomicIntegerFieldUpdater updateCount_100_1000_Updater = AtomicIntegerFieldUpdater.newUpdater(SqlStat.class, "updateCount_100_1000");
    static final AtomicIntegerFieldUpdater updateCount_1000_10000_Updater = AtomicIntegerFieldUpdater.newUpdater(SqlStat.class, "updateCount_1000_10000");
    static final AtomicIntegerFieldUpdater updateCount_10000_more_Updater = AtomicIntegerFieldUpdater.newUpdater(SqlStat.class, "updateCount_10000_more");

    public SqlStat(String string) {
        this.sql = string;
        this.id = "SQL" + IDGenerator.generateId();
    }

    public String getLastSlowParameters() {
        return this.lastSlowParameters;
    }

    public void setLastSlowParameters(String string) {
        this.lastSlowParameters = string;
    }

    public String getDataSource() {
        return this.dataSource;
    }

    public void setDataSource(String string) {
        this.dataSource = string;
    }

    public String getDataSourceId() {
        return this.dataSourceId;
    }

    public void setDataSourceId(String string) {
        this.dataSourceId = string;
    }

    public String getFile() {
        return this.file;
    }

    public void setFile(String string) {
        this.file = string;
    }

    public void reset() {
        this.executeLastStartTime = 0L;
        executeBatchSizeTotalUpdater.set(this, 0L);
        executeBatchSizeMaxUpdater.set(this, 0);
        executeSuccessCountUpdater.set(this, 0L);
        executeSpanNanoTotalUpdater.set(this, 0L);
        executeSpanNanoMaxUpdater.set(this, 0L);
        this.executeNanoSpanMaxOccurTime = 0L;
        concurrentMaxUpdater.set(this, 0);
        executeErrorCountUpdater.set(this, 0L);
        this.executeErrorLast = null;
        this.executeErrorLastTime = 0L;
        updateCountUpdater.set(this, 0L);
        updateCountMaxUpdater.set(this, 0L);
        fetchRowCountUpdater.set(this, 0L);
        fetchRowCountMaxUpdater.set(this, 0L);
        histogram_0_1_Updater.set(this, 0L);
        histogram_1_10_Updater.set(this, 0L);
        histogram_10_100_Updater.set(this, 0);
        histogram_100_1000_Updater.set(this, 0);
        histogram_1000_10000_Updater.set(this, 0);
        histogram_10000_100000_Updater.set(this, 0);
        histogram_100000_1000000_Updater.set(this, 0);
        histogram_1000000_more_Updater.set(this, 0);
        this.lastSlowParameters = null;
        inTransactionCountUpdater.set(this, 0L);
        resultSetHoldTimeNanoUpdater.set(this, 0L);
        executeAndResultSetHoldTimeUpdater.set(this, 0L);
        fetchRowCount_0_1_Updater.set(this, 0L);
        fetchRowCount_1_10_Updater.set(this, 0L);
        fetchRowCount_10_100_Updater.set(this, 0L);
        fetchRowCount_100_1000_Updater.set(this, 0);
        fetchRowCount_1000_10000_Updater.set(this, 0);
        fetchRowCount_10000_more_Updater.set(this, 0);
        updateCount_0_1_Updater.set(this, 0L);
        updateCount_1_10_Updater.set(this, 0L);
        updateCount_10_100_Updater.set(this, 0L);
        updateCount_100_1000_Updater.set(this, 0);
        updateCount_1000_10000_Updater.set(this, 0);
        updateCount_10000_more_Updater.set(this, 0);
        executeAndResultHoldTime_0_1_Updater.set(this, 0L);
        executeAndResultHoldTime_1_10_Updater.set(this, 0L);
        executeAndResultHoldTime_10_100_Updater.set(this, 0);
        executeAndResultHoldTime_100_1000_Updater.set(this, 0);
        executeAndResultHoldTime_1000_10000_Updater.set(this, 0);
        executeAndResultHoldTime_10000_100000_Updater.set(this, 0);
        executeAndResultHoldTime_100000_1000000_Updater.set(this, 0);
        executeAndResultHoldTime_1000000_more_Updater.set(this, 0);
        blobOpenCountUpdater.set(this, 0L);
        clobOpenCountUpdater.set(this, 0L);
        readStringLengthUpdater.set(this, 0L);
        readBytesLengthUpdater.set(this, 0L);
        inputStreamOpenCountUpdater.set(this, 0L);
        readerOpenCountUpdater.set(this, 0L);
    }

    public SqlStatValue getValueAndReset() {
        return this.getValue(true);
    }

    public SqlStatValue getValue(boolean bl) {
        SqlStatValue sqlStatValue = new SqlStatValue();
        sqlStatValue.setDataSource(this.dataSource);
        sqlStatValue.setDataSourceId(this.dataSourceId);
        sqlStatValue.setSql(this.sql);
        sqlStatValue.setSqlHash(this.getSqlHash());
        sqlStatValue.setId(this.id);
        sqlStatValue.setExecuteLastStartTime(this.executeLastStartTime);
        if (bl) {
            this.executeLastStartTime = 0L;
        }
        sqlStatValue.setExecuteBatchSizeTotal(SqlStat.get((Object)this, executeBatchSizeTotalUpdater, bl));
        sqlStatValue.setExecuteBatchSizeMax(SqlStat.get((Object)this, executeBatchSizeMaxUpdater, bl));
        sqlStatValue.setExecuteSuccessCount(SqlStat.get((Object)this, executeSuccessCountUpdater, bl));
        sqlStatValue.setExecuteSpanNanoTotal(SqlStat.get((Object)this, executeSpanNanoTotalUpdater, bl));
        sqlStatValue.setExecuteSpanNanoMax(SqlStat.get((Object)this, executeSpanNanoMaxUpdater, bl));
        sqlStatValue.setExecuteNanoSpanMaxOccurTime(this.executeNanoSpanMaxOccurTime);
        if (bl) {
            this.executeNanoSpanMaxOccurTime = 0L;
        }
        sqlStatValue.setRunningCount(this.runningCount);
        sqlStatValue.setConcurrentMax(SqlStat.get((Object)this, concurrentMaxUpdater, bl));
        sqlStatValue.setExecuteErrorCount(SqlStat.get((Object)this, executeErrorCountUpdater, bl));
        sqlStatValue.setExecuteErrorLast(this.executeErrorLast);
        if (bl) {
            this.executeErrorLast = null;
        }
        sqlStatValue.setExecuteErrorLastTime(this.executeErrorLastTime);
        if (bl) {
            this.executeErrorLastTime = 0L;
        }
        sqlStatValue.setUpdateCount(SqlStat.get((Object)this, updateCountUpdater, bl));
        sqlStatValue.setUpdateCountMax(SqlStat.get((Object)this, updateCountMaxUpdater, bl));
        sqlStatValue.setFetchRowCount(SqlStat.get((Object)this, fetchRowCountUpdater, bl));
        sqlStatValue.setFetchRowCountMax(SqlStat.get((Object)this, fetchRowCountMaxUpdater, bl));
        sqlStatValue.histogram_0_1 = SqlStat.get((Object)this, histogram_0_1_Updater, bl);
        sqlStatValue.histogram_1_10 = SqlStat.get((Object)this, histogram_1_10_Updater, bl);
        sqlStatValue.histogram_10_100 = SqlStat.get((Object)this, histogram_10_100_Updater, bl);
        sqlStatValue.histogram_100_1000 = SqlStat.get((Object)this, histogram_100_1000_Updater, bl);
        sqlStatValue.histogram_1000_10000 = SqlStat.get((Object)this, histogram_1000_10000_Updater, bl);
        sqlStatValue.histogram_10000_100000 = SqlStat.get((Object)this, histogram_10000_100000_Updater, bl);
        sqlStatValue.histogram_100000_1000000 = SqlStat.get((Object)this, histogram_100000_1000000_Updater, bl);
        sqlStatValue.histogram_1000000_more = SqlStat.get((Object)this, histogram_1000000_more_Updater, bl);
        sqlStatValue.setLastSlowParameters(this.lastSlowParameters);
        if (bl) {
            this.lastSlowParameters = null;
        }
        sqlStatValue.setInTransactionCount(SqlStat.get((Object)this, inTransactionCountUpdater, bl));
        sqlStatValue.setResultSetHoldTimeNano(SqlStat.get((Object)this, resultSetHoldTimeNanoUpdater, bl));
        sqlStatValue.setExecuteAndResultSetHoldTime(SqlStat.get((Object)this, executeAndResultSetHoldTimeUpdater, bl));
        sqlStatValue.fetchRowCount_0_1 = SqlStat.get((Object)this, fetchRowCount_0_1_Updater, bl);
        sqlStatValue.fetchRowCount_1_10 = SqlStat.get((Object)this, fetchRowCount_1_10_Updater, bl);
        sqlStatValue.fetchRowCount_10_100 = SqlStat.get((Object)this, fetchRowCount_10_100_Updater, bl);
        sqlStatValue.fetchRowCount_100_1000 = SqlStat.get((Object)this, fetchRowCount_100_1000_Updater, bl);
        sqlStatValue.fetchRowCount_1000_10000 = SqlStat.get((Object)this, fetchRowCount_1000_10000_Updater, bl);
        sqlStatValue.fetchRowCount_10000_more = SqlStat.get((Object)this, fetchRowCount_10000_more_Updater, bl);
        sqlStatValue.updateCount_0_1 = SqlStat.get((Object)this, updateCount_0_1_Updater, bl);
        sqlStatValue.updateCount_1_10 = SqlStat.get((Object)this, updateCount_1_10_Updater, bl);
        sqlStatValue.updateCount_10_100 = SqlStat.get((Object)this, updateCount_10_100_Updater, bl);
        sqlStatValue.updateCount_100_1000 = SqlStat.get((Object)this, updateCount_100_1000_Updater, bl);
        sqlStatValue.updateCount_1000_10000 = SqlStat.get((Object)this, updateCount_1000_10000_Updater, bl);
        sqlStatValue.updateCount_10000_more = SqlStat.get((Object)this, updateCount_10000_more_Updater, bl);
        sqlStatValue.executeAndResultHoldTime_0_1 = SqlStat.get((Object)this, executeAndResultHoldTime_0_1_Updater, bl);
        sqlStatValue.executeAndResultHoldTime_1_10 = SqlStat.get((Object)this, executeAndResultHoldTime_1_10_Updater, bl);
        sqlStatValue.executeAndResultHoldTime_10_100 = SqlStat.get((Object)this, executeAndResultHoldTime_10_100_Updater, bl);
        sqlStatValue.executeAndResultHoldTime_100_1000 = SqlStat.get((Object)this, executeAndResultHoldTime_100_1000_Updater, bl);
        sqlStatValue.executeAndResultHoldTime_1000_10000 = SqlStat.get((Object)this, executeAndResultHoldTime_1000_10000_Updater, bl);
        sqlStatValue.executeAndResultHoldTime_10000_100000 = SqlStat.get((Object)this, executeAndResultHoldTime_10000_100000_Updater, bl);
        sqlStatValue.executeAndResultHoldTime_100000_1000000 = SqlStat.get((Object)this, executeAndResultHoldTime_100000_1000000_Updater, bl);
        sqlStatValue.executeAndResultHoldTime_1000000_more = SqlStat.get((Object)this, executeAndResultHoldTime_1000000_more_Updater, bl);
        sqlStatValue.setBlobOpenCount(SqlStat.get((Object)this, blobOpenCountUpdater, bl));
        sqlStatValue.setClobOpenCount(SqlStat.get((Object)this, clobOpenCountUpdater, bl));
        sqlStatValue.setReadStringLength(SqlStat.get((Object)this, readStringLengthUpdater, bl));
        sqlStatValue.setReadBytesLength(SqlStat.get((Object)this, readBytesLengthUpdater, bl));
        sqlStatValue.setInputStreamOpenCount(SqlStat.get((Object)this, inputStreamOpenCountUpdater, bl));
        sqlStatValue.setReaderOpenCount(SqlStat.get((Object)this, readerOpenCountUpdater, bl));
        return sqlStatValue;
    }

    public long getConcurrentMax() {
        return this.concurrentMax;
    }

    public long getRunningCount() {
        return this.runningCount;
    }

    public void addUpdateCount(int n2) {
        long l2;
        if (n2 > 0) {
            updateCountUpdater.addAndGet(this, n2);
        }
        while ((long)n2 > (l2 = updateCountMaxUpdater.get(this)) && !updateCountMaxUpdater.compareAndSet(this, l2, n2)) {
        }
        if (n2 < 1) {
            updateCount_0_1_Updater.incrementAndGet(this);
        } else if (n2 < 10) {
            updateCount_1_10_Updater.incrementAndGet(this);
        } else if (n2 < 100) {
            updateCount_10_100_Updater.incrementAndGet(this);
        } else if (n2 < 1000) {
            updateCount_100_1000_Updater.incrementAndGet(this);
        } else if (n2 < 10000) {
            updateCount_1000_10000_Updater.incrementAndGet(this);
        } else {
            updateCount_10000_more_Updater.incrementAndGet(this);
        }
    }

    public long getUpdateCount() {
        return this.updateCount;
    }

    public long getUpdateCountMax() {
        return this.updateCountMax;
    }

    public long getFetchRowCount() {
        return this.fetchRowCount;
    }

    public long getFetchRowCountMax() {
        return this.fetchRowCountMax;
    }

    public long getClobOpenCount() {
        return this.clobOpenCount;
    }

    public void incrementClobOpenCount() {
        clobOpenCountUpdater.incrementAndGet(this);
    }

    public long getBlobOpenCount() {
        return this.blobOpenCount;
    }

    public void incrementBlobOpenCount() {
        blobOpenCountUpdater.incrementAndGet(this);
    }

    public long getReadStringLength() {
        return this.readStringLength;
    }

    public void addStringReadLength(long l2) {
        readStringLengthUpdater.addAndGet(this, l2);
    }

    public long getReadBytesLength() {
        return this.readBytesLength;
    }

    public void addReadBytesLength(long l2) {
        readBytesLengthUpdater.addAndGet(this, l2);
    }

    public long getReaderOpenCount() {
        return this.readerOpenCount;
    }

    public void addReaderOpenCount(int n2) {
        readerOpenCountUpdater.addAndGet(this, n2);
    }

    public long getInputStreamOpenCount() {
        return this.inputStreamOpenCount;
    }

    public void addInputStreamOpenCount(int n2) {
        inputStreamOpenCountUpdater.addAndGet(this, n2);
    }

    public String getId() {
        return this.id;
    }

    public String getSql() {
        return this.sql;
    }

    public long getSqlHash() {
        if (this.sqlHash == 0L) {
            this.sqlHash = DriverUtil.murmurhash2_64(this.sql);
        }
        return this.sqlHash;
    }

    public Date getExecuteLastStartTime() {
        if (this.executeLastStartTime <= 0L) {
            return null;
        }
        return new Date(this.executeLastStartTime);
    }

    public void setExecuteLastStartTime(long l2) {
        this.executeLastStartTime = l2;
    }

    public Date getExecuteNanoSpanMaxOccurTime() {
        if (this.executeNanoSpanMaxOccurTime <= 0L) {
            return null;
        }
        return new Date(this.executeNanoSpanMaxOccurTime);
    }

    public Date getExecuteErrorLastTime() {
        if (this.executeErrorLastTime <= 0L) {
            return null;
        }
        return new Date(this.executeErrorLastTime);
    }

    public void addFetchRowCount(long l2) {
        long l3;
        fetchRowCountUpdater.addAndGet(this, l2);
        while (l2 > (l3 = fetchRowCountMaxUpdater.get(this)) && !fetchRowCountMaxUpdater.compareAndSet(this, l3, l2)) {
        }
        if (l2 < 1L) {
            fetchRowCount_0_1_Updater.incrementAndGet(this);
        } else if (l2 < 10L) {
            fetchRowCount_1_10_Updater.incrementAndGet(this);
        } else if (l2 < 100L) {
            fetchRowCount_10_100_Updater.incrementAndGet(this);
        } else if (l2 < 1000L) {
            fetchRowCount_100_1000_Updater.incrementAndGet(this);
        } else if (l2 < 10000L) {
            fetchRowCount_1000_10000_Updater.incrementAndGet(this);
        } else {
            fetchRowCount_10000_more_Updater.incrementAndGet(this);
        }
    }

    public void addExecuteBatchCount(long l2) {
        int n2;
        executeBatchSizeTotalUpdater.addAndGet(this, l2);
        while ((long)(n2 = executeBatchSizeMaxUpdater.get(this)) < l2 && !executeBatchSizeMaxUpdater.compareAndSet(this, n2, (int)l2)) {
        }
    }

    public long getExecuteBatchSizeTotal() {
        return this.executeBatchSizeTotal;
    }

    public void incrementExecuteSuccessCount() {
        executeSuccessCountUpdater.incrementAndGet(this);
    }

    public void incrementRunningCount() {
        int n2;
        int n3 = runningCountUpdater.incrementAndGet(this);
        while (n3 > (n2 = concurrentMaxUpdater.get(this)) && !concurrentMaxUpdater.compareAndSet(this, n2, n3)) {
        }
    }

    public void decrementRunningCount() {
        runningCountUpdater.decrementAndGet(this);
    }

    public long getExecuteSuccessCount() {
        return this.executeSuccessCount;
    }

    public void addExecuteTime(ExecuteType executeType, boolean bl, long l2, String string) {
        this.addExecuteTime(l2, string);
        if (ExecuteType.QUERY != executeType && !bl) {
            this.executeAndResultHoldTimeHistogramRecord(l2);
        }
    }

    private void executeAndResultHoldTimeHistogramRecord(long l2) {
        long l3 = l2 / 1000L / 1000L;
        if (l3 < 1L) {
            executeAndResultHoldTime_0_1_Updater.incrementAndGet(this);
        } else if (l3 < 10L) {
            executeAndResultHoldTime_1_10_Updater.incrementAndGet(this);
        } else if (l3 < 100L) {
            executeAndResultHoldTime_10_100_Updater.incrementAndGet(this);
        } else if (l3 < 1000L) {
            executeAndResultHoldTime_100_1000_Updater.incrementAndGet(this);
        } else if (l3 < 10000L) {
            executeAndResultHoldTime_1000_10000_Updater.incrementAndGet(this);
        } else if (l3 < 100000L) {
            executeAndResultHoldTime_10000_100000_Updater.incrementAndGet(this);
        } else if (l3 < 1000000L) {
            executeAndResultHoldTime_100000_1000000_Updater.incrementAndGet(this);
        } else {
            executeAndResultHoldTime_1000000_more_Updater.incrementAndGet(this);
        }
    }

    private void histogramRecord(long l2) {
        long l3 = l2 / 1000L / 1000L;
        if (l3 < 1L) {
            histogram_0_1_Updater.incrementAndGet(this);
        } else if (l3 < 10L) {
            histogram_1_10_Updater.incrementAndGet(this);
        } else if (l3 < 100L) {
            histogram_10_100_Updater.incrementAndGet(this);
        } else if (l3 < 1000L) {
            histogram_100_1000_Updater.incrementAndGet(this);
        } else if (l3 < 10000L) {
            histogram_1000_10000_Updater.incrementAndGet(this);
        } else if (l3 < 100000L) {
            histogram_10000_100000_Updater.incrementAndGet(this);
        } else if (l3 < 1000000L) {
            histogram_100000_1000000_Updater.incrementAndGet(this);
        } else {
            histogram_1000000_more_Updater.incrementAndGet(this);
        }
    }

    public void addExecuteTime(long l2, String string) {
        long l3;
        executeSpanNanoTotalUpdater.addAndGet(this, l2);
        while ((l3 = executeSpanNanoMaxUpdater.get(this)) < l2) {
            if (!executeSpanNanoMaxUpdater.compareAndSet(this, l3, l2)) continue;
            this.executeNanoSpanMaxOccurTime = System.currentTimeMillis();
            this.lastSlowParameters = string;
            break;
        }
        this.histogramRecord(l2);
    }

    public long getExecuteMillisTotal() {
        return this.executeSpanNanoTotal / 1000000L;
    }

    public long getExecuteMillisMax() {
        return this.executeSpanNanoMax / 1000000L;
    }

    public long getErrorCount() {
        return this.executeErrorCount;
    }

    public long getExecuteBatchSizeMax() {
        return this.executeBatchSizeMax;
    }

    public long getInTransactionCount() {
        return this.inTransactionCount;
    }

    public void incrementInTransactionCount() {
        inTransactionCountUpdater.incrementAndGet(this);
    }

    public long getExecuteCount() {
        return this.getErrorCount() + this.getExecuteSuccessCount();
    }

    public Map getData() {
        return this.getValue(false).getData();
    }

    public long[] getHistogramValues() {
        return new long[]{this.histogram_0_1, this.histogram_1_10, this.histogram_10_100, this.histogram_100_1000, this.histogram_1000_10000, this.histogram_10000_100000, this.histogram_100000_1000000, this.histogram_1000000_more};
    }

    public long getHistogramSum() {
        long[] lArray = this.getHistogramValues();
        long l2 = 0L;
        int n2 = 0;
        while (n2 < lArray.length) {
            l2 += lArray[n2];
            ++n2;
        }
        return l2;
    }

    public Throwable getExecuteErrorLast() {
        return this.executeErrorLast;
    }

    public void error(Throwable throwable) {
        executeErrorCountUpdater.incrementAndGet(this);
        this.executeErrorLastTime = System.currentTimeMillis();
        this.executeErrorLast = throwable;
    }

    public long getResultSetHoldTimeMilis() {
        return this.getResultSetHoldTimeNano() / 1000000L;
    }

    public long getExecuteAndResultSetHoldTimeMilis() {
        return this.getExecuteAndResultSetHoldTimeNano() / 1000000L;
    }

    public long[] getFetchRowCountHistogramValues() {
        return new long[]{this.fetchRowCount_0_1, this.fetchRowCount_1_10, this.fetchRowCount_10_100, this.fetchRowCount_100_1000, this.fetchRowCount_1000_10000, this.fetchRowCount_10000_more};
    }

    public long[] getUpdateCountHistogramValues() {
        return new long[]{this.updateCount_0_1, this.updateCount_1_10, this.updateCount_10_100, this.updateCount_100_1000, this.updateCount_1000_10000, this.updateCount_10000_more};
    }

    public long[] getExecuteAndResultHoldTimeHistogramValues() {
        return new long[]{this.executeAndResultHoldTime_0_1, this.executeAndResultHoldTime_1_10, this.executeAndResultHoldTime_10_100, this.executeAndResultHoldTime_100_1000, this.executeAndResultHoldTime_1000_10000, this.executeAndResultHoldTime_10000_100000, this.executeAndResultHoldTime_100000_1000000, this.executeAndResultHoldTime_1000000_more};
    }

    public long getExecuteAndResultHoldTimeHistogramSum() {
        long[] lArray = this.getExecuteAndResultHoldTimeHistogramValues();
        long l2 = 0L;
        int n2 = 0;
        while (n2 < lArray.length) {
            l2 += lArray[n2];
            ++n2;
        }
        return l2;
    }

    public long getResultSetHoldTimeNano() {
        return this.resultSetHoldTimeNano;
    }

    public long getExecuteAndResultSetHoldTimeNano() {
        return this.executeAndResultSetHoldTime;
    }

    public void addResultSetHoldTimeNano(long l2) {
        resultSetHoldTimeNanoUpdater.addAndGet(this, l2);
    }

    public void addResultSetHoldTimeNano(long l2, long l3) {
        resultSetHoldTimeNanoUpdater.addAndGet(this, l3);
        executeAndResultSetHoldTimeUpdater.addAndGet(this, l2 + l3);
        this.executeAndResultHoldTimeHistogramRecord((l2 + l3) / 1000L / 1000L);
        updateCount_0_1_Updater.incrementAndGet(this);
    }

    public boolean isRemoved() {
        return this.removed;
    }

    public void setRemoved(boolean bl) {
        this.removed = bl;
    }

    public static Map getData(Object object) {
        try {
            if (object.getClass() == SqlStat.class) {
                return ((SqlStat)object).getData();
            }
            Method method = object.getClass().getMethod("getData", new Class[0]);
            Object object2 = method.invoke(object, new Object[0]);
            return (Map)object2;
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static long[] rtrim(long[] lArray) {
        int n2 = lArray.length;
        int n3 = lArray.length - 1;
        while (n3 >= 0) {
            if (lArray[n3] != 0L) break;
            --n3;
            --n2;
        }
        if (n2 != lArray.length) {
            long[] lArray2 = new long[n2];
            System.arraycopy(lArray, 0, lArray2, 0, Math.min(lArray.length, n2));
            lArray = lArray2;
        }
        return lArray;
    }
}

