/*
 * Decompiled with CFR 0.152.
 */
package org.pcap4j.packet;

import org.pcap4j.packet.SimplePacket;
import org.pcap4j.util.ByteArrays;

public final class CompressedPacket
extends SimplePacket {
    private static final long serialVersionUID = 3129881252128550354L;

    public static CompressedPacket newPacket(byte[] rawData, int offset, int length) {
        ByteArrays.validateBounds(rawData, offset, length);
        return new CompressedPacket(rawData, offset, length);
    }

    private CompressedPacket(byte[] rawData, int offset, int length) {
        super(rawData, offset, length);
    }

    private CompressedPacket(Builder builder) {
        super(builder);
    }

    @Override
    public Builder getBuilder() {
        return new Builder(this);
    }

    @Override
    protected String modifier() {
        return "Compressed ";
    }

    public static final class Builder
    extends SimplePacket.Builder {
        public Builder() {
        }

        private Builder(CompressedPacket packet) {
            super(packet);
        }

        public Builder rawData(byte[] rawData) {
            this.setRawData(rawData);
            return this;
        }

        @Override
        public CompressedPacket build() {
            return new CompressedPacket(this);
        }
    }
}

