/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hertzbeat.collector.collect.ipmi2.client;

import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.security.InvalidKeyException;
import java.security.SecureRandom;
import java.util.Arrays;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.hertzbeat.collector.collect.ipmi2.client.IpmiPacketContext;
import org.apache.hertzbeat.collector.collect.ipmi2.protocol.common.AbstractWireable;
import org.apache.hertzbeat.collector.collect.ipmi2.protocol.ipmi.payload.AbstractSessionIpmiPayload;
import org.apache.hertzbeat.collector.collect.ipmi2.protocol.ipmi.security.IpmiAuthenticationCode;
import org.apache.hertzbeat.collector.collect.ipmi2.protocol.ipmi.security.IpmiConfidentialityCode;
import org.apache.hertzbeat.collector.collect.ipmi2.protocol.ipmi.security.IpmiIntegrityCode;
import org.apache.hertzbeat.collector.collect.ipmi2.protocol.ipmi.security.authentication.IpmiAuthentication;
import org.apache.hertzbeat.collector.collect.ipmi2.utils.ByteOrderUtils;

public class IpmiSession
implements IpmiPacketContext {
    private final int consoleSessionId;
    private int systemSessionId;
    private byte[] consoleRandomNumber;
    private byte[] systemRandomNumber;
    private byte[] systemGuid;
    private byte[] sik;
    private byte[] k1;
    private byte[] k2;
    private String userName;
    private String password;
    private boolean isConnected = false;
    private AtomicInteger authenticatedSequenceNumber = new AtomicInteger(1);
    private AtomicInteger unauthenticatedSequenceNumber = new AtomicInteger(1);
    private IpmiAuthenticationCode authenticationAlgorithm = IpmiAuthenticationCode.RAKP_HMAC_SHA1;
    private IpmiConfidentialityCode confidentialityAlgorithm = IpmiConfidentialityCode.AES_CBC_128;
    private IpmiIntegrityCode integrityAlgorithm = IpmiIntegrityCode.HMAC_SHA1_96;
    private AbstractSessionIpmiPayload.MaximumPrivilegeLevel maximumPrivilegeLevel = AbstractSessionIpmiPayload.MaximumPrivilegeLevel.ADMINISTRATOR;

    public IpmiSession(int consoleSessionId) {
        this.consoleSessionId = consoleSessionId;
    }

    public void generateSik() {
        int length = 34 + (this.userName == null ? 0 : this.userName.length());
        ByteBuffer buffer = ByteBuffer.allocate(length);
        ByteOrderUtils.writeBytes(buffer, this.consoleRandomNumber);
        ByteOrderUtils.writeBytes(buffer, this.systemRandomNumber);
        byte t = AbstractWireable.setBits((byte)0, 4, 1, 1);
        AbstractSessionIpmiPayload.MaximumPrivilegeLevel maximumPrivilegeLevel = this.getMaximumPrivilegeLevel();
        t = AbstractWireable.setBits(t, 0, 15, maximumPrivilegeLevel.getCode());
        buffer.put(t);
        if (this.userName != null) {
            byte[] usernameBytes = this.userName.getBytes(StandardCharsets.US_ASCII);
            buffer.put((byte)usernameBytes.length);
            buffer.put(usernameBytes);
        } else {
            buffer.put((byte)0);
        }
        IpmiAuthenticationCode authenticationCode = this.authenticationAlgorithm;
        IpmiAuthentication authentication = authenticationCode.newIpmiAuthentication();
        if (authentication == null) {
            throw new UnsupportedOperationException("Unsupported authentication code: " + authenticationCode);
        }
        try {
            authentication.setKey(this.password.getBytes(StandardCharsets.US_ASCII));
            authentication.setData(buffer.array());
            this.sik = authentication.getHash();
        }
        catch (InvalidKeyException e) {
            throw new RuntimeException(e);
        }
    }

    public byte[] generateK(int n) {
        byte[] data = new byte[20];
        Arrays.fill(data, (byte)n);
        IpmiAuthentication authentication = this.authenticationAlgorithm.newIpmiAuthentication();
        if (authentication == null) {
            throw new UnsupportedOperationException("Unsupported authentication code: " + this.authenticationAlgorithm);
        }
        try {
            authentication.setKey(this.sik);
            authentication.setData(data);
            return authentication.getHash();
        }
        catch (InvalidKeyException e) {
            throw new RuntimeException(e);
        }
    }

    public void generateConsoleRandomNumber() {
        SecureRandom random = new SecureRandom();
        this.consoleRandomNumber = random.generateSeed(16);
    }

    @Override
    public IpmiSession getIpmiSession() {
        return this;
    }

    public int getConsoleSessionId() {
        return this.consoleSessionId;
    }

    public int getSystemSessionId() {
        return this.systemSessionId;
    }

    public byte[] getConsoleRandomNumber() {
        return this.consoleRandomNumber;
    }

    public byte[] getSystemRandomNumber() {
        return this.systemRandomNumber;
    }

    public byte[] getSystemGuid() {
        return this.systemGuid;
    }

    public byte[] getSik() {
        return this.sik;
    }

    public byte[] getK1() {
        return this.k1;
    }

    public byte[] getK2() {
        return this.k2;
    }

    public String getUserName() {
        return this.userName;
    }

    public String getPassword() {
        return this.password;
    }

    public boolean isConnected() {
        return this.isConnected;
    }

    public AtomicInteger getAuthenticatedSequenceNumber() {
        return this.authenticatedSequenceNumber;
    }

    public AtomicInteger getUnauthenticatedSequenceNumber() {
        return this.unauthenticatedSequenceNumber;
    }

    public IpmiAuthenticationCode getAuthenticationAlgorithm() {
        return this.authenticationAlgorithm;
    }

    public IpmiConfidentialityCode getConfidentialityAlgorithm() {
        return this.confidentialityAlgorithm;
    }

    public IpmiIntegrityCode getIntegrityAlgorithm() {
        return this.integrityAlgorithm;
    }

    public AbstractSessionIpmiPayload.MaximumPrivilegeLevel getMaximumPrivilegeLevel() {
        return this.maximumPrivilegeLevel;
    }

    public void setSystemSessionId(int systemSessionId) {
        this.systemSessionId = systemSessionId;
    }

    public void setConsoleRandomNumber(byte[] consoleRandomNumber) {
        this.consoleRandomNumber = consoleRandomNumber;
    }

    public void setSystemRandomNumber(byte[] systemRandomNumber) {
        this.systemRandomNumber = systemRandomNumber;
    }

    public void setSystemGuid(byte[] systemGuid) {
        this.systemGuid = systemGuid;
    }

    public void setSik(byte[] sik) {
        this.sik = sik;
    }

    public void setK1(byte[] k1) {
        this.k1 = k1;
    }

    public void setK2(byte[] k2) {
        this.k2 = k2;
    }

    public void setUserName(String userName) {
        this.userName = userName;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public void setConnected(boolean isConnected) {
        this.isConnected = isConnected;
    }

    public void setAuthenticatedSequenceNumber(AtomicInteger authenticatedSequenceNumber) {
        this.authenticatedSequenceNumber = authenticatedSequenceNumber;
    }

    public void setUnauthenticatedSequenceNumber(AtomicInteger unauthenticatedSequenceNumber) {
        this.unauthenticatedSequenceNumber = unauthenticatedSequenceNumber;
    }

    public void setAuthenticationAlgorithm(IpmiAuthenticationCode authenticationAlgorithm) {
        this.authenticationAlgorithm = authenticationAlgorithm;
    }

    public void setConfidentialityAlgorithm(IpmiConfidentialityCode confidentialityAlgorithm) {
        this.confidentialityAlgorithm = confidentialityAlgorithm;
    }

    public void setIntegrityAlgorithm(IpmiIntegrityCode integrityAlgorithm) {
        this.integrityAlgorithm = integrityAlgorithm;
    }

    public void setMaximumPrivilegeLevel(AbstractSessionIpmiPayload.MaximumPrivilegeLevel maximumPrivilegeLevel) {
        this.maximumPrivilegeLevel = maximumPrivilegeLevel;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof IpmiSession)) {
            return false;
        }
        IpmiSession other = (IpmiSession)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getConsoleSessionId() != other.getConsoleSessionId()) {
            return false;
        }
        if (this.getSystemSessionId() != other.getSystemSessionId()) {
            return false;
        }
        if (this.isConnected() != other.isConnected()) {
            return false;
        }
        if (!Arrays.equals(this.getConsoleRandomNumber(), other.getConsoleRandomNumber())) {
            return false;
        }
        if (!Arrays.equals(this.getSystemRandomNumber(), other.getSystemRandomNumber())) {
            return false;
        }
        if (!Arrays.equals(this.getSystemGuid(), other.getSystemGuid())) {
            return false;
        }
        if (!Arrays.equals(this.getSik(), other.getSik())) {
            return false;
        }
        if (!Arrays.equals(this.getK1(), other.getK1())) {
            return false;
        }
        if (!Arrays.equals(this.getK2(), other.getK2())) {
            return false;
        }
        String this$userName = this.getUserName();
        String other$userName = other.getUserName();
        if (this$userName == null ? other$userName != null : !this$userName.equals(other$userName)) {
            return false;
        }
        String this$password = this.getPassword();
        String other$password = other.getPassword();
        if (this$password == null ? other$password != null : !this$password.equals(other$password)) {
            return false;
        }
        AtomicInteger this$authenticatedSequenceNumber = this.getAuthenticatedSequenceNumber();
        AtomicInteger other$authenticatedSequenceNumber = other.getAuthenticatedSequenceNumber();
        if (this$authenticatedSequenceNumber == null ? other$authenticatedSequenceNumber != null : !this$authenticatedSequenceNumber.equals(other$authenticatedSequenceNumber)) {
            return false;
        }
        AtomicInteger this$unauthenticatedSequenceNumber = this.getUnauthenticatedSequenceNumber();
        AtomicInteger other$unauthenticatedSequenceNumber = other.getUnauthenticatedSequenceNumber();
        if (this$unauthenticatedSequenceNumber == null ? other$unauthenticatedSequenceNumber != null : !this$unauthenticatedSequenceNumber.equals(other$unauthenticatedSequenceNumber)) {
            return false;
        }
        IpmiAuthenticationCode this$authenticationAlgorithm = this.getAuthenticationAlgorithm();
        IpmiAuthenticationCode other$authenticationAlgorithm = other.getAuthenticationAlgorithm();
        if (this$authenticationAlgorithm == null ? other$authenticationAlgorithm != null : !this$authenticationAlgorithm.equals(other$authenticationAlgorithm)) {
            return false;
        }
        IpmiConfidentialityCode this$confidentialityAlgorithm = this.getConfidentialityAlgorithm();
        IpmiConfidentialityCode other$confidentialityAlgorithm = other.getConfidentialityAlgorithm();
        if (this$confidentialityAlgorithm == null ? other$confidentialityAlgorithm != null : !this$confidentialityAlgorithm.equals(other$confidentialityAlgorithm)) {
            return false;
        }
        IpmiIntegrityCode this$integrityAlgorithm = this.getIntegrityAlgorithm();
        IpmiIntegrityCode other$integrityAlgorithm = other.getIntegrityAlgorithm();
        if (this$integrityAlgorithm == null ? other$integrityAlgorithm != null : !this$integrityAlgorithm.equals(other$integrityAlgorithm)) {
            return false;
        }
        AbstractSessionIpmiPayload.MaximumPrivilegeLevel this$maximumPrivilegeLevel = this.getMaximumPrivilegeLevel();
        AbstractSessionIpmiPayload.MaximumPrivilegeLevel other$maximumPrivilegeLevel = other.getMaximumPrivilegeLevel();
        return !(this$maximumPrivilegeLevel == null ? other$maximumPrivilegeLevel != null : !this$maximumPrivilegeLevel.equals(other$maximumPrivilegeLevel));
    }

    protected boolean canEqual(Object other) {
        return other instanceof IpmiSession;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getConsoleSessionId();
        result = result * 59 + this.getSystemSessionId();
        result = result * 59 + (this.isConnected() ? 79 : 97);
        result = result * 59 + Arrays.hashCode(this.getConsoleRandomNumber());
        result = result * 59 + Arrays.hashCode(this.getSystemRandomNumber());
        result = result * 59 + Arrays.hashCode(this.getSystemGuid());
        result = result * 59 + Arrays.hashCode(this.getSik());
        result = result * 59 + Arrays.hashCode(this.getK1());
        result = result * 59 + Arrays.hashCode(this.getK2());
        String $userName = this.getUserName();
        result = result * 59 + ($userName == null ? 43 : $userName.hashCode());
        String $password = this.getPassword();
        result = result * 59 + ($password == null ? 43 : $password.hashCode());
        AtomicInteger $authenticatedSequenceNumber = this.getAuthenticatedSequenceNumber();
        result = result * 59 + ($authenticatedSequenceNumber == null ? 43 : $authenticatedSequenceNumber.hashCode());
        AtomicInteger $unauthenticatedSequenceNumber = this.getUnauthenticatedSequenceNumber();
        result = result * 59 + ($unauthenticatedSequenceNumber == null ? 43 : $unauthenticatedSequenceNumber.hashCode());
        IpmiAuthenticationCode $authenticationAlgorithm = this.getAuthenticationAlgorithm();
        result = result * 59 + ($authenticationAlgorithm == null ? 43 : $authenticationAlgorithm.hashCode());
        IpmiConfidentialityCode $confidentialityAlgorithm = this.getConfidentialityAlgorithm();
        result = result * 59 + ($confidentialityAlgorithm == null ? 43 : $confidentialityAlgorithm.hashCode());
        IpmiIntegrityCode $integrityAlgorithm = this.getIntegrityAlgorithm();
        result = result * 59 + ($integrityAlgorithm == null ? 43 : $integrityAlgorithm.hashCode());
        AbstractSessionIpmiPayload.MaximumPrivilegeLevel $maximumPrivilegeLevel = this.getMaximumPrivilegeLevel();
        result = result * 59 + ($maximumPrivilegeLevel == null ? 43 : $maximumPrivilegeLevel.hashCode());
        return result;
    }

    public String toString() {
        return "IpmiSession(consoleSessionId=" + this.getConsoleSessionId() + ", systemSessionId=" + this.getSystemSessionId() + ", consoleRandomNumber=" + Arrays.toString(this.getConsoleRandomNumber()) + ", systemRandomNumber=" + Arrays.toString(this.getSystemRandomNumber()) + ", systemGuid=" + Arrays.toString(this.getSystemGuid()) + ", sik=" + Arrays.toString(this.getSik()) + ", k1=" + Arrays.toString(this.getK1()) + ", k2=" + Arrays.toString(this.getK2()) + ", userName=" + this.getUserName() + ", password=" + this.getPassword() + ", isConnected=" + this.isConnected() + ", authenticatedSequenceNumber=" + this.getAuthenticatedSequenceNumber() + ", unauthenticatedSequenceNumber=" + this.getUnauthenticatedSequenceNumber() + ", authenticationAlgorithm=" + this.getAuthenticationAlgorithm() + ", confidentialityAlgorithm=" + this.getConfidentialityAlgorithm() + ", integrityAlgorithm=" + this.getIntegrityAlgorithm() + ", maximumPrivilegeLevel=" + this.getMaximumPrivilegeLevel() + ")";
    }
}

