/*
 * Decompiled with CFR 0.152.
 */
package io.greptime.common.util;

import java.util.concurrent.BlockingQueue;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.RejectedExecutionHandler;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LogThreadPoolExecutor
extends ThreadPoolExecutor {
    private static final Logger LOG = LoggerFactory.getLogger(LogThreadPoolExecutor.class);
    private final int corePoolSize;
    private final int maximumPoolSize;
    private final String name;

    public LogThreadPoolExecutor(int corePoolSize, int maximumPoolSize, long keepAliveTime, TimeUnit unit, BlockingQueue<Runnable> workQueue, ThreadFactory threadFactory, RejectedExecutionHandler handler, String name) {
        super(corePoolSize, maximumPoolSize, keepAliveTime, unit, workQueue, threadFactory, handler);
        this.corePoolSize = corePoolSize;
        this.maximumPoolSize = maximumPoolSize;
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    @Override
    protected void afterExecute(Runnable r, Throwable t) {
        super.afterExecute(r, t);
        if (t == null && r instanceof Future) {
            try {
                Future f = (Future)((Object)r);
                if (f.isDone()) {
                    f.get();
                }
            }
            catch (CancellationException | ExecutionException ee) {
                t = ee.getCause();
            }
            catch (InterruptedException ie) {
                Thread.currentThread().interrupt();
            }
        }
        if (t != null) {
            LOG.error("Uncaught exception in pool: {}, {}.", new Object[]{this.name, super.toString(), t});
        }
    }

    @Override
    protected void terminated() {
        super.terminated();
        LOG.info("ThreadPool is terminated: {}, {}.", (Object)this.name, (Object)super.toString());
    }

    @Override
    public String toString() {
        return "ThreadPoolExecutor{corePoolSize=" + this.corePoolSize + ", maximumPoolSize=" + this.maximumPoolSize + ", name='" + this.name + '\'' + "} " + super.toString();
    }
}

