/*
 * Apache Fineract REST API
 * Apache Fineract is a secure, multi-tenanted microfinance platform. The goal of the Apache Fineract API is to empower developers to build apps on top of the Apache Fineract Platform. The [reference app](https://cui.fineract.dev) (username: mifos, password: password) works on the same demo tenant as the interactive links in this documentation. Until we complete the new REST API documentation you still have the legacy documentation available [here](https://fineract.apache.org/docs/legacy/). Please check [the current Fineract documentation](https://fineract.apache.org/docs/current/) for more information.
 *
 * The version of the OpenAPI document: 1.14.0
 * Contact: dev@fineract.apache.org
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package org.apache.fineract.client.models;

import java.util.Objects;
import java.util.Arrays;
import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.fineract.client.models.LoanProductData;
import org.apache.fineract.client.models.OfficeData;

/**
 * AdHocSearchQueryData
 */
@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", comments = "Generator version: 7.8.0")
public class AdHocSearchQueryData {
  public static final String SERIALIZED_NAME_COUNT = "count";
  @SerializedName(SERIALIZED_NAME_COUNT)
  private Integer count;

  public static final String SERIALIZED_NAME_LOAN_OUT_STANDING = "loanOutStanding";
  @SerializedName(SERIALIZED_NAME_LOAN_OUT_STANDING)
  private BigDecimal loanOutStanding;

  public static final String SERIALIZED_NAME_LOAN_PRODUCT_NAME = "loanProductName";
  @SerializedName(SERIALIZED_NAME_LOAN_PRODUCT_NAME)
  private String loanProductName;

  public static final String SERIALIZED_NAME_LOAN_PRODUCTS = "loanProducts";
  @SerializedName(SERIALIZED_NAME_LOAN_PRODUCTS)
  private List<LoanProductData> loanProducts;

  public static final String SERIALIZED_NAME_OFFICE_NAME = "officeName";
  @SerializedName(SERIALIZED_NAME_OFFICE_NAME)
  private String officeName;

  public static final String SERIALIZED_NAME_OFFICES = "offices";
  @SerializedName(SERIALIZED_NAME_OFFICES)
  private List<OfficeData> offices;

  public static final String SERIALIZED_NAME_PERCENTAGE = "percentage";
  @SerializedName(SERIALIZED_NAME_PERCENTAGE)
  private Double percentage;

  public AdHocSearchQueryData() {
  }

  public AdHocSearchQueryData count(Integer count) {
    
    this.count = count;
    return this;
  }

  /**
   * Get count
   * @return count
   */
  @javax.annotation.Nullable

  public Integer getCount() {
    return count;
  }


  public void setCount(Integer count) {
    this.count = count;
  }

  public AdHocSearchQueryData loanOutStanding(BigDecimal loanOutStanding) {
    
    this.loanOutStanding = loanOutStanding;
    return this;
  }

  /**
   * Get loanOutStanding
   * @return loanOutStanding
   */
  @javax.annotation.Nullable

  public BigDecimal getLoanOutStanding() {
    return loanOutStanding;
  }


  public void setLoanOutStanding(BigDecimal loanOutStanding) {
    this.loanOutStanding = loanOutStanding;
  }

  public AdHocSearchQueryData loanProductName(String loanProductName) {
    
    this.loanProductName = loanProductName;
    return this;
  }

  /**
   * Get loanProductName
   * @return loanProductName
   */
  @javax.annotation.Nullable

  public String getLoanProductName() {
    return loanProductName;
  }


  public void setLoanProductName(String loanProductName) {
    this.loanProductName = loanProductName;
  }

  public AdHocSearchQueryData loanProducts(List<LoanProductData> loanProducts) {
    
    this.loanProducts = loanProducts;
    return this;
  }

  public AdHocSearchQueryData addLoanProductsItem(LoanProductData loanProductsItem) {
    if (this.loanProducts == null) {
      this.loanProducts = new ArrayList<>();
    }
    this.loanProducts.add(loanProductsItem);
    return this;
  }

  /**
   * Get loanProducts
   * @return loanProducts
   */
  @javax.annotation.Nullable

  public List<LoanProductData> getLoanProducts() {
    return loanProducts;
  }


  public void setLoanProducts(List<LoanProductData> loanProducts) {
    this.loanProducts = loanProducts;
  }

  public AdHocSearchQueryData officeName(String officeName) {
    
    this.officeName = officeName;
    return this;
  }

  /**
   * Get officeName
   * @return officeName
   */
  @javax.annotation.Nullable

  public String getOfficeName() {
    return officeName;
  }


  public void setOfficeName(String officeName) {
    this.officeName = officeName;
  }

  public AdHocSearchQueryData offices(List<OfficeData> offices) {
    
    this.offices = offices;
    return this;
  }

  public AdHocSearchQueryData addOfficesItem(OfficeData officesItem) {
    if (this.offices == null) {
      this.offices = new ArrayList<>();
    }
    this.offices.add(officesItem);
    return this;
  }

  /**
   * Get offices
   * @return offices
   */
  @javax.annotation.Nullable

  public List<OfficeData> getOffices() {
    return offices;
  }


  public void setOffices(List<OfficeData> offices) {
    this.offices = offices;
  }

  public AdHocSearchQueryData percentage(Double percentage) {
    
    this.percentage = percentage;
    return this;
  }

  /**
   * Get percentage
   * @return percentage
   */
  @javax.annotation.Nullable

  public Double getPercentage() {
    return percentage;
  }


  public void setPercentage(Double percentage) {
    this.percentage = percentage;
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    AdHocSearchQueryData adHocSearchQueryData = (AdHocSearchQueryData) o;
    return Objects.equals(this.count, adHocSearchQueryData.count) &&
        Objects.equals(this.loanOutStanding, adHocSearchQueryData.loanOutStanding) &&
        Objects.equals(this.loanProductName, adHocSearchQueryData.loanProductName) &&
        Objects.equals(this.loanProducts, adHocSearchQueryData.loanProducts) &&
        Objects.equals(this.officeName, adHocSearchQueryData.officeName) &&
        Objects.equals(this.offices, adHocSearchQueryData.offices) &&
        Objects.equals(this.percentage, adHocSearchQueryData.percentage);
  }

  @Override
  public int hashCode() {
    return Objects.hash(count, loanOutStanding, loanProductName, loanProducts, officeName, offices, percentage);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class AdHocSearchQueryData {\n");
    sb.append("    count: ").append(toIndentedString(count)).append("\n");
    sb.append("    loanOutStanding: ").append(toIndentedString(loanOutStanding)).append("\n");
    sb.append("    loanProductName: ").append(toIndentedString(loanProductName)).append("\n");
    sb.append("    loanProducts: ").append(toIndentedString(loanProducts)).append("\n");
    sb.append("    officeName: ").append(toIndentedString(officeName)).append("\n");
    sb.append("    offices: ").append(toIndentedString(offices)).append("\n");
    sb.append("    percentage: ").append(toIndentedString(percentage)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}

