/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fineract.useradministration.service;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.apache.fineract.infrastructure.core.data.ApiParameterError;
import org.apache.fineract.infrastructure.core.data.DataValidatorBuilder;
import org.apache.fineract.infrastructure.core.exception.InvalidJsonException;
import org.apache.fineract.infrastructure.core.exception.PlatformApiDataValidationException;
import org.apache.fineract.infrastructure.core.serialization.FromJsonHelper;
import org.apache.fineract.useradministration.domain.AppUser;
import org.apache.fineract.useradministration.domain.PasswordValidationPolicy;
import org.apache.fineract.useradministration.domain.PasswordValidationPolicyRepository;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public final class UserDataValidator {
    public static final String USERNAME = "username";
    public static final String FIRSTNAME = "firstname";
    public static final String LASTNAME = "lastname";
    public static final String EMAIL = "email";
    public static final String OFFICE_ID = "officeId";
    public static final String NOT_SELECTED_ROLES = "notSelectedRoles";
    public static final String ROLES = "roles";
    public static final String SEND_PASSWORD_TO_EMAIL = "sendPasswordToEmail";
    public static final String STAFF_ID = "staffId";
    public static final String PASSWORD_NEVER_EXPIRES = "passwordNeverExpires";
    private static final Set<String> CREATE_SUPPORTED_PARAMETERS = new HashSet<String>(Arrays.asList("username", "firstname", "lastname", "password", "repeatPassword", "email", "officeId", "notSelectedRoles", "roles", "sendPasswordToEmail", "staffId", "passwordNeverExpires", "isSelfServiceUser", "clients"));
    private static final Set<String> UPDATE_SUPPORTED_PARAMETERS = new HashSet<String>(Arrays.asList("username", "firstname", "lastname", "password", "repeatPassword", "email", "officeId", "notSelectedRoles", "roles", "sendPasswordToEmail", "staffId", "passwordNeverExpires", "isSelfServiceUser", "clients"));
    private static final Set<String> CHANGE_PASSWORD_SUPPORTED_PARAMETERS = new HashSet<String>(Arrays.asList("password", "repeatPassword"));
    public static final String PASSWORD_NEVER_EXPIRE = "passwordNeverExpire";
    private final FromJsonHelper fromApiJsonHelper;
    private final PasswordValidationPolicyRepository passwordValidationPolicy;

    @Autowired
    public UserDataValidator(FromJsonHelper fromApiJsonHelper, PasswordValidationPolicyRepository passwordValidationPolicy) {
        this.fromApiJsonHelper = fromApiJsonHelper;
        this.passwordValidationPolicy = passwordValidationPolicy;
    }

    public void validateForCreate(String json) {
        if (StringUtils.isBlank((CharSequence)json)) {
            throw new InvalidJsonException();
        }
        Type typeOfMap = new /* Unavailable Anonymous Inner Class!! */.getType();
        this.fromApiJsonHelper.checkForUnsupportedParameters(typeOfMap, json, (Collection)CREATE_SUPPORTED_PARAMETERS);
        ArrayList dataValidationErrors = new ArrayList();
        DataValidatorBuilder baseDataValidator = new DataValidatorBuilder(dataValidationErrors).resource("user");
        JsonElement element = this.fromApiJsonHelper.parse(json);
        String username = this.fromApiJsonHelper.extractStringNamed(USERNAME, element);
        baseDataValidator.reset().parameter(USERNAME).value((Object)username).notBlank().notExceedingLengthOf(Integer.valueOf(100));
        String firstname = this.fromApiJsonHelper.extractStringNamed(FIRSTNAME, element);
        baseDataValidator.reset().parameter(FIRSTNAME).value((Object)firstname).notBlank().notExceedingLengthOf(Integer.valueOf(100));
        String lastname = this.fromApiJsonHelper.extractStringNamed(LASTNAME, element);
        baseDataValidator.reset().parameter(LASTNAME).value((Object)lastname).notBlank().notExceedingLengthOf(Integer.valueOf(100));
        Boolean sendPasswordToEmail = this.fromApiJsonHelper.extractBooleanNamed(SEND_PASSWORD_TO_EMAIL, element);
        if (sendPasswordToEmail != null) {
            if (sendPasswordToEmail.booleanValue()) {
                String email = this.fromApiJsonHelper.extractStringNamed(EMAIL, element);
                baseDataValidator.reset().parameter(EMAIL).value((Object)email).notBlank().notExceedingLengthOf(Integer.valueOf(100));
            } else {
                this.validatePassword(baseDataValidator, element);
            }
        } else {
            baseDataValidator.reset().parameter(SEND_PASSWORD_TO_EMAIL).value((Object)sendPasswordToEmail).trueOrFalseRequired((Object)false);
        }
        Long officeId = this.fromApiJsonHelper.extractLongNamed(OFFICE_ID, element);
        baseDataValidator.reset().parameter(OFFICE_ID).value((Object)officeId).notNull().integerGreaterThanZero();
        if (this.fromApiJsonHelper.parameterExists(STAFF_ID, element)) {
            Long staffId = this.fromApiJsonHelper.extractLongNamed(STAFF_ID, element);
            baseDataValidator.reset().parameter(STAFF_ID).value((Object)staffId).notNull().integerGreaterThanZero();
        }
        if (this.fromApiJsonHelper.parameterExists(PASSWORD_NEVER_EXPIRES, element)) {
            boolean passwordNeverExpire = this.fromApiJsonHelper.extractBooleanNamed(PASSWORD_NEVER_EXPIRES, element);
            baseDataValidator.reset().parameter(PASSWORD_NEVER_EXPIRE).value((Object)passwordNeverExpire).validateForBooleanValue();
        }
        Boolean isSelfServiceUser = null;
        if (this.fromApiJsonHelper.parameterExists("isSelfServiceUser", element) && (isSelfServiceUser = this.fromApiJsonHelper.extractBooleanNamed("isSelfServiceUser", element)) == null) {
            baseDataValidator.reset().parameter("isSelfServiceUser").trueOrFalseRequired((Object)false);
        }
        if (this.fromApiJsonHelper.parameterExists("clients", element)) {
            if (isSelfServiceUser == null || !isSelfServiceUser.booleanValue()) {
                baseDataValidator.reset().parameter("clients").failWithCode("not.supported.when.isSelfServiceUser.is.false", new Object[]{"clients parameter is not supported when isSelfServiceUser parameter is false"});
            } else {
                JsonArray clientsArray = this.fromApiJsonHelper.extractJsonArrayNamed("clients", element);
                baseDataValidator.reset().parameter("clients").value((Object)clientsArray).jsonArrayNotEmpty();
                for (JsonElement client : clientsArray) {
                    Long clientId = client.getAsLong();
                    baseDataValidator.reset().parameter("clients").value((Object)clientId).longGreaterThanZero();
                }
            }
        }
        String[] roles = this.fromApiJsonHelper.extractArrayNamed(ROLES, element);
        baseDataValidator.reset().parameter(ROLES).value((Object)roles).arrayNotEmpty();
        this.throwExceptionIfValidationWarningsExist(dataValidationErrors);
    }

    private void throwExceptionIfValidationWarningsExist(List<ApiParameterError> dataValidationErrors) {
        if (!dataValidationErrors.isEmpty()) {
            throw new PlatformApiDataValidationException(dataValidationErrors);
        }
    }

    private Set<String> getParamNamesFromRequest(String json) {
        JsonElement element = this.fromApiJsonHelper.parse(json);
        if (element.isJsonObject()) {
            return ((JsonObject)element).keySet();
        }
        return Set.of();
    }

    void validateFieldLevelACL(String json, AppUser authenticatedUser) {
        if (!authenticatedUser.hasAnyPermission(new String[]{"ALL_FUNCTIONS", "UPDATE_USER"})) {
            Set paramNamesFromRequest = this.getParamNamesFromRequest(json);
            if (authenticatedUser.isSelfServiceUser()) {
                paramNamesFromRequest.removeAll(Set.of("clients", "password", "repeatPassword"));
            } else {
                paramNamesFromRequest.removeAll(Set.of("password", "repeatPassword"));
            }
            if (paramNamesFromRequest.size() > 0) {
                throw new PlatformApiDataValidationException(List.of(ApiParameterError.parameterError((String)"not.enough.permission.to.update.fields", (String)"Current user has no permission to update fields", (String)String.join((CharSequence)",", paramNamesFromRequest), (Object[])new Object[0])));
            }
        }
    }

    public void validateForChangePassword(String json, AppUser authenticatedUser) {
        if (StringUtils.isBlank((CharSequence)json)) {
            throw new InvalidJsonException();
        }
        Type typeOfMap = new /* Unavailable Anonymous Inner Class!! */.getType();
        this.fromApiJsonHelper.checkForUnsupportedParameters(typeOfMap, json, (Collection)CHANGE_PASSWORD_SUPPORTED_PARAMETERS);
        ArrayList dataValidationErrors = new ArrayList();
        DataValidatorBuilder baseDataValidator = new DataValidatorBuilder(dataValidationErrors).resource("user");
        JsonElement element = this.fromApiJsonHelper.parse(json);
        this.validatePassword(baseDataValidator, element);
        this.throwExceptionIfValidationWarningsExist(dataValidationErrors);
        this.validateFieldLevelACL(json, authenticatedUser);
    }

    public void validateForUpdate(String json, AppUser authenticatedUser) {
        if (StringUtils.isBlank((CharSequence)json)) {
            throw new InvalidJsonException();
        }
        Type typeOfMap = new /* Unavailable Anonymous Inner Class!! */.getType();
        this.fromApiJsonHelper.checkForUnsupportedParameters(typeOfMap, json, (Collection)UPDATE_SUPPORTED_PARAMETERS);
        ArrayList dataValidationErrors = new ArrayList();
        DataValidatorBuilder baseDataValidator = new DataValidatorBuilder(dataValidationErrors).resource("user");
        JsonElement element = this.fromApiJsonHelper.parse(json);
        if (this.fromApiJsonHelper.parameterExists(OFFICE_ID, element)) {
            Long officeId = this.fromApiJsonHelper.extractLongNamed(OFFICE_ID, element);
            baseDataValidator.reset().parameter(OFFICE_ID).value((Object)officeId).notNull().integerGreaterThanZero();
        }
        if (this.fromApiJsonHelper.parameterExists(STAFF_ID, element)) {
            Long staffId = this.fromApiJsonHelper.extractLongNamed(STAFF_ID, element);
            baseDataValidator.reset().parameter(STAFF_ID).value((Object)staffId).ignoreIfNull().integerGreaterThanZero();
        }
        if (this.fromApiJsonHelper.parameterExists(USERNAME, element)) {
            String username = this.fromApiJsonHelper.extractStringNamed(USERNAME, element);
            baseDataValidator.reset().parameter(USERNAME).value((Object)username).notBlank().notExceedingLengthOf(Integer.valueOf(100));
        }
        if (this.fromApiJsonHelper.parameterExists(FIRSTNAME, element)) {
            String firstname = this.fromApiJsonHelper.extractStringNamed(FIRSTNAME, element);
            baseDataValidator.reset().parameter(FIRSTNAME).value((Object)firstname).notBlank().notExceedingLengthOf(Integer.valueOf(100));
        }
        if (this.fromApiJsonHelper.parameterExists(LASTNAME, element)) {
            String lastname = this.fromApiJsonHelper.extractStringNamed(LASTNAME, element);
            baseDataValidator.reset().parameter(LASTNAME).value((Object)lastname).notBlank().notExceedingLengthOf(Integer.valueOf(100));
        }
        if (this.fromApiJsonHelper.parameterExists(EMAIL, element)) {
            String email = this.fromApiJsonHelper.extractStringNamed(EMAIL, element);
            baseDataValidator.reset().parameter(EMAIL).value((Object)email).notBlank().notExceedingLengthOf(Integer.valueOf(100));
        }
        if (this.fromApiJsonHelper.parameterExists(ROLES, element)) {
            String[] roles = this.fromApiJsonHelper.extractArrayNamed(ROLES, element);
            baseDataValidator.reset().parameter(ROLES).value((Object)roles).arrayNotEmpty();
        }
        if (this.fromApiJsonHelper.parameterExists("password", element)) {
            this.validatePassword(baseDataValidator, element);
        }
        if (this.fromApiJsonHelper.parameterExists(PASSWORD_NEVER_EXPIRE, element)) {
            boolean passwordNeverExpire = this.fromApiJsonHelper.extractBooleanNamed(PASSWORD_NEVER_EXPIRE, element);
            baseDataValidator.reset().parameter(PASSWORD_NEVER_EXPIRE).value((Object)passwordNeverExpire).validateForBooleanValue();
        }
        Boolean isSelfServiceUser = null;
        if (this.fromApiJsonHelper.parameterExists("isSelfServiceUser", element) && (isSelfServiceUser = this.fromApiJsonHelper.extractBooleanNamed("isSelfServiceUser", element)) == null) {
            baseDataValidator.reset().parameter("isSelfServiceUser").trueOrFalseRequired((Object)false);
        }
        if (this.fromApiJsonHelper.parameterExists("clients", element)) {
            if (isSelfServiceUser != null && !isSelfServiceUser.booleanValue()) {
                baseDataValidator.reset().parameter("clients").failWithCode("not.supported.when.isSelfServiceUser.is.false", new Object[]{"clients parameter is not supported when isSelfServiceUser parameter is false"});
            } else {
                JsonArray clientsArray = this.fromApiJsonHelper.extractJsonArrayNamed("clients", element);
                baseDataValidator.reset().parameter("clients").value((Object)clientsArray).jsonArrayNotEmpty();
                for (JsonElement client : clientsArray) {
                    Long clientId = client.getAsLong();
                    baseDataValidator.reset().parameter("clients").value((Object)clientId).longGreaterThanZero();
                }
            }
        }
        this.throwExceptionIfValidationWarningsExist(dataValidationErrors);
        this.validateFieldLevelACL(json, authenticatedUser);
    }

    private void validatePassword(DataValidatorBuilder baseDataValidator, JsonElement element) {
        String password = this.fromApiJsonHelper.extractStringNamed("password", element);
        String repeatPassword = this.fromApiJsonHelper.extractStringNamed("repeatPassword", element);
        PasswordValidationPolicy validationPolicy = this.passwordValidationPolicy.findActivePasswordValidationPolicy();
        String regex = validationPolicy.getRegex();
        String description = validationPolicy.getDescription();
        DataValidatorBuilder validator = baseDataValidator.reset().parameter("password").value((Object)password).matchesRegularExpression(regex, description);
        if (StringUtils.isNotBlank((CharSequence)password)) {
            validator.equalToParameter("repeatPassword", (Object)repeatPassword);
        }
    }
}

