/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fineract.useradministration.service;

import java.util.Collection;
import org.apache.fineract.infrastructure.core.service.database.DatabaseSpecificSQLGenerator;
import org.apache.fineract.useradministration.data.PasswordValidationPolicyData;
import org.apache.fineract.useradministration.exception.PasswordValidationPolicyNotFoundException;
import org.apache.fineract.useradministration.service.PasswordValidationPolicyReadPlatformService;
import org.apache.fineract.useradministration.service.PasswordValidationPolicyReadPlatformServiceImpl;
import org.springframework.dao.EmptyResultDataAccessException;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.RowMapper;

public class PasswordValidationPolicyReadPlatformServiceImpl
implements PasswordValidationPolicyReadPlatformService {
    private final JdbcTemplate jdbcTemplate;
    private final DatabaseSpecificSQLGenerator sqlGenerator;
    private final PasswordValidationPolicyMapper passwordValidationPolicyMapper;

    public PasswordValidationPolicyReadPlatformServiceImpl(JdbcTemplate jdbcTemplate, DatabaseSpecificSQLGenerator sqlGenerator) {
        this.jdbcTemplate = jdbcTemplate;
        this.sqlGenerator = sqlGenerator;
        this.passwordValidationPolicyMapper = new PasswordValidationPolicyMapper(sqlGenerator);
    }

    public Collection<PasswordValidationPolicyData> retrieveAll() {
        String sql = "select " + this.passwordValidationPolicyMapper.schema() + " order by pvp.id";
        return this.jdbcTemplate.query(sql, (RowMapper)this.passwordValidationPolicyMapper);
    }

    public PasswordValidationPolicyData retrieveActiveValidationPolicy() {
        try {
            String sql = "select " + this.passwordValidationPolicyMapper.schema() + " where pvp.active = true";
            return (PasswordValidationPolicyData)this.jdbcTemplate.queryForObject(sql, (RowMapper)this.passwordValidationPolicyMapper);
        }
        catch (EmptyResultDataAccessException e) {
            throw new PasswordValidationPolicyNotFoundException(e);
        }
    }
}

